/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileTypePrivate
extends FileType {
    public File mFile;

    public FileTypePrivate(Context context, String file) {
        super(context);
        this.mFile = new File(file);
    }

    public FileTypePrivate(Context context, File file) {
        super(context);
        this.mFile = file;
    }

    @Override
    public void discard() {
        try {
            this.mFile.delete();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public File getFile() {
        return this.mFile;
    }

    @Override
    public long getFileSize() {
        long result = 0L;
        try {
            result = this.mFile.length();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.mFile, false);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.mFile);
    }

    @Override
    public boolean isValid() {
        return this.mFile.exists();
    }
}

