/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

public class FirmwareOnline {
    private String family_id;
    private String fw_revision;
    private final String bootloader_revision;
    private String release_notes;
    private String notes_url;
    private String fw_file_name;
    private final String bootloader_file_name;
    public int[] mBootloaderMajor = new int[]{0, 0};
    public int[] mBootloaderMinor = new int[]{0, 0};
    public int[] mFirmwareMajor = new int[]{0, 0};
    public int[] mFirmwareMinor = new int[]{0, 0};

    public FirmwareOnline(String fw_family, String fw_rev, String bl_rev, String fw_notes, String notes_url, String fw_file, String bl_file) {
        this.family_id = fw_family;
        this.fw_revision = fw_rev;
        this.bootloader_revision = bl_rev;
        this.release_notes = fw_notes;
        this.notes_url = notes_url;
        this.fw_file_name = fw_file;
        this.bootloader_file_name = bl_file;
        int[] bootloaderRevisionArray = this.parseRevision(this.bootloader_revision);
        this.mBootloaderMajor[0] = bootloaderRevisionArray[0];
        this.mBootloaderMinor[0] = bootloaderRevisionArray[1];
        int[] firmwareRevisionArray = this.parseRevision(this.fw_revision);
        this.mFirmwareMajor[0] = firmwareRevisionArray[0];
        this.mFirmwareMinor[0] = firmwareRevisionArray[1];
    }

    public String toString() {
        return String.format("fam:%s | rev:%s | file:%s | notes:%s", this.family_id, this.fw_revision, this.fw_file_name, this.release_notes);
    }

    public String getFamilyID() {
        return this.family_id;
    }

    public String getRevision() {
        return this.fw_revision;
    }

    public String getBootloaderRev() {
        return this.bootloader_revision;
    }

    public String getBootloaderFileName() {
        return this.bootloader_file_name;
    }

    public String getNotesURL() {
        return this.notes_url;
    }

    public void setNotesURL(String new_notes) {
        this.notes_url = new_notes;
    }

    public void setRevision(String revision) {
        this.fw_revision = revision;
    }

    public void setFamilyID(String familyId) {
        this.family_id = familyId;
    }

    public String getFile_name() {
        return this.fw_file_name;
    }

    public void setFile_name(String file_name) {
        this.fw_file_name = file_name;
    }

    public String getRelease_notes() {
        return this.release_notes;
    }

    public void setRelease_notes(String release_notes) {
        this.release_notes = release_notes;
    }

    protected int[] parseRevision(String revisionString) {
        int[] result = new int[]{0, 0};
        if (revisionString != null && !revisionString.equals("") && !revisionString.equals("NA")) {
            String[] revisionArray = revisionString.split("\\.");
            if (revisionArray.length > 1) {
                result[0] = this.getRevisionNumber(revisionArray[0]);
                result[1] = this.getRevisionNumber(revisionArray[1]);
            } else {
                int revisionNumber = this.getRevisionNumber(revisionString);
                result[0] = (int)((float)revisionNumber / 10.0f);
                result[1] = revisionNumber % 10;
            }
        }
        return result;
    }

    protected int getRevisionNumber(String revisionString) {
        int revisionNumber = 0;
        try {
            if (revisionString != null && !revisionString.equals("") && !revisionString.equals("NA")) {
                revisionNumber = Integer.parseInt(revisionString);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return revisionNumber;
    }
}

