/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Constants;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FirmwareVersion;
import com.elinchrom.software.LayoutViewUnit;
import com.elinchrom.software.Unit_Prototype_Json;
import java.nio.charset.StandardCharsets;

public class FlashDevice {
    public static final byte ELSP_HEADS_RATIO_VOID = 0;
    public static final byte ELSP_HEADS_RATIO_50_50 = 1;
    public static final byte ELSP_HEADS_RATIO_66_33 = 2;
    public static final int UNIT_CLASS_COMPACT = 1;
    public static final int UNIT_CLASS_BATTERY_SINGLE_RATIO = 2;
    public static final int UNIT_CLASS_BATTERY_MULTIPLE_RATIOS = 3;
    public static final int UNIT_CLASS_CONTINUOUS_LIGHT = 4;
    public static final int UNIT_CLASS_BATTERY_FULLY_ASYMMETRIC = 5;
    public static final int UNIT_CLASS_SKYPORT_DEVICES = 6;
    public static final int UNIT_CLASS_POWER_PACK = 7;
    public static final int NO_INTERNET_CONNECTION = 0;
    public static final int NEW_FIRMWARE_ON_WEBSITE = 1;
    public static final int UNIT_UPDATED_TO_LAST_FIRMWARE = 2;
    public static final int HEAD_TYPE_NOT_COMPATIBLE = 0;
    public static final int HEAD_TYPE_ELB1200_PRO = 1;
    public static final int HEAD_TYPE_ELB1200_ACTION = 2;
    public static final int HEAD_TYPE_ELB1200_HS = 3;
    public static final int HEAD_TYPE_ELB1200_VIDEO = 4;
    public Context mContext = null;
    public ElinchromDevice mElinchromDevice = null;
    FirmwareVersion version;
    private byte Min_flash_power;
    private byte Max_flash_power;
    private byte Min_lamp_power;
    private byte Max_lamp_power;
    private byte[] Supported_ratios;
    private String[] Supported_skyport_commands;
    private Versioned_skyport_commands[] Versioned_skyport_commands;
    private byte Num_outlets;
    private byte Generation;
    private byte[] Head_types;
    private byte Unit_category;
    private byte head_a_type;
    private byte head_b_type;
    private byte head_c_type;
    private byte head_d_type;
    private byte head_plugged;
    public int mUIGroup = 0;
    public String mUiFriendlyName = null;
    public int mUIPosition = -1;
    public int mPreviousPosition = -1;
    public boolean mIsRemoved = false;
    public boolean mIsHidden = false;
    public boolean mIsSlidding = false;
    public int mNoAnswerCount = 0;
    public long mNoAnswerTimestamp = 0L;
    public boolean mIsUnresponsive = false;
    public boolean mIsUnreachable = false;
    private int new_firmware_available;
    public boolean mIsGroupLabel = false;
    public byte group;
    public byte[] friendly_name;
    public byte flash_power;
    public byte head_a_power;
    public byte head_b_power;
    public byte head_on;
    public byte lamp_power_fstop;
    public byte lamp_mode;
    public byte lamp_timer;
    public byte lamp_power_percentage;
    public byte modlamp_a_power;
    public byte modlamp_b_power;
    public short[] flash_mode_values;
    public byte flash_mode;
    public byte sequence_address;
    public byte num_sequence_units;
    public short sequence_timeout;
    public short delay_time;
    public byte strobo_frequency;
    public short strobo_duration;
    public boolean second_gen_seq_on;
    public byte second_gen_seq_count;
    public byte second_gen_seq_time;
    public byte heads_ratio;
    public byte auto_off_minutes;
    public byte auto_off_hours;
    public byte auto_off;
    public boolean unit_standby;
    public boolean vfc;
    public LayoutViewUnit mLayoutViewUnit = null;
    public int mLoadingState;
    public byte mSignalStrength = 0;
    public byte mBatteryLevel = 0;
    public String mPreviousFriendlyName = "";
    public boolean mIsFlashSessionInitialized = false;
    public int mFlashSessionCount = 0;
    public String[] mUnitAddressLabels = null;
    public byte[] mUnitAddressValues = null;
    public int[] mUnitAddressPosition = null;
    public String[] mTotalUnitsLabels = null;
    public byte[] mTotalUnitsValues = null;
    public int[] mTotalUnitsPosition = null;
    public String[] mFlashesPerSecondLabels = null;
    public byte[] mFlashesPerSecondValues = null;
    public int[] mFlashesPerSecondPosition = null;
    public String[] mFlashModeLabels = null;
    public byte[] mFlashModeValues = null;
    public int[] mFlashModePosition = null;
    public String[] mRecyclingModeLabels = null;
    public byte[] mRecyclingModeValues = null;
    public int[] mRecyclingModePosition = null;
    public String[] mPhotocellLabels = null;
    public byte[] mPhotocellValues = null;
    public int[] mPhotocellPosition = null;
    public String[] mPowerRatioLabels = null;
    public byte[] mPowerRatioValues = null;
    public int[] mPowerRatioPosition = null;
    public int[] mFeatureList = null;
    public String mPowerTitle = null;
    public String mLampTitle = null;

    public FlashDevice(Context context, ElinchromDevice elinchromDevice) {
        this.mContext = context;
        this.mElinchromDevice = elinchromDevice;
        this.mFeatureList = new int[14];
        this.mFeatureList[0] = 1;
        this.mFeatureList[1] = 0;
        this.mFeatureList[2] = 0;
        this.mFeatureList[3] = 0;
        this.mFeatureList[4] = 0;
        this.mFeatureList[5] = 0;
        this.mFeatureList[6] = 1;
        this.mFeatureList[7] = 1;
        this.mFeatureList[8] = 0;
        this.mFeatureList[9] = 1;
        this.mFeatureList[10] = 1;
        this.mFeatureList[11] = 0;
        this.mFeatureList[12] = 1;
        this.mFeatureList[13] = 1;
        this.mPowerTitle = "Flash power";
        this.mLampTitle = "Mod lamp";
        this.mRecyclingModeLabels = new String[]{"Eco", "Normal", "Fast"};
        this.mRecyclingModeValues = new byte[]{1, 0, 2};
        this.mRecyclingModePosition = new int[]{1, 0, 2, 2};
        this.mPhotocellLabels = new String[]{"Off", "Photocell", "Eyecell"};
        this.mPhotocellValues = new byte[]{0, 1, 2};
        this.mPhotocellPosition = new int[]{0, 1, 2};
        this.mFlashModeLabels = new String[]{"Default", "Sequence", "Delay", "Strobo"};
        this.mFlashModeValues = new byte[]{0, 1, 2, 3};
        this.mFlashModePosition = new int[]{0, 1, 2, 3};
        this.mUnitAddressLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
        this.mUnitAddressValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        this.mUnitAddressPosition = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        this.mTotalUnitsLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
        this.mTotalUnitsValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        this.mTotalUnitsPosition = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        this.mFlashesPerSecondLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
        this.mFlashesPerSecondValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        this.mFlashesPerSecondPosition = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    }

    public boolean areAllHeadsOn() {
        return true;
    }

    public int batteryLevel() {
        return this.mBatteryLevel;
    }

    public byte[] checkPowerBoundsHeadA(int[] flashPowerValues) {
        byte[] result = new byte[3];
        if (this.areAllHeadsOn()) {
            byte[] checkedPowerValues = this.checkPowerBoundsHead(flashPowerValues[1], flashPowerValues[2]);
            result[0] = checkedPowerValues[2];
            result[1] = checkedPowerValues[0];
            result[2] = checkedPowerValues[1];
        } else {
            result[0] = this.clipPowerSingleMainFStop(flashPowerValues[1]);
            result[1] = result[0];
            result[2] = 0;
        }
        return result;
    }

    public byte[] checkPowerBoundsHeadB(int[] flashPowerValues) {
        byte[] result = new byte[3];
        if (this.areAllHeadsOn()) {
            byte[] checkedPowerValues = this.checkPowerBoundsHead(flashPowerValues[2], flashPowerValues[1]);
            result[0] = checkedPowerValues[2];
            result[1] = checkedPowerValues[1];
            result[2] = checkedPowerValues[0];
        } else {
            result[0] = this.clipPowerSingleMainFStop(flashPowerValues[2]);
            result[1] = 0;
            result[2] = result[0];
        }
        return result;
    }

    protected byte[] checkPowerBoundsHead(int head, int otherHead) {
        double headJoule = this.mContext.mUtil.convert_in_joule(head);
        double otherHeadJoule = this.mContext.mUtil.convert_in_joule(otherHead);
        double newHeadJoule = this.clipPowerHeadJoule(headJoule);
        double newOtherHeadJoule = this.clipPowerHeadJoule(otherHeadJoule);
        double sumJoule = newHeadJoule + newOtherHeadJoule;
        double newSumJoule = this.clipPowerMainJoule(sumJoule);
        byte[] result = new byte[3];
        result[1] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newOtherHeadJoule));
        result[2] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newSumJoule));
        newHeadJoule = newSumJoule - this.mContext.mUtil.convert_in_joule(result[1]);
        result[0] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newHeadJoule));
        return result;
    }

    public byte[] checkPowerBoundsMain(int[] flashPowerValues) {
        byte[] result = new byte[3];
        if (this.areAllHeadsOn()) {
            double mainJoule = this.mContext.mUtil.convert_in_joule(flashPowerValues[0]);
            double headAJoule = this.mContext.mUtil.convert_in_joule(flashPowerValues[1]);
            double headBJoule = this.mContext.mUtil.convert_in_joule(flashPowerValues[2]);
            double newMainJoule = this.clipPowerMainJoule(mainJoule);
            double sumJoule = headAJoule + headBJoule;
            if (headAJoule <= headBJoule && newMainJoule <= sumJoule || headAJoule > headBJoule && newMainJoule > sumJoule) {
                double newMinHeadJoule = this.clipPowerHeadAJoule(headAJoule / sumJoule * newMainJoule);
                result[0] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMainJoule));
                result[1] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMinHeadJoule));
                double newMaxHeadJoule = this.clipPowerHeadBJoule(newMainJoule - this.mContext.mUtil.convert_in_joule(result[1]));
                result[2] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMaxHeadJoule));
            } else {
                double newMinHeadJoule = this.clipPowerHeadBJoule(headBJoule / sumJoule * newMainJoule);
                result[0] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMainJoule));
                result[2] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMinHeadJoule));
                double newMaxHeadJoule = this.clipPowerHeadAJoule(newMainJoule - this.mContext.mUtil.convert_in_joule(result[2]));
                result[1] = (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMaxHeadJoule));
            }
        } else {
            result[0] = this.isHeadAOn() || this.isHeadBOn() ? this.clipPowerSingleMainFStop(flashPowerValues[0]) : (byte)0;
            result[1] = this.isHeadAOn() ? result[0] : (byte)0;
            result[2] = this.isHeadBOn() ? result[0] : (byte)0;
        }
        return result;
    }

    public byte[] checkPowerBoundsModLamp(int modLamp, int otherModLamp) {
        byte[] result = new byte[]{this.isHeadAOn() ? (byte)Math.max(this.getMin_lamp_power(), Math.min(this.getMax_lamp_power(), modLamp)) : (byte)0, this.isHeadBOn() ? (byte)Math.max(this.getMin_lamp_power(), Math.min(this.getMax_lamp_power(), otherModLamp)) : (byte)0};
        return result;
    }

    public byte[] checkPowerBoundsMultipleFixedRatio(byte main, byte headOn, byte ratio) {
        double mainJoule = this.mContext.mUtil.convert_in_joule(main);
        double minJoule = 0.0;
        double maxJoule = 0.0;
        double newMainJoule = 0.0;
        double newAJoule = 0.0;
        double newBJoule = 0.0;
        block0 : switch (headOn) {
            case 0: {
                switch (ratio) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        minJoule = 2.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                        break;
                    }
                    case 2: {
                        minJoule = 3.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                    }
                }
                break;
            }
            case 1: {
                switch (ratio) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        minJoule = 2.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newAJoule = newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                        break;
                    }
                    case 2: {
                        minJoule = 3.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newAJoule = newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                    }
                }
                break;
            }
            case 2: {
                switch (ratio) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        minJoule = this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = 0.5 * this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newBJoule = newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                        break;
                    }
                    case 2: {
                        minJoule = this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = 0.3333333333333333 * this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newBJoule = newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                    }
                }
                break;
            }
            case 3: {
                switch (ratio) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        minJoule = 2.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                        newAJoule = 0.5 * newMainJoule;
                        newBJoule = 0.5 * newMainJoule;
                        break block0;
                    }
                    case 2: {
                        minJoule = 3.0 * this.mContext.mUtil.convert_in_joule(this.getMin_flash_power());
                        maxJoule = this.mContext.mUtil.convert_in_joule(this.getMax_flash_power());
                        newMainJoule = Math.max(minJoule, Math.min(maxJoule, mainJoule));
                        newAJoule = 0.6666666666666666 * newMainJoule;
                        newBJoule = 0.3333333333333333 * newMainJoule;
                    }
                }
            }
        }
        byte[] result = new byte[]{(byte)Math.round(this.mContext.mUtil.convert_in_fstop(newMainJoule)), (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newAJoule)), (byte)Math.round(this.mContext.mUtil.convert_in_fstop(newBJoule))};
        return result;
    }

    public byte checkPowerBoundsContinuousLightPercent(byte percent) {
        return (byte)Math.max(this.getMinContinuousLightPercent(), Math.min(percent, 100));
    }

    public byte clipPowerHead(int powerHead) {
        byte newPowerHead = powerHead < this.getMinFlashPowerHeadA() ? this.getMinFlashPowerHeadA() : (powerHead > this.getMaxFlashPowerHeadA() ? this.getMaxFlashPowerHeadA() : (byte)powerHead);
        return newPowerHead;
    }

    public double clipPowerHeadJoule(double powerHead) {
        return this.clipPowerHeadAJoule(powerHead);
    }

    public double clipPowerHeadAJoule(double powerHeadA) {
        double newPowerHeadA = powerHeadA;
        if (powerHeadA < this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadA())) {
            newPowerHeadA = this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadA());
        } else if (powerHeadA > this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadA())) {
            newPowerHeadA = this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadA());
        }
        return newPowerHeadA;
    }

    public double clipPowerHeadBJoule(double powerHeadB) {
        double newPowerHeadB = powerHeadB;
        if (powerHeadB < this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadB())) {
            newPowerHeadB = this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadB());
        } else if (powerHeadB > this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadB())) {
            newPowerHeadB = this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadB());
        }
        return newPowerHeadB;
    }

    public double clipPowerMainJoule(double powerMain) {
        double newPowerMain = powerMain;
        if (powerMain < this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerMain())) {
            newPowerMain = this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerMain());
        } else if (powerMain > this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain())) {
            newPowerMain = this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain());
        }
        return newPowerMain;
    }

    public byte[] getCheckedLampPowerValuesForFreeMode(int lampPowerIncrement) {
        int[] lampPowerValues = this.getLampPowerValuesFStop();
        return this.getClippedLampPowerValues(new int[]{lampPowerValues[0] + lampPowerIncrement, lampPowerValues[1] + lampPowerIncrement});
    }

    public byte[] getCheckedLampPowerValuesForPropMode() {
        return this.getClippedLampPowerValuesFromFlashPowerValues(this.getMainPowerValues());
    }

    public byte[] getClippedFlashPowerValues(int[] flashPowerValues) {
        return new byte[]{this.clipPowerSingleMainFStop(flashPowerValues[0]), 0, 0};
    }

    public byte[] getClippedLampPowerValues(int[] lampPowerValues) {
        return this.checkPowerBoundsModLamp(lampPowerValues[0], lampPowerValues[1]);
    }

    public byte[] getCheckedLampPowerValuesA(int lampAPower) {
        int[] lampPowerValues = this.getLampPowerValuesFStop();
        return this.getClippedLampPowerValues(new int[]{lampAPower, lampPowerValues[1]});
    }

    public byte[] getCheckedLampPowerValuesB(int lampBPower) {
        int[] lampPowerValues = this.getLampPowerValuesFStop();
        return this.getClippedLampPowerValues(new int[]{lampPowerValues[0], lampBPower});
    }

    public byte[] getClippedLampPowerValuesFromFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsModLamp(flashPowerValues[0], 0);
    }

    public byte clipPowerSingleMainFStop(int powerMain) {
        byte newPowerMain = powerMain < this.getMinFlashPowerMain() ? this.getMinFlashPowerMain() : (powerMain > this.getMaxFlashPowerMain() ? this.getMaxFlashPowerMain() : (byte)powerMain);
        return newPowerMain;
    }

    public double clipRatio(double ratio) {
        double newRatio = ratio;
        if (ratio < this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadB()) / this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain())) {
            newRatio = this.mContext.mUtil.convert_in_joule(this.getMinFlashPowerHeadB()) / this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain());
        } else if (ratio > this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadA()) / this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain())) {
            newRatio = this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerHeadA()) / this.mContext.mUtil.convert_in_joule(this.getMaxFlashPowerMain());
        }
        return newRatio;
    }

    public byte[] computeHeadsValues(byte totalFlashPower) {
        byte[] result = new byte[]{totalFlashPower, 0, 0};
        switch (this.getHead_on()) {
            default: {
                if (this.getHeads_ratio() == 1) {
                    result[1] = (byte)(totalFlashPower - 10);
                    result[2] = (byte)(totalFlashPower - 10);
                    break;
                }
                result[1] = (byte)(totalFlashPower - 6);
                result[2] = (byte)(totalFlashPower - 16);
                break;
            }
            case 1: {
                result[1] = totalFlashPower;
                result[2] = 0;
                break;
            }
            case 2: {
                result[1] = 0;
                result[2] = totalFlashPower;
                break;
            }
            case 0: {
                result[0] = 0;
                result[1] = 0;
                result[2] = 0;
            }
        }
        return result;
    }

    public byte getAudio_mode() {
        return this.readNative(0)[0];
    }

    public byte getAuto_off() {
        return this.readNative(14)[0];
    }

    public byte getCharge_mode() {
        return this.readNative(1)[0];
    }

    public int getContinuousLightLampPower() {
        return (int)Math.ceil((float)this.getLamp_power_percentage() / 100.0f * (float)this.getMax_lamp_power());
    }

    public short getDelay_time() {
        byte[] flash_mode_settings = this.readNative(2);
        return (short)((short)(flash_mode_settings[6] & 0xFF) << 8 | (short)(flash_mode_settings[7] & 0xFF));
    }

    public byte getFlash_mode() {
        return this.readNative(2)[0];
    }

    public short[] getFlash_mode_values() {
        byte[] flashMode = this.readNative(2);
        short[] flashModeValues = new short[]{flashMode[0], flashMode[1], flashMode[2], flashMode[3], (short)((short)(flashMode[4] & 0xFF) << 8 | (short)(flashMode[5] & 0xFF)), (short)((short)(flashMode[6] & 0xFF) << 8 | (short)(flashMode[7] & 0xFF)), flashMode[8], (short)((short)(flashMode[9] & 0xFF) << 8 | (short)(flashMode[10] & 0xFF))};
        return flashModeValues;
    }

    public int getFlash_power() {
        return this.getFlash_power_values()[0];
    }

    public byte[] getFlash_power_values() {
        return this.readNative(3);
    }

    public int[] getMainPowerValues() {
        byte[] powerValues = this.getFlash_power_values();
        return new int[]{powerValues[0], powerValues[1], powerValues[2]};
    }

    public String getFormatedFriendlyName() {
        String unitName;
        if (this.hasData(4)) {
            unitName = this.mContext.mUtil.convertUtf8BytesToString(this.mContext.mUtil.cleanBytes(this.getFriendly_name()));
            if (!this.mContext.mCheckedNameFlashUnitArray.contains(this.mElinchromDevice.getSkyportId())) {
                this.mContext.mCheckedNameFlashUnitArray.add(this.mElinchromDevice.getSkyportId());
                this.mContext.mFileManager.updateCheckedNameFlashUnits();
                if (this.isBadName(unitName)) {
                    unitName = this.mElinchromDevice.getProductName();
                    this.setFriendly_name(unitName.getBytes(StandardCharsets.UTF_8));
                }
            }
        } else {
            unitName = this.mElinchromDevice.getProductName();
        }
        return unitName;
    }

    public byte[] getFriendly_name() {
        return this.readNative(4);
    }

    public String getFriendlyNameString() {
        return this.getFormatedFriendlyName();
    }

    public byte getGeneration() {
        return this.mElinchromDevice.valueGetByte(33);
    }

    public byte getGroup() {
        return this.readNative(5)[0];
    }

    public FlashDevice getInstance() {
        return null;
    }

    public byte getPhotocell_mode() {
        byte[] cellStatus = this.readNative(10);
        if (cellStatus[0] != 0 && cellStatus[1] != 0) {
            return 2;
        }
        if (cellStatus[0] != 0) {
            return 1;
        }
        return 0;
    }

    public int getFlash_counter() {
        byte[] flash_counter = this.readNative(13);
        return (flash_counter[3] & 0xFF) * 1000000 + (flash_counter[2] & 0xFF) * 10000 + (flash_counter[1] & 0xFF) * 100 + (flash_counter[0] & 0xFF) * 1;
    }

    public byte getHead_a_power() {
        return this.getFlash_power_values()[1];
    }

    public byte getHead_a_type() {
        return this.readNative(6)[2];
    }

    public byte getHead_b_power() {
        return this.getFlash_power_values()[2];
    }

    public byte getHead_b_type() {
        return this.readNative(6)[3];
    }

    public byte getHead_c_type() {
        return this.readNative(6)[4];
    }

    public byte getHead_d_type() {
        return this.readNative(6)[5];
    }

    public byte getHead_on() {
        return this.readNative(6)[0];
    }

    public byte getHead_plugged() {
        return this.readNative(6)[1];
    }

    public byte[] getHead_types() {
        return this.Head_types;
    }

    public byte getHeads_ratio() {
        byte ratio = this.readNative(2)[1];
        return ratio == 1 ? ratio : (byte)2;
    }

    public byte getLamp_mode() {
        return this.readNative(9)[0];
    }

    public int getLamp_power_fstop() {
        return this.readNative(7)[0];
    }

    public byte[] getLamp_power_fstop_values() {
        return this.readNative(7);
    }

    public int[] getLampPowerValuesFStop() {
        byte[] lampPowerValues = this.readNative(7);
        return new int[]{lampPowerValues[0], lampPowerValues[1]};
    }

    public byte getLamp_power_percentage() {
        return this.readNative(8)[0];
    }

    public byte getLamp_timer() {
        return this.readNative(9)[1];
    }

    public byte getMaster_fw_rev() {
        return this.version.getMaster();
    }

    public byte getMax_flash_power() {
        return this.mElinchromDevice.valueGetByte(35);
    }

    public byte getMaxFlashPowerMain() {
        return this.mElinchromDevice.valueGetByte(35);
    }

    public byte getMaxFlashPowerHeadA() {
        return this.mElinchromDevice.valueGetByte(35);
    }

    public byte getMaxFlashPowerHeadB() {
        return this.mElinchromDevice.valueGetByte(35);
    }

    public byte getMax_lamp_power() {
        return this.mElinchromDevice.valueGetByte(37);
    }

    public byte getMin_flash_power() {
        return this.mElinchromDevice.valueGetByte(34);
    }

    public byte getMinFlashPowerMain() {
        return this.mElinchromDevice.valueGetByte(34);
    }

    public byte getMinFlashPowerHeadA() {
        return this.mElinchromDevice.valueGetByte(34);
    }

    public byte getMinFlashPowerHeadB() {
        return this.mElinchromDevice.valueGetByte(34);
    }

    public byte getMin_lamp_power() {
        return this.mElinchromDevice.valueGetByte(36);
    }

    public byte getMinContinuousLightPercent() {
        double minPercent = (double)this.getMin_lamp_power() / (double)this.getMax_lamp_power() * 100.0;
        return (byte)minPercent;
    }

    public byte getModlamp_a_power() {
        return this.readNative(7)[0];
    }

    public byte getModlamp_b_power() {
        return this.readNative(7)[1];
    }

    public byte getNum_outlets() {
        return this.Num_outlets;
    }

    public byte getNum_sequence_units() {
        return this.readNative(2)[3];
    }

    public byte getSequence_address() {
        return this.readNative(2)[2];
    }

    public short getSequence_timeout() {
        byte[] flash_mode_settings = this.readNative(2);
        return (short)((short)(flash_mode_settings[4] & 0xFF) << 8 | (short)(flash_mode_settings[5] & 0xFF));
    }

    public short getStrobo_duration() {
        byte[] flash_mode_settings = this.readNative(2);
        return (short)((short)(flash_mode_settings[9] & 0xFF) << 8 | (short)(flash_mode_settings[10] & 0xFF));
    }

    public byte getStrobo_frequency() {
        return this.readNative(2)[8];
    }

    public byte[] getSupported_ratios() {
        return this.Supported_ratios;
    }

    public byte[] getSupportedCommands(FirmwareVersion version) {
        String[] cmds = this.getVersionedCommands(version);
        byte[] retVal = new byte[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            try {
                retVal[i] = Byte.parseByte(cmds[i], 16);
                continue;
            }
            catch (NumberFormatException nfe) {
                retVal[i] = 0;
            }
        }
        return retVal;
    }

    public byte getUnit_category() {
        return this.mElinchromDevice.valueGetByte(32);
    }

    public FirmwareVersion getVersion() {
        return this.version;
    }

    public String[] getVersionedCommands(FirmwareVersion version) {
        if (this.Supported_skyport_commands != null || version == null) {
            return this.Supported_skyport_commands;
        }
        String[] retCmd = new String[]{};
        FirmwareVersion retVer = new FirmwareVersion("0.0");
        for (Versioned_skyport_commands vsc : this.Versioned_skyport_commands) {
            FirmwareVersion from;
            if (vsc == null) {
                // empty if block
            }
            if (version.isBefore(from = new FirmwareVersion(vsc.From_version)) || from.isBefore(retVer)) continue;
            retVer = from;
            retCmd = vsc.Commands;
        }
        return retCmd;
    }

    public boolean getVfc() {
        return (this.readNative(9)[0] & 0x10) == 16;
    }

    public boolean getLampTimerOn() {
        return (this.readNative(9)[0] & 0x40) == 64;
    }

    public void init() {
        Unit_Prototype_Json unit_prototype = this.mContext.mUnitPrototypes.get(this.mElinchromDevice.mProductId);
        this.Num_outlets = unit_prototype.getNum_outlets();
        this.Supported_ratios = unit_prototype.getSupported_ratios();
        this.Head_types = unit_prototype.getHead_types();
        this.mLayoutViewUnit.init();
    }

    public void initFlashSession() {
        if (!this.mIsFlashSessionInitialized && this.isCommandSupported(13) && this.hasData(13)) {
            this.mFlashSessionCount = Math.max(0, this.getFlash_counter());
            this.mIsFlashSessionInitialized = true;
        }
    }

    public void initPrototype() {
    }

    public boolean isBadName(String name) {
        int productId = this.mElinchromDevice.getProductId();
        boolean ret = false;
        if (productId == 50) {
            ret = name.equalsIgnoreCase("ELC PRO 500");
        }
        if (productId == 51) {
            ret = name.equalsIgnoreCase("ELC PRO 1000");
        }
        if (productId == 56) {
            boolean bl = ret = name.equalsIgnoreCase("ELB400") || name.equalsIgnoreCase("");
        }
        if (productId == 60) {
            ret = name.equalsIgnoreCase("ELB1200");
        }
        if (productId == 64) {
            boolean bl = ret = name.equalsIgnoreCase("STELLA PRO") || name.equalsIgnoreCase("ELM 8");
        }
        if (productId == 70) {
            ret = name.equalsIgnoreCase("ELB500-1");
        }
        return ret;
    }

    public boolean isCommandSupported(int iotIndex) {
        return this.mElinchromDevice.valueGetByte(iotIndex) != 0;
    }

    public boolean hasData(int iotIndex) {
        return this.mContext.mModuleManagerSdk.read(this.mElinchromDevice, iotIndex, 0, new byte[0]) != 9;
    }

    public boolean isHeadAOn() {
        return (this.getHead_on() & 1) != 0;
    }

    public boolean isHeadBOn() {
        return (this.getHead_on() & 2) != 0;
    }

    public boolean isInitialized() {
        return this.hasData(5);
    }

    public boolean isLampOn() {
        return this.getLamp_mode_mode() != 0;
    }

    public int isNew_firmware_available() {
        return this.new_firmware_available;
    }

    public boolean isUnit_standby() {
        return this.readNative(11)[0] != 0;
    }

    public byte[] readNative(int iotIndex) {
        int size = Constants.IOT_DATA_SIZE[iotIndex];
        byte[] data = new byte[size];
        this.mContext.mModuleManagerSdk.read(this.mElinchromDevice, iotIndex, size, data);
        return data;
    }

    public void setAudio_mode(byte audio_mode) {
        this.sendNative(0, new byte[]{audio_mode});
    }

    public void setAuto_off(byte auto_off) {
        this.auto_off = auto_off;
    }

    public void setCharge_mode(byte charge_mode) {
        this.sendNative(1, new byte[]{charge_mode});
    }

    public void setDelay_time(short delay_time) {
        this.delay_time = delay_time;
    }

    public void setFlash_mode(byte flash_mode) {
        this.flash_mode = flash_mode;
    }

    public void sendFlashMode(byte flashMode, byte sequenceAddress, byte numSequenceUnits, short sequenceTimeout, short delayTime, byte stroboFrequency, short stroboDuration) {
        byte[] sequenceTimeoutBytes = this.mContext.mUtil.intToBytes(sequenceTimeout);
        byte sequenceTimeoutLsb = sequenceTimeoutBytes[0];
        byte sequenceTimeoutMsb = sequenceTimeoutBytes[1];
        byte[] delayTimeBytes = this.mContext.mUtil.intToBytes(delayTime);
        byte delayTimeLsb = delayTimeBytes[0];
        byte delayTimeMsb = delayTimeBytes[1];
        byte[] stroboDurationBytes = this.mContext.mUtil.intToBytes(stroboDuration);
        byte stroboDurationLsb = stroboDurationBytes[0];
        byte stroboDurationMsb = stroboDurationBytes[1];
        byte[] toSend = new byte[]{flashMode, this.readNative(2)[1], sequenceAddress, numSequenceUnits, sequenceTimeoutMsb, sequenceTimeoutLsb, delayTimeMsb, delayTimeLsb, stroboFrequency, stroboDurationMsb, stroboDurationLsb};
        this.sendNative(2, toSend);
    }

    public void sendFlashMode(short[] values) {
        this.sendFlashMode((byte)values[0], (byte)values[1], (byte)values[2], (byte)values[3], values[4], values[5], (byte)values[6], values[7]);
    }

    public void sendFlashMode(byte flashMode, byte headsRatio, byte sequenceAddress, byte numSequenceUnits, short sequenceTimeout, short delayTime, byte stroboFrequency, short stroboDuration) {
        byte[] sequenceTimeoutBytes = this.mContext.mUtil.intToBytes(sequenceTimeout);
        byte sequenceTimeoutLsb = sequenceTimeoutBytes[0];
        byte sequenceTimeoutMsb = sequenceTimeoutBytes[1];
        byte[] delayTimeBytes = this.mContext.mUtil.intToBytes(delayTime);
        byte delayTimeLsb = delayTimeBytes[0];
        byte delayTimeMsb = delayTimeBytes[1];
        byte[] stroboDurationBytes = this.mContext.mUtil.intToBytes(stroboDuration);
        byte stroboDurationLsb = stroboDurationBytes[0];
        byte stroboDurationMsb = stroboDurationBytes[1];
        byte[] toSend = new byte[]{flashMode, headsRatio, sequenceAddress, numSequenceUnits, sequenceTimeoutMsb, sequenceTimeoutLsb, delayTimeMsb, delayTimeLsb, stroboFrequency, stroboDurationMsb, stroboDurationLsb};
        this.sendNative(2, toSend);
    }

    public void sendFlashMode(byte flashMode, byte headsRatio, byte sequenceAddress, byte numSequenceUnits, byte sequenceTimeoutMsb, byte sequenceTimeoutLsb, byte delayTimeMsb, byte delayTimeLsb, byte stroboFrequency, byte stroboDurationMsb, byte stroboDurationLsb) {
        byte[] toSend = new byte[]{flashMode, headsRatio, sequenceAddress, numSequenceUnits, sequenceTimeoutMsb, sequenceTimeoutLsb, delayTimeMsb, delayTimeLsb, stroboFrequency, stroboDurationMsb, stroboDurationLsb};
        this.sendNative(2, toSend);
    }

    public void sendTrigger() {
        if (this.isCommandSupported(15)) {
            this.mContext.mModuleManagerSdk.trigger(this.mElinchromDevice);
        }
    }

    public void setFlash_power(byte flash_power) {
        this.setFlash_power(flash_power, (byte)0, (byte)0);
    }

    public void setFlash_power(byte flash_power, byte head_a_fstop, byte head_b_fstop) {
        this.sendNative(3, new byte[]{flash_power, head_a_fstop, head_b_fstop});
    }

    public void setFlash_power_values(byte[] flash_power) {
        this.setFlash_power(flash_power[0], flash_power[1], flash_power[2]);
    }

    public void setFriendly_name(byte[] friendly_name) {
        int i;
        byte[] friendlyNamePadded = new byte[16];
        for (i = 0; i < friendly_name.length && i < 16; ++i) {
            friendlyNamePadded[i] = friendly_name[i];
        }
        while (i < 16) {
            friendlyNamePadded[i] = 0;
            ++i;
        }
        this.sendNative(4, friendlyNamePadded);
    }

    public void setFriendlyNameIfChanged(String friendly_name) {
        if (!friendly_name.equals(this.getFriendlyNameString())) {
            this.setFriendly_name(this.mContext.mUtil.convertStringToUtf8Bytes(friendly_name));
        }
    }

    public void setGroup(byte group) {
        this.sendNative(5, new byte[]{group});
    }

    public void setHead_a_power(byte head_a_power) {
        this.head_a_power = this.mElinchromDevice.getProductId() == 60 || this.mElinchromDevice.getProductId() == 70 ? head_a_power : (head_a_power == 0 ? head_a_power : (this.head_b_power != 0 ? (byte)(this.getFlash_power() - 6) : (byte)this.getFlash_power()));
    }

    public void setHead_a_type(byte head_a_type) {
        this.head_a_type = head_a_type;
    }

    public void setHead_b_power(byte head_b_power) {
        this.head_b_power = this.mElinchromDevice.getProductId() == 60 || this.mElinchromDevice.getProductId() == 70 ? head_b_power : (head_b_power == 0 ? head_b_power : (this.head_a_power != 0 ? (byte)(this.getFlash_power() - 16) : (this.flash_power > 16 ? (byte)(this.flash_power - 16) : this.flash_power)));
    }

    public void setHead_b_type(byte head_b_type) {
        this.head_b_type = head_b_type;
    }

    public void setHead_c_type(byte head_c_type) {
        this.head_c_type = head_c_type;
    }

    public void setHead_d_type(byte head_d_type) {
        this.head_d_type = head_d_type;
    }

    public void setHead_on(byte head_on) {
        this.sendNative(6, new byte[]{head_on});
    }

    public void setHead_plugged(byte head_plugged) {
        this.head_plugged = head_plugged;
    }

    public void setHead_types(byte[] head_types) {
        this.Head_types = head_types;
    }

    public void sendHeads_ratio(byte headsRatio) {
        byte[] flashMode = this.readNative(2);
        flashMode[1] = headsRatio;
        this.sendNative(2, flashMode);
    }

    public void setLamp_mode(byte lamp_mode) {
        this.sendNative(9, new byte[]{lamp_mode, 0});
    }

    public void setLampOn(boolean isOn) {
        this.setLamp_mode_mode(isOn ? 1 : 0);
    }

    public void setLamp_mode_mode(int lamp_mode_mode) {
        byte lampMode = this.getLamp_mode();
        switch (lamp_mode_mode) {
            case 0: {
                this.setLamp_mode((byte)(lampMode & 0x7E));
                break;
            }
            case 1: {
                this.setLamp_mode((byte)(lampMode & 0x7E | 1));
                break;
            }
            case 2: {
                this.setLamp_mode((byte)(lampMode & 0x70 | 1));
                break;
            }
            case 3: {
                this.setLamp_mode((byte)(lampMode & 0x70 | 3));
                break;
            }
        }
    }

    public byte getLamp_mode_mode() {
        byte lampMode = this.getLamp_mode();
        int result = (lampMode & 1) == 0 ? 0 : ((lampMode & 0xF) == 1 ? 2 : 3);
        return (byte)result;
    }

    public void setLamp_power_fstop(byte lamp_power_fstop) {
        this.setLamp_power_fstop(lamp_power_fstop, (byte)0);
    }

    public void setLamp_power_fstop(byte lamp_a_fstop, byte lamp_b_fstop) {
        this.sendNative(7, new byte[]{lamp_a_fstop, lamp_b_fstop});
    }

    public void setLamp_power_fstop_values(byte[] lamp_power_fstop) {
        this.setLamp_power_fstop(lamp_power_fstop[0], lamp_power_fstop[1]);
    }

    public void setLampPowerValues(byte[] checkedLampPowerValues) {
        this.setLamp_power_fstop_values(checkedLampPowerValues);
    }

    public void setLamp_power_percentage(byte lamp_power_percentage) {
        this.sendNative(8, new byte[]{lamp_power_percentage});
    }

    public void setLamp_timer(byte lamp_timer) {
        this.lamp_timer = lamp_timer;
    }

    public void setMax_flash_power(byte max_flash_power) {
        this.Max_flash_power = max_flash_power;
    }

    public void setMax_lamp_power(byte max_lamp_power) {
        this.Max_lamp_power = max_lamp_power;
    }

    public void setMin_flash_power(byte min_flash_power) {
        this.Min_flash_power = min_flash_power;
    }

    public void setMin_lamp_power(byte min_lamp_power) {
        this.Min_lamp_power = min_lamp_power;
    }

    public void setModlamp_a_power(byte modlamp_a_power) {
        byte modlamp_b_power = this.getModlamp_b_power();
        this.sendNative(7, new byte[]{modlamp_a_power, modlamp_b_power});
    }

    public void setModlamp_b_power(byte modlamp_b_power) {
        byte modlamp_a_power = this.getModlamp_a_power();
        this.sendNative(7, new byte[]{modlamp_a_power, modlamp_b_power});
    }

    protected void sendNative(int iotIndex, byte[] data) {
        this.mContext.mModuleManagerSdk.send(this.mElinchromDevice, iotIndex, data.length, data);
    }

    public void setNew_firmware_available(int new_firmware_available) {
        this.new_firmware_available = new_firmware_available;
    }

    public void setNum_outlets(byte num_outlets) {
        this.Num_outlets = num_outlets;
    }

    public void setNum_sequence_units(byte num_sequence_units) {
        this.num_sequence_units = num_sequence_units;
    }

    public void setPhotocell_mode(byte photocell_mode) {
        this.sendNative(10, new byte[]{(byte)(photocell_mode != 0 ? 1 : 0), (byte)(photocell_mode == 2 ? 1 : 0)});
    }

    public void setPhotocell_mode(boolean photocell, boolean eyecell) {
        this.sendNative(10, new byte[]{(byte)(photocell ? 1 : 0), (byte)(eyecell ? 1 : 0)});
    }

    public void setSequence_address(byte sequence_address) {
        this.sequence_address = sequence_address;
    }

    public void setSequence_timeout(short sequence_timeout) {
        this.sequence_timeout = sequence_timeout;
    }

    public void setStrobo_duration(short strobo_duration) {
        this.strobo_duration = strobo_duration;
    }

    public void setStrobo_frequency(byte strobo_frequency) {
        this.strobo_frequency = strobo_frequency;
    }

    public void setUnit_category(byte unit_category) {
        this.Unit_category = unit_category;
    }

    public void setUnit_standby(boolean unit_standby) {
        this.sendNative(11, new byte[]{(byte)(unit_standby ? 1 : 0)});
    }

    public void setSupported_ratios(byte[] supported_ratios) {
        this.Supported_ratios = supported_ratios;
    }

    public void setVersion(FirmwareVersion v) {
        this.version = v;
    }

    public void setVfc(boolean vfc) {
        this.vfc = vfc;
    }

    protected boolean unitSupportsHeadOnOff() {
        switch (this.mElinchromDevice.getProductId()) {
            case 60: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    public void updateBatteryLevel() {
        byte batteryLevel = this.readNative(11)[1];
        this.mBatteryLevel = batteryLevel < (this.mBatteryLevel == 0 ? (byte)30 : 20) ? (byte)0 : (batteryLevel < (this.mBatteryLevel == 1 ? (byte)55 : 45) ? (byte)1 : (batteryLevel < (this.mBatteryLevel == 2 ? (byte)80 : 70) ? (byte)2 : (byte)3));
    }

    public void updateLampMode(int lampMode) {
        if (lampMode == 3) {
            if ((this.getLamp_mode() & 0xF) != 3) {
                this.setLamp_mode_mode(3);
                byte[] checkedValues = this.checkPowerBoundsModLamp(this.getModlamp_a_power(), this.getModlamp_b_power());
                this.setLamp_power_fstop(checkedValues[0], checkedValues[1]);
            }
        } else if (this.getLamp_mode_mode() != lampMode) {
            this.setLamp_mode_mode(lampMode);
        }
    }

    public void setLampFreeIfNeeded() {
        if ((this.getLamp_mode() & 0xF) != 3) {
            this.setLamp_mode_mode(3);
        }
    }

    public LayoutViewUnit getLayoutViewUnit() {
        return this.mLayoutViewUnit;
    }

    public int getLampPowerMinusA() {
        int minusLampPower = 0;
        if (this.isHeadAOn() || this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    public int getLampPowerMinusB() {
        return 0;
    }

    public int getLampPowerPlusA() {
        int plusLampPower = 0;
        if (this.isHeadAOn() || this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    public int getLampPowerPlusB() {
        return 0;
    }

    public boolean isSelected(boolean nothingSelected) {
        return (nothingSelected || this.getLayoutViewUnit().mIsSelected) && (1 << this.getGroup() & this.mContext.mGroupSelected) != 0;
    }

    public boolean isSelectedLamp(boolean nothingSelected) {
        return this.isSelected(nothingSelected);
    }

    public boolean isSelectedPower(boolean nothingSelected) {
        return this.isSelected(nothingSelected);
    }

    public class Versioned_skyport_commands {
        String From_version;
        String[] Commands;

        public Versioned_skyport_commands(String From_version, String[] Commands) {
            this.From_version = From_version;
            this.Commands = Commands;
        }
    }
}

