/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnitCategoryFullyAsymmetric;

public class FlashDeviceFullyAsymmetric
extends FlashDevice {
    public FlashDeviceFullyAsymmetric(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
        this.mFeatureList[1] = 1;
        this.mFeatureList[2] = 1;
        this.mFeatureList[4] = 1;
        this.mFeatureList[5] = 1;
        this.mFeatureList[10] = 1;
        this.mPowerTitle = "Total power";
        this.mRecyclingModeLabels = new String[]{"Eco", "Fast"};
        this.mRecyclingModePosition = new int[]{0, 0, 1, 1};
        this.mRecyclingModeValues = new byte[]{0, 2};
        this.mLayoutViewUnit = new LayoutViewUnitCategoryFullyAsymmetric(context, this.mElinchromDevice);
    }

    @Override
    public boolean areAllHeadsOn() {
        return this.getHead_on() == 3;
    }

    @Override
    public byte[] getClippedFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsMain(flashPowerValues);
    }

    @Override
    public byte[] getClippedLampPowerValuesFromFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsModLamp(flashPowerValues[1], flashPowerValues[2]);
    }

    @Override
    public int getLampPowerMinusA() {
        int minusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    @Override
    public int getLampPowerMinusB() {
        int minusLampPower = 0;
        if (this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[1], this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    @Override
    public int getLampPowerPlusA() {
        int plusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    @Override
    public int getLampPowerPlusB() {
        int plusLampPower = 0;
        if (this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[1], this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    @Override
    public byte getMaxFlashPowerHeadA() {
        byte result = this.mElinchromDevice.valueGetByte(35);
        if (this.areAllHeadsOn()) {
            result = (byte)(result - this.getMinFlashPowerHeadA());
        }
        return result;
    }

    @Override
    public byte getMaxFlashPowerHeadB() {
        return this.getMaxFlashPowerHeadA();
    }

    @Override
    public byte getMinFlashPowerMain() {
        byte result = this.mElinchromDevice.valueGetByte(34);
        if (this.areAllHeadsOn()) {
            result = (byte)(result + 10);
        }
        return result;
    }
}

