/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnitCategoryMultipleRatios;

public class FlashDeviceMultipleRatios
extends FlashDevice {
    public FlashDeviceMultipleRatios(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
        this.mFeatureList[1] = 1;
        this.mFeatureList[3] = 1;
        this.mFeatureList[4] = 1;
        this.mFeatureList[5] = 1;
        this.mFeatureList[7] = 0;
        this.mFeatureList[8] = 1;
        this.mFeatureList[11] = 1;
        this.mPowerTitle = "Total power";
        this.mRecyclingModeLabels = new String[]{"Eco", "Default", "Fast"};
        this.mRecyclingModePosition = new int[]{1, 0, 2, 2};
        this.mRecyclingModeValues = new byte[]{1, 0, 2};
        this.mPowerRatioLabels = new String[]{"50/50", "66/33"};
        this.mPowerRatioPosition = new int[]{0, 0, 1};
        this.mPowerRatioValues = new byte[]{1, 2};
        this.mLayoutViewUnit = new LayoutViewUnitCategoryMultipleRatios(context, this.mElinchromDevice);
    }

    @Override
    public boolean areAllHeadsOn() {
        return this.getHead_on() == 3;
    }

    @Override
    public byte[] getClippedFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsMain(flashPowerValues);
    }

    @Override
    public byte[] getClippedLampPowerValuesFromFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsModLamp(flashPowerValues[1], flashPowerValues[2]);
    }

    @Override
    public byte[] getFlash_power_values() {
        return this.computeHeadsValues(this.readNative(3)[0]);
    }

    @Override
    public int getLampPowerMinusA() {
        int minusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    @Override
    public int getLampPowerMinusB() {
        int minusLampPower = 0;
        if (this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[1], this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    @Override
    public int getLampPowerPlusA() {
        int plusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[0], this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    @Override
    public int getLampPowerPlusB() {
        int plusLampPower = 0;
        if (this.isHeadBOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getLamp_power_fstop_values()[1], this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    @Override
    public byte getMaxFlashPowerHeadA() {
        return (byte)(this.isHeadBOn() ? (this.getHeads_ratio() == 1 ? 65 : 69) : 75);
    }

    @Override
    public byte getMaxFlashPowerHeadB() {
        return this.getHeads_ratio() == 1 ? (byte)65 : 59;
    }

    @Override
    public byte getMaxFlashPowerMain() {
        return (byte)(!this.isHeadAOn() && this.isHeadBOn() ? (this.getHeads_ratio() == 1 ? 65 : 59) : 75);
    }

    @Override
    public byte getMinFlashPowerHeadA() {
        return this.isHeadBOn() ? (this.getHeads_ratio() == 1 ? (byte)1 : 11) : (this.getHeads_ratio() == 1 ? (byte)11 : 17);
    }

    @Override
    public byte getMinFlashPowerMain() {
        return !this.isHeadAOn() && this.isHeadBOn() ? (byte)1 : (this.getHeads_ratio() == 1 ? (byte)11 : 17);
    }

    @Override
    public void setFlash_power_values(byte[] flash_power) {
        this.setFlash_power(flash_power[0], (byte)0, (byte)0);
    }
}

