/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FileDocumentFirmwareFile;
import com.elinchrom.software.JsonNewsFirmwareFile;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewUpdate;
import com.elinchrom.software.LayoutViewUpdateListItem;
import com.elinchrom.software.SortedDeviceItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import javafx.application.Platform;
import javafx.scene.layout.Pane;
import org.apache.commons.io.IOUtils;

public class LayoutPresenterUpdate
extends LayoutPresenter {
    public LayoutViewUpdate mLayoutViewUpdate = new LayoutViewUpdate(this.mContext);
    public Pane mParentView = null;
    public int mCountUpdates = 0;
    public int mCountUpdateSuccess = 0;
    public int mCountUpdateFailure = 0;
    public LayoutViewUpdateListItem mHasNewFirmwareSav = null;
    public int mState = 0;
    protected Instant mScanStartTime = null;
    protected long mElinchromDeviceId = 0L;

    public LayoutPresenterUpdate(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewUpdate);
    }

    public void addUnit(ElinchromDevice flashUnit) {
        this.mContext.mLayoutPresenterUpdateList.addUnit(flashUnit);
    }

    public void animateProgress(ElinchromDevice elinchromDevice, int progress) {
        if (!(this.mContext.mUtil.isWindows() || this.mElinchromDeviceId != elinchromDevice.mDeviceId || elinchromDevice.getProductId() != 200 && elinchromDevice.getProductId() != 202 && elinchromDevice.getProductId() != 203 && elinchromDevice.getProductId() != 204 && elinchromDevice.getProductId() != 205 && elinchromDevice.getProductId() != 206 && elinchromDevice.getProductId() != 201)) {
            this.onUpdateFirmwareStatus(elinchromDevice, 1, progress);
            this.onUpdateFirmwareStatus(elinchromDevice, 2, progress);
            if (progress < 100) {
                this.mContext.mUtil.sleep(214L);
                this.mContext.mModuleManagerApp.enqueueUiTask(8, 8, progress + 1, 0L, elinchromDevice.mDeviceId);
            }
        }
    }

    public void displayResult(int result) {
        if (result == 0) {
            ++this.mCountUpdateSuccess;
        } else {
            ++this.mCountUpdateFailure;
        }
    }

    public void displayResults() {
        if (this.mCountUpdateSuccess > 0 && this.mCountUpdateFailure > 0) {
            this.mLayoutViewUpdate.displayStatusText(this.mCountUpdateSuccess + " firmware update" + (this.mCountUpdateSuccess > 1 ? "s were" : " was") + " successful, please do " + this.mCountUpdateFailure + " update" + (this.mCountUpdateFailure > 1 ? "s" : "") + " again. It is now safe to disconnect your units.");
        } else if (this.mCountUpdateSuccess > 0) {
            this.mLayoutViewUpdate.displayStatusText(this.mCountUpdateSuccess + " firmware update" + (this.mCountUpdateSuccess > 1 ? "s were" : " was") + " successful. It is now safe to disconnect your unit" + (this.mCountUpdates > 1 ? "s" : "") + ".");
        } else if (this.mCountUpdateFailure > 0) {
            this.mLayoutViewUpdate.displayStatusText("Please do " + this.mCountUpdateFailure + " firmware update" + (this.mCountUpdateFailure > 1 ? "s" : "") + " again. It is now safe to disconnect your unit" + (this.mCountUpdates > 1 ? "s" : "") + ".");
        } else {
            this.mLayoutViewUpdate.displayStatusText("");
        }
        this.mCountUpdateSuccess = 0;
        this.mCountUpdateFailure = 0;
    }

    public void displayUpdates() {
        this.mLayoutViewUpdate.initIfNeeded();
        this.mLayoutViewUpdate.displayProgressBars(false);
        this.mLayoutViewUpdate.displayStatusText("");
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.setMouseTransparent(false);
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.setMouseTransparent(true);
        this.mContext.mLayoutPresenterUpdateList.present((Pane)this.mLayoutViewUpdate.mLayoutNodeDisplayMain);
        this.mContext.mLayoutPresenterUpdateList.displayMark(null);
    }

    public void displayUpdateWithDetails(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mLayoutViewUpdate.initIfNeeded();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.setMouseTransparent(true);
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.setMouseTransparent(false);
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.setMouseTransparent(false);
        this.mContext.mLayoutPresenterUpdateList.present((Pane)this.mLayoutViewUpdate.mLayoutNodeDisplayLeft);
        this.mContext.mLayoutPresenterUpdateDetail.present((Pane)this.mLayoutViewUpdate.mLayoutNodeDisplayRight);
        this.mContext.mLayoutPresenterUpdateList.displayMark(layoutViewUpdateListItem);
        this.mContext.mLayoutPresenterUpdateDetail.displayUpdateListItem(layoutViewUpdateListItem);
    }

    public void displayStartedExtract(ElinchromDevice elinchromDevice) {
        this.mContext.mLayoutPresenterSideMenu.enableDarkMask();
        this.mLayoutViewUpdate.displayFindUnits(false);
        this.mLayoutViewUpdate.displayStatusText("Extract in progress, do not turn off your computer or disconnect your unit !");
        this.mLayoutViewUpdate.displayProgressValue(2, 0, 0, 0);
        this.mLayoutViewUpdate.displayProgressBarForExtract();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.setMouseTransparent(false);
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.setMouseTransparent(true);
        this.mContext.mLayoutPresenterUpdateList.presentStartedExtract((Pane)this.mLayoutViewUpdate.mLayoutNodeDisplayMain, elinchromDevice);
    }

    public void displayStartedUpdates() {
        this.mContext.mLayoutPresenterSideMenu.enableDarkMask();
        this.mLayoutViewUpdate.displayFindUnits(false);
        this.mLayoutViewUpdate.displayStatusText("Update in progress, do not turn off your computer or disconnect your unit" + (this.mCountUpdates > 1 ? "s" : "") + " !");
        this.mLayoutViewUpdate.displayProgressValue(1, 0, 0, 0);
        this.mLayoutViewUpdate.displayProgressValue(2, 0, 0, 0);
        this.mLayoutViewUpdate.displayProgressUnits(0);
        this.mLayoutViewUpdate.displayProgressBars(true);
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewUpdate.mLayoutNodeDisplayMain.setMouseTransparent(false);
        this.mLayoutViewUpdate.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        this.mLayoutViewUpdate.mLayoutNodeDisplayRight.setMouseTransparent(true);
        this.mContext.mLayoutPresenterUpdateList.presentStartedUpdates((Pane)this.mLayoutViewUpdate.mLayoutNodeDisplayMain);
    }

    public void onExtractFirmwareStatus(ElinchromDevice elinchromDevice, int event, int value) {
        switch (event) {
            case 2: {
                this.mLayoutViewUpdate.displayProgressValue(event, value, 0, 1);
                break;
            }
        }
    }

    public void onFindUnits() {
        this.mContext.mLayoutPresenterChannel.onRefreshUpdates();
    }

    public void onFirmwareExtracted(ElinchromDevice elinchromDevice, int board1Size, int board2Size) {
        boolean isSuccess = false;
        this.mElinchromDeviceId = 0L;
        Object message = "";
        if (elinchromDevice != null) {
            FileOutputStream outputStream;
            File firmwareFile;
            String firmwareName;
            int result;
            byte[] boardBuffer;
            isSuccess = elinchromDevice.mComponentUpdatable.mNumberOfBoards > 1 ? board1Size > 0 && board2Size > 0 : board1Size > 0;
            elinchromDevice.mComponentUpdatable.getLayoutViewUpdate().displayResultExtract(isSuccess ? 0 : 1);
            if (board1Size > 0) {
                boardBuffer = new byte[board1Size];
                result = this.mContext.mModuleManagerApp.ElinchromDeviceSdkValueGet(elinchromDevice.mDeviceSdk, 76, board1Size, boardBuffer);
                firmwareName = elinchromDevice.getFirmwareFileName1();
                firmwareFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + firmwareName);
                try {
                    outputStream = new FileOutputStream(firmwareFile);
                    outputStream.write(boardBuffer);
                    message = (String)message + firmwareName;
                    outputStream.close();
                }
                catch (Throwable t) {
                    this.mContext.mLogger.printStackTrace(t);
                }
            }
            if (board2Size > 0) {
                boardBuffer = new byte[board2Size];
                result = this.mContext.mModuleManagerApp.ElinchromDeviceSdkValueGet(elinchromDevice.mDeviceSdk, 77, board2Size, boardBuffer);
                firmwareName = elinchromDevice.getFirmwareFileName2();
                firmwareFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + firmwareName);
                try {
                    outputStream = new FileOutputStream(firmwareFile);
                    outputStream.write(boardBuffer);
                    message = (String)message + ", " + firmwareName;
                    outputStream.close();
                }
                catch (Throwable t) {
                    this.mContext.mLogger.printStackTrace(t);
                }
            }
        }
        if (isSuccess) {
            this.mLayoutViewUpdate.displayStatusText((String)message + " saved in " + System.getProperty("user.home") + ".");
        } else {
            this.mLayoutViewUpdate.displayStatusText("Please extract firmware again. It is now safe to disconnect your unit.");
        }
        this.mLayoutViewUpdate.displayProgressValue(2, 100, 0, 0);
        Platform.runLater(() -> this.mLayoutViewUpdate.displayOk(true));
    }

    public void onOk() {
        this.mContext.mIsUpdating = false;
        this.mLayoutViewUpdate.displayOk(false);
        this.mContext.mLayoutPresenterChannel.onRefreshUpdates();
    }

    public void onSavExtractFirmware(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        ElinchromDevice elinchromDevice = layoutViewUpdateListItem.mElinchromDevice;
        if (elinchromDevice.valueGetByte(60) == 3) {
            this.mContext.mIsUpdating = true;
            this.displayStartedExtract(elinchromDevice);
            this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 47, 0L, 0L, elinchromDevice.mDeviceId);
            layoutViewUpdateListItem.displayStartedFirmwareStatus("Extracting ...");
            this.mElinchromDeviceId = elinchromDevice.mDeviceId;
            this.animateProgress(elinchromDevice, 1);
        }
    }

    public void onSavLoadVersion(LayoutViewUpdateListItem layoutViewUpdateListItem, File fileToOpen) {
        this.mHasNewFirmwareSav = null;
        if (fileToOpen != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileToOpen)));
                String firstLine = br.readLine();
                IOUtils.closeQuietly(br);
                int fieldIndex = firstLine.equals(";Elinchrom Firmware_MCUID0") ? 12 : (firstLine.equals(";Elinchrom Firmware_MCUID1") ? 13 : 12);
                FileDocumentFirmwareFile onlineFirmwareFile = new FileDocumentFirmwareFile(this.mContext).fromLocalFile(fileToOpen);
                if (onlineFirmwareFile.tryValidate()) {
                    byte[] fileFirmware = onlineFirmwareFile.getAllBytes();
                    this.mContext.mModuleManagerSdk.addProduct(layoutViewUpdateListItem.mElinchromDevice.getProductId(), fieldIndex, fileFirmware.length, fileFirmware, 0);
                    this.mHasNewFirmwareSav = layoutViewUpdateListItem;
                }
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        this.displayUpdates();
    }

    public void onSavSelectVersion(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.enableDarkMask();
        this.mContext.mAppMain.showSavSelectVersion(layoutViewUpdateListItem);
    }

    public void onShowAllUnits(boolean showAllUpdateUnits) {
        this.mContext.mShowAllUpdateUnits = showAllUpdateUnits;
        this.displayUpdates();
    }

    public void onUnit(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        if (!this.mContext.mIsUpdating) {
            this.displayUpdateWithDetails(layoutViewUpdateListItem);
        }
    }

    public void onToggleSav() {
        if (!this.mContext.mIsUpdating) {
            byte isSav = (byte)(this.mContext.mModuleManagerSdk.valueGetByte(48) == 0 ? 1 : 0);
            this.mContext.mModuleManagerSdk.valueSetByte(48, isSav);
            this.mContext.mLayoutPresenterUpdateList.displayUpdates();
        }
    }

    public void onUpdate() {
        this.mCountUpdates = 0;
        this.mCountUpdateSuccess = 0;
        this.mCountUpdateFailure = 0;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedUpdates) {
            ElinchromDevice elinchromDevice = sortedDeviceItem.getElinchromDevice();
            LayoutViewUpdateListItem layoutViewUnit = sortedDeviceItem.getElinchromDevice().mComponentUpdatable.getLayoutViewUpdate();
            if (!layoutViewUnit.mHasNewFirmware || elinchromDevice.valueGetByte(60) != 3 || !layoutViewUnit.mIsSelected) continue;
            ++this.mCountUpdates;
        }
        if (this.mCountUpdates > 0) {
            this.displayStartedUpdates();
            this.mContext.mCurrentUpdate = this.mContext.mSortedUpdates.iterator();
            this.onUpdateNext();
        }
    }

    public void onUpdateFirmwareStatus(ElinchromDevice elinchromDevice, int event, int value) {
        switch (event) {
            case 0: {
                this.mElinchromDeviceId = 0L;
                this.displayResult(value);
                if (elinchromDevice != null) {
                    elinchromDevice.mComponentUpdatable.getLayoutViewUpdate().displayResult(value);
                }
                if (this.mCountUpdateFailure + this.mCountUpdateSuccess < this.mCountUpdates) {
                    this.mLayoutViewUpdate.displayProgressValue(1, 0, 0, 0);
                    this.mLayoutViewUpdate.displayProgressValue(2, 0, 0, 0);
                    this.onUpdateNext();
                    break;
                }
                this.mLayoutViewUpdate.displayProgressValue(1, 100, 0, 0);
                this.mLayoutViewUpdate.displayProgressValue(2, 100, 0, 0);
                this.mLayoutViewUpdate.displayProgressUnits(100);
                this.displayResults();
                Platform.runLater(() -> this.mLayoutViewUpdate.displayOk(true));
                break;
            }
            case 1: 
            case 2: {
                this.mLayoutViewUpdate.displayProgressValue(event, value, this.mCountUpdateFailure + this.mCountUpdateSuccess, this.mCountUpdates);
                break;
            }
        }
    }

    public void onUpdateNext() {
        this.mContext.mIsUpdating = false;
        while (this.mContext.mCurrentUpdate.hasNext()) {
            ElinchromDevice elinchromDevice = this.mContext.mCurrentUpdate.next().getElinchromDevice();
            LayoutViewUpdateListItem layoutViewUnit = elinchromDevice.mComponentUpdatable.getLayoutViewUpdate();
            if (!layoutViewUnit.mHasNewFirmware || elinchromDevice.valueGetByte(60) != 3 || !layoutViewUnit.mIsSelected) continue;
            if (this.mContext.mModuleManagerSdk.valueGetByte(48) == 0) {
                JsonNewsFirmwareFile[] firmwareFiles;
                for (JsonNewsFirmwareFile jsonNewsFirmwareFile : firmwareFiles = this.mContext.mFileDocumentFirmwareNews.getFirmwareFiles(elinchromDevice)) {
                    int fieldIndex = 0;
                    boolean isValidTarget = false;
                    FileDocumentFirmwareFile onlineFirmwareFile = new FileDocumentFirmwareFile(this.mContext).fromUrl("https://services.elinchrom.com/firmware", jsonNewsFirmwareFile.file_name);
                    switch (jsonNewsFirmwareFile.target_name) {
                        case "BOOTLOADER": {
                            fieldIndex = 11;
                            isValidTarget = true;
                            break;
                        }
                        case "BOARD_1": {
                            fieldIndex = 12;
                            isValidTarget = true;
                            break;
                        }
                        case "BOARD_2": {
                            fieldIndex = 13;
                            isValidTarget = true;
                            break;
                        }
                    }
                    if (!isValidTarget || !onlineFirmwareFile.tryValidate()) continue;
                    int version = (int)jsonNewsFirmwareFile.firmware_version << 8 | (int)(jsonNewsFirmwareFile.firmware_version * 10.0f) % 10;
                    byte[] fileFirmware = onlineFirmwareFile.getAllBytes();
                    this.mContext.mModuleManagerSdk.addProduct(elinchromDevice.getProductId(), fieldIndex, fileFirmware.length, fileFirmware, version);
                    onlineFirmwareFile.discardTemporaryData();
                }
            }
            this.mContext.mIsUpdating = true;
            this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 32, 0L, 0L, elinchromDevice.mDeviceId);
            layoutViewUnit.displayStartedFirmwareStatus("Updating ...");
            this.mElinchromDeviceId = elinchromDevice.mDeviceId;
            this.animateProgress(elinchromDevice, 1);
            break;
        }
        if (this.mCountUpdates > 0 && !this.mContext.mIsUpdating) {
            this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 33, 0L, 0L, 0L);
        }
    }

    @Override
    public void present(Pane parentView) {
        super.present(parentView);
        this.mContext.mCurrentLayoutPresenter = this;
        this.mParentView = parentView;
        this.displayUpdates();
    }

    public void refresh(int arg) {
    }
}

