/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.JsonHelpLinks;
import com.elinchrom.software.LayoutView;
import java.net.URL;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewHelpLinks
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public ScrollPane mHelpUpdateListScrollView = null;
    public GridPane mScrollContentPane = null;

    public LayoutViewHelpLinks(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    public void displayLinks(JsonHelpLinks[] jsonHelpLinks) {
        float insetTop = 5.0f;
        Pane line = null;
        for (JsonHelpLinks jsonHelpLink : jsonHelpLinks) {
            Text textHelpTitle = new Text(jsonHelpLink.help_title);
            textHelpTitle.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
            textHelpTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxHelpTitle = new TextFlow();
            boxHelpTitle.setTextAlignment(TextAlignment.LEFT);
            boxHelpTitle.setMinWidth(674.0);
            boxHelpTitle.setPrefWidth(674.0);
            boxHelpTitle.setMaxWidth(674.0);
            boxHelpTitle.setMinHeight(25.0);
            boxHelpTitle.setPrefHeight(25.0);
            boxHelpTitle.setMaxHeight(25.0);
            boxHelpTitle.getChildren().add((Object)textHelpTitle);
            GridPane.setConstraints((Node)boxHelpTitle, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets((double)(insetTop + 15.0f) - textHelpTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
            Text textHelpUrl = new Text(jsonHelpLink.help_url);
            textHelpUrl.setFill((Paint)Color.web((String)this.mContext.mNightActivatedColor, (double)1.0));
            textHelpUrl.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxHelpUrl = new TextFlow();
            boxHelpUrl.setTextAlignment(TextAlignment.LEFT);
            boxHelpUrl.setMinWidth(674.0);
            boxHelpUrl.setPrefWidth(674.0);
            boxHelpUrl.setMaxWidth(674.0);
            boxHelpUrl.setMinHeight(25.0);
            boxHelpUrl.setPrefHeight(25.0);
            boxHelpUrl.setMaxHeight(25.0);
            boxHelpUrl.getChildren().add((Object)textHelpUrl);
            boxHelpUrl.setOnMouseClicked(event -> {
                try {
                    if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                        this.mContext.mUtil.openWebpage(new URL(jsonHelpLink.help_url));
                    }
                }
                catch (Throwable t) {
                    this.mContext.mLogger.printStackTrace(t);
                }
            });
            GridPane.setConstraints((Node)boxHelpUrl, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets((double)(insetTop + 40.0f) - textHelpUrl.getBaselineOffset(), 0.0, 0.0, 0.0));
            line = new Pane();
            line.setMinWidth(674.0);
            line.setPrefWidth(674.0);
            line.setMaxWidth(674.0);
            line.setMinHeight(1.0);
            line.setPrefHeight(1.0);
            line.setMaxHeight(1.0);
            line.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
            GridPane.setConstraints((Node)line, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets((double)(insetTop + 60.0f), 0.0, 0.0, 0.0));
            this.mScrollContentPane.getChildren().addAll((Object[])new Node[]{boxHelpTitle, boxHelpUrl, line});
            insetTop += 75.0f;
        }
        if (line != null) {
            line.setVisible(false);
            line.setManaged(false);
        }
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, true);
        column.setPercentWidth(100.0);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, true);
        row.setPercentHeight(100.0);
        ColumnConstraints columnContent = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.CENTER, false);
        column.setPercentWidth(100.0);
        RowConstraints rowContent = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, false);
        this.mScrollContentPane = new GridPane();
        this.mScrollContentPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnContent});
        this.mScrollContentPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowContent});
        GridPane.setConstraints((Node)this.mScrollContentPane, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mHelpUpdateListScrollView = new ScrollPane();
        this.mHelpUpdateListScrollView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mHelpUpdateListScrollView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mHelpUpdateListScrollView.setFitToWidth(true);
        this.mHelpUpdateListScrollView.setContent((Node)this.mScrollContentPane);
        GridPane.setConstraints((Node)this.mHelpUpdateListScrollView, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mHelpUpdateListScrollView});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            this.mHelpUpdateListScrollView.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateListScrollView, this.mScrollContentPane});
            this.getChildren().add((Object)this.mScrollContentPane);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateListScrollView, this.mScrollContentPane});
            this.mHelpUpdateListScrollView.setContent((Node)this.mScrollContentPane);
            this.getChildren().add((Object)this.mHelpUpdateListScrollView);
        }
    }
}

