/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.JsonHelpContents;
import com.elinchrom.software.JsonHelpFirmwareUpdate;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewHelpUpdateListItem
extends GridPane
implements LayoutView {
    public Context mContext;
    public JsonHelpFirmwareUpdate mJsonHelpFirmwareUpdate;
    public JsonNewsFirmware mJsonNewsFirmware;
    public JsonHelpContents mJsonHelpContents;
    public int mConnectionType;
    public URL mImageUrl;
    public boolean mIsInitialized = false;
    public ImageView mImageUnit = null;
    public LayoutWidgetIcon mLineMark = null;
    public LayoutWidgetIcon mIconConnection = null;
    public LayoutWidgetIcon mIconSignal = null;
    public Text mTextProductName = null;
    public Text mFirmwareStatus = null;

    public LayoutViewHelpUpdateListItem(Context context, JsonHelpFirmwareUpdate jsonHelpFirmwareUpdate, JsonNewsFirmware jsonNewsFirmware, JsonHelpContents jsonHelpContents, int connectionType, URL imageUrl) {
        this.mContext = context;
        this.mJsonHelpFirmwareUpdate = jsonHelpFirmwareUpdate;
        this.mJsonNewsFirmware = jsonNewsFirmware;
        this.mJsonHelpContents = jsonHelpContents;
        this.mConnectionType = connectionType;
        this.mImageUrl = imageUrl;
    }

    public void displayMark(boolean showMark) {
        this.mLineMark.setVisible(showMark);
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    public String getLatestFirmwareVersion() {
        Object latestFirmwareVersion = "";
        if (this.mJsonNewsFirmware.firmwares.length > 1) {
            latestFirmwareVersion = (String)latestFirmwareVersion + (int)(this.mJsonNewsFirmware.firmwares[0].firmware_version * 10.0f);
            latestFirmwareVersion = (String)latestFirmwareVersion + ".";
            latestFirmwareVersion = (String)latestFirmwareVersion + (int)(this.mJsonNewsFirmware.firmwares[1].firmware_version * 10.0f);
        } else if (this.mJsonNewsFirmware.firmwares.length > 0) {
            latestFirmwareVersion = (String)latestFirmwareVersion + this.mJsonNewsFirmware.firmwares[0].firmware_version;
        }
        return latestFirmwareVersion;
    }

    @Override
    public void init() {
        this.setOnMouseClicked(this::onTouchItem);
        this.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 50px 0px 50px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        ColumnConstraints columnLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(12.0);
        ColumnConstraints columnImage = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnImage.setPercentWidth(13.0);
        ColumnConstraints columnName = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnName.setPercentWidth(36.0);
        ColumnConstraints columnVersion = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnVersion.setPercentWidth(39.0);
        RowConstraints rowTop = new RowConstraints(35.0, 35.0, 35.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowBottom = new RowConstraints(37.0, 37.0, 37.0, Priority.NEVER, VPos.TOP, false);
        this.mImageUnit = new ImageView();
        this.mImageUnit.setFitWidth(64.0);
        this.mImageUnit.setFitHeight(64.0);
        this.mImageUnit.setPreserveRatio(true);
        this.mImageUnit.setSmooth(true);
        GridPane.setConstraints((Node)this.mImageUnit, (int)1, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        if (this.mImageUrl != null) {
            this.mImageUnit.setImage(new Image(this.mImageUrl.toString()));
        }
        this.mTextProductName = new Text(this.mJsonHelpFirmwareUpdate.title_of_help_item);
        this.mTextProductName.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mTextProductName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
        TextFlow boxProductName = new TextFlow();
        boxProductName.setTextAlignment(TextAlignment.LEFT);
        boxProductName.setPrefHeight(72.0);
        boxProductName.setMaxHeight(72.0);
        boxProductName.getChildren().add((Object)this.mTextProductName);
        this.mContext.mUtil.setTextBaseline(boxProductName, this.mTextProductName, 41.0);
        GridPane.setConstraints((Node)boxProductName, (int)2, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        List<String> imageConnection = Arrays.asList("day_connection_usb.svg", "day_connection_usb.svg", "day_connection_ble.svg", "day_connection_skyport.svg");
        this.mIconConnection = this.mContext.mUtil.factoryIconSet(24, 24, imageConnection, this.mConnectionType);
        this.mIconConnection.setTranslateY(7.0);
        GridPane.setConstraints((Node)this.mIconConnection, (int)3, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mFirmwareStatus = new Text("Latest firmware " + this.getLatestFirmwareVersion());
        this.mFirmwareStatus.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFirmwareStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxFirmwareStatus = new TextFlow();
        boxFirmwareStatus.setTextAlignment(TextAlignment.LEFT);
        boxFirmwareStatus.setTranslateX(1.0);
        boxFirmwareStatus.getChildren().add((Object)this.mFirmwareStatus);
        this.mContext.mUtil.setTextBaseline(boxFirmwareStatus, this.mFirmwareStatus, 21.0);
        GridPane.setConstraints((Node)boxFirmwareStatus, (int)3, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mLineMark = new LayoutWidgetIcon(this.mContext, 36.0, 36.0, "line_mark.svg", "", this.mContext.mFontRegular, 7.5, this.mContext.mNightActivatedColor);
        this.mLineMark.setTranslateX(-32.0);
        this.mLineMark.setVisible(false);
        GridPane.setConstraints((Node)this.mLineMark, (int)3, (int)0, (int)1, (int)2, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnImage, columnName, columnVersion});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mImageUnit, boxProductName, this.mIconConnection, boxFirmwareStatus, this.mLineMark});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchItem(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterHelp.displayHelpUpdateWithDetails(this);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

