/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;

public class LayoutViewMessage
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public StackPane mLayoutNodeOverlay = null;
    public String mName = "";
    public String mDestinationName = "";
    public LayoutWidgetIcon mShowAgainButton = null;
    public boolean mIsDoNotShowAgainChecked = false;
    public int mMessageId = 0;
    public int mElConfImageId = 0;

    public LayoutViewMessage(Context context) {
        this.mContext = context;
    }

    public void displayDoNotShowAgain(boolean isDoNotShowAgainChecked) {
        if (this.mShowAgainButton != null) {
            this.mShowAgainButton.setTint(isDoNotShowAgainChecked ? "000000" : "909090");
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        ColumnConstraints columnDisplaySideNavigation = new ColumnConstraints(256.0, 256.0, 256.0, Priority.NEVER, HPos.LEFT, true);
        ColumnConstraints columnDisplayMain = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.CENTER, false);
        RowConstraints rowDisplay = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.CENTER, false);
        StackPane layoutNodeSideNavigation = new StackPane();
        layoutNodeSideNavigation.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + this.mContext.mOpacityTransparent + ";");
        GridPane.setMargin((Node)layoutNodeSideNavigation, (Insets)new Insets(100.0, 0.0, 0.0, 0.0));
        GridPane.setFillHeight((Node)layoutNodeSideNavigation, (Boolean)true);
        this.add((Node)layoutNodeSideNavigation, 0, 0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDisplaySideNavigation, columnDisplayMain});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowDisplay});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void onTouchClose(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterMessages.onClose(this.mMessageId, this.mIsDoNotShowAgainChecked ? 0 : 1);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchDoNotShowAgain(MouseEvent event) {
        try {
            this.setIsDoNotShowAgainChecked(!this.mIsDoNotShowAgainChecked);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFeedback(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterMessages.onFeedback();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchNo(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterMessages.onNo(this.mMessageId, this.mIsDoNotShowAgainChecked ? 0 : 1);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPrivacy(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterMessages.onPrivacy();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchYes(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterMessages.onYes(this.mMessageId, this.mIsDoNotShowAgainChecked ? 0 : 1, this.mName, this.mElConfImageId);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void setIsDoNotShowAgainChecked(boolean isDoNotShowAgainChecked) {
        this.mIsDoNotShowAgainChecked = isDoNotShowAgainChecked;
        if (this.isInitialized()) {
            this.displayDoNotShowAgain(this.mIsDoNotShowAgainChecked);
        }
    }

    public void setMessageData(int elConfImageId) {
        this.mElConfImageId = elConfImageId;
    }

    public void setMessageData(String name) {
        this.mName = name;
    }

    public void setMessageData(String sourceName, String destinationName) {
        this.mName = sourceName;
        this.mDestinationName = destinationName;
    }

    public void setMessageId(int messageId) {
        this.mMessageId = messageId;
    }

    public void setTitle(String title) {
    }
}

