/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;

public class LayoutViewSceneButtons
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public Pane mDarkPane = null;
    public LayoutWidgetIcon mButtonSave = null;
    public LayoutWidgetIcon mButtonImport = null;
    public StackPane mContainerButtonExport = null;

    public LayoutViewSceneButtons(Context context) {
        this.mContext = context;
    }

    public void enableButtons(boolean isEnabled) {
        this.mDarkPane.setVisible(!isEnabled);
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.CENTER, false);
        column.setPercentWidth(100.0);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.BOTTOM, false);
        row.setPercentHeight(100.0);
        this.mButtonSave = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_save_activated.svg", 24.0, "Save", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonSave.setStyle("-fx-background-color: rgb(33,184,148);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        this.mButtonSave.setOnMouseClicked(this::onTouchSave);
        GridPane.setConstraints((Node)this.mButtonSave, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 342.0, 59.0, 0.0));
        this.mButtonImport = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_import_activated.svg", 24.0, "Import", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonImport.setStyle("-fx-background-color: rgb(51,54,59);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        this.mButtonImport.setOnMouseClicked(this::onTouchImport);
        GridPane.setConstraints((Node)this.mButtonImport, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 59.0, 0.0));
        LayoutWidgetIcon buttonExport = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_export_activated.svg", 24.0, "Export", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonExport.setStyle("-fx-background-color: rgb(51,54,59);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        buttonExport.setOnMouseClicked(this::onTouchExport);
        this.mDarkPane = new Pane();
        this.mDarkPane.setPrefSize(120.0, 32.0);
        this.mDarkPane.setStyle("-fx-background-color:rgba(0,0,0,0.72);");
        this.mContainerButtonExport = new StackPane();
        this.mContainerButtonExport.getChildren().addAll((Object[])new Node[]{buttonExport, this.mDarkPane});
        GridPane.setConstraints((Node)this.mContainerButtonExport, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 59.0, 342.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mButtonSave, this.mButtonImport, this.mContainerButtonExport});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void onFocusChangeButtonImport(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        try {
            if (!newValue.booleanValue()) {
                this.mContext.mLogger.log("focus lost");
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchExport(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterScene.onExport();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchImport(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterScene.onImport();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSave(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterScene.onSave();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void setExportEnabled(boolean isEnabled) {
        this.mDarkPane.setVisible(!isEnabled);
    }
}

