/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfImage;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.ElConfUnit;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FileDocumentPicture;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutViewSceneUnit;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.OnTouchScenePictureListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class LayoutViewSceneDetail
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public ElConfScene mElConfScene = null;
    public ScrollPane mScrollContainer = null;
    public GridPane mSceneUnits = null;
    public GridPane mScrollContent = null;
    public GridPane mSceneDetail = null;
    public TextField mSceneName = null;
    public TextArea mSceneDescription = null;
    public LayoutWidgetIcon mButtonAddImage = null;
    public VBox mImageContainer = null;

    public LayoutViewSceneDetail(Context context) {
        this.mContext = context;
    }

    public void displayElConfImages(ElConfImage[] elConfImages) {
        boolean index = false;
        this.mImageContainer.getChildren().clear();
        for (ElConfImage elConfImage : elConfImages) {
            FileDocumentPicture fileDocumentPicture = new FileDocumentPicture(this.mContext).fromElConfImage(elConfImage);
            Image image = fileDocumentPicture.getImage();
            if (image == null) continue;
            ImageView sceneImage = new ImageView();
            sceneImage.setFitWidth(632.0);
            sceneImage.setFitHeight(632.0);
            sceneImage.setPreserveRatio(true);
            sceneImage.setSmooth(true);
            sceneImage.setImage(image);
            VBox.setMargin((Node)sceneImage, (Insets)new Insets(0.0, 0.0, 45.0, 0.0));
            this.mImageContainer.getChildren().add((Object)sceneImage);
            sceneImage.setOnMouseClicked((EventHandler)new OnTouchScenePictureListener(this.mContext, this.mElConfScene, elConfImage.id));
        }
    }

    public void displayElConfScene(ElConfScene elConfScene) {
        this.mElConfScene = elConfScene;
        int countImages = elConfScene.images.length;
        int countUnits = elConfScene.units.length;
        this.mSceneName.setText(elConfScene.name);
        this.mSceneDescription.setText(elConfScene.description);
        Text helper = new Text();
        helper.setText(elConfScene.description);
        helper.setFont(this.mSceneDescription.getFont());
        helper.setWrappingWidth(617.0);
        this.mSceneDescription.setPrefHeight(helper.getLayoutBounds().getHeight() + 15.0);
        this.displayElConfImages(elConfScene.images);
        this.displayElConfUnits(elConfScene.units);
    }

    public void displayElConfUnits(ElConfUnit[] units) {
        int index = 0;
        this.mSceneUnits.getChildren().clear();
        for (ElConfUnit elConfUnit : units) {
            LayoutViewSceneUnit layoutViewSceneUnit = new LayoutViewSceneUnit(this.mContext);
            layoutViewSceneUnit.displayElConfUnit(elConfUnit);
            GridPane.setConstraints((Node)layoutViewSceneUnit, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(86.0 * (double)index++ + 14.0, 0.0, 0.0, 0.0));
            this.mSceneUnits.getChildren().add((Object)layoutViewSceneUnit);
        }
    }

    public void displaySignalStrength(ElinchromDevice elinchromDevice, int signalStrength) {
        for (Node viewNode : this.mSceneUnits.getChildren()) {
            if (!(viewNode instanceof LayoutViewSceneUnit)) continue;
            LayoutViewSceneUnit layoutViewSceneUnit = (LayoutViewSceneUnit)viewNode;
            if (!layoutViewSceneUnit.mElConfUnit.skyport_id.equals(elinchromDevice.getSkyportId())) continue;
            layoutViewSceneUnit.displaySignalStrength(signalStrength);
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        ColumnConstraints columnPaddinLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnDetail = new ColumnConstraints(632.0, 632.0, 632.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnPaddinRight = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.RIGHT, false);
        RowConstraints rowDetailTitle = new RowConstraints(95.0, 95.0, 95.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowDetailDescription = new RowConstraints(30.0, -1.0, Double.MAX_VALUE, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowDetailButon = new RowConstraints(85.0, 85.0, 85.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowDetailImages = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, VPos.TOP, false);
        this.mSceneDetail = new GridPane();
        this.mSceneDetail.getStyleClass().add((Object)"day-theme");
        this.mSceneDetail.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 0px 0px 0px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        GridPane.setConstraints((Node)this.mSceneDetail, (int)1, (int)0);
        this.mSceneName = new TextField();
        this.mSceneName.setAlignment(Pos.TOP_LEFT);
        this.mSceneName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 28.0));
        this.mSceneName.setPrefWidth(632.0);
        this.mSceneName.setPromptText("Enter a name for your scene");
        this.mSceneName.focusedProperty().addListener(this::onFocusChangeSceneName);
        this.mSceneName.setOnKeyReleased(this::onKeyScene);
        GridPane.setConstraints((Node)this.mSceneName, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(25.0, 0.0, 0.0, 0.0));
        this.mSceneDescription = new TextArea();
        this.mSceneDescription.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mSceneDescription.setPrefWidth(632.0);
        this.mSceneDescription.setPromptText("Enter a description for your scene");
        this.mSceneDescription.setWrapText(true);
        this.mSceneDescription.focusedProperty().addListener(this::onFocusChangeSceneDescription);
        GridPane.setConstraints((Node)this.mSceneDescription, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(-2.5, 0.0, 0.0, 0.0));
        this.mButtonAddImage = new LayoutWidgetIcon(this.mContext, 120.0, 30.0, null, "day_icon_plus_activated.svg", 6.0, "Add image", 24.0, this.mContext.mFontRegular, 14.0, this.mContext.mDayActivatedColor);
        this.mButtonAddImage.setOnMousePressed(this::onTouchAddImage);
        GridPane.setConstraints((Node)this.mButtonAddImage, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        this.mImageContainer = new VBox(0.0);
        this.mImageContainer.setAlignment(Pos.TOP_CENTER);
        this.mImageContainer.setMinWidth(632.0);
        this.mImageContainer.setPrefWidth(632.0);
        this.mImageContainer.setMaxWidth(632.0);
        this.mImageContainer.setMinHeight(0.0);
        this.mImageContainer.setPrefHeight(-1.0);
        this.mImageContainer.setMaxHeight(Double.MAX_VALUE);
        GridPane.setConstraints((Node)this.mImageContainer, (int)1, (int)3);
        this.mSceneDetail.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnPaddinLeft, columnDetail, columnPaddinRight});
        this.mSceneDetail.getRowConstraints().addAll((Object[])new RowConstraints[]{rowDetailTitle, rowDetailDescription, rowDetailButon, rowDetailImages});
        this.mSceneDetail.getChildren().addAll((Object[])new Node[]{this.mSceneName, this.mSceneDescription, this.mButtonAddImage, this.mImageContainer});
        ColumnConstraints column100 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, true);
        column100.setPercentWidth(100.0);
        RowConstraints rowUnits = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, VPos.TOP, false);
        this.mSceneUnits = new GridPane();
        GridPane.setConstraints((Node)this.mSceneUnits, (int)1, (int)1);
        this.mSceneUnits.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mSceneUnits.getRowConstraints().addAll((Object[])new RowConstraints[]{rowUnits});
        ColumnConstraints columnMarginLeft = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnCenter = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.CENTER, true);
        ColumnConstraints columnMarginRight = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.RIGHT, false);
        RowConstraints rowDetail = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, VPos.TOP, false);
        this.mScrollContent = new GridPane();
        GridPane.setConstraints((Node)this.mScrollContent, (int)0, (int)0);
        this.mScrollContent.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnMarginLeft, columnCenter, columnMarginRight});
        this.mScrollContent.getRowConstraints().addAll((Object[])new RowConstraints[]{rowDetail, rowUnits});
        this.mScrollContent.getChildren().addAll((Object[])new Node[]{this.mSceneDetail, this.mSceneUnits});
        this.mScrollContainer = new ScrollPane();
        this.mScrollContainer.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mScrollContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mScrollContainer.setFitToWidth(true);
        this.mScrollContainer.setContent((Node)this.mScrollContent);
        GridPane.setConstraints((Node)this.mScrollContainer, (int)0, (int)0);
        GridPane.setFillHeight((Node)this.mScrollContainer, (Boolean)true);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row.setPercentHeight(100.0);
        this.getStyleClass().add((Object)"night-theme");
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mScrollContainer});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onFocusChangeSceneDescription(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        try {
            if (!newValue.booleanValue()) {
                this.mContext.mLayoutPresenterSceneDetail.onSceneDescription(this.mElConfScene, this.mSceneDescription.getText().toString());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onFocusChangeAddImage(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        try {
            if (!newValue.booleanValue()) {
                this.mContext.mLogger.log("focus lost");
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onFocusChangeSceneName(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        try {
            if (!newValue.booleanValue()) {
                this.mContext.mLayoutPresenterSceneDetail.onSceneName(this.mElConfScene, this.mSceneName.getText().toString());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onKeyScene(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ENTER) {
            this.requestFocus();
        }
    }

    public void onTouchAddImage(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSceneDetail.onAddPicture(this.mElConfScene);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            this.mScrollContainer.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mScrollContainer, this.mScrollContent});
            this.getChildren().add((Object)this.mScrollContent);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.getChildren().removeAll((Object[])new Node[]{this.mScrollContainer, this.mScrollContent});
            this.mScrollContainer.setContent((Node)this.mScrollContent);
            this.getChildren().add((Object)this.mScrollContainer);
        }
    }
}

