/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewSceneSaveNew
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public TextField mSceneName = null;
    public LayoutWidgetIcon mButtonCancel = null;
    public LayoutWidgetIcon mButtonSaveNew = null;

    public LayoutViewSceneSaveNew(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.CENTER, false);
        column.setPercentWidth(100.0);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row.setPercentHeight(100.0);
        Text textLabelSceneName = new Text("Enter a name for your new scene");
        textLabelSceneName.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelSceneName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 24.0));
        TextFlow boxLabelSceneName = new TextFlow();
        boxLabelSceneName.getChildren().add((Object)textLabelSceneName);
        GridPane.setConstraints((Node)boxLabelSceneName, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(158.0 - textLabelSceneName.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mSceneName = new TextField();
        this.mSceneName.setAlignment(Pos.CENTER);
        this.mSceneName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.5));
        this.mSceneName.setPrefWidth(270.0);
        this.mSceneName.setText(this.mContext.mUtil.findSceneNameSuggestion());
        this.mSceneName.setOnKeyReleased(this::onKeySceneName);
        GridPane.setConstraints((Node)this.mSceneName, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(206.125, 0.0, 0.0, 0.0));
        this.mButtonCancel = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_cross_mark_enabled.svg", 26.0, "Cancel", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightEnabledColor);
        this.mButtonCancel.setStyle("-fx-background-color: rgb(51,54,59), rgb(0,0,0);-fx-background-insets: 0px, 1px;-fx-background-radius: 16px, 15px;");
        this.mButtonCancel.setOnMouseClicked(this::onTouchCancel);
        GridPane.setConstraints((Node)this.mButtonCancel, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(362.0, 172.0, 0.0, 0.0));
        this.mButtonSaveNew = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_check_mark_activated.svg", 26.0, "Create", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonSaveNew.setStyle("-fx-background-color: rgb(33,184,148);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        this.mButtonSaveNew.setOnMouseClicked(this::onTouchSaveNew);
        GridPane.setConstraints((Node)this.mButtonSaveNew, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(362.0, 0.0, 0.0, 172.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{boxLabelSceneName, this.mSceneName, this.mButtonCancel, this.mButtonSaveNew});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onKeySceneName(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ENTER) {
            this.requestFocus();
        }
    }

    public void onTouchCancel(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterSceneSave.onCancel();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSaveNew(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterSceneSave.onSaveNew(this.mSceneName.getText().toString());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSceneNameSuggestion(String sceneNameSuggestion) {
        this.mSceneName.setText(sceneNameSuggestion);
    }
}

