/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.LayoutWidgetSlider;
import com.elinchrom.software.LayoutWidgetSwitch;
import com.elinchrom.software.LayoutWidgetToggleGroup;
import com.elinchrom.software.UnitView;
import com.elinchrom.software.Unit_Prototype_Json;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewUnit
extends GridPane
implements LayoutView,
UnitView {
    static final int INDEX_LABEL_STANDBY = 0;
    static final int INDEX_LABEL_AUDIO = 1;
    static final int INDEX_LABEL_PHOTOCELL = 2;
    static final int INDEX_LABEL_RECYCLING = 3;
    static final int INDEX_LABEL_FLASH_MODE = 4;
    static final int INDEX_LABEL_SEQUENCE_TIMEOUT = 5;
    static final int INDEX_LABEL_UNIT_ADDRESS = 6;
    static final int INDEX_LABEL_DELAY = 7;
    static final int INDEX_LABEL_STROBO_DURATION = 8;
    static final int INDEX_LABEL_STROBO_FREQUENCY = 9;
    static final int INDEX_LABEL_FIRMWARE = 10;
    static final int INDEX_LABEL_FIRMWARE_VALUE = 11;
    static final int INDEX_LABEL_UNIT_ID = 12;
    static final int INDEX_LABEL_UNIT_ID_VALUE = 13;
    static final int INDEX_LABEL_FLASH_COUNT = 14;
    static final int INDEX_LABEL_FLASH_COUNT_VALUE = 15;
    static final int INDEX_LABEL_SESSION_COUNT = 16;
    static final int INDEX_LABEL_SESSION_COUNT_VALUE = 17;
    static final int COUNT_LABEL = 18;
    public Context mContext;
    public ElinchromDevice mElinchromDevice;
    public int[] mGroupPos = new int[]{0, 0, 1, 2, 3};
    public byte[] mGroupIds = new byte[]{1, 2, 3, 4};
    public String[] mGroupLabels = new String[]{"", "Group 1", "Group 2", "Group 3", "Group 4"};
    public String[] mGroupNames = new String[]{"Group 1", "Group 2", "Group 3", "Group 4"};
    public Pane mDarkMask = null;
    public GridPane mViewDashboard = null;
    public GridPane mViewSettings = null;
    public GridPane mViewInfo = null;
    public LayoutWidgetIcon mIconCheckbox = null;
    public LayoutWidgetIcon mTabDashboard = null;
    public LayoutWidgetIcon mTabSettings = null;
    public LayoutWidgetIcon mTabInfo = null;
    public LayoutWidgetIcon mIconSignal = null;
    public LayoutWidgetIcon mUnitBatteryIcon = null;
    public ComboBox<String> mChoiceGroup = null;
    public ComboBox<String> mChoiceRatio = null;
    public ComboBox<String> mChoicePhotocell = null;
    public ComboBox<String> mChoiceRecycling = null;
    public ComboBox<String> mChoiceFlashMode = null;
    public ComboBox<String> mChoiceUnitAddress = null;
    public ComboBox<String> mChoiceTotalUnits = null;
    public ComboBox<String> mChoiceStroboFrequency = null;
    public Text mSpacerSlash = null;
    public TextField mFriendlyName = null;
    public ImageView mImageUnit = null;
    public Text mFlashMainElStop = null;
    public Text mFlashMainWs = null;
    public LayoutWidgetIcon mFlashMainMinus = null;
    public LayoutWidgetIcon mFlashMainPlus = null;
    public LayoutWidgetIcon mLampOn = null;
    public LayoutWidgetSlider mFlashMainSlider = null;
    public Text mFlashMainMin = null;
    public Text mFlashMainMax = null;
    public LayoutWidgetToggleGroup mLampMode = null;
    public LayoutWidgetSwitch mLampModeSwitch = null;
    public Text mHeadALabel = null;
    public Text mHeadAElStop = null;
    public Text mHeadAWs = null;
    public LayoutWidgetSwitch mHeadASwitch = null;
    public LayoutWidgetSlider mHeadASlider = null;
    public LayoutWidgetIcon mHeadAMinus = null;
    public LayoutWidgetIcon mHeadAPlus = null;
    public Text mHeadBLabel = null;
    public Text mHeadBElStop = null;
    public Text mHeadBWs = null;
    public LayoutWidgetSwitch mHeadBSwitch = null;
    public LayoutWidgetSlider mHeadBSlider = null;
    public LayoutWidgetIcon mHeadBMinus = null;
    public LayoutWidgetIcon mHeadBPlus = null;
    public GridPane mPowerMainControlGrid = null;
    public GridPane mHeadValueGrid = null;
    public GridPane mHeadSliderGrid = null;
    public GridPane mLampModeGrid = null;
    public GridPane mLampAValueGrid = null;
    public GridPane mLampAControlGrid = null;
    public GridPane mLampBValueGrid = null;
    public GridPane mLampBControlGrid = null;
    public Text mLampLabel = null;
    public Text mLampAElStop = null;
    public LayoutWidgetIcon mLampAMinus = null;
    public LayoutWidgetIcon mLampAPlus = null;
    public LayoutWidgetSlider mLampASlider = null;
    public Text mLampAMin = null;
    public Text mLampAMax = null;
    public Text mLampBElStop = null;
    public LayoutWidgetIcon mLampBMinus = null;
    public LayoutWidgetIcon mLampBPlus = null;
    public LayoutWidgetSlider mLampBSlider = null;
    public Text mLampBMin = null;
    public Text mLampBMax = null;
    public Text[] mLabels = new Text[18];
    public Text mFirmwareStatus = null;
    public TextField mSequenceTimeout = null;
    public TextField mDelay = null;
    public TextField mStroboDuration = null;
    public LayoutWidgetIcon mFirmwareMark = null;
    public LayoutWidgetSwitch mStandbySwitch = null;
    public LayoutWidgetSwitch mAudioSwitch = null;
    public LayoutWidgetSwitch mPhotocellSwitch = null;
    public boolean mIsSelected = false;
    public boolean mIsIndented = false;
    public boolean mIsDragging = false;
    public boolean mIsSliding = false;
    public boolean mIsInitialized = false;
    public int mTabStored = 0;

    public LayoutViewUnit(Context context, ElinchromDevice elinchromDevice) {
        this.mContext = context;
        this.mElinchromDevice = elinchromDevice;
        this.setOnDragDetected(this::onDragDetected);
        this.setOnDragDone(this::onDragDone);
        this.setOnDragDropped(this::onDragDropped);
        this.setOnDragOver(this::onDragOver);
    }

    public void displayAudioMode(byte audioMode) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[10] == 1) {
            this.mAudioSwitch.setActivated(audioMode != 0);
        }
    }

    public void displayFirmwareStatus(boolean isFirmwareVersionLatest, boolean isInternetAvailable) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[13] == 1) {
            this.mFirmwareStatus.setText(isInternetAvailable ? "Your firmware is up to date" : "No Internet");
            this.mFirmwareMark.setVisible(isInternetAvailable && !isFirmwareVersionLatest);
            this.mFirmwareStatus.setVisible(!isInternetAvailable || isFirmwareVersionLatest);
            this.mTabInfo.getStyleClass().remove((Object)"has-new");
            if (isInternetAvailable && !isFirmwareVersionLatest) {
                this.mTabInfo.getStyleClass().add((Object)"has-new");
            }
        }
    }

    public void displayFirmwareVersion(String firmwareVersion) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[13] == 1) {
            this.mLabels[11].setText(firmwareVersion);
        }
    }

    public void displayFlashCounter(int flashCount, int flashCountSession) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[12] == 1) {
            this.mLabels[15].setText("" + flashCount);
            this.mLabels[17].setText("" + Math.max(0, flashCount - flashCountSession));
        }
    }

    public void displayFlashMode() {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[11] == 1) {
            short[] flashModeValues = this.mElinchromDevice.mComponentLighting.getFlash_mode_values();
            switch (flashModeValues[0]) {
                default: {
                    this.show((Node)this.mLabels[7], false);
                    this.show((Node)this.mLabels[5], false);
                    this.show((Node)this.mLabels[6], false);
                    this.show((Node)this.mLabels[8], false);
                    this.show((Node)this.mLabels[9], false);
                    this.show((Node)this.mDelay, false);
                    this.show((Node)this.mSequenceTimeout, false);
                    this.show((Node)this.mChoiceUnitAddress, false);
                    this.show((Node)this.mSpacerSlash, false);
                    this.show((Node)this.mChoiceTotalUnits, false);
                    this.show((Node)this.mStroboDuration, false);
                    this.show((Node)this.mChoiceStroboFrequency, false);
                    break;
                }
                case 1: {
                    this.show((Node)this.mLabels[7], false);
                    this.show((Node)this.mLabels[5], true);
                    this.show((Node)this.mLabels[6], true);
                    this.show((Node)this.mLabels[8], false);
                    this.show((Node)this.mLabels[9], false);
                    this.show((Node)this.mDelay, false);
                    this.show((Node)this.mSequenceTimeout, true);
                    this.show((Node)this.mChoiceUnitAddress, true);
                    this.show((Node)this.mSpacerSlash, true);
                    this.show((Node)this.mChoiceTotalUnits, true);
                    this.show((Node)this.mStroboDuration, false);
                    this.show((Node)this.mChoiceStroboFrequency, false);
                    break;
                }
                case 2: {
                    this.show((Node)this.mLabels[7], true);
                    this.show((Node)this.mLabels[5], false);
                    this.show((Node)this.mLabels[6], false);
                    this.show((Node)this.mLabels[8], false);
                    this.show((Node)this.mLabels[9], false);
                    this.show((Node)this.mDelay, true);
                    this.show((Node)this.mSequenceTimeout, false);
                    this.show((Node)this.mChoiceUnitAddress, false);
                    this.show((Node)this.mSpacerSlash, false);
                    this.show((Node)this.mChoiceTotalUnits, false);
                    this.show((Node)this.mStroboDuration, false);
                    this.show((Node)this.mChoiceStroboFrequency, false);
                    break;
                }
                case 3: {
                    this.show((Node)this.mLabels[7], false);
                    this.show((Node)this.mLabels[5], false);
                    this.show((Node)this.mLabels[6], false);
                    this.show((Node)this.mLabels[8], true);
                    this.show((Node)this.mLabels[9], true);
                    this.show((Node)this.mDelay, false);
                    this.show((Node)this.mSequenceTimeout, false);
                    this.show((Node)this.mChoiceUnitAddress, false);
                    this.show((Node)this.mSpacerSlash, false);
                    this.show((Node)this.mChoiceTotalUnits, false);
                    this.show((Node)this.mStroboDuration, true);
                    this.show((Node)this.mChoiceStroboFrequency, true);
                }
            }
            if (!this.mSequenceTimeout.isFocused()) {
                this.mSequenceTimeout.setText(Short.toString(flashModeValues[4]));
            }
            if (!this.mDelay.isFocused()) {
                this.mDelay.setText(Short.toString(flashModeValues[5]));
            }
            if (!this.mStroboDuration.isFocused()) {
                this.mStroboDuration.setText(Short.toString(flashModeValues[7]));
            }
            this.mChoiceFlashMode.setOnAction(null);
            this.mChoiceFlashMode.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mFlashModePosition[flashModeValues[0]]);
            this.mChoiceFlashMode.setOnAction(this::onValueChangedFlashMode);
            this.mChoiceUnitAddress.setOnAction(null);
            this.mChoiceUnitAddress.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mUnitAddressPosition[flashModeValues[2]]);
            this.mChoiceUnitAddress.setOnAction(this::onValueChangedFlashModeSequence);
            this.mChoiceTotalUnits.setOnAction(null);
            this.mChoiceTotalUnits.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mTotalUnitsPosition[flashModeValues[3]]);
            this.mChoiceTotalUnits.setOnAction(this::onValueChangedFlashModeSequence);
            this.mChoiceStroboFrequency.setOnAction(null);
            this.mChoiceStroboFrequency.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mFlashesPerSecondPosition[flashModeValues[6]]);
            this.mChoiceStroboFrequency.setOnAction(this::onValueChangedStroboFrequency);
        }
    }

    @Override
    public void displayFlashPower(byte[] flashPowerValues) {
        if (!this.mIsSliding) {
            FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
            float flashMainMin = (float)componentLighting.getMinFlashPowerMain() / 10.0f;
            float flashMainMax = (float)componentLighting.getMaxFlashPowerMain() / 10.0f;
            float flashMain = (float)flashPowerValues[0] / 10.0f;
            this.mFlashMainMin.setText("" + flashMainMin);
            this.mFlashMainMax.setText("" + flashMainMax);
            this.mFlashMainElStop.setText("" + flashMain);
            this.mFlashMainSlider.setMin(flashMainMin);
            this.mFlashMainSlider.setMax(flashMainMax);
            this.mFlashMainSlider.setValue(Math.max(flashMainMin, Math.min(flashMain, flashMainMax)));
            this.mFlashMainWs.setText(this.mContext.mUtil.fstopToJouleString(flashPowerValues[0]));
            if (componentLighting.mFeatureList[1] == 1) {
                float flashA = (float)flashPowerValues[1] / 10.0f;
                float flashB = (float)flashPowerValues[2] / 10.0f;
                this.mHeadAElStop.setText("" + flashA);
                this.mHeadBElStop.setText("" + flashB);
                this.mHeadAWs.setText(this.mContext.mUtil.fstopToJouleString(flashPowerValues[1]));
                this.mHeadBWs.setText(this.mContext.mUtil.fstopToJouleString(flashPowerValues[2]));
                if (componentLighting.mFeatureList[2] == 1) {
                    float flashAMin = (float)componentLighting.getMinFlashPowerHeadA() / 10.0f;
                    float flashAMax = (float)componentLighting.getMaxFlashPowerHeadA() / 10.0f;
                    this.mHeadASlider.setMin(flashAMin);
                    this.mHeadASlider.setMax(flashAMax);
                    this.mHeadASlider.setValue(Math.max(flashAMin, Math.min(flashA, flashAMax)));
                    float flashBMin = (float)componentLighting.getMinFlashPowerHeadB() / 10.0f;
                    float flashBMax = (float)componentLighting.getMaxFlashPowerHeadB() / 10.0f;
                    this.mHeadBSlider.setMin(flashBMin);
                    this.mHeadBSlider.setMax(flashBMax);
                    this.mHeadBSlider.setValue(Math.max(flashBMin, Math.min(flashB, flashBMax)));
                }
            }
        }
    }

    @Override
    public void displayFriendlyName(String friendlyName) {
        this.mFriendlyName.setText(friendlyName);
    }

    @Override
    public void displayGroup(byte group) {
        int activeGroup = group > 0 ? group : 4;
        int selectedGroup = group > 0 ? group - 1 : 3;
        this.getStyleClass().removeAll((Object[])new String[]{"group-1", "group-2", "group-3", "group-4"});
        this.getStyleClass().add((Object)("group-" + activeGroup));
        this.mChoiceGroup.setOnAction(null);
        this.mChoiceGroup.getSelectionModel().select(selectedGroup);
        this.mChoiceGroup.setOnAction(this::onValueChangedGroup);
    }

    @Override
    public void displayHeadOn(int headOn, int headPlugged) {
        boolean isHeadBPlugged;
        boolean isHeadAOn = (headOn & 1) != 0;
        boolean isHeadBOn = (headOn & 2) != 0;
        boolean isHeadAPlugged = (headPlugged & 1) != 0;
        boolean bl = isHeadBPlugged = (headPlugged & 2) != 0;
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
            this.mPowerMainControlGrid.setVisible(isHeadAOn || isHeadBOn);
            this.mHeadASwitch.setEnabled(this.mElinchromDevice.mComponentLighting.mFeatureList[4] == 1 && isHeadAPlugged);
            this.mHeadASwitch.setOnMouseClicked(null);
            this.mHeadASwitch.setActivated(isHeadAOn);
            this.mHeadASwitch.setOnMouseClicked(this::onTouchHeadASwitch);
            this.mHeadBSwitch.setEnabled(this.mElinchromDevice.mComponentLighting.mFeatureList[4] == 1 && isHeadBPlugged);
            this.mHeadBSwitch.setOnMouseClicked(null);
            this.mHeadBSwitch.setActivated(isHeadBOn);
            this.mHeadBSwitch.setOnMouseClicked(this::onTouchHeadBSwitch);
            this.mHeadAElStop.setVisible(isHeadAOn);
            this.mHeadAWs.setVisible(isHeadAOn);
            this.mHeadBElStop.setVisible(isHeadBOn);
            this.mHeadBWs.setVisible(isHeadBOn);
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[2] == 1) {
                this.mHeadAMinus.setVisible(isHeadAOn);
                this.mHeadAPlus.setVisible(isHeadAOn);
                this.mHeadASlider.setVisible(isHeadAOn);
                this.mHeadBMinus.setVisible(isHeadBOn);
                this.mHeadBPlus.setVisible(isHeadBOn);
                this.mHeadBSlider.setVisible(isHeadBOn);
            }
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[3] == 1) {
                this.mChoiceRatio.setVisible(isHeadAOn || isHeadBOn);
            }
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0) {
            this.mLampModeGrid.setVisible(isHeadAOn || isHeadBOn);
            this.mLampAValueGrid.setVisible(isHeadAOn);
            this.mLampAControlGrid.setVisible(isHeadAOn);
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            this.mLampModeGrid.setVisible(isHeadAOn || isHeadBOn);
            this.mLampAValueGrid.setVisible(isHeadAOn);
            this.mLampAControlGrid.setVisible(isHeadAOn);
            this.mLampBValueGrid.setVisible(isHeadBOn);
            this.mLampBControlGrid.setVisible(isHeadBOn);
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 2) {
            this.mLampModeGrid.setVisible(isHeadAOn || isHeadBOn);
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 3) {
            this.mLampModeGrid.setVisible(isHeadAOn || isHeadBOn);
        }
    }

    @Override
    public void displayInteractionStatus(boolean isStandbyOn, int headOn) {
    }

    @Override
    public void displayLampMode(int lampMode) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            switch (lampMode) {
                case 0: {
                    this.mLampMode.onLeft();
                    break;
                }
                case 2: {
                    this.mLampMode.onCenter();
                    break;
                }
                default: {
                    this.mLampMode.onRight();
                    break;
                }
            }
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 2 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 4) {
            this.mLampModeSwitch.setActivated(lampMode != 0);
        }
    }

    @Override
    public void displayLampPower(byte[] lampPowerValues) {
        if (!(this.mElinchromDevice.mComponentLighting.mFeatureList[5] != 0 && this.mElinchromDevice.mComponentLighting.mFeatureList[5] != 1 || this.mIsSliding)) {
            FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
            float lampMin = (float)componentLighting.getMin_lamp_power() / 10.0f;
            float lampMax = (float)componentLighting.getMax_lamp_power() / 10.0f;
            float lampAValue = (float)lampPowerValues[0] / 10.0f;
            this.mLampAMin.setText("" + lampMin);
            this.mLampAMax.setText("" + lampMax);
            this.mLampAElStop.setText("" + lampAValue);
            this.mLampASlider.setMin(lampMin);
            this.mLampASlider.setMax(lampMax);
            this.mLampASlider.setValue(Math.max(lampMin, Math.min(lampAValue, lampMax)));
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
                float lampBValue = (float)lampPowerValues[1] / 10.0f;
                this.mLampBMin.setText("" + lampMin);
                this.mLampBMax.setText("" + lampMax);
                this.mLampBElStop.setText("" + lampBValue);
                this.mLampBSlider.setMin(lampMin);
                this.mLampBSlider.setMax(lampMax);
                this.mLampBSlider.setValue(Math.max(lampMin, Math.min(lampBValue, lampMax)));
            }
        }
    }

    public void displayPhotocellMode(byte photocellMode) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[8] == 1) {
            this.mChoicePhotocell.setOnAction(null);
            this.mChoicePhotocell.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mPhotocellPosition[photocellMode]);
            this.mChoicePhotocell.setOnAction(this::onValueChangedPhotocell);
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[7] == 1) {
            this.mPhotocellSwitch.setActivated(photocellMode != 0);
        }
    }

    public void displayPowerRatio(byte powerRatio) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[3] == 1) {
            this.mChoiceRatio.setOnAction(null);
            this.mChoiceRatio.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mPowerRatioPosition[powerRatio]);
            this.mChoiceRatio.setOnAction(this::onValueChangedRatio);
        }
    }

    public void displayRecyclingMode(byte recyclingMode) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[9] == 1) {
            this.mChoiceRecycling.setOnAction(null);
            this.mChoiceRecycling.getSelectionModel().select(this.mElinchromDevice.mComponentLighting.mRecyclingModePosition[recyclingMode]);
            this.mChoiceRecycling.setOnAction(this::onValueChangedRecycling);
        }
    }

    public void displayTabDashboard() {
        this.mChoiceGroup.getStyleClass().remove((Object)"rounded-right");
        this.mChoiceGroup.getStyleClass().add((Object)"rounded-right");
        this.mTabDashboard.getStyleClass().remove((Object)"activated");
        this.mTabDashboard.getStyleClass().add((Object)"activated");
        this.mTabSettings.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left", "rounded-right"});
        this.mTabSettings.getStyleClass().add((Object)"rounded-left");
        this.mTabInfo.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left"});
        this.mViewDashboard.setVisible(true);
        this.mViewSettings.setVisible(false);
        this.mViewInfo.setVisible(false);
    }

    public void displayTabSettings() {
        this.mChoiceGroup.getStyleClass().remove((Object)"rounded-right");
        this.mTabDashboard.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-right"});
        this.mTabDashboard.getStyleClass().add((Object)"rounded-right");
        this.mTabSettings.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left", "rounded-right"});
        this.mTabSettings.getStyleClass().add((Object)"activated");
        this.mTabInfo.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left"});
        this.mTabInfo.getStyleClass().add((Object)"rounded-left");
        this.mViewDashboard.setVisible(false);
        this.mViewSettings.setVisible(true);
        this.mViewInfo.setVisible(false);
    }

    public void displayTabInfo() {
        this.mChoiceGroup.getStyleClass().remove((Object)"rounded-right");
        this.mTabDashboard.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-right"});
        this.mTabSettings.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left", "rounded-right"});
        this.mTabSettings.getStyleClass().add((Object)"rounded-right");
        this.mTabInfo.getStyleClass().removeAll((Object[])new String[]{"activated", "rounded-left"});
        this.mTabInfo.getStyleClass().add((Object)"activated");
        this.mViewDashboard.setVisible(false);
        this.mViewSettings.setVisible(false);
        this.mViewInfo.setVisible(true);
    }

    public void displaySignalStrength(int signalStrength) {
        int previousIndex = this.mIconSignal.getIndex();
        int newIndex = signalStrength < (previousIndex == 0 ? 30 : 20) ? 0 : (signalStrength < (previousIndex == 1 ? 55 : 45) ? 1 : (signalStrength < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mIconSignal.setIndex(newIndex);
        }
    }

    public void displayBatteryLevel(int batteryLevel) {
        int previousIndex = this.mUnitBatteryIcon.getIndex();
        int newIndex = batteryLevel < (previousIndex == 0 ? 30 : 20) ? 0 : (batteryLevel < (previousIndex == 1 ? 55 : 45) ? 1 : (batteryLevel < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mUnitBatteryIcon.setIndex(newIndex);
        }
        this.mUnitBatteryIcon.setVisible(true);
    }

    @Override
    public void displayStandbyMode(boolean isStandbyOn) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[6] == 1) {
            this.mDarkMask.setVisible(isStandbyOn);
            this.mStandbySwitch.setActivated(isStandbyOn);
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        Unit_Prototype_Json unit_Prototype_Json = this.mContext.mUnitPrototypes.get(this.mElinchromDevice.getProductId());
        GridPane.setFillHeight((Node)this, (Boolean)true);
        this.getStyleClass().addAll((Object[])new String[]{"day-theme"});
        this.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(56.0);
        ColumnConstraints columnMiddle = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnMiddle.setPercentWidth(26.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnRight.setPercentWidth(18.0);
        RowConstraints rowTabs = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTabs.setPercentHeight(7.0);
        RowConstraints rowMiddle = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowMiddle.setPercentHeight(21.0);
        RowConstraints rowBottom = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowBottom.setPercentHeight(72.0);
        List<String> imageCheckbox = Arrays.asList("group_checkbox_enabled.svg", "group_checkbox_activated.svg");
        this.mIconCheckbox = this.mContext.mUtil.factoryIconSet(26, 26, imageCheckbox, 0);
        this.mIconCheckbox.getStyleClass().add((Object)"group-color");
        this.mIconCheckbox.setOnMouseClicked(this::onTouchSelectionCheckbox);
        GridPane.setConstraints((Node)this.mIconCheckbox, (int)0, (int)0, (int)1, (int)2);
        this.mChoiceGroup = new ComboBox();
        this.mChoiceGroup.getItems().addAll((Collection)IntStream.rangeClosed(1, 4).mapToObj(Integer::toString).collect(Collectors.toList()));
        this.mChoiceGroup.setMinSize(45.0, 26.0);
        this.mChoiceGroup.setPrefSize(45.0, 26.0);
        this.mChoiceGroup.setMaxSize(45.0, 26.0);
        this.mChoiceGroup.getStyleClass().addAll((Object[])new String[]{"tab-choice", "rounded-right"});
        this.mChoiceGroup.setOnAction(this::onValueChangedGroup);
        GridPane.setConstraints(this.mChoiceGroup, (int)0, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 27.0));
        this.mTabDashboard = new LayoutWidgetIcon(this.mContext, 26.0, null, "Dashboard", this.mContext.mFontRegular, 14.0, this.mContext.mDayGraphicsColor);
        this.mTabDashboard.setMaxWidth(Double.MAX_VALUE);
        this.mTabDashboard.setOnMouseClicked(this::onTouchTabDashboard);
        this.mTabDashboard.getStyleClass().addAll((Object[])new String[]{"tab", "activated"});
        GridPane.setConstraints((Node)this.mTabDashboard, (int)0, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS, (Insets)new Insets(0.0, 0.0, 0.0, 72.0));
        GridPane.setFillWidth((Node)this.mTabDashboard, (Boolean)true);
        this.mTabSettings = new LayoutWidgetIcon(this.mContext, 26.0, null, "Settings", this.mContext.mFontRegular, 14.0, this.mContext.mDayGraphicsColor);
        this.mTabSettings.setMaxWidth(Double.MAX_VALUE);
        this.mTabSettings.setOnMouseClicked(this::onTouchTabSettings);
        this.mTabSettings.getStyleClass().addAll((Object[])new String[]{"tab", "rounded-left"});
        GridPane.setConstraints((Node)this.mTabSettings, (int)1, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.mTabSettings, (Boolean)true);
        Pane hasNew = new Pane();
        hasNew.setTranslateX(13.0);
        hasNew.setTranslateY(5.0);
        hasNew.getStyleClass().add((Object)"has-new-mark");
        hasNew.setMinSize(9.0, 9.0);
        hasNew.setPrefSize(9.0, 9.0);
        hasNew.setMaxSize(9.0, 9.0);
        this.mTabInfo = new LayoutWidgetIcon(this.mContext, 26.0, null, "Info", this.mContext.mFontRegular, 14.0, this.mContext.mDayGraphicsColor);
        this.mTabInfo.setAlignment(Pos.CENTER);
        this.mTabInfo.setMaxWidth(Double.MAX_VALUE);
        this.mTabInfo.setOnMouseClicked(this::onTouchTabInfo);
        this.mTabInfo.getStyleClass().addAll((Object[])new String[]{"tab", "last"});
        this.mTabInfo.getChildren().add((Object)hasNew);
        GridPane.setConstraints((Node)this.mTabInfo, (int)2, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.mTabInfo, (Boolean)true);
        this.mImageUnit = new ImageView();
        this.mImageUnit.setFitWidth(100.0);
        this.mImageUnit.setFitHeight(100.0);
        this.mImageUnit.setPreserveRatio(true);
        this.mImageUnit.setSmooth(true);
        this.mImageUnit.setTranslateX(-96.0);
        this.mImageUnit.setTranslateY(1.0);
        this.mImageUnit.setOnMouseClicked(this::onTouchProductPicture);
        GridPane.setConstraints((Node)this.mImageUnit, (int)0, (int)1, (int)3, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        URL url = this.mElinchromDevice.getImageUrl();
        if (url != null) {
            this.mImageUnit.setImage(new Image(url.toString()));
        }
        List<String> imageSignal = Arrays.asList("day_signal_0.svg", "day_signal_1.svg", "day_signal_2.svg", "day_signal_3.svg");
        this.mIconSignal = this.mContext.mUtil.factoryIconSet(24, 24, imageSignal, 0);
        this.mIconSignal.setTranslateX(-23.0);
        this.mIconSignal.setTranslateY(18.0);
        GridPane.setConstraints((Node)this.mIconSignal, (int)0, (int)1, (int)3, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        List<String> imageBattery = Arrays.asList("day_battery_0.svg", "day_battery_1.svg", "day_battery_2.svg", "day_battery_3.svg");
        this.mUnitBatteryIcon = this.mContext.mUtil.factoryIconSet(24, 24, imageBattery, 0);
        this.mUnitBatteryIcon.setTranslateX(16.0);
        this.mUnitBatteryIcon.setTranslateY(18.0);
        this.mUnitBatteryIcon.setVisible(false);
        GridPane.setConstraints((Node)this.mUnitBatteryIcon, (int)0, (int)1, (int)3, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        this.mFriendlyName = new TextField();
        this.mFriendlyName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
        this.mFriendlyName.setPrefWidth(198.0);
        this.mFriendlyName.setText("");
        this.mFriendlyName.setTranslateX(56.0);
        this.mFriendlyName.setTranslateY(47.125);
        GridPane.setConstraints((Node)this.mFriendlyName, (int)0, (int)1, (int)3, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[0] == 1) {
            this.mFriendlyName.focusedProperty().addListener(this::onFocusChangeFriendlyName);
            this.mFriendlyName.setOnKeyReleased(this::onKey);
        } else {
            this.mFriendlyName.setEditable(false);
        }
        this.mDarkMask = new Pane();
        this.mDarkMask.setStyle("-fx-background-color: rgba(0, 0, 0, 0.45);");
        this.mDarkMask.setMouseTransparent(true);
        this.mDarkMask.setVisible(false);
        GridPane.setFillWidth((Node)this.mDarkMask, (Boolean)true);
        GridPane.setFillHeight((Node)this.mDarkMask, (Boolean)true);
        GridPane.setConstraints((Node)this.mDarkMask, (int)0, (int)0, (int)3, (int)3);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnMiddle, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTabs, rowMiddle, rowBottom});
        ColumnConstraints column100 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.CENTER, false);
        column100.setPercentWidth(100.0);
        RowConstraints row0 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row0.setPercentHeight(10.0);
        RowConstraints row1 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row1.setPercentHeight(20.0);
        RowConstraints row2 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row2.setPercentHeight(9.0);
        RowConstraints row3 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row3.setPercentHeight(8.0);
        RowConstraints row4 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row4.setPercentHeight(14.0);
        RowConstraints row5 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row5.setPercentHeight(12.0);
        RowConstraints row6 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row6.setPercentHeight(7.0);
        RowConstraints row7 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row7.setPercentHeight(20.0);
        this.mViewDashboard = new GridPane();
        this.mViewDashboard.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewDashboard.getRowConstraints().addAll((Object[])new RowConstraints[]{row0, row1, row2, row3, row4, row5, row6, row7});
        this.mViewDashboard.getStyleClass().addAll((Object[])new String[]{"group-color"});
        GridPane.setFillWidth((Node)this.mViewDashboard, (Boolean)true);
        GridPane.setFillHeight((Node)this.mViewDashboard, (Boolean)true);
        GridPane.setConstraints((Node)this.mViewDashboard, (int)0, (int)2, (int)3, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[3] == 1) {
            this.mChoiceRatio = new ComboBox();
            this.mChoiceRatio.getItems().addAll((Object[])new String[]{"50/50", "66/33"});
            this.mChoiceRatio.setMinSize(73.0, 26.0);
            this.mChoiceRatio.setPrefSize(73.0, 26.0);
            this.mChoiceRatio.setMaxSize(73.0, 26.0);
            this.mChoiceRatio.getStyleClass().addAll((Object[])new String[]{"padded", "rounded"});
            this.mChoiceRatio.setOnAction(this::onValueChangedRatio);
            GridPane.setConstraints(this.mChoiceRatio, (int)0, (int)1, (int)1, (int)7, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(11.0, 226.0, 0.0, 0.0));
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mChoiceRatio});
        }
        RowConstraints row100 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row100.setPercentHeight(100.0);
        this.mFlashMainElStop = new Text("");
        this.mFlashMainElStop.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mFlashMainElStop.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 35.0));
        TextFlow boxFlashMainElStop = new TextFlow();
        boxFlashMainElStop.setTextAlignment(TextAlignment.CENTER);
        boxFlashMainElStop.getChildren().add((Object)this.mFlashMainElStop);
        GridPane.setConstraints((Node)boxFlashMainElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(34.0 - this.mFlashMainElStop.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mFlashMainWs = new Text("");
        this.mFlashMainWs.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFlashMainWs.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow boxFlashMainWs = new TextFlow();
        boxFlashMainWs.setTextAlignment(TextAlignment.LEFT);
        boxFlashMainWs.getChildren().add((Object)this.mFlashMainWs);
        GridPane.setConstraints((Node)boxFlashMainWs, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(34.0 - this.mFlashMainWs.getBaselineOffset(), 0.0, 0.0, 27.0));
        GridPane powerMainValueGrid = new GridPane();
        powerMainValueGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        powerMainValueGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        powerMainValueGrid.getChildren().addAll((Object[])new Node[]{boxFlashMainWs, boxFlashMainElStop});
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[3] == 1) {
            powerMainValueGrid.setMinWidth(211.0);
            powerMainValueGrid.setPrefWidth(211.0);
            GridPane.setConstraints((Node)powerMainValueGrid, (int)0, (int)0, (int)1, (int)8, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 89.0));
        } else {
            powerMainValueGrid.setMinWidth(300.0);
            powerMainValueGrid.setPrefWidth(300.0);
            GridPane.setConstraints((Node)powerMainValueGrid, (int)0, (int)0, (int)1, (int)8);
        }
        this.mViewDashboard.getChildren().addAll((Object[])new Node[]{powerMainValueGrid});
        this.mFlashMainMin = new Text("");
        this.mFlashMainMin.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFlashMainMin.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow boxFlashMainMin = new TextFlow();
        boxFlashMainMin.setTextAlignment(TextAlignment.LEFT);
        boxFlashMainMin.getChildren().add((Object)this.mFlashMainMin);
        GridPane.setConstraints((Node)boxFlashMainMin, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(51.0 - this.mFlashMainMin.getBaselineOffset(), 0.0, 0.0, 27.0));
        this.mFlashMainMax = new Text("");
        this.mFlashMainMax.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFlashMainMax.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow boxFlashMainMax = new TextFlow();
        boxFlashMainMax.setTextAlignment(TextAlignment.RIGHT);
        boxFlashMainMax.getChildren().add((Object)this.mFlashMainMax);
        GridPane.setConstraints((Node)boxFlashMainMax, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(51.0 - this.mFlashMainMax.getBaselineOffset(), 27.0, 0.0, 0.0));
        this.mFlashMainSlider = new LayoutWidgetSlider(this.mContext, 0.0, 100.0, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeFlashMain));
        this.mFlashMainSlider.setMinHeight(48.0);
        this.mFlashMainSlider.setPrefHeight(48.0);
        this.mFlashMainSlider.setOnMousePressed(this::onMousePressedFlashMain);
        this.mFlashMainSlider.setOnMouseReleased(this::onMouseReleasedFlashMain);
        GridPane.setFillWidth((Node)this.mFlashMainSlider, (Boolean)true);
        GridPane.setConstraints((Node)this.mFlashMainSlider, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 23.0, 0.0, 23.0));
        List<String> imageArrowLeft = Arrays.asList("night_arrow_left_activated.svg");
        this.mFlashMainMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
        this.mFlashMainMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchFlashMainMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchFlashMainMinus));
        GridPane.setConstraints((Node)this.mFlashMainMinus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(13.0, 0.0, 0.0, 0.0));
        List<String> imageArrowRight = Arrays.asList("night_arrow_right_activated.svg");
        this.mFlashMainPlus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
        this.mFlashMainPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchFlashMainPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchFlashMainPlus));
        GridPane.setConstraints((Node)this.mFlashMainPlus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(13.0, 0.0, 0.0, 0.0));
        this.mPowerMainControlGrid = new GridPane();
        this.mPowerMainControlGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mPowerMainControlGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        this.mPowerMainControlGrid.getChildren().addAll((Object[])new Node[]{boxFlashMainMin, boxFlashMainMax, this.mFlashMainSlider, this.mFlashMainMinus, this.mFlashMainPlus});
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[3] == 1) {
            this.mPowerMainControlGrid.setMinWidth(211.0);
            this.mPowerMainControlGrid.setPrefWidth(211.0);
            GridPane.setConstraints((Node)this.mPowerMainControlGrid, (int)0, (int)1, (int)1, (int)7, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 89.0));
        } else {
            this.mPowerMainControlGrid.setMinWidth(300.0);
            this.mPowerMainControlGrid.setPrefWidth(300.0);
            GridPane.setConstraints((Node)this.mPowerMainControlGrid, (int)0, (int)1, (int)1, (int)7);
        }
        this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mPowerMainControlGrid});
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
            this.mHeadALabel = new Text("Head A");
            this.mHeadALabel.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mHeadALabel.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxHeadALabel = new TextFlow();
            boxHeadALabel.setTextAlignment(TextAlignment.LEFT);
            boxHeadALabel.getChildren().add((Object)this.mHeadALabel);
            GridPane.setConstraints((Node)boxHeadALabel, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(24.0 - this.mHeadALabel.getBaselineOffset(), 0.0, 0.0, 27.0));
            this.mHeadASwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mHeadASwitch.setOnMouseClicked(this::onTouchHeadASwitch);
            GridPane.setConstraints((Node)this.mHeadASwitch, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(8.0, 0.0, 0.0, 88.0));
            this.mHeadBLabel = new Text("Head B");
            this.mHeadBLabel.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mHeadBLabel.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxHeadBLabel = new TextFlow();
            boxHeadBLabel.setTextAlignment(TextAlignment.RIGHT);
            boxHeadBLabel.getChildren().add((Object)this.mHeadBLabel);
            GridPane.setConstraints((Node)boxHeadBLabel, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(24.0 - this.mHeadBLabel.getBaselineOffset(), 75.0, 0.0, 0.0));
            this.mHeadBSwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mHeadBSwitch.setOnMouseClicked(this::onTouchHeadBSwitch);
            GridPane.setConstraints((Node)this.mHeadBSwitch, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(8.0, 27.0, 0.0, 0.0));
            GridPane headSwitchGrid = new GridPane();
            headSwitchGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            headSwitchGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            headSwitchGrid.getChildren().addAll((Object[])new Node[]{boxHeadBLabel, boxHeadALabel, this.mHeadBSwitch, this.mHeadASwitch});
            headSwitchGrid.setMinWidth(300.0);
            headSwitchGrid.setPrefWidth(300.0);
            GridPane.setConstraints((Node)headSwitchGrid, (int)0, (int)2, (int)1, (int)6, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[4] != 1) {
                this.mHeadASwitch.getStyleClass().add((Object)"disabled");
                this.mHeadBSwitch.getStyleClass().add((Object)"disabled");
            }
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{headSwitchGrid});
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
            this.mHeadAElStop = new Text("0.0");
            this.mHeadAElStop.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
            this.mHeadAElStop.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.0));
            TextFlow boxHeadAElStop = new TextFlow();
            boxHeadAElStop.setTextAlignment(TextAlignment.CENTER);
            boxHeadAElStop.getChildren().add((Object)this.mHeadAElStop);
            GridPane.setConstraints((Node)boxHeadAElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(31.0 - this.mHeadAElStop.getBaselineOffset(), 120.0, 0.0, 0.0));
            this.mHeadAWs = new Text("");
            this.mHeadAWs.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mHeadAWs.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxHeadAWs = new TextFlow();
            boxHeadAWs.setTextAlignment(TextAlignment.LEFT);
            boxHeadAWs.getChildren().add((Object)this.mHeadAWs);
            GridPane.setConstraints((Node)boxHeadAWs, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(31.0 - this.mHeadAWs.getBaselineOffset(), 0.0, 0.0, 27.0));
            this.mHeadBElStop = new Text("0.0");
            this.mHeadBElStop.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
            this.mHeadBElStop.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.0));
            TextFlow boxHeadBElStop = new TextFlow();
            boxHeadBElStop.setTextAlignment(TextAlignment.CENTER);
            boxHeadBElStop.getChildren().add((Object)this.mHeadBElStop);
            GridPane.setConstraints((Node)boxHeadBElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(31.0 - this.mHeadBElStop.getBaselineOffset(), 0.0, 0.0, 144.0));
            this.mHeadBWs = new Text("");
            this.mHeadBWs.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mHeadBWs.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxHeadBWs = new TextFlow();
            boxHeadBWs.setTextAlignment(TextAlignment.LEFT);
            boxHeadBWs.getChildren().add((Object)this.mHeadBWs);
            GridPane.setConstraints((Node)boxHeadBWs, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(31.0 - this.mHeadBWs.getBaselineOffset(), 0.0, 0.0, 159.0));
            this.mHeadValueGrid = new GridPane();
            this.mHeadValueGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mHeadValueGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mHeadValueGrid.getChildren().addAll((Object[])new Node[]{boxHeadBWs, boxHeadAWs, boxHeadBElStop, boxHeadAElStop});
            this.mHeadValueGrid.setMinWidth(300.0);
            this.mHeadValueGrid.setPrefWidth(300.0);
            GridPane.setConstraints((Node)this.mHeadValueGrid, (int)0, (int)3, (int)1, (int)5, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mHeadValueGrid});
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[2] == 1) {
            this.mHeadASlider = new LayoutWidgetSlider(this.mContext, 0.0, 100.0, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeHeadA));
            this.mHeadASlider.setMinSize(104.0, 52.0);
            this.mHeadASlider.setPrefSize(104.0, 52.0);
            this.mHeadASlider.setOnMousePressed(this::onMousePressedHeadPowerASlider);
            this.mHeadASlider.setOnMouseReleased(this::onMouseReleasedHeadPowerASlider);
            GridPane.setConstraints((Node)this.mHeadASlider, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 23.0));
            this.mHeadAMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
            this.mHeadAMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchHeadAMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchHeadAMinus));
            GridPane.setConstraints((Node)this.mHeadAMinus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mHeadAPlus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
            this.mHeadAPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchHeadAPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchHeadAPlus));
            GridPane.setConstraints((Node)this.mHeadAPlus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 24.0, 0.0, 0.0));
            this.mHeadBSlider = new LayoutWidgetSlider(this.mContext, 0.0, 100.0, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeHeadB));
            this.mHeadBSlider.setMinSize(104.0, 52.0);
            this.mHeadBSlider.setPrefSize(104.0, 52.0);
            this.mHeadBSlider.setOnMousePressed(this::onMousePressedHeadPowerBSlider);
            this.mHeadBSlider.setOnMouseReleased(this::onMouseReleasedHeadPowerBSlider);
            GridPane.setConstraints((Node)this.mHeadBSlider, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 23.0, 0.0, 0.0));
            this.mHeadBMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
            this.mHeadBMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchHeadBMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchHeadBMinus));
            GridPane.setConstraints((Node)this.mHeadBMinus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 24.0));
            this.mHeadBPlus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
            this.mHeadBPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchHeadBPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchHeadBPlus));
            GridPane.setConstraints((Node)this.mHeadBPlus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mHeadSliderGrid = new GridPane();
            this.mHeadSliderGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mHeadSliderGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mHeadSliderGrid.getChildren().addAll((Object[])new Node[]{this.mHeadBPlus, this.mHeadAPlus, this.mHeadBMinus, this.mHeadAMinus, this.mHeadBSlider, this.mHeadASlider});
            this.mHeadSliderGrid.setMinWidth(300.0);
            this.mHeadSliderGrid.setPrefWidth(300.0);
            GridPane.setConstraints((Node)this.mHeadSliderGrid, (int)0, (int)4, (int)1, (int)4);
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mHeadSliderGrid});
        }
        this.mLampLabel = new Text(this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 4 ? "Video light" : "Lamp");
        this.mLampLabel.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mLampLabel.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLampLabel = new TextFlow();
        boxLampLabel.getChildren().add((Object)this.mLampLabel);
        GridPane.setConstraints((Node)boxLampLabel, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(31.0 - this.mLampLabel.getBaselineOffset(), 0.0, 0.0, 27.0));
        this.mLampModeGrid = new GridPane();
        this.mLampModeGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mLampModeGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        this.mLampModeGrid.setMinWidth(300.0);
        this.mLampModeGrid.setPrefWidth(300.0);
        this.mLampModeGrid.getChildren().addAll((Object[])new Node[]{boxLampLabel});
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            this.mLampMode = new LayoutWidgetToggleGroup(this.mContext, 154, 26, "Off", "Prop", "Free", (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeOff), (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeProp), (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeFree));
            GridPane.setConstraints((Node)this.mLampMode, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(13.0, 0.0, 0.0, 0.0));
            this.mLampModeGrid.getChildren().addAll((Object[])new Node[]{this.mLampMode});
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 2 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 4) {
            this.mLampModeSwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mLampModeSwitch.setOnMouseClicked(this::onTouchLampModeSwitch);
            GridPane.setConstraints((Node)this.mLampModeSwitch, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mLampModeGrid.getChildren().addAll((Object[])new Node[]{this.mLampModeSwitch});
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 3) {
            List<String> imageLamp = Arrays.asList("day_icon_lamp.svg");
            this.mLampOn = this.mContext.mUtil.factoryIconSet(26, 26, imageLamp, 0);
            this.mLampOn.setOnMouseClicked(this::onTouchLampOn);
            GridPane.setConstraints((Node)this.mLampOn, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(13.0, 0.0, 0.0, 0.0));
            this.mLampModeGrid.getChildren().addAll((Object[])new Node[]{this.mLampOn});
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
            GridPane.setConstraints((Node)this.mLampModeGrid, (int)0, (int)5, (int)1, (int)3, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(1.0, 0.0, 0.0, 0.0));
        } else {
            GridPane.setConstraints((Node)this.mLampModeGrid, (int)0, (int)3, (int)1, (int)5, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        }
        this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mLampModeGrid});
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            this.mLampAElStop = new Text("0.0");
            this.mLampAElStop.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
            this.mLampAElStop.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
            TextFlow boxLampAElStop = new TextFlow();
            boxLampAElStop.setTextAlignment(TextAlignment.CENTER);
            boxLampAElStop.getChildren().add((Object)this.mLampAElStop);
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
                GridPane.setConstraints((Node)boxLampAElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - this.mLampAElStop.getBaselineOffset(), 0.0, 0.0, 31.0));
            } else {
                GridPane.setConstraints((Node)boxLampAElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - this.mLampAElStop.getBaselineOffset(), 0.0, 0.0, 0.0));
            }
            this.mLampAValueGrid = new GridPane();
            this.mLampAValueGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mLampAValueGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mLampAValueGrid.getChildren().addAll((Object[])new Node[]{boxLampAElStop});
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
                this.mLampAValueGrid.setMinWidth(149.0);
                this.mLampAValueGrid.setPrefWidth(149.0);
                GridPane.setConstraints((Node)this.mLampAValueGrid, (int)0, (int)6, (int)1, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 151.0, 0.0, 0.0));
            } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0) {
                if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
                    this.mLampAValueGrid.setMinWidth(300.0);
                    this.mLampAValueGrid.setPrefWidth(300.0);
                    GridPane.setConstraints((Node)this.mLampAValueGrid, (int)0, (int)6, (int)1, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                } else {
                    this.mLampAValueGrid.setMinWidth(300.0);
                    this.mLampAValueGrid.setPrefWidth(300.0);
                    GridPane.setConstraints((Node)this.mLampAValueGrid, (int)0, (int)4, (int)1, (int)4, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0, 0.0, 0.0, 0.0));
                }
            }
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mLampAValueGrid});
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0 || this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            this.mLampAMin = new Text("");
            this.mLampAMin.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLampAMin.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxLampAMin = new TextFlow();
            boxLampAMin.setTextAlignment(TextAlignment.LEFT);
            boxLampAMin.getChildren().add((Object)this.mLampAMin);
            GridPane.setConstraints((Node)boxLampAMin, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(53.0 - this.mLampAMin.getBaselineOffset(), 0.0, 0.0, 27.0));
            this.mLampAMax = new Text("");
            this.mLampAMax.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLampAMax.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxLampAMax = new TextFlow();
            boxLampAMax.setTextAlignment(TextAlignment.RIGHT);
            boxLampAMax.getChildren().add((Object)this.mLampAMax);
            GridPane.setConstraints((Node)boxLampAMax, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(53.0 - this.mLampAMax.getBaselineOffset(), 27.0, 0.0, 0.0));
            this.mLampASlider = new LayoutWidgetSlider(this.mContext, 0.0, 100.0, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeLampA));
            this.mLampASlider.setMinHeight(52.0);
            this.mLampASlider.setPrefHeight(52.0);
            this.mLampASlider.setOnMousePressed(this::onMousePressedLampA);
            this.mLampASlider.setOnMouseReleased(this::onMouseReleasedLampA);
            GridPane.setFillWidth((Node)this.mLampASlider, (Boolean)true);
            GridPane.setConstraints((Node)this.mLampASlider, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 23.0, 0.0, 23.0));
            this.mLampAMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
            this.mLampAMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampAMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampAMinus));
            GridPane.setConstraints((Node)this.mLampAMinus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mLampAPlus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
            this.mLampAPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampAPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampAPlus));
            GridPane.setConstraints((Node)this.mLampAPlus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mLampAControlGrid = new GridPane();
            this.mLampAControlGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mLampAControlGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mLampAControlGrid.getChildren().addAll((Object[])new Node[]{boxLampAMin, boxLampAMax, this.mLampASlider, this.mLampAMinus, this.mLampAPlus});
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
                this.mLampAControlGrid.setMinWidth(149.0);
                this.mLampAControlGrid.setPrefWidth(149.0);
                GridPane.setConstraints((Node)this.mLampAControlGrid, (int)0, (int)7, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 151.0, 0.0, 0.0));
            } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0) {
                if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
                    this.mLampAControlGrid.setMinWidth(300.0);
                    this.mLampAControlGrid.setPrefWidth(300.0);
                    GridPane.setConstraints((Node)this.mLampAControlGrid, (int)0, (int)7, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                } else {
                    this.mLampAControlGrid.setMinWidth(300.0);
                    this.mLampAControlGrid.setPrefWidth(300.0);
                    GridPane.setConstraints((Node)this.mLampAControlGrid, (int)0, (int)5, (int)1, (int)3, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(1.0, 0.0, 0.0, 0.0));
                }
            }
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mLampAControlGrid});
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
            this.mLampBElStop = new Text("0.0");
            this.mLampBElStop.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
            this.mLampBElStop.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
            TextFlow boxLampBElStop = new TextFlow();
            boxLampBElStop.setTextAlignment(TextAlignment.CENTER);
            boxLampBElStop.getChildren().add((Object)this.mLampBElStop);
            GridPane.setConstraints((Node)boxLampBElStop, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - this.mLampBElStop.getBaselineOffset(), 7.0, 0.0, 0.0));
            this.mLampBValueGrid = new GridPane();
            this.mLampBValueGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mLampBValueGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mLampBValueGrid.getChildren().addAll((Object[])new Node[]{boxLampBElStop});
            this.mLampBValueGrid.setMinWidth(149.0);
            this.mLampBValueGrid.setPrefWidth(149.0);
            GridPane.setConstraints((Node)this.mLampBValueGrid, (int)0, (int)6, (int)1, (int)2, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 151.0));
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mLampBValueGrid});
            this.mLampBMin = new Text("");
            this.mLampBMin.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLampBMin.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxLampBMin = new TextFlow();
            boxLampBMin.setTextAlignment(TextAlignment.LEFT);
            boxLampBMin.getChildren().add((Object)this.mLampBMin);
            GridPane.setConstraints((Node)boxLampBMin, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(53.0 - this.mLampBMin.getBaselineOffset(), 0.0, 0.0, 27.0));
            this.mLampBMax = new Text("");
            this.mLampBMax.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLampBMax.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
            TextFlow boxLampBMax = new TextFlow();
            boxLampBMax.setTextAlignment(TextAlignment.RIGHT);
            boxLampBMax.getChildren().add((Object)this.mLampBMax);
            GridPane.setConstraints((Node)boxLampBMax, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(53.0 - this.mLampBMax.getBaselineOffset(), 27.0, 0.0, 0.0));
            this.mLampBSlider = new LayoutWidgetSlider(this.mContext, 0.0, 100.0, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeLampB));
            this.mLampBSlider.setMinHeight(52.0);
            this.mLampBSlider.setPrefHeight(52.0);
            this.mLampBSlider.setOnMousePressed(this::onMousePressedLampB);
            this.mLampBSlider.setOnMouseReleased(this::onMouseReleasedLampB);
            GridPane.setFillWidth((Node)this.mLampBSlider, (Boolean)true);
            GridPane.setConstraints((Node)this.mLampBSlider, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 23.0, 0.0, 23.0));
            this.mLampBMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
            this.mLampBMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampBMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampBMinus));
            GridPane.setConstraints((Node)this.mLampBMinus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mLampBPlus = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
            this.mLampBPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampBPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampBPlus));
            GridPane.setConstraints((Node)this.mLampBPlus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
            this.mLampBControlGrid = new GridPane();
            this.mLampBControlGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
            this.mLampBControlGrid.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
            this.mLampBControlGrid.getChildren().addAll((Object[])new Node[]{boxLampBMin, boxLampBMax, this.mLampBSlider, this.mLampBMinus, this.mLampBPlus});
            this.mLampBControlGrid.setMinWidth(149.0);
            this.mLampBControlGrid.setPrefWidth(149.0);
            GridPane.setConstraints((Node)this.mLampBControlGrid, (int)0, (int)7, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 151.0));
            this.mViewDashboard.getChildren().addAll((Object[])new Node[]{this.mLampBControlGrid});
        }
        int rowIndex = 2;
        ColumnConstraints col = new ColumnConstraints(246.0, 246.0, 246.0, Priority.NEVER, HPos.CENTER, false);
        RowConstraints r0 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r0.setPercentHeight(5.0);
        RowConstraints r1 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r1.setPercentHeight(11.33333);
        RowConstraints r2 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r2.setPercentHeight(11.33333);
        RowConstraints r3 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r3.setPercentHeight(11.33333);
        RowConstraints r4 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r4.setPercentHeight(11.33333);
        RowConstraints r5 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r5.setPercentHeight(11.33333);
        RowConstraints r6 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r6.setPercentHeight(11.33333);
        RowConstraints r7 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r7.setPercentHeight(11.33333);
        RowConstraints r8 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r8.setPercentHeight(11.33333);
        RowConstraints r9 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        r9.setPercentHeight(4.33333);
        this.mViewSettings = new GridPane();
        this.mViewSettings.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col});
        this.mViewSettings.getRowConstraints().addAll((Object[])new RowConstraints[]{r0, r1, r2, r3, r4, r5, r6, r7, r8, r9});
        this.mViewSettings.getStyleClass().addAll((Object[])new String[]{"group-color"});
        this.mViewSettings.setVisible(false);
        GridPane.setConstraints((Node)this.mViewSettings, (int)0, (int)2, (int)3, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        GridPane.setFillHeight((Node)this.mViewSettings, (Boolean)true);
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[6] == 1) {
            this.mLabels[0] = new Text("Standby");
            this.mLabels[0].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[0].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelStandby = new TextFlow();
            boxLabelStandby.setMinWidth(246.0);
            boxLabelStandby.setPrefWidth(246.0);
            boxLabelStandby.getChildren().add((Object)this.mLabels[0]);
            GridPane.setConstraints((Node)boxLabelStandby, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[0].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mStandbySwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mStandbySwitch.setTranslateX(1.0);
            this.mStandbySwitch.setOnMouseClicked(this::onTouchStandby);
            GridPane.setConstraints((Node)this.mStandbySwitch, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelStandby, this.mStandbySwitch});
            ++rowIndex;
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[10] == 1) {
            this.mLabels[1] = new Text("Audio");
            this.mLabels[1].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[1].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelAudio = new TextFlow();
            boxLabelAudio.setMinWidth(246.0);
            boxLabelAudio.setPrefWidth(246.0);
            boxLabelAudio.getChildren().add((Object)this.mLabels[1]);
            GridPane.setConstraints((Node)boxLabelAudio, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[1].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mAudioSwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mAudioSwitch.setTranslateX(1.0);
            this.mAudioSwitch.setOnMouseClicked(this::onTouchAudio);
            GridPane.setConstraints((Node)this.mAudioSwitch, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelAudio, this.mAudioSwitch});
            ++rowIndex;
        }
        this.mLabels[2] = new Text("Photocell");
        this.mLabels[2].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mLabels[2].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelPhotocell = new TextFlow();
        boxLabelPhotocell.setMinWidth(246.0);
        boxLabelPhotocell.setPrefWidth(246.0);
        boxLabelPhotocell.getChildren().add((Object)this.mLabels[2]);
        GridPane.setConstraints((Node)boxLabelPhotocell, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[2].getBaselineOffset(), 0.0, 0.0, 0.0));
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[8] == 1) {
            this.mChoicePhotocell = new ComboBox();
            this.mChoicePhotocell.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mPhotocellLabels);
            this.mChoicePhotocell.setMinSize(128.0, 26.0);
            this.mChoicePhotocell.setPrefSize(128.0, 26.0);
            this.mChoicePhotocell.setMaxSize(128.0, 26.0);
            this.mChoicePhotocell.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoicePhotocell.setOnAction(this::onValueChangedPhotocell);
            GridPane.setConstraints(this.mChoicePhotocell, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelPhotocell, this.mChoicePhotocell});
            ++rowIndex;
        } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[7] == 1) {
            this.mPhotocellSwitch = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
            this.mPhotocellSwitch.setTranslateX(1.0);
            this.mPhotocellSwitch.setOnMouseClicked(this::onTouchPhotocell);
            GridPane.setConstraints((Node)this.mPhotocellSwitch, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelPhotocell, this.mPhotocellSwitch});
            ++rowIndex;
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[9] == 1) {
            this.mLabels[3] = new Text("Recycling");
            this.mLabels[3].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[3].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelRecycling = new TextFlow();
            boxLabelRecycling.setMinWidth(246.0);
            boxLabelRecycling.setPrefWidth(246.0);
            boxLabelRecycling.getChildren().add((Object)this.mLabels[3]);
            GridPane.setConstraints((Node)boxLabelRecycling, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[3].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mChoiceRecycling = new ComboBox();
            this.mChoiceRecycling.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mRecyclingModeLabels);
            this.mChoiceRecycling.setMinSize(128.0, 26.0);
            this.mChoiceRecycling.setPrefSize(128.0, 26.0);
            this.mChoiceRecycling.setMaxSize(128.0, 26.0);
            this.mChoiceRecycling.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoiceRecycling.setOnAction(this::onValueChangedRecycling);
            GridPane.setConstraints(this.mChoiceRecycling, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelRecycling, this.mChoiceRecycling});
            ++rowIndex;
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[11] == 1) {
            this.mLabels[4] = new Text("Flash mode");
            this.mLabels[4].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[4].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelFlashMode = new TextFlow();
            boxLabelFlashMode.setMinWidth(246.0);
            boxLabelFlashMode.setPrefWidth(246.0);
            boxLabelFlashMode.getChildren().add((Object)this.mLabels[4]);
            GridPane.setConstraints((Node)boxLabelFlashMode, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[4].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mChoiceFlashMode = new ComboBox();
            this.mChoiceFlashMode.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mFlashModeLabels);
            this.mChoiceFlashMode.setMinSize(128.0, 26.0);
            this.mChoiceFlashMode.setPrefSize(128.0, 26.0);
            this.mChoiceFlashMode.setMaxSize(128.0, 26.0);
            this.mChoiceFlashMode.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoiceFlashMode.setOnAction(this::onValueChangedFlashMode);
            GridPane.setConstraints(this.mChoiceFlashMode, (int)0, (int)rowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            this.mLabels[7] = new Text("Delay");
            this.mLabels[7].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[7].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mLabels[7], false);
            TextFlow boxLabelDelay = new TextFlow();
            boxLabelDelay.setMinWidth(246.0);
            boxLabelDelay.setPrefWidth(246.0);
            boxLabelDelay.getChildren().add((Object)this.mLabels[7]);
            GridPane.setConstraints((Node)boxLabelDelay, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[7].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mDelay = new TextField();
            this.mDelay.setAlignment(Pos.TOP_RIGHT);
            this.mDelay.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.mDelay.setPrefWidth(128.0);
            this.mDelay.setPromptText("1");
            this.mDelay.focusedProperty().addListener(this::onFocusChangeDelay);
            this.mDelay.setOnKeyReleased(this::onKey);
            GridPane.setConstraints((Node)this.mDelay, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
            this.show((Node)this.mDelay, false);
            this.mLabels[5] = new Text("Sequence timeout");
            this.mLabels[5].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[5].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mLabels[5], false);
            TextFlow boxLabelSequenceTimeout = new TextFlow();
            boxLabelSequenceTimeout.setMinWidth(246.0);
            boxLabelSequenceTimeout.setPrefWidth(246.0);
            boxLabelSequenceTimeout.getChildren().add((Object)this.mLabels[5]);
            GridPane.setConstraints((Node)boxLabelSequenceTimeout, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[5].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mSequenceTimeout = new TextField();
            this.mSequenceTimeout.setAlignment(Pos.TOP_RIGHT);
            this.mSequenceTimeout.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.mSequenceTimeout.setPrefWidth(128.0);
            this.mSequenceTimeout.setPromptText("100");
            this.mSequenceTimeout.focusedProperty().addListener(this::onFocusChangeSequenceTimeout);
            this.mSequenceTimeout.setOnKeyReleased(this::onKey);
            GridPane.setConstraints((Node)this.mSequenceTimeout, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
            this.show((Node)this.mSequenceTimeout, false);
            this.mLabels[6] = new Text("Unit address");
            this.mLabels[6].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[6].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mLabels[6], false);
            TextFlow boxLabelUnitAddress = new TextFlow();
            boxLabelUnitAddress.setMinWidth(246.0);
            boxLabelUnitAddress.setPrefWidth(246.0);
            boxLabelUnitAddress.getChildren().add((Object)this.mLabels[6]);
            GridPane.setConstraints((Node)boxLabelUnitAddress, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[6].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mChoiceUnitAddress = new ComboBox();
            this.mChoiceUnitAddress.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mUnitAddressLabels);
            this.mChoiceUnitAddress.setMinSize(54.0, 26.0);
            this.mChoiceUnitAddress.setPrefSize(54.0, 26.0);
            this.mChoiceUnitAddress.setMaxSize(54.0, 26.0);
            this.mChoiceUnitAddress.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoiceUnitAddress.setOnAction(this::onValueChangedFlashModeSequence);
            GridPane.setConstraints(this.mChoiceUnitAddress, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 74.0, 0.0, 0.0));
            this.show((Node)this.mChoiceUnitAddress, false);
            this.mSpacerSlash = new Text("/");
            this.mSpacerSlash.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mSpacerSlash.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mSpacerSlash, false);
            TextFlow boxSpacerSlash = new TextFlow();
            boxSpacerSlash.getChildren().add((Object)this.mSpacerSlash);
            GridPane.setConstraints((Node)boxSpacerSlash, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mSpacerSlash.getBaselineOffset(), 0.0, 0.0, 118.0));
            this.mChoiceTotalUnits = new ComboBox();
            this.mChoiceTotalUnits.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mTotalUnitsLabels);
            this.mChoiceTotalUnits.setMinSize(54.0, 26.0);
            this.mChoiceTotalUnits.setPrefSize(54.0, 26.0);
            this.mChoiceTotalUnits.setMaxSize(54.0, 26.0);
            this.mChoiceTotalUnits.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoiceTotalUnits.setOnAction(this::onValueChangedFlashModeSequence);
            GridPane.setConstraints(this.mChoiceTotalUnits, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            this.show((Node)this.mChoiceTotalUnits, false);
            this.mLabels[8] = new Text("Duration");
            this.mLabels[8].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[8].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mLabels[8], false);
            TextFlow boxLabelStroboDuration = new TextFlow();
            boxLabelStroboDuration.setMinWidth(246.0);
            boxLabelStroboDuration.setPrefWidth(246.0);
            boxLabelStroboDuration.getChildren().add((Object)this.mLabels[8]);
            GridPane.setConstraints((Node)boxLabelStroboDuration, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[8].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mStroboDuration = new TextField();
            this.mStroboDuration.setAlignment(Pos.TOP_RIGHT);
            this.mStroboDuration.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.mStroboDuration.setPrefWidth(128.0);
            this.mStroboDuration.setPromptText("500");
            this.mStroboDuration.focusedProperty().addListener(this::onFocusChangeStroboDuration);
            this.mStroboDuration.setOnKeyReleased(this::onKey);
            GridPane.setConstraints((Node)this.mStroboDuration, (int)0, (int)(rowIndex + 1), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
            this.show((Node)this.mStroboDuration, false);
            this.mLabels[9] = new Text("Flashes/second");
            this.mLabels[9].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[9].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            this.show((Node)this.mLabels[9], false);
            TextFlow boxLabelStroboFrequency = new TextFlow();
            boxLabelStroboFrequency.setMinWidth(246.0);
            boxLabelStroboFrequency.setPrefWidth(246.0);
            boxLabelStroboFrequency.getChildren().add((Object)this.mLabels[9]);
            GridPane.setConstraints((Node)boxLabelStroboFrequency, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(22.0 - this.mLabels[9].getBaselineOffset(), 0.0, 0.0, 0.0));
            this.mChoiceStroboFrequency = new ComboBox();
            this.mChoiceStroboFrequency.getItems().addAll((Object[])this.mElinchromDevice.mComponentLighting.mFlashesPerSecondLabels);
            this.mChoiceStroboFrequency.setMinSize(128.0, 26.0);
            this.mChoiceStroboFrequency.setPrefSize(128.0, 26.0);
            this.mChoiceStroboFrequency.setMaxSize(128.0, 26.0);
            this.mChoiceStroboFrequency.getStyleClass().addAll((Object[])new String[]{"rounded"});
            this.mChoiceStroboFrequency.setOnAction(this::onValueChangedStroboFrequency);
            GridPane.setConstraints(this.mChoiceStroboFrequency, (int)0, (int)(rowIndex + 2), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            this.show((Node)this.mChoiceStroboFrequency, false);
            this.mViewSettings.getChildren().addAll((Object[])new Node[]{boxLabelFlashMode, this.mChoiceFlashMode, boxLabelSequenceTimeout, this.mSequenceTimeout, boxLabelUnitAddress, this.mChoiceUnitAddress, boxSpacerSlash, this.mChoiceTotalUnits, boxLabelDelay, this.mDelay, boxLabelStroboDuration, this.mStroboDuration, boxLabelStroboFrequency, this.mChoiceStroboFrequency});
        }
        this.mViewInfo = new GridPane();
        this.mViewInfo.getStyleClass().addAll((Object[])new String[]{"group-color"});
        GridPane.setConstraints((Node)this.mViewInfo, (int)0, (int)2, (int)3, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        GridPane.setFillHeight((Node)this.mViewInfo, (Boolean)true);
        int infoRowIndex = 2;
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[13] == 1) {
            this.mLabels[10] = new Text("Firmware");
            this.mLabels[10].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[10].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelFirmware = new TextFlow();
            boxLabelFirmware.setTextAlignment(TextAlignment.LEFT);
            boxLabelFirmware.setMinWidth(246.0);
            boxLabelFirmware.setPrefWidth(246.0);
            boxLabelFirmware.getChildren().add((Object)this.mLabels[10]);
            this.mContext.mUtil.setTextBaseline(boxLabelFirmware, this.mLabels[10], 22.0);
            GridPane.setConstraints((Node)boxLabelFirmware, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
            this.mLabels[11] = new Text("0.0");
            this.mLabels[11].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[11].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelFirmwareValue = new TextFlow();
            boxLabelFirmwareValue.setTextAlignment(TextAlignment.RIGHT);
            boxLabelFirmwareValue.setMinWidth(246.0);
            boxLabelFirmwareValue.setPrefWidth(246.0);
            boxLabelFirmwareValue.getChildren().add((Object)this.mLabels[11]);
            this.mContext.mUtil.setTextBaseline(boxLabelFirmwareValue, this.mLabels[11], 22.0);
            GridPane.setConstraints((Node)boxLabelFirmwareValue, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP);
            this.mViewInfo.getChildren().addAll((Object[])new Node[]{boxLabelFirmware, boxLabelFirmwareValue});
            ++infoRowIndex;
        }
        this.mLabels[12] = new Text("Unit ID");
        this.mLabels[12].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mLabels[12].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelUnitId = new TextFlow();
        boxLabelUnitId.setTextAlignment(TextAlignment.LEFT);
        boxLabelUnitId.setMinWidth(246.0);
        boxLabelUnitId.setPrefWidth(246.0);
        boxLabelUnitId.getChildren().add((Object)this.mLabels[12]);
        this.mContext.mUtil.setTextBaseline(boxLabelUnitId, this.mLabels[12], 22.0);
        GridPane.setConstraints((Node)boxLabelUnitId, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mLabels[13] = new Text(this.mElinchromDevice.getSkyportId());
        this.mLabels[13].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mLabels[13].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelUnitIdValue = new TextFlow();
        boxLabelUnitIdValue.setTextAlignment(TextAlignment.RIGHT);
        boxLabelUnitIdValue.setMinWidth(246.0);
        boxLabelUnitIdValue.setPrefWidth(246.0);
        boxLabelUnitIdValue.getChildren().add((Object)this.mLabels[13]);
        this.mContext.mUtil.setTextBaseline(boxLabelUnitIdValue, this.mLabels[13], 22.0);
        GridPane.setConstraints((Node)boxLabelUnitIdValue, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP);
        ++infoRowIndex;
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[12] == 1) {
            this.mLabels[14] = new Text("Flash count");
            this.mLabels[14].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[14].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelFlashCount = new TextFlow();
            boxLabelFlashCount.setTextAlignment(TextAlignment.LEFT);
            boxLabelFlashCount.setMinWidth(246.0);
            boxLabelFlashCount.setPrefWidth(246.0);
            boxLabelFlashCount.getChildren().add((Object)this.mLabels[14]);
            this.mContext.mUtil.setTextBaseline(boxLabelFlashCount, this.mLabels[14], 22.0);
            GridPane.setConstraints((Node)boxLabelFlashCount, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
            this.mLabels[15] = new Text("0");
            this.mLabels[15].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[15].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelFlashCountValue = new TextFlow();
            boxLabelFlashCountValue.setTextAlignment(TextAlignment.RIGHT);
            boxLabelFlashCountValue.setMinWidth(246.0);
            boxLabelFlashCountValue.setPrefWidth(246.0);
            boxLabelFlashCountValue.getChildren().add((Object)this.mLabels[15]);
            this.mContext.mUtil.setTextBaseline(boxLabelFlashCountValue, this.mLabels[15], 22.0);
            GridPane.setConstraints((Node)boxLabelFlashCountValue, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP);
            ++infoRowIndex;
            this.mLabels[16] = new Text("Session count");
            this.mLabels[16].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[16].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelSessionCount = new TextFlow();
            boxLabelSessionCount.setTextAlignment(TextAlignment.LEFT);
            boxLabelSessionCount.setMinWidth(246.0);
            boxLabelSessionCount.setPrefWidth(246.0);
            boxLabelSessionCount.getChildren().add((Object)this.mLabels[16]);
            this.mContext.mUtil.setTextBaseline(boxLabelSessionCount, this.mLabels[16], 22.0);
            GridPane.setConstraints((Node)boxLabelSessionCount, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
            this.mLabels[17] = new Text("0");
            this.mLabels[17].setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
            this.mLabels[17].setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxLabelSessionCountValue = new TextFlow();
            boxLabelSessionCountValue.setTextAlignment(TextAlignment.RIGHT);
            boxLabelSessionCountValue.setMinWidth(246.0);
            boxLabelSessionCountValue.setPrefWidth(246.0);
            boxLabelSessionCountValue.getChildren().add((Object)this.mLabels[17]);
            this.mContext.mUtil.setTextBaseline(boxLabelSessionCountValue, this.mLabels[17], 22.0);
            GridPane.setConstraints((Node)boxLabelSessionCountValue, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP);
            this.mViewInfo.getChildren().addAll((Object[])new Node[]{boxLabelFlashCount, boxLabelFlashCountValue, boxLabelSessionCount, boxLabelSessionCountValue});
            ++infoRowIndex;
        }
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[13] == 1) {
            this.mFirmwareStatus = new Text("Your firmware is up to date");
            this.mFirmwareStatus.getStyleClass().add((Object)"status-text");
            this.mFirmwareStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
            TextFlow boxFirmwareStatus = new TextFlow();
            boxFirmwareStatus.setTextAlignment(TextAlignment.CENTER);
            boxFirmwareStatus.setMinWidth(246.0);
            boxFirmwareStatus.setPrefWidth(246.0);
            boxFirmwareStatus.getChildren().add((Object)this.mFirmwareStatus);
            this.mContext.mUtil.setTextBaseline(boxFirmwareStatus, this.mFirmwareStatus, 22.0);
            GridPane.setConstraints((Node)boxFirmwareStatus, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
            this.mFirmwareMark = new LayoutWidgetIcon(this.mContext, -1.0, 34.0, null, "firmware_mark.svg", 3.5, "A new firmware is available", 16.0, this.mContext.mFontRegular, 14.0, this.mContext.mDayActivatedColor);
            this.mFirmwareMark.setVisible(false);
            this.mFirmwareMark.setOnMouseClicked(this::onTouchFirmwareStatus);
            GridPane.setConstraints((Node)this.mFirmwareMark, (int)0, (int)infoRowIndex, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
            this.mViewInfo.getChildren().addAll((Object[])new Node[]{boxFirmwareStatus, this.mFirmwareMark});
        }
        this.mViewInfo.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col});
        this.mViewInfo.getRowConstraints().addAll((Object[])new RowConstraints[]{r0, r1, r2, r3, r4, r5, r6, r7, r8, r9});
        this.mViewInfo.getChildren().addAll((Object[])new Node[]{boxLabelUnitId, boxLabelUnitIdValue});
        this.mViewInfo.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{this.mViewDashboard, this.mViewSettings, this.mViewInfo, this.mIconCheckbox, this.mChoiceGroup, this.mTabDashboard, this.mTabSettings, this.mTabInfo, this.mIconSignal, this.mUnitBatteryIcon, this.mFriendlyName, this.mImageUnit, this.mDarkMask});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    public void onChangeFriendlyName() {
        this.mElinchromDevice.mComponentLighting.setFriendlyNameIfChanged(this.mFriendlyName.getText());
    }

    public void onDragDetected(MouseEvent event) {
        try {
            this.mContext.mLogger.log("Drag detected for " + this.mElinchromDevice.getSkyportId());
            Dragboard dragBoard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            if (this.mContext.mUtil.isWindows()) {
                dragBoard.setDragView((Image)this.snapshot(null, null), event.getX(), event.getY());
            } else {
                dragBoard.setDragView((Image)this.snapshot(null, null));
            }
            ClipboardContent content = new ClipboardContent();
            content.putString("" + this.mElinchromDevice.mDeviceId);
            dragBoard.setContent((Map)content);
            this.setVisible(false);
            this.mContext.mLayoutPresenterSideMenu.onGroupIndent();
            event.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragDone(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag done for " + this.mElinchromDevice.getSkyportId());
            this.mContext.mLayoutPresenterSideMenu.onGroupRestore();
            this.setVisible(true);
            dragEvent.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragDropped(DragEvent dragEvent) {
        try {
            ElinchromDevice sourceDevice;
            this.mContext.mLogger.log("Drag dropped on " + this.mElinchromDevice.getSkyportId());
            if (this.mContext.mStoredPreferences.sortManually == 1 && (sourceDevice = this.mContext.mElinchromDevices.get(Long.valueOf(dragEvent.getDragboard().getString()))) != null && this.mContext.mManuallySortedFlashUnitMap.containsKey(sourceDevice.getSkyportId())) {
                int sourcePosition = this.mContext.mManuallySortedFlashUnitMap.get(sourceDevice.getSkyportId());
                int destinationPosition = this.mContext.mManuallySortedFlashUnitMap.get(this.mElinchromDevice.getSkyportId());
                for (Map.Entry<String, Integer> storedEntry : this.mContext.mManuallySortedFlashUnitMap.entrySet()) {
                    if (storedEntry.getValue() >= destinationPosition && storedEntry.getValue() < sourcePosition) {
                        this.mContext.mManuallySortedFlashUnitMap.put(storedEntry.getKey(), storedEntry.getValue() + 1);
                        continue;
                    }
                    if (storedEntry.getValue() <= sourcePosition || storedEntry.getValue() > destinationPosition) continue;
                    this.mContext.mManuallySortedFlashUnitMap.put(storedEntry.getKey(), storedEntry.getValue() - 1);
                }
                this.mContext.mManuallySortedFlashUnitMap.put(sourceDevice.getSkyportId(), destinationPosition);
                this.mContext.mFileManager.updateManuallySortedUnits();
                this.mContext.mLayoutPresenterUnits.sortUnits();
                this.mContext.mLayoutPresenterUnits.displayUnits();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragOver(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag over on " + this.mElinchromDevice.getSkyportId());
            if (this.mContext.mStoredPreferences.sortManually == 1) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                dragEvent.consume();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onFocusChangeDelay(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        block5: {
            try {
                String newValueString;
                if (newValue.booleanValue()) break block5;
                String value = this.mDelay.getText();
                int minValue = 1;
                int maxValue = 10000;
                try {
                    newValueString = Integer.toString(Math.max(minValue, Math.min(Integer.parseInt(value.replaceAll("[^\\d]", "")), maxValue)));
                }
                catch (Throwable t) {
                    newValueString = Integer.toString(minValue);
                }
                if (!value.equals(newValue)) {
                    this.mDelay.setText(newValueString);
                }
                this.mContext.mLayoutPresenterUnits.onChangeFlashModeDelay(this.mElinchromDevice, newValueString);
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }

    public void onFocusChangeFriendlyName(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        try {
            if (!newValue.booleanValue()) {
                String checkedName;
                String name = this.mFriendlyName.getText();
                if (!name.equals(checkedName = this.mContext.mUtil.checkFriendlyName(name, 16))) {
                    this.mFriendlyName.setText(checkedName);
                }
                this.onChangeFriendlyName();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onFocusChangeSequenceTimeout(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        block5: {
            try {
                String newValueString;
                if (newValue.booleanValue()) break block5;
                String value = this.mSequenceTimeout.getText();
                int minValue = 100;
                int maxValue = 5000;
                try {
                    newValueString = Integer.toString(Math.max(minValue, Math.min(Integer.parseInt(value.replaceAll("[^\\d]", "")), maxValue)));
                }
                catch (Throwable t) {
                    newValueString = Integer.toString(minValue);
                }
                if (!value.equals(newValueString)) {
                    this.mSequenceTimeout.setText(newValueString);
                }
                this.mContext.mLayoutPresenterUnits.onChangeFlashModeSequence(this.mElinchromDevice, newValueString, this.mChoiceUnitAddress.getSelectionModel().getSelectedIndex(), this.mChoiceTotalUnits.getSelectionModel().getSelectedIndex());
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }

    public void onFocusChangeStroboDuration(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        block5: {
            try {
                String newValueString;
                if (newValue.booleanValue()) break block5;
                String value = this.mStroboDuration.getText();
                int minValue = 500;
                int maxValue = 5000;
                try {
                    newValueString = Integer.toString(Math.max(minValue, Math.min(Integer.parseInt(value.replaceAll("[^\\d]", "")), maxValue)));
                }
                catch (Throwable t) {
                    newValueString = Integer.toString(minValue);
                }
                if (!value.equals(newValueString)) {
                    this.mStroboDuration.setText(newValueString);
                }
                this.mContext.mLayoutPresenterUnits.onChangeFlashModeStrobo(this.mElinchromDevice, newValueString, this.mChoiceStroboFrequency.getSelectionModel().getSelectedIndex());
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }

    public void onKey(KeyEvent keyEvent) {
        try {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.requestFocus();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMousePressedFlashMain(MouseEvent event) {
        try {
            this.mIsSliding = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMousePressedHeadPowerASlider(MouseEvent event) {
        try {
            this.mIsSliding = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMousePressedHeadPowerBSlider(MouseEvent event) {
        try {
            this.mIsSliding = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMousePressedLampA(MouseEvent event) {
        try {
            this.mIsSliding = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMousePressedLampB(MouseEvent event) {
        try {
            this.mIsSliding = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMouseReleasedFlashMain(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeFlashPower(this.mElinchromDevice, (int)Math.round(this.mFlashMainSlider.getValue() * 10.0));
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMouseReleasedHeadPowerASlider(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeHeadAElStop(this.mElinchromDevice, (int)Math.round(this.mHeadASlider.getValue() * 10.0));
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMouseReleasedHeadPowerBSlider(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeHeadBElStop(this.mElinchromDevice, (int)Math.round(this.mHeadBSlider.getValue() * 10.0));
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMouseReleasedLampA(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, (int)Math.round(this.mLampASlider.getValue() * 10.0));
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onMouseReleasedLampB(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampB(this.mElinchromDevice, (int)Math.round(this.mLampBSlider.getValue() * 10.0));
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onLongTouchFlashMainMinus(MouseEvent event) {
        this.onFlashMainIncrement(-10);
    }

    public void onLongTouchFlashMainPlus(MouseEvent event) {
        this.onFlashMainIncrement(10);
    }

    public void onLongTouchHeadAMinus(MouseEvent event) {
        this.onHeadAIncrement(-10);
    }

    public void onLongTouchHeadAPlus(MouseEvent event) {
        this.onHeadAIncrement(10);
    }

    public void onLongTouchHeadBMinus(MouseEvent event) {
        this.onHeadBIncrement(-10);
    }

    public void onLongTouchHeadBPlus(MouseEvent event) {
        this.onHeadBIncrement(10);
    }

    public void onLongTouchLampAMinus(MouseEvent event) {
        this.onLampAIncrement(-10);
    }

    public void onLongTouchLampAPlus(MouseEvent event) {
        this.onLampAIncrement(10);
    }

    public void onLongTouchLampBMinus(MouseEvent event) {
        this.onLampBIncrement(-10);
    }

    public void onLongTouchLampBPlus(MouseEvent event) {
        this.onLampBIncrement(10);
    }

    public void onTouchAudio(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onUnitAudio(this.mElinchromDevice, this.mAudioSwitch.onSwitch());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFirmwareStatus(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onFirmwareStatus(this.mElinchromDevice);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFlashMainMinus(MouseEvent event) {
        this.onFlashMainIncrement(-1);
    }

    public void onFlashMainIncrement(int increment) {
        this.mContext.mLayoutPresenterUnits.onChangeFlashPower(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getMainPowerValues()[0] + increment);
    }

    public void onTouchFlashMainPlus(MouseEvent event) {
        this.onFlashMainIncrement(1);
    }

    public void onTouchHeadAMinus(MouseEvent event) {
        this.onHeadAIncrement(-1);
    }

    public void onHeadAIncrement(int increment) {
        this.mContext.mLayoutPresenterUnits.onChangeHeadAElStop(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getMainPowerValues()[1] + increment);
    }

    public void onTouchHeadAPlus(MouseEvent event) {
        this.onHeadAIncrement(1);
    }

    public void onTouchHeadASwitch(MouseEvent event) {
        try {
            if (this.mHeadASwitch.isEnabled()) {
                this.mContext.mLayoutPresenterUnits.onHeadSwitch(this.mElinchromDevice, this.mHeadASwitch.onSwitch(), this.mHeadBSwitch.isActivated());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchHeadBMinus(MouseEvent event) {
        this.onHeadBIncrement(-1);
    }

    public void onHeadBIncrement(int increment) {
        this.mContext.mLayoutPresenterUnits.onChangeHeadBElStop(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getMainPowerValues()[2] + increment);
    }

    public void onTouchHeadBPlus(MouseEvent event) {
        this.onHeadBIncrement(1);
    }

    public void onTouchHeadBSwitch(MouseEvent event) {
        try {
            if (this.mHeadBSwitch.isEnabled()) {
                this.mContext.mLayoutPresenterUnits.onHeadSwitch(this.mElinchromDevice, this.mHeadASwitch.isActivated(), this.mHeadBSwitch.onSwitch());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampAMinus(MouseEvent event) {
        this.onLampAIncrement(-1);
    }

    public void onLampAIncrement(int increment) {
        this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[0] + increment);
    }

    public void onTouchLampAPlus(MouseEvent event) {
        this.onLampAIncrement(1);
    }

    public void onTouchLampBMinus(MouseEvent event) {
        this.onLampBIncrement(-1);
    }

    public void onLampBIncrement(int increment) {
        this.mContext.mLayoutPresenterUnits.onChangeLampB(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[1] + increment);
    }

    public void onTouchLampBPlus(MouseEvent event) {
        this.onLampBIncrement(1);
    }

    public void onTouchLampModeFree(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampMode(this.mElinchromDevice, 3);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampModeOff(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampMode(this.mElinchromDevice, 0);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampModeProp(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampMode(this.mElinchromDevice, 2);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampModeSwitch(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampMode(this.mElinchromDevice, this.mLampModeSwitch.onSwitch() ? 1 : 0);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampOn(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeLampMode(this.mElinchromDevice, 1);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPhotocell(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterUnits.onUnitPhotocell(this.mElinchromDevice, this.mPhotocellSwitch.onSwitch() ? (byte)1 : 0);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchProductPicture(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mModuleManagerSdk.trigger(this.mElinchromDevice);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchScreen(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.requestFocus();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSelectionCheckbox(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mIsSelected = !this.mIsSelected;
                this.mIconCheckbox.setIndex(this.mIsSelected ? 1 : 0);
                this.mContext.mLayoutPresenterUnits.onSelectionChange();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchStandby(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterUnits.onUnitStandby(this.mElinchromDevice, this.mStandbySwitch.onSwitch());
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabDashboard(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.displayTabDashboard();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabSettings(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.displayTabSettings();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabInfo(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.displayTabInfo();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedFlashMode(ActionEvent event) {
        try {
            switch (this.mElinchromDevice.mComponentLighting.mFlashModeValues[this.mChoiceFlashMode.getSelectionModel().getSelectedIndex()]) {
                default: {
                    this.mContext.mLayoutPresenterUnits.onChangeFlashModeDefault(this.mElinchromDevice);
                    this.displayFlashMode();
                    break;
                }
                case 1: {
                    this.mContext.mLayoutPresenterUnits.onChangeFlashModeSequence(this.mElinchromDevice, this.mSequenceTimeout.getText(), this.mChoiceUnitAddress.getSelectionModel().getSelectedIndex(), this.mChoiceTotalUnits.getSelectionModel().getSelectedIndex());
                    this.displayFlashMode();
                    break;
                }
                case 2: {
                    this.mContext.mLayoutPresenterUnits.onChangeFlashModeDelay(this.mElinchromDevice, this.mDelay.getText());
                    this.displayFlashMode();
                    break;
                }
                case 3: {
                    this.mContext.mLayoutPresenterUnits.onChangeFlashModeStrobo(this.mElinchromDevice, this.mStroboDuration.getText(), this.mChoiceStroboFrequency.getSelectionModel().getSelectedIndex());
                    this.displayFlashMode();
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedFlashModeSequence(ActionEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeFlashModeSequence(this.mElinchromDevice, this.mSequenceTimeout.getText(), this.mChoiceUnitAddress.getSelectionModel().getSelectedIndex(), this.mChoiceTotalUnits.getSelectionModel().getSelectedIndex());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedGroup(ActionEvent event) {
        try {
            this.mElinchromDevice.mComponentLighting.setGroup(this.mGroupIds[this.mChoiceGroup.getSelectionModel().getSelectedIndex()]);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedPhotocell(ActionEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onUnitPhotocell(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.mPhotocellValues[this.mChoicePhotocell.getSelectionModel().getSelectedIndex()]);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedRatio(ActionEvent event) {
        try {
            this.mElinchromDevice.mComponentLighting.sendHeads_ratio(this.mElinchromDevice.mComponentLighting.mPowerRatioValues[this.mChoiceRatio.getSelectionModel().getSelectedIndex()]);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedRecycling(ActionEvent event) {
        try {
            this.mElinchromDevice.mComponentLighting.setCharge_mode(this.mElinchromDevice.mComponentLighting.mRecyclingModeValues[this.mChoiceRecycling.getSelectionModel().getSelectedIndex()]);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedStroboFrequency(ActionEvent event) {
        try {
            this.mContext.mLayoutPresenterUnits.onChangeFlashModeStrobo(this.mElinchromDevice, this.mStroboDuration.getText(), this.mChoiceStroboFrequency.getSelectionModel().getSelectedIndex());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangeFlashMain(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            this.showFlashMain((int)Math.round(newValue.doubleValue() * 10.0));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangeHeadA(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            this.showFlashA((int)Math.round(newValue.doubleValue() * 10.0));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangeHeadB(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            this.showFlashB((int)Math.round(newValue.doubleValue() * 10.0));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangeLampA(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            this.showLampA((int)Math.round(newValue.doubleValue() * 10.0));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangeLampB(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            this.showLampB((int)Math.round(newValue.doubleValue() * 10.0));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void show(Node node, boolean isVisible) {
        node.setVisible(isVisible);
        node.setManaged(isVisible);
    }

    public void showFlashA(int flashAPower) {
        FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.checkPowerBoundsHeadA(new int[]{flashPowerValues[0], flashAPower, flashPowerValues[2]});
        this.mHeadAElStop.setText("" + (float)checkedFlashPower[1] / 10.0f);
    }

    public void showFlashB(int flashBPower) {
        FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.checkPowerBoundsHeadB(new int[]{flashPowerValues[0], flashPowerValues[1], flashBPower});
        this.mHeadBElStop.setText("" + (float)checkedFlashPower[2] / 10.0f);
    }

    public void showFlashMain(int flashMainPower) {
        FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.getClippedFlashPowerValues(new int[]{flashMainPower, flashPowerValues[1], flashPowerValues[2]});
        this.mFlashMainElStop.setText("" + (float)checkedFlashPower[0] / 10.0f);
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[1] == 1) {
            this.mHeadAElStop.setText("" + (float)checkedFlashPower[1] / 10.0f);
            this.mHeadBElStop.setText("" + (float)checkedFlashPower[2] / 10.0f);
        }
        if (componentLighting.getLamp_mode_mode() == 2) {
            byte[] checkedLampPower = componentLighting.getClippedLampPowerValuesFromFlashPowerValues(new int[]{checkedFlashPower[0], checkedFlashPower[1], checkedFlashPower[2]});
            if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0) {
                this.mLampAElStop.setText("" + (float)checkedLampPower[0] / 10.0f);
            } else if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 1) {
                this.mLampAElStop.setText("" + (float)checkedLampPower[0] / 10.0f);
                this.mLampBElStop.setText("" + (float)checkedLampPower[1] / 10.0f);
            }
        }
    }

    public void showLampA(int lampAPower) {
        if (this.mLampAElStop != null) {
            byte[] checkedLampAPowerValues = this.mElinchromDevice.mComponentLighting.getCheckedLampPowerValuesA(lampAPower);
            this.mLampAElStop.setText("" + (float)checkedLampAPowerValues[0] / 10.0f);
        }
    }

    public void showLampB(int lampAPower) {
        if (this.mLampBElStop != null) {
            byte[] checkedLampPowerValues = this.mElinchromDevice.mComponentLighting.getCheckedLampPowerValuesB(lampAPower);
            this.mLampBElStop.setText("" + (float)checkedLampPowerValues[1] / 10.0f);
        }
    }

    public void showTabDashboard() {
        this.tabStore();
        this.displayTabDashboard();
    }

    public void showTabInfo() {
        this.tabStore();
        this.displayTabInfo();
    }

    public void showTabSettings() {
        this.tabStore();
        this.displayTabSettings();
    }

    public void tabRestore() {
        switch (this.mTabStored) {
            case 1: {
                this.displayTabSettings();
                break;
            }
            case 2: {
                this.displayTabInfo();
                break;
            }
            default: {
                this.displayTabDashboard();
            }
        }
    }

    public void tabStore() {
        this.mTabStored = this.mViewDashboard.isVisible() ? 0 : (this.mViewSettings.isVisible() ? 1 : 2);
    }
}

