/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnit;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.MouseEvent;

public class LayoutViewUnitCategoryContinuousLight
extends LayoutViewUnit {
    public LayoutViewUnitCategoryContinuousLight(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
    }

    @Override
    public void displayFlashPower(byte[] flashPowerValues) {
    }

    @Override
    public void displayHeadOn(int headOn, int headPlugged) {
    }

    @Override
    public void displayInteractionStatus(boolean isStandbyOn, int headOn) {
    }

    @Override
    public void displayLampPower(byte[] lampPowerValues) {
        if (!this.mIsSliding) {
            FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
            float lampAMin = (float)componentLighting.getMin_lamp_power() * 100.0f;
            float lampAMax = (float)componentLighting.getMax_lamp_power() * 100.0f;
            float lampAValue = (float)lampPowerValues[0] * 100.0f;
            this.mFlashMainMin.setText("" + (int)lampAMin);
            this.mFlashMainMax.setText("" + (int)lampAMax);
            this.mFlashMainElStop.setText("" + (int)lampAValue);
            this.mFlashMainSlider.setMin(lampAMin);
            this.mFlashMainSlider.setMax(lampAMax);
            this.mFlashMainSlider.setValue(Math.max(lampAMin, Math.min(lampAValue, lampAMax)));
            this.mFlashMainWs.setText(this.mContext.mUtil.valueToPercentString(lampAValue, lampAMax));
        }
    }

    @Override
    public void onMouseReleasedFlashMain(MouseEvent event) {
        this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, (int)Math.round(this.mFlashMainSlider.getValue()));
        this.mIsSliding = false;
    }

    @Override
    public void onTouchFlashMainMinus(MouseEvent event) {
        this.mContext.mLayoutPresenterUnits.onChangeLampPowerIncrement(this.mElinchromDevice, -1);
    }

    @Override
    public void onTouchFlashMainPlus(MouseEvent event) {
        this.mContext.mLayoutPresenterUnits.onChangeLampPowerIncrement(this.mElinchromDevice, 1);
    }

    @Override
    public void onValueChangeFlashMain(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        FlashDevice componentLighting = this.mElinchromDevice.mComponentLighting;
        int lampAValue = (int)Math.round((Double)newValue / 100.0) * 100;
        int lampAMax = componentLighting.getMax_lamp_power() * 100;
        this.mFlashMainElStop.setText("" + lampAValue);
        this.mFlashMainWs.setText(this.mContext.mUtil.valueToPercentString(lampAValue, lampAMax));
    }
}

