/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutViewUnit;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.LayoutWidgetSlider;
import com.elinchrom.software.LayoutWidgetToggleGroup;
import com.elinchrom.software.SortedDeviceItem;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;

public class LayoutViewUnits
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public int mSoundButtonState = 1;
    public int mLampModeButtonState = 1;
    public int mStandbyButtonState = 0;
    public GridPane mFlashUnitsView = null;
    public ScrollPane mFlashUnitsScrollView = null;
    public GridPane mBottomLeftPane = null;
    public GridPane mBottomRightPane = null;
    public Node mGroupActive = null;
    public float mDragX = 0.0f;
    public float mDragY = 0.0f;
    public int mDragState = 0;
    public boolean mIsIndented = false;
    public boolean mIsDragging = false;
    public boolean mIsSlidingFlashPower = false;
    public boolean mIsSlidingLampPower = false;
    public LayoutWidgetIcon mIconRefresh = null;
    public LayoutWidgetIcon mIconToggleAutoRefresh = null;
    public LayoutWidgetIcon mIconSave = null;
    public LayoutWidgetIcon mIconStandby = null;
    public LayoutWidgetIcon mIconSound = null;
    public LayoutWidgetIcon mIconTrigger = null;
    public LayoutWidgetIcon mIconPowerMinus = null;
    public LayoutWidgetIcon mIconPowerPlus = null;
    public LayoutWidgetIcon mIconLampMinus = null;
    public LayoutWidgetIcon mIconLampPlus = null;
    public LayoutWidgetToggleGroup mLampMode = null;
    public LayoutWidgetSlider mFlashPowerSlider = null;
    public LayoutWidgetSlider mLampPowerSlider = null;
    public LayoutWidgetIcon mButtonGroup = null;

    public LayoutViewUnits(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    protected void displayRefreshMode(byte refreshMode) {
        this.mIconToggleAutoRefresh.setIndex(refreshMode == 1 ? 1 : 0);
        this.mIconRefresh.setIndex(refreshMode == 1 ? 0 : 1);
        this.mIconRefresh.setEnabled(refreshMode == 0);
    }

    protected void displayTitle(String title) {
        if (this.mButtonGroup != null) {
            this.mButtonGroup.setText(title);
        }
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            int flashUnitsHeight = Math.max(417, this.mContext.mRowsCount * (this.mContext.mRowHeight + 14) - 14);
            this.mFlashUnitsView.setMinHeight((double)flashUnitsHeight);
            this.mFlashUnitsView.setPrefHeight((double)flashUnitsHeight);
            this.mFlashUnitsView.setMaxHeight((double)flashUnitsHeight);
            this.setMinHeight(flashUnitsHeight + 169);
            this.setPrefHeight(flashUnitsHeight + 169);
            this.setMaxHeight(flashUnitsHeight + 169);
            this.mFlashUnitsScrollView.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mFlashUnitsScrollView, this.mFlashUnitsView});
            this.getChildren().add((Object)this.mFlashUnitsView);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.mFlashUnitsView.setMinHeight(-1.0);
            this.mFlashUnitsView.setPrefHeight(-1.0);
            this.mFlashUnitsView.setMaxHeight(-1.0);
            this.setMinHeight(-1.0);
            this.setPrefHeight(-1.0);
            this.setMaxHeight(-1.0);
            this.getChildren().removeAll((Object[])new Node[]{this.mFlashUnitsScrollView, this.mFlashUnitsView});
            this.mFlashUnitsScrollView.setContent((Node)this.mFlashUnitsView);
            this.getChildren().add((Object)this.mFlashUnitsScrollView);
        }
    }

    @Override
    public void init() {
        int toolHeight = this.mContext.mUtil.isWindows() ? 50 : 44;
        int controlHeight = this.mContext.mUtil.isWindows() ? 50 : 50;
        int gapHeight = this.mContext.mUtil.isWindows() ? 8 : 0;
        ColumnConstraints column100 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        column100.setPercentWidth(100.0);
        RowConstraints row100 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row100.setPercentHeight(100.0);
        this.mFlashUnitsView = new GridPane();
        this.mFlashUnitsView.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mFlashUnitsView.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        this.mFlashUnitsView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        GridPane.setConstraints((Node)this.mFlashUnitsView, (int)0, (int)1, (int)2, (int)1);
        GridPane.setFillHeight((Node)this.mFlashUnitsView, (Boolean)true);
        GridPane.setFillWidth((Node)this.mFlashUnitsView, (Boolean)true);
        ColumnConstraints column0 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        column0.setPercentWidth(25.0);
        ColumnConstraints column1 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        column1.setPercentWidth(25.0);
        ColumnConstraints column2 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        column2.setPercentWidth(25.0);
        ColumnConstraints column3 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        column3.setPercentWidth(25.0);
        RowConstraints row0 = new RowConstraints((double)gapHeight, (double)gapHeight, (double)gapHeight, Priority.NEVER, VPos.CENTER, false);
        RowConstraints row1 = new RowConstraints((double)controlHeight, (double)controlHeight, (double)controlHeight, Priority.NEVER, VPos.CENTER, false);
        RowConstraints row2 = new RowConstraints((double)controlHeight, (double)controlHeight, (double)controlHeight, Priority.NEVER, VPos.CENTER, false);
        this.mBottomLeftPane = new GridPane();
        GridPane.setConstraints((Node)this.mBottomLeftPane, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 75.0, 0.0, 100.0));
        GridPane.setFillWidth((Node)this.mBottomLeftPane, (Boolean)true);
        List<String> imageTrigger = Arrays.asList("night_icon_trigger.svg");
        this.mIconTrigger = this.mContext.mUtil.factoryIconSet(28, 28, imageTrigger, 0);
        this.mIconTrigger.setOnMousePressed(this::onTouchTrigger);
        GridPane.setConstraints((Node)this.mIconTrigger, (int)1, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER);
        List<String> imageMinus = Arrays.asList("night_arrow_left_activated.svg");
        this.mIconPowerMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageMinus, 0);
        this.mIconPowerMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchFlashPowerMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchFlashPowerMinus));
        GridPane.setConstraints((Node)this.mIconPowerMinus, (int)1, (int)1);
        List<String> imagePlus = Arrays.asList("night_arrow_right_activated.svg");
        this.mIconPowerPlus = this.mContext.mUtil.factoryIconSet(22, 22, imagePlus, 0);
        this.mIconPowerPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchFlashPowerPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchFlashPowerPlus));
        GridPane.setConstraints((Node)this.mIconPowerPlus, (int)2, (int)1);
        List<String> imageStandby = Arrays.asList("night_icon_standby_enabled.svg", "night_icon_standby_activated.svg");
        this.mIconStandby = this.mContext.mUtil.factoryIconSet(22, 22, imageStandby, 0);
        this.mIconStandby.setOnMouseClicked(this::onTouchStandby);
        GridPane.setConstraints((Node)this.mIconStandby, (int)0, (int)1);
        List<String> imageSound = Arrays.asList("night_icon_sound_enabled.svg", "night_icon_sound_activated.svg");
        this.mIconSound = this.mContext.mUtil.factoryIconSet(22, 22, imageSound, 1);
        this.mIconSound.setOnMouseClicked(this::onTouchSound);
        GridPane.setConstraints((Node)this.mIconSound, (int)3, (int)1);
        this.mFlashPowerSlider = new LayoutWidgetSlider(this.mContext, 0.1, 7.5, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeFlashPower));
        this.mFlashPowerSlider.setOnMousePressed(this::onMousePressedFlash);
        this.mFlashPowerSlider.setOnMouseReleased(this::onMouseReleasedFlash);
        GridPane.setConstraints((Node)this.mFlashPowerSlider, (int)0, (int)2, (int)4, (int)1);
        GridPane.setFillWidth((Node)this.mFlashPowerSlider, (Boolean)true);
        this.mBottomLeftPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0, column1, column2, column3});
        this.mBottomLeftPane.getRowConstraints().addAll((Object[])new RowConstraints[]{row0, row1, row2});
        this.mBottomLeftPane.getChildren().addAll((Object[])new Node[]{this.mIconTrigger, this.mIconPowerMinus, this.mIconPowerPlus, this.mIconStandby, this.mIconSound, this.mFlashPowerSlider});
        ColumnConstraints col0 = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, true);
        ColumnConstraints col1 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints col2 = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, true);
        this.mBottomRightPane = new GridPane();
        GridPane.setConstraints((Node)this.mBottomRightPane, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 100.0, 0.0, 75.0));
        GridPane.setFillWidth((Node)this.mBottomRightPane, (Boolean)true);
        this.mIconLampMinus = this.mContext.mUtil.factoryIconSet(22, 22, imageMinus, 0);
        this.mIconLampMinus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampPowerMinus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampPowerMinus));
        HBox boxButtonMinus = new HBox(0.0);
        boxButtonMinus.setAlignment(Pos.CENTER);
        boxButtonMinus.getChildren().add((Object)this.mIconLampMinus);
        GridPane.setConstraints((Node)boxButtonMinus, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 20.0, 0.0, 30.0));
        this.mLampMode = new LayoutWidgetToggleGroup(this.mContext, 190, 26, "Off", "Prop", "Free", (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeOff), (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeProp), (EventHandler<? super MouseEvent>)((EventHandler)this::onTouchLampModeFree));
        GridPane.setConstraints((Node)this.mLampMode, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mIconLampPlus = this.mContext.mUtil.factoryIconSet(22, 22, imagePlus, 0);
        this.mIconLampPlus.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchLampPowerPlus), (EventHandler<MouseEvent>)((EventHandler)this::onLongTouchLampPowerPlus));
        HBox boxButtonPlus = new HBox(0.0);
        boxButtonPlus.setAlignment(Pos.CENTER);
        boxButtonPlus.getChildren().add((Object)this.mIconLampPlus);
        GridPane.setConstraints((Node)boxButtonPlus, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 30.0, 0.0, 20.0));
        this.mLampPowerSlider = new LayoutWidgetSlider(this.mContext, 0.1, 7.5, (ChangeListener<? super Number>)((ChangeListener)this::onValueChangeLampPower));
        this.mLampPowerSlider.setOnMousePressed(this::onMousePressedLamp);
        this.mLampPowerSlider.setOnMouseReleased(this::onMouseReleasedLamp);
        GridPane.setConstraints((Node)this.mLampPowerSlider, (int)0, (int)2, (int)3, (int)1);
        GridPane.setFillWidth((Node)this.mLampPowerSlider, (Boolean)true);
        this.mBottomRightPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col0, col1, col2});
        this.mBottomRightPane.getRowConstraints().addAll((Object[])new RowConstraints[]{row0, row1, row2});
        this.mBottomRightPane.getChildren().addAll((Object[])new Node[]{this.mLampMode, boxButtonMinus, boxButtonPlus, this.mLampPowerSlider});
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints((double)toolHeight, (double)toolHeight, (double)toolHeight, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowMiddle = new RowConstraints(0.0, 0.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
        RowConstraints rowBottom = new RowConstraints((double)(2 * controlHeight + gapHeight), (double)(2 * controlHeight + gapHeight), (double)(2 * controlHeight + gapHeight), Priority.NEVER, VPos.BOTTOM, false);
        this.mButtonGroup = new LayoutWidgetIcon(this.mContext, 47.0, "", this.mContext.mFontSemibold, 14.0, this.mContext.mNightGraphicsColor);
        GridPane.setConstraints((Node)this.mButtonGroup, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        List<String> imageSave = Arrays.asList("night_save_big_activated.svg");
        this.mIconSave = this.mContext.mUtil.factoryIconSet(22, 22, imageSave, 0);
        this.mIconSave.setOnMouseClicked(this::onTouchSave);
        GridPane.setConstraints((Node)this.mIconSave, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 153.0, 0.0, 0.0));
        List<String> imageAutoRefresh = Arrays.asList("night_icon_auto_refresh_enabled.svg", "night_icon_auto_refresh_activated.svg");
        this.mIconToggleAutoRefresh = this.mContext.mUtil.factoryIconSet(26, 24, imageAutoRefresh, 0);
        this.mIconToggleAutoRefresh.setOnMouseClicked(this::onTouchToggleAutoRefresh);
        GridPane.setConstraints((Node)this.mIconToggleAutoRefresh, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 99.0, 0.0, 0.0));
        List<String> imageRefresh = Arrays.asList("night_icon_refresh_disabled.svg", "night_icon_refresh_activated.svg");
        this.mIconRefresh = this.mContext.mUtil.factoryIconSet(22, 22, imageRefresh, 1);
        this.mIconRefresh.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchRefresh));
        GridPane.setConstraints((Node)this.mIconRefresh, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.mFlashUnitsScrollView = new ScrollPane();
        this.mFlashUnitsScrollView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mFlashUnitsScrollView.setContent((Node)this.mFlashUnitsView);
        this.mFlashUnitsScrollView.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.mFlashUnitsScrollView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        GridPane.setConstraints((Node)this.mFlashUnitsScrollView, (int)0, (int)1, (int)2, (int)1);
        GridPane.setFillHeight((Node)this.mFlashUnitsScrollView, (Boolean)true);
        GridPane.setFillWidth((Node)this.mFlashUnitsScrollView, (Boolean)true);
        this.getStyleClass().add((Object)"night-theme");
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowMiddle, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mButtonGroup, this.mIconSave, this.mIconToggleAutoRefresh, this.mIconRefresh, this.mFlashUnitsScrollView, this.mBottomLeftPane, this.mBottomRightPane});
        StackPane.setAlignment((Node)this, (Pos)Pos.TOP_LEFT);
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onFlashPowerIncrement(int increment) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedPower(nothingSelected)) continue;
            this.mContext.mLayoutPresenterUnits.onChangeFlashPower(elinchromDevice, elinchromDevice.mComponentLighting.getFlash_power() + increment);
        }
    }

    public void onLampPowerIncrement(int increment) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedLamp(nothingSelected)) continue;
            this.mContext.mLayoutPresenterUnits.onChangeLampPowerIncrement(elinchromDevice, increment);
        }
    }

    public void onLongTouchFlashPowerMinus(MouseEvent event) {
        this.onFlashPowerIncrement(-10);
    }

    public void onLongTouchFlashPowerPlus(MouseEvent event) {
        this.onFlashPowerIncrement(10);
    }

    public void onLongTouchLampPowerMinus(MouseEvent event) {
        this.onLampPowerIncrement(-10);
    }

    public void onLongTouchLampPowerPlus(MouseEvent event) {
        this.onLampPowerIncrement(10);
    }

    public void onTouchFlashPowerMinus(MouseEvent event) {
        this.onFlashPowerIncrement(-1);
    }

    public void onTouchFlashPowerPlus(MouseEvent event) {
        this.onFlashPowerIncrement(1);
    }

    public void onTouchLampModeFree(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
                for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
                    if (!sortedDeviceItem.getElinchromDevice().mComponentLighting.isSelectedLamp(nothingSelected)) continue;
                    LayoutViewUnit layoutViewUnit = sortedDeviceItem.getElinchromDevice().mComponentLighting.getLayoutViewUnit();
                    layoutViewUnit.displayLampMode(3);
                    sortedDeviceItem.getElinchromDevice().mComponentLighting.setLamp_mode_mode(3);
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampModeOff(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
                for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
                    if (!sortedDeviceItem.getElinchromDevice().mComponentLighting.isSelectedLamp(nothingSelected)) continue;
                    LayoutViewUnit layoutViewUnit = sortedDeviceItem.getElinchromDevice().mComponentLighting.getLayoutViewUnit();
                    layoutViewUnit.displayLampMode(0);
                    sortedDeviceItem.getElinchromDevice().mComponentLighting.setLamp_mode_mode(0);
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampModeProp(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
                for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
                    if (!sortedDeviceItem.getElinchromDevice().mComponentLighting.isSelectedLamp(nothingSelected)) continue;
                    LayoutViewUnit layoutViewUnit = sortedDeviceItem.getElinchromDevice().mComponentLighting.getLayoutViewUnit();
                    layoutViewUnit.displayLampMode(2);
                    sortedDeviceItem.getElinchromDevice().mComponentLighting.setLamp_mode_mode(2);
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLampPowerMinus(MouseEvent event) {
        this.onLampPowerIncrement(-1);
    }

    public void onTouchLampPowerPlus(MouseEvent event) {
        this.onLampPowerIncrement(1);
    }

    public void onTouchRefresh(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterUnits.onRefresh();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSave(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterUnits.onSave();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchToggleAutoRefresh(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterUnits.onToggleAutoRefresh();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchScreen(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.requestFocus();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSound(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mIconSound.setIndex(this.mIconSound.getIndex() == 0 ? 1 : 0);
                boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
                for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
                    if (!sortedDeviceItem.getElinchromDevice().mComponentLighting.isSelected(nothingSelected)) continue;
                    sortedDeviceItem.getElinchromDevice().mComponentLighting.setAudio_mode((byte)this.mIconSound.getIndex());
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchStandby(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mIconStandby.setIndex(this.mIconStandby.getIndex() == 0 ? 1 : 0);
                boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
                for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
                    if (sortedDeviceItem.getElinchromDevice().mComponentLighting.mFeatureList[6] != 1 || !sortedDeviceItem.getElinchromDevice().mComponentLighting.isSelected(nothingSelected)) continue;
                    sortedDeviceItem.getElinchromDevice().mComponentLighting.setUnit_standby(this.mIconStandby.getIndex() != 0);
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTrigger(MouseEvent event) {
        try {
            this.mContext.mModuleManagerSdk.trigger(this.mContext.mGroupTriggerTarget, 0);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onSelectionChange() {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        if (!this.mIsSlidingFlashPower) {
            float minFlashPower = 0.0f;
            float maxFlashPower = 0.0f;
            for (ElinchromDevice flashDevice : this.mContext.mLightingDevices) {
                if (!flashDevice.mComponentLighting.isSelectedPower(nothingSelected)) continue;
                float minusFlashPower = flashDevice.mComponentLighting.getFlash_power() - flashDevice.mComponentLighting.getMinFlashPowerMain();
                minFlashPower = Math.min(-minusFlashPower / 10.0f, minFlashPower);
                float plusFlashPower = flashDevice.mComponentLighting.getMaxFlashPowerMain() - flashDevice.mComponentLighting.getFlash_power();
                maxFlashPower = Math.max(plusFlashPower / 10.0f, maxFlashPower);
            }
            this.mFlashPowerSlider.setValue(0.0);
            if (this.mFlashPowerSlider.getMin() != (double)minFlashPower) {
                this.mFlashPowerSlider.setMin(minFlashPower == maxFlashPower ? (double)(minFlashPower - 0.1f) : (double)minFlashPower);
            }
            if (this.mFlashPowerSlider.getMax() != (double)maxFlashPower) {
                this.mFlashPowerSlider.setMax(minFlashPower == maxFlashPower ? (double)(maxFlashPower + 0.1f) : (double)maxFlashPower);
            }
        }
        if (!this.mIsSlidingLampPower) {
            float minLampPower = 0.0f;
            float maxLampPower = 0.0f;
            for (ElinchromDevice flashDevice : this.mContext.mLightingDevices) {
                if (!flashDevice.mComponentLighting.isSelectedLamp(nothingSelected)) continue;
                minLampPower = Math.min((float)(-flashDevice.mComponentLighting.getLampPowerMinusA()) / 10.0f, minLampPower);
                maxLampPower = Math.max((float)flashDevice.mComponentLighting.getLampPowerPlusA() / 10.0f, maxLampPower);
                minLampPower = Math.min((float)(-flashDevice.mComponentLighting.getLampPowerMinusB()) / 10.0f, minLampPower);
                maxLampPower = Math.max((float)flashDevice.mComponentLighting.getLampPowerPlusB() / 10.0f, maxLampPower);
            }
            this.mLampPowerSlider.setValue(0.0);
            if (this.mLampPowerSlider.getMin() != (double)minLampPower) {
                this.mLampPowerSlider.setMin(minLampPower == maxLampPower ? (double)(minLampPower - 0.1f) : (double)minLampPower);
            }
            if (this.mLampPowerSlider.getMax() != (double)maxLampPower) {
                this.mLampPowerSlider.setMax(minLampPower == maxLampPower ? (double)(maxLampPower + 0.1f) : (double)maxLampPower);
            }
        }
    }

    public void onMousePressedFlash(MouseEvent event) {
        this.mIsSlidingFlashPower = true;
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedPower(nothingSelected)) continue;
            elinchromDevice.mComponentLighting.getLayoutViewUnit().showTabDashboard();
        }
    }

    public void onMousePressedLamp(MouseEvent event) {
        this.mIsSlidingLampPower = true;
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedLamp(nothingSelected)) continue;
            elinchromDevice.mComponentLighting.getLayoutViewUnit().showTabDashboard();
        }
    }

    public void onMouseReleasedFlash(MouseEvent event) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedPower(nothingSelected)) continue;
            this.mContext.mLayoutPresenterUnits.onChangeFlashPower(elinchromDevice, elinchromDevice.mComponentLighting.getFlash_power() + (int)Math.round(this.mFlashPowerSlider.getValue() * 10.0));
            elinchromDevice.mComponentLighting.getLayoutViewUnit().tabRestore();
        }
        this.mIsSlidingFlashPower = false;
    }

    public void onMouseReleasedLamp(MouseEvent event) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedLamp(nothingSelected)) continue;
            this.mContext.mLayoutPresenterUnits.onChangeLampPowerIncrement(elinchromDevice, (int)Math.round(this.mLampPowerSlider.getValue() * 10.0));
            elinchromDevice.mComponentLighting.getLayoutViewUnit().tabRestore();
        }
        this.mIsSlidingLampPower = false;
    }

    public void onValueChangeFlashPower(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedPower(nothingSelected)) continue;
            elinchromDevice.mComponentLighting.getLayoutViewUnit().showFlashMain(elinchromDevice.mComponentLighting.getFlash_power() + Math.round(newValue.floatValue() * 10.0f));
        }
    }

    public void onValueChangeLampPower(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        boolean nothingSelected = this.mContext.mUtil.isNothingSelected();
        for (ElinchromDevice elinchromDevice : this.mContext.mLightingDevices) {
            if (!elinchromDevice.mComponentLighting.isSelectedLamp(nothingSelected)) continue;
            elinchromDevice.mComponentLighting.getLayoutViewUnit().showLampA(elinchromDevice.mComponentLighting.getLampPowerValuesFStop()[0] + Math.round(newValue.floatValue() * 10.0f));
            elinchromDevice.mComponentLighting.getLayoutViewUnit().showLampB(elinchromDevice.mComponentLighting.getLampPowerValuesFStop()[1] + Math.round(newValue.floatValue() * 10.0f));
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

