/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class LayoutWidgetProgressBar
extends Pane {
    public Context mContext;
    public Pane mProgressBar = null;
    public Parent mMaskMiddle = null;
    public float mMaximum = 0.0f;
    public int mProgressPixels = 0;
    public int mWidth = 0;

    public LayoutWidgetProgressBar(Context context, float progress, float maximum, int width, int height, String barColor) {
        this.mContext = context;
        this.mMaximum = maximum;
        this.mProgressPixels = 4;
        this.mWidth = width;
        this.setMinSize(width, height);
        this.setMaxSize(width, height);
        this.setPrefSize(width, height);
        this.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
        this.mProgressBar = new Pane();
        this.mProgressBar.setMinHeight((double)height);
        this.mProgressBar.setMaxHeight((double)height);
        this.mProgressBar.setPrefHeight((double)height);
        this.mProgressBar.setMinWidth(4.0);
        this.mProgressBar.setMaxWidth((double)width);
        this.mProgressBar.setStyle("-fx-background-color:#" + barColor + ";");
        this.getChildren().add((Object)this.mProgressBar);
        this.getChildren().add((Object)this.mContext.mUtil.loadImageNode("night_mask_progress_bar_left.svg"));
        this.mMaskMiddle = this.mContext.mUtil.loadImageNode("night_mask_progress_bar_middle.svg");
        this.getChildren().add((Object)this.mMaskMiddle);
        Parent maskRight = this.mContext.mUtil.loadImageNode("night_mask_progress_bar_right.svg");
        maskRight.setTranslateX((double)(this.mWidth - 2));
        this.getChildren().add((Object)maskRight);
        this.setProgress(progress);
    }

    public float getProgress() {
        return (float)this.mProgressPixels / (float)this.mWidth;
    }

    public float getProgressPercent() {
        return (float)this.mProgressPixels / (float)this.mWidth * 100.0f;
    }

    public void increment(float increment) {
        this.mProgressPixels = Math.max(4, Math.min(this.mProgressPixels + Math.round(increment / this.mMaximum * (float)this.mWidth), this.mWidth));
        this.mProgressBar.setPrefWidth((double)this.mProgressPixels);
        this.mMaskMiddle.setTranslateX((double)(this.mProgressPixels - 2));
    }

    public void setMaximum(float maximum) {
        this.mMaximum = maximum;
        this.setProgress(this.getProgress() * this.mMaximum);
    }

    public void setProgress(float progress) {
        this.mProgressPixels = Math.max(4, Math.min(Math.round(progress / this.mMaximum * (float)this.mWidth), this.mWidth));
        this.mProgressBar.setPrefWidth((double)this.mProgressPixels);
        this.mMaskMiddle.setTranslateX((double)(this.mProgressPixels - 2));
    }
}

