/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;

public class LayoutWidgetSlider
extends Slider {
    public Context mContext;
    public ChangeListener<? super Number> mListener;

    public LayoutWidgetSlider(Context context, double minValue, double maxValue) {
        super(minValue, maxValue, minValue);
        this.mContext = context;
        this.setShowTickMarks(false);
        this.setShowTickLabels(false);
        this.setBlockIncrement(1.0);
        this.minProperty().addListener(this::refresh);
        this.maxProperty().addListener(this::refresh);
        this.valueProperty().addListener(this::refresh);
    }

    public LayoutWidgetSlider(Context context, double minValue, double maxValue, ChangeListener<? super Number> listener) {
        super(minValue, maxValue, minValue);
        this.mContext = context;
        this.mListener = listener;
        this.setShowTickMarks(false);
        this.setShowTickLabels(false);
        this.setBlockIncrement(1.0);
        this.minProperty().addListener(this::refresh);
        this.maxProperty().addListener(this::refresh);
        this.valueProperty().addListener(this::refreshWithListener);
    }

    void refresh(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            String percent = String.format("%1$.1f", (this.getValue() - this.getMin()) / (this.getMax() - this.getMin()) * 100.0);
            this.setStyle("-track-color: linear-gradient(to right, -activated-color 0%, -activated-color  " + percent + "%, -border-color " + percent + "%, -border-color 100%);");
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    void refreshWithListener(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        try {
            String percent = String.format("%1$.1f", (newValue.doubleValue() - this.getMin()) / (this.getMax() - this.getMin()) * 100.0);
            this.setStyle("-track-color: linear-gradient(to right, -activated-color 0%, -activated-color  " + percent + "%, -border-color " + percent + "%, -border-color 100%);");
            this.mListener.changed(observable, (Object)oldValue, (Object)newValue);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }
}

