/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import javafx.scene.layout.Pane;

public class LayoutWidgetSwitch
extends Pane {
    public Context mContext;
    public String mInsetVerticalString = null;
    public String mInsetHorizontalString = null;
    public String mRadiusTrackString = null;
    public String mRadiusThumbString = null;
    boolean mIsActivated = false;
    boolean mIsEnabled = false;

    public LayoutWidgetSwitch(Context context, double width, double height) {
        this.mContext = context;
        double trackHeight = 0.6666666666666666 * (height - 1.0);
        double insetVertical = (height - trackHeight) / 2.0;
        double insetHorizontal = width - height;
        double radiusTrack = trackHeight / 2.0;
        double radiusThumb = height / 2.0;
        this.mInsetVerticalString = String.format("%1$.1f", insetVertical);
        this.mInsetHorizontalString = String.format("%1$.1f", insetHorizontal);
        this.mRadiusTrackString = String.format("%1$.1f", radiusTrack);
        this.mRadiusThumbString = String.format("%1$.1f", radiusThumb);
        this.setPrefSize(width, height);
        this.getStyleClass().add((Object)"control-switch");
        this.setStyle("-fx-background-insets: " + this.mInsetVerticalString + "px 1px " + this.mInsetVerticalString + "px 1px, 0px " + this.mInsetHorizontalString + "px 0px 0px;-fx-background-radius: " + this.mRadiusTrackString + "px, " + this.mRadiusThumbString + "px;");
    }

    public boolean onSwitch() {
        this.setActivated(!this.mIsActivated);
        return this.mIsActivated;
    }

    public boolean isActivated() {
        return this.mIsActivated;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setActivated(boolean isActivated) {
        this.mIsActivated = isActivated;
        this.getStyleClass().remove((Object)"activated");
        if (this.mIsActivated) {
            this.getStyleClass().add((Object)"activated");
            this.setStyle("-fx-background-insets: " + this.mInsetVerticalString + "px 1px " + this.mInsetVerticalString + "px 1px, 0px 0px 0px " + this.mInsetHorizontalString + "px;-fx-background-radius: " + this.mRadiusTrackString + "px, " + this.mRadiusThumbString + "px;");
        } else {
            this.setStyle("-fx-background-insets: " + this.mInsetVerticalString + "px 1px " + this.mInsetVerticalString + "px 1px, 0px " + this.mInsetHorizontalString + "px 0px 0px;-fx-background-radius: " + this.mRadiusTrackString + "px, " + this.mRadiusThumbString + "px;");
        }
    }

    public void setEnabled(boolean isEnabled) {
        this.mIsEnabled = isEnabled;
        this.getStyleClass().remove((Object)"disabled");
        if (!this.mIsEnabled) {
            this.getStyleClass().add((Object)"disabled");
        }
    }
}

