/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Constants;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;

public class ModuleManagerSdk {
    public Context mContext;
    protected long mElContextSdk = 0L;

    public ModuleManagerSdk(Context context) {
        this.mContext = context;
    }

    public void addProduct(int productId, int fieldIndex, int dataSize, byte[] data, int version) {
        this.mContext.mModuleManagerApp.ElModuleManagerSdkAddProduct(this.mElContextSdk, productId, fieldIndex, dataSize, data, version);
    }

    public void executeCoreTask(int taskIndex, int taskState, long arg, long value, long elinchromDeviceId) {
        this.mContext.mModuleManagerApp.ElModuleManagerSdkExecuteCoreTask(this.mElContextSdk, taskIndex, taskState, arg, value, elinchromDeviceId);
    }

    public void enqueueRxTxTask(int taskIndex, int taskState, long arg, long value, long elinchromDeviceId) {
        this.mContext.mModuleManagerApp.ElModuleManagerSdkEnqueueRxTxTask(this.mElContextSdk, taskIndex, taskState, arg, value, elinchromDeviceId);
    }

    public int factory() {
        int result = 1;
        long elContextSdk = this.mContext.mModuleManagerApp.factoryElContextSdk();
        if (elContextSdk != 0L) {
            this.mElContextSdk = elContextSdk;
            result = 0;
        }
        return result;
    }

    public int freeContextSdk() {
        return this.mContext.mModuleManagerApp.freeElContextSdk(this.mElContextSdk);
    }

    public int read(ElinchromDevice elinchromDevice, int cmdIndex, int size, byte[] data) {
        return this.mContext.mModuleManagerApp.ElinchromDeviceSdkCommandRead(elinchromDevice.mDeviceSdk, cmdIndex, size, data);
    }

    public int send(ElinchromDevice elinchromDevice, int cmdIndex, int size, byte[] data) {
        return this.mContext.mModuleManagerApp.ElinchromDeviceSdkCommandSend(elinchromDevice.mDeviceSdk, cmdIndex, size, data);
    }

    public byte[] valueGet(int dataIndex) {
        int size = Constants.SIZE_DEVICE_INDEX[dataIndex];
        byte[] data = new byte[size];
        this.mContext.mModuleManagerApp.ElModuleManagerSdkValueGet(this.mElContextSdk, dataIndex, size, data);
        return data;
    }

    public byte valueGetByte(int dataIndex) {
        return this.valueGet(dataIndex)[0];
    }

    public byte[] valueGet(ElinchromDevice elinchromDevice, int dataIndex) {
        int size = Constants.SIZE_DEVICE_INDEX[dataIndex];
        byte[] data = new byte[size];
        this.mContext.mModuleManagerApp.ElinchromDeviceSdkValueGet(elinchromDevice.mDeviceSdk, dataIndex, size, data);
        return data;
    }

    public byte valueGetByte(ElinchromDevice elinchromDevice, int dataIndex) {
        return this.valueGet(elinchromDevice, dataIndex)[0];
    }

    public long valueGetLong(ElinchromDevice elinchromDevice, int dataIndex) {
        byte[] value = this.valueGet(elinchromDevice, dataIndex);
        return (long)(value[0] & 0xFF) << 0 | (long)(value[1] & 0xFF) << 8 | (long)(value[2] & 0xFF) << 16 | (long)(value[3] & 0xFF) << 24 | (long)(value[4] & 0xFF) << 32 | (long)(value[5] & 0xFF) << 40 | (long)(value[6] & 0xFF) << 48 | (long)(value[7] & 0xFF) << 56;
    }

    public int valueSet(int dataIndex, byte[] data) {
        return this.mContext.mModuleManagerApp.ElModuleManagerSdkValueSet(this.mElContextSdk, dataIndex, data.length, data);
    }

    public int valueSetByte(int dataIndex, byte data) {
        return this.valueSet(dataIndex, new byte[]{data});
    }

    public int valueSet(ElinchromDevice elinchromDevice, int dataIndex, byte[] data) {
        return this.mContext.mModuleManagerApp.ElinchromDeviceSdkValueSet(elinchromDevice.mDeviceSdk, dataIndex, data.length, data);
    }

    public int valueSetByte(ElinchromDevice elinchromDevice, int dataIndex, byte data) {
        return this.valueSet(elinchromDevice, dataIndex, new byte[]{data});
    }

    public void trigger(ElinchromDevice elinchromDevice) {
        this.mContext.mModuleManagerApp.ElModuleManagerSdkTriggerUnit(this.mElContextSdk, elinchromDevice.mDeviceId);
    }

    public void trigger(int group, int command) {
        this.mContext.mModuleManagerApp.ElModuleManagerSdkTrigger(this.mElContextSdk, group, command);
    }

    static {
        try {
            if (System.getProperty("os.name").indexOf("Windows ") == 0) {
                System.loadLibrary("ElinchromSoftwareSdk2.0");
            } else {
                System.load(System.getProperty("user.dir") + "/libElinchromSoftwareSdk2.0.dylib");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

