/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.OnTouchSideMenuListener;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Duration;

public class OnTouchSideMenuListenerGroup
extends OnTouchSideMenuListener {
    public TranslateTransition mTranslateTransition = null;
    public LayoutWidgetIcon mLocalIcon;
    public String mGroupTitle;
    public byte mGroup;
    public int mGroupSelected;
    public int mGroupTriggerTarget;
    public final double mXOrigin = 0.0;
    public final double mXDestination = -14.0;

    public OnTouchSideMenuListenerGroup(Context context, LayoutWidgetIcon layoutWidgetIcon, LayoutPresenter targetPresenter, LayoutWidgetIcon localIcon, String groupTitle, byte group, int groupSelected, int groupTriggerTarget) {
        super(context, layoutWidgetIcon, targetPresenter);
        this.mLocalIcon = localIcon;
        this.mGroupTitle = groupTitle;
        this.mGroup = group;
        this.mGroupSelected = groupSelected;
        this.mGroupTriggerTarget = groupTriggerTarget;
    }

    public void display(FlashDevice flashDevice) {
        this.mContext.mGroupTitle = this.mGroupTitle;
        this.mContext.mGroupSelected = this.mGroupSelected;
        this.mContext.mGroupListener = this;
        this.mContext.mGroupTriggerTarget = this.mGroupTriggerTarget;
        this.mContext.mLayoutPresenterSideMenu.highlight(this.mLayoutWidgetIcon);
        this.mContext.mNavigationManager.attachPresenterToMain(this.mTargetPresenter);
    }

    public void onDragDropped(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag dropped on group " + this.mGroup);
            ElinchromDevice sourceDevice = this.mContext.mElinchromDevices.get(Long.valueOf(dragEvent.getDragboard().getString()));
            if (sourceDevice != null) {
                sourceDevice.mComponentLighting.setGroup(this.mGroup);
                this.mContext.mLayoutPresenterUnits.sortUnits();
                this.mContext.mLayoutPresenterUnits.displayUnits();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragEntered(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag entered group " + this.mGroup);
            this.onGroupRestore();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragExited(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag exited group " + this.mGroup);
            this.onGroupIndent();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onDragOver(DragEvent dragEvent) {
        try {
            this.mContext.mLogger.log("Drag entered group " + this.mGroup);
            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            dragEvent.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onGroupDisable() {
        this.mLocalIcon.getStyleClass().remove((Object)"side-group-rounded");
    }

    public void onGroupEnable() {
        this.mLocalIcon.getStyleClass().remove((Object)"side-group-rounded");
        this.mLocalIcon.getStyleClass().add((Object)"side-group-rounded");
    }

    public void onGroupIndent() {
        this.resetAnimation();
        this.mTranslateTransition = new TranslateTransition(Duration.millis((double)42.0), (Node)this.mLocalIcon);
        this.mTranslateTransition.setFromX(this.mLocalIcon.getTranslateX());
        this.mTranslateTransition.setToX(-14.0);
        this.mTranslateTransition.play();
    }

    public void onGroupRestore() {
        this.resetAnimation();
        this.mTranslateTransition = new TranslateTransition(Duration.millis((double)42.0), (Node)this.mLocalIcon);
        this.mTranslateTransition.setFromX(this.mLocalIcon.getTranslateX());
        this.mTranslateTransition.setToX(0.0);
        this.mTranslateTransition.play();
    }

    @Override
    public void onTouch() {
        this.mContext.mGroupSelected = this.mGroupSelected;
        FlashDevice flashDevice = null;
        this.display(flashDevice);
    }

    public void resetAnimation() {
        if (this.mTranslateTransition != null) {
            this.mTranslateTransition.stop();
        }
    }
}

