/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.OpDispatcher;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.TaskInsert;
import com.elinchrom.software.TaskScan;
import com.elinchrom.software.TaskStatus;
import com.elinchrom.software.TaskTrigger;
import com.elinchrom.software.TaskUnitChanged;

public class OpDispatcherUi
implements OpDispatcher {
    public Context mContext;

    public OpDispatcherUi(Context context) {
        this.mContext = context;
    }

    @Override
    public void dispatch(TaskInit task) {
        switch (task.mTaskState) {
            case 1: {
                this.mContext.mOpHandlerUi.initTaskState1();
                break;
            }
            case 2: {
                this.mContext.mOpHandlerUi.initTaskState2();
                break;
            }
            case 4: {
                this.mContext.mOpHandlerUi.initTaskState4(task);
                break;
            }
            case 5: {
                this.mContext.mOpHandlerUi.initTaskState5(task);
                break;
            }
            case 18: {
                this.mContext.mLogger.log("TASK_INIT_STATE_DETECT_AFTER_FREE");
                this.mContext.mOpHandlerUi.initDetectAfterFree();
                break;
            }
            case 19: {
                this.mContext.mLogger.log("TASK_INIT_STATE_SCAN_AFTER_STOP");
                this.mContext.mLayoutPresenterChannel.onScanUpdateAfterStop();
                break;
            }
            case 20: {
                this.mContext.mLogger.log("TASK_INIT_STATE_CONNECT_AFTER_STOP");
                this.mContext.mOpHandlerUi.initConnectAfterStop();
                break;
            }
            case 30: {
                this.mContext.mLogger.log("TASK_INIT_STATE_SHARING_UI");
                this.mContext.mOpHandlerUi.handleSharingUi(task);
                break;
            }
            default: {
                this.mContext.mLogger.log("WARNING: unknown init state: " + task.mTaskState);
            }
        }
    }

    @Override
    public void dispatch(TaskInsert task) {
        switch (task.mTaskState) {
            case 0: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_DISPLAY_DEVICE");
                this.mContext.mOpHandlerUi.handleInsertNewUnit((int)task.mArg, task.mValue, task.mElinchromDeviceId);
                break;
            }
            case 1: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_HAS_FIRMWARE");
                this.mContext.mOpHandlerUi.insertHasFirmware((int)task.mArg, task.mValue, task.mElinchromDeviceId);
                break;
            }
            case 2: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_HAS_RADIO");
                this.mContext.mOpHandlerUi.insertHasRadio((int)task.mArg, task.mValue, task.mElinchromDeviceId);
                break;
            }
            case 6: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_BAD_DEVICE");
                this.mContext.mOpHandlerUi.handleBadDevice(this.findElinchromDevice(task.mElinchromDeviceId), (int)task.mArg);
                break;
            }
            case 9: {
                this.mContext.mOpHandlerUi.refreshUnit(this.findElinchromDevice(task.mElinchromDeviceId));
                break;
            }
            case 13: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_DISPLAY_BRIDGE");
                this.mContext.mOpHandlerUi.displayBridge((int)task.mArg, task.mElinchromDeviceId, task.mValue);
                break;
            }
            case 14: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_DISPLAY_UPDATABLE");
                break;
            }
            case 17: {
                this.mContext.mLogger.log("TASK_INSERT_STATE_CANNOT_OPEN_TRANSMITTER_PRO");
                this.mContext.mOpHandlerUi.insertCannotOpenTransmitterPro();
                break;
            }
            default: {
                this.mContext.mLogger.log("WARNING: unknown insert state: " + task.mTaskState);
            }
        }
    }

    @Override
    public void dispatch(TaskScan task) {
        switch (task.mTaskState) {
            case 10: {
                this.mContext.mLogger.log("TASK_SCAN_STATE_INIT_RF");
                this.mContext.mOpHandlerUi.scanInitRf(this.findElinchromDevice(task.mElinchromDeviceId));
                break;
            }
            case 16: {
                this.mContext.mLogger.log("TASK_SCAN_STATE_BLE_CLEAN");
                System.gc();
                break;
            }
            default: {
                this.mContext.mLogger.log("WARNING: unknown scan state: " + task.mTaskState);
            }
        }
    }

    @Override
    public void dispatch(TaskStatus task) {
        switch (task.mTaskState) {
            case 6: {
                this.mContext.mLogger.log("TASK_STATUS_STATE_REFRESH");
                this.mContext.mOpHandlerUi.refreshUI(task);
                break;
            }
            case 7: {
                this.mContext.mLogger.log("TASK_STATUS_STATE_UPDATE_FIRMWARE");
                this.mContext.mOpHandlerUi.statusUpdateFirmware(this.findElinchromDevice(task.mElinchromDeviceId), (int)task.mArg, (int)task.mValue);
                break;
            }
            case 8: {
                this.mContext.mLogger.log("TASK_STATUS_STATE_UPDATE_INIT");
                this.mContext.mOpHandlerUi.statusUpdateInit(this.findElinchromDevice(task.mElinchromDeviceId), (int)task.mArg);
                break;
            }
            case 10: {
                this.mContext.mLogger.log("TASK_STATUS_STATE_EXTRACT_FIRMWARE");
                this.mContext.mOpHandlerUi.statusExtractFirmware(this.findElinchromDevice(task.mElinchromDeviceId), (int)task.mArg, (int)task.mValue);
                break;
            }
            case 11: {
                this.mContext.mLogger.log("TASK_STATUS_STATE_FIRMWARE_EXTRACTED");
                this.mContext.mOpHandlerUi.statusFirmwareExtracted(this.findElinchromDevice(task.mElinchromDeviceId), (int)task.mArg, (int)task.mValue);
                break;
            }
            default: {
                this.mContext.mLogger.log("WARNING: unknown status state: " + task.mTaskState);
            }
        }
    }

    @Override
    public void dispatch(TaskTrigger task) {
    }

    @Override
    public void dispatch(TaskUnitChanged task) {
        switch (task.mTaskState) {
            case 1: {
                this.mContext.mOpHandlerUi.onUnitChanged(this.findElinchromDevice(task.mElinchromDeviceId), task.mTaskState, (int)task.mArg);
                break;
            }
            case 2: {
                this.mContext.mOpHandlerUi.onUnitChanged(this.findElinchromDevice(task.mElinchromDeviceId), task.mTaskState, (int)task.mArg);
                break;
            }
            case 3: {
                this.mContext.mOpHandlerUi.onUnitChanged(this.findElinchromDevice(task.mElinchromDeviceId), task.mTaskState, (int)task.mArg);
                break;
            }
            case 4: {
                this.mContext.mOpHandlerUi.onUnitChanged(this.findElinchromDevice(task.mElinchromDeviceId), task.mTaskState, (int)task.mArg);
                break;
            }
            default: {
                this.mContext.mLogger.log("WARNING: unknown changed state: " + task.mTaskState);
            }
        }
    }

    public ElinchromDevice findElinchromDevice(long elinchromDeviceId) {
        return this.mContext.mElinchromDevices.get(elinchromDeviceId);
    }
}

