/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileDocumentFirmwareNews;
import com.elinchrom.software.FileDocumentSkyportUnits;
import com.elinchrom.software.FileDocumentSoftwareNews;
import com.elinchrom.software.JsonNewsFirmwareConnectionType;
import com.elinchrom.software.Skyport_Command;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.TaskInsert;
import com.elinchrom.software.TaskStatus;
import com.elinchrom.software.Unit_Prototype_Json;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;

public class OpHandlerCore {
    public static final int DELAY_REFRESH_BATTERY_LEVEL = 30;
    public static final int DELAY_REFRESH_SIGNAL_STRENGTH = 3;
    public Context mContext;
    public Instant mBatteryCheckTime;
    public Instant mSignalCheckTime;

    public OpHandlerCore(Context context) {
        this.mContext = context;
        this.mBatteryCheckTime = Instant.now().minus(Duration.ofSeconds(60L));
        this.mSignalCheckTime = Instant.now().minus(Duration.ofSeconds(6L));
    }

    public void initFileDialog() {
    }

    public void handleRefreshUnit(TaskInsert task) {
        this.mContext.mOpThreadUi.enqueueTask(task);
    }

    public void handleTaskStatus(TaskStatus task) {
        int refreshIndicators = 0;
        this.mContext.mOpThreadUi.enqueueTask(new TaskStatus(this.mContext, 6, refreshIndicators, 0L));
    }

    public void handleSharingCore(TaskInit task) {
        try {
            String jsonString = this.mContext.mFileManager.sendToService(task.mStrings[0]);
            this.mContext.mOpThreadUi.enqueueTask(new TaskInit(this.mContext, 30, new String[]{jsonString}));
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void handleSendToService(TaskInit task) {
        try {
            this.mContext.mFileManager.sendToService(task.mStrings[0]);
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void initTaskState0() {
        FileDocumentSoftwareNews localSoftwareNews;
        FileDocumentSoftwareNews onlineSoftwareNews;
        this.mContext.mIsInternetAvailable = this.mContext.mUtil.isInternetAvailable();
        FileDocumentSoftwareNews validSoftwareNews = null;
        FileDocumentSoftwareNews debugSoftwareNews = new FileDocumentSoftwareNews(this.mContext).fromLocalFolder(this.mContext.mFolderDebug + "software_news.json");
        if (debugSoftwareNews.tryValidate()) {
            validSoftwareNews = debugSoftwareNews;
            validSoftwareNews.swapTo(this.mContext.mFolderConfig + "software_news.json");
        }
        if (validSoftwareNews == null && this.mContext.mIsInternetAvailable && (onlineSoftwareNews = new FileDocumentSoftwareNews(this.mContext).fromUrl("https://services.elinchrom.com/config", "software_news.json")).tryValidate()) {
            validSoftwareNews = onlineSoftwareNews;
            validSoftwareNews.swapTo(this.mContext.mFolderConfig + "software_news.json");
        }
        if (validSoftwareNews == null && (localSoftwareNews = new FileDocumentSoftwareNews(this.mContext).fromLocalFolder(this.mContext.mFolderConfig + "software_news.json")).tryValidate()) {
            validSoftwareNews = localSoftwareNews;
        }
        if (validSoftwareNews == null) {
            validSoftwareNews = new FileDocumentSoftwareNews(this.mContext).fromResources("software_news.json");
            validSoftwareNews.tryValidate();
            validSoftwareNews.swapTo(this.mContext.mFolderConfig + "software_news.json");
        }
        this.use(validSoftwareNews);
        if (this.mContext.mFileDocumentSoftwareNews.shouldDownloadNewSoftware()) {
            this.mContext.mOpThreadUi.enqueueTask(new TaskInit(this.mContext, 1, 0L, 0L));
        } else {
            this.mContext.mOpThreadUi.enqueueTask(new TaskInit(this.mContext, 2, 0L, 0L));
            this.initTaskState3();
        }
    }

    public void initTaskState3() {
        FileDocumentFirmwareNews localFirmwareNews;
        FileDocumentFirmwareNews onlineSkyportUnits;
        FileDocumentSkyportUnits localSkyportUnits;
        FileDocumentSkyportUnits onlineSkyportUnits2;
        FileDocumentSkyportUnits validSkyportUnits = null;
        FileDocumentSkyportUnits debugSkyportUnits = new FileDocumentSkyportUnits(this.mContext).fromLocalFolder(this.mContext.mFolderDebug + "skyport_units_1.0.json");
        if (debugSkyportUnits.tryValidate()) {
            validSkyportUnits = debugSkyportUnits;
            validSkyportUnits.swapTo(this.mContext.mFolderConfig + "skyport_units_1.0.json");
        }
        if (validSkyportUnits == null && this.mContext.mIsInternetAvailable && (onlineSkyportUnits2 = new FileDocumentSkyportUnits(this.mContext).fromUrl("https://services.elinchrom.com/config", "skyport_units_1.0.json")).tryValidate()) {
            validSkyportUnits = onlineSkyportUnits2;
            validSkyportUnits.swapTo(this.mContext.mFolderConfig + "skyport_units_1.0.json");
        }
        if (validSkyportUnits == null && (localSkyportUnits = new FileDocumentSkyportUnits(this.mContext).fromLocalFolder(this.mContext.mFolderConfig + "skyport_units_1.0.json")).tryValidate()) {
            validSkyportUnits = localSkyportUnits;
        }
        if (validSkyportUnits == null) {
            validSkyportUnits = new FileDocumentSkyportUnits(this.mContext).fromResources("skyport_units_1.0.json");
            validSkyportUnits.tryValidate();
            validSkyportUnits.swapTo(this.mContext.mFolderConfig + "skyport_units_1.0.json");
        }
        this.use(validSkyportUnits);
        FileDocumentFirmwareNews validFirmwareNews = null;
        FileDocumentFirmwareNews debugFirmwareNews = new FileDocumentFirmwareNews(this.mContext).fromLocalFolder(this.mContext.mFolderDebug + "firmware_news_1.0.json");
        if (debugFirmwareNews.tryValidate()) {
            validFirmwareNews = debugFirmwareNews;
            validFirmwareNews.swapTo(this.mContext.mFolderConfig + "firmware_news_1.0.json");
        }
        if (validFirmwareNews == null && this.mContext.mIsInternetAvailable && (onlineSkyportUnits = new FileDocumentFirmwareNews(this.mContext).fromUrl("https://services.elinchrom.com/config", "firmware_news_1.0.json")).tryValidate()) {
            validFirmwareNews = onlineSkyportUnits;
            validFirmwareNews.swapTo(this.mContext.mFolderConfig + "firmware_news_1.0.json");
        }
        if (validFirmwareNews == null && (localFirmwareNews = new FileDocumentFirmwareNews(this.mContext).fromLocalFolder(this.mContext.mFolderConfig + "firmware_news_1.0.json")).tryValidate()) {
            validFirmwareNews = localFirmwareNews;
        }
        if (validFirmwareNews == null) {
            validFirmwareNews = new FileDocumentFirmwareNews(this.mContext).fromResources("firmware_news_1.0.json");
            validFirmwareNews.tryValidate();
            validFirmwareNews.swapTo(this.mContext.mFolderConfig + "firmware_news_1.0.json");
        }
        this.use(validFirmwareNews);
        this.mContext.mOpThreadUi.enqueueTask(new TaskInit(this.mContext, 5, 0L, 0L));
        this.mContext.mModuleManagerSdk.valueSetByte(46, this.mContext.mRefreshMode);
        this.mContext.mModuleManagerSdk.executeCoreTask(4, 6, 0L, 0L, 0L);
    }

    public void use(FileDocumentSoftwareNews fileDocumentSoftwareNews) {
        this.mContext.mFileDocumentSoftwareNews = fileDocumentSoftwareNews;
    }

    public void use(FileDocumentSkyportUnits fileDocumentSkyportUnits) {
        this.mContext.mFileDocumentSkyportUnits = fileDocumentSkyportUnits;
        this.mContext.mSkyportCommands = fileDocumentSkyportUnits.mSkyportCommands;
        this.mContext.mUnitPrototypes = fileDocumentSkyportUnits.mUnitPrototypes;
        fileDocumentSkyportUnits.downloadImages();
    }

    public void use(FileDocumentFirmwareNews fileDocumentFirmwareNews) {
        this.mContext.mFileDocumentFirmwareNews = fileDocumentFirmwareNews;
        fileDocumentFirmwareNews.downloadImages();
        for (Map.Entry<String, Skyport_Command> entry : this.mContext.mSkyportCommands.entrySet()) {
            Integer index = this.mContext.mCommandIndexes.get(entry.getKey());
            if (index == null) continue;
            this.mContext.mModuleManagerSdk.valueSetByte(index, entry.getValue().getCmd_id_byte());
        }
        for (Map.Entry<Object, Object> entry : this.mContext.mUnitPrototypes.entrySet()) {
            int updateCount;
            byte[] updateBy;
            int ordinal;
            float version;
            byte[] usbPid = new byte[]{(byte)((((Unit_Prototype_Json)entry.getValue()).USB_PID & 0xFF000000) >>> 24), (byte)((((Unit_Prototype_Json)entry.getValue()).USB_PID & 0xFF0000) >>> 16), (byte)((((Unit_Prototype_Json)entry.getValue()).USB_PID & 0xFF00) >>> 8), (byte)((((Unit_Prototype_Json)entry.getValue()).USB_PID & 0xFF) >>> 0)};
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 0, usbPid.length, usbPid, 0);
            byte[] modelFullName = ((Unit_Prototype_Json)entry.getValue()).getModel_full_name().getBytes(StandardCharsets.UTF_8);
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 1, modelFullName.length, modelFullName, 0);
            byte[] bluetoothName = ((Unit_Prototype_Json)entry.getValue()).getBluetooth_name().getBytes(StandardCharsets.UTF_8);
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 2, bluetoothName.length, bluetoothName, 0);
            byte[] values = new byte[41];
            values[30] = (byte)(((Unit_Prototype_Json)entry.getValue()).Family_id & 0xFF);
            values[32] = ((Unit_Prototype_Json)entry.getValue()).getUnit_category();
            values[33] = ((Unit_Prototype_Json)entry.getValue()).getGeneration();
            values[34] = ((Unit_Prototype_Json)entry.getValue()).getMin_flash_power();
            values[35] = ((Unit_Prototype_Json)entry.getValue()).getMax_flash_power();
            values[36] = ((Unit_Prototype_Json)entry.getValue()).getMin_lamp_power();
            values[37] = ((Unit_Prototype_Json)entry.getValue()).getMax_lamp_power();
            values[38] = ((Unit_Prototype_Json)entry.getValue()).getMax_battery_level();
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 3, values.length, values, 0);
            byte[] ratios = ((Unit_Prototype_Json)entry.getValue()).getSupported_ratios();
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 4, ratios.length, ratios, 0);
            byte[] headTypes = ((Unit_Prototype_Json)entry.getValue()).getHead_types();
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 5, headTypes.length, headTypes, 0);
            byte[] addressKey = ((Unit_Prototype_Json)entry.getValue()).Address_Key.getBytes(StandardCharsets.UTF_8);
            this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 14, addressKey.length, addressKey, 0);
            for (Unit_Prototype_Json.Versioned_skyport_commands versionedBootloader : ((Unit_Prototype_Json)entry.getValue()).Versioned_bootloader) {
                version = versionedBootloader.From_version;
                ordinal = (int)version << 8 | (int)(version * 10.0f) % 10;
                updateBy = new byte[versionedBootloader.Update_by.length * 3];
                updateCount = 0;
                for (JsonNewsFirmwareConnectionType jsonNewsFirmwareConnectionType : versionedBootloader.Update_by) {
                    switch (jsonNewsFirmwareConnectionType.Connection) {
                        default: {
                            updateBy[updateCount++] = 1;
                            break;
                        }
                        case "BLE": {
                            updateBy[updateCount++] = 2;
                            break;
                        }
                        case "SKYPORT": {
                            updateBy[updateCount++] = 3;
                        }
                    }
                    float protocol = jsonNewsFirmwareConnectionType.Protocol;
                    updateBy[updateCount++] = (byte)((int)protocol & 0xFF);
                    updateBy[updateCount++] = (byte)((int)(protocol * 10.0f) % 10 & 0xFF);
                }
                this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 6, updateCount, updateBy, ordinal);
            }
            for (Unit_Prototype_Json.Versioned_skyport_commands versionedCommands : ((Unit_Prototype_Json)entry.getValue()).Versioned_firmware) {
                version = versionedCommands.From_version;
                ordinal = (int)version << 8 | (int)(version * 10.0f) % 10;
                updateBy = new byte[versionedCommands.Update_by.length * 3];
                updateCount = 0;
                for (JsonNewsFirmwareConnectionType jsonNewsFirmwareConnectionType : versionedCommands.Update_by) {
                    switch (jsonNewsFirmwareConnectionType.Connection) {
                        default: {
                            updateBy[updateCount++] = 1;
                            break;
                        }
                        case "BLE": {
                            updateBy[updateCount++] = 2;
                            break;
                        }
                        case "SKYPORT": {
                            updateBy[updateCount++] = 3;
                        }
                    }
                    float protocol = jsonNewsFirmwareConnectionType.Protocol;
                    updateBy[updateCount++] = (byte)((int)protocol & 0xFF);
                    updateBy[updateCount++] = (byte)((int)(protocol * 10.0f) % 10 & 0xFF);
                }
                this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 7, updateCount, updateBy, ordinal);
                byte[] bridgeBy = new byte[versionedCommands.Bridge_by.length * 3];
                int bridgeCount = 0;
                for (JsonNewsFirmwareConnectionType jsonNewsFirmwareConnectionType : versionedCommands.Bridge_by) {
                    switch (jsonNewsFirmwareConnectionType.Connection) {
                        default: {
                            bridgeBy[bridgeCount++] = 1;
                            break;
                        }
                        case "BLE": {
                            bridgeBy[bridgeCount++] = 2;
                            break;
                        }
                        case "SKYPORT": {
                            bridgeBy[bridgeCount++] = 3;
                        }
                    }
                    float protocol = jsonNewsFirmwareConnectionType.Protocol;
                    bridgeBy[bridgeCount++] = (byte)((int)protocol & 0xFF);
                    bridgeBy[bridgeCount++] = (byte)((int)(protocol * 10.0f) % 10 & 0xFF);
                }
                this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 8, bridgeCount, bridgeBy, ordinal);
                byte[] controlBy = new byte[versionedCommands.Control_by.length * 3];
                int controlCount = 0;
                for (JsonNewsFirmwareConnectionType jsonNewsFirmwareConnectionType : versionedCommands.Control_by) {
                    switch (jsonNewsFirmwareConnectionType.Connection) {
                        default: {
                            controlBy[controlCount++] = 1;
                            break;
                        }
                        case "BLE": {
                            controlBy[controlCount++] = 2;
                            break;
                        }
                        case "SKYPORT": {
                            controlBy[controlCount++] = 3;
                        }
                    }
                    float protocol = jsonNewsFirmwareConnectionType.Protocol;
                    controlBy[controlCount++] = (byte)((int)protocol & 0xFF);
                    controlBy[controlCount++] = (byte)((int)(protocol * 10.0f) % 10 & 0xFF);
                }
                this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 9, controlCount, controlBy, ordinal);
                byte[] commands = new byte[versionedCommands.Commands.length];
                int commandCount = 0;
                Arrays.sort(versionedCommands.Commands);
                for (String stringCommand : versionedCommands.Commands) {
                    byte decodedValue;
                    byte[] decodedArray = this.mContext.mUtil.convertHexStringToByteArray(stringCommand);
                    if (decodedArray == null || decodedArray.length <= 0) continue;
                    commands[commandCount] = decodedValue = decodedArray[0];
                    ++commandCount;
                }
                this.mContext.mModuleManagerSdk.addProduct((Integer)entry.getKey(), 10, commandCount, commands, ordinal);
            }
        }
    }
}

