/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.BridgeDeviceBle;
import com.elinchrom.software.BridgeDeviceUsb;
import com.elinchrom.software.ComponentUpdatable;
import com.elinchrom.software.Context;
import com.elinchrom.software.DataServiceResponse;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.JsonHelpContents;
import com.elinchrom.software.JsonHelpFirmwareUpdate;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.TaskStatus;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import javafx.scene.layout.Pane;

public class OpHandlerUi {
    public Context mContext;
    public boolean mIsMainScreenInitialized = false;

    public OpHandlerUi(Context context) {
        this.mContext = context;
    }

    public void displayBridge(int bridgeType, long bridgeDeviceId, long bridgeDeviceSdk) {
    }

    public void handleBadDevice(ElinchromDevice elinchromDevice, int connectionType) {
        if (elinchromDevice != null) {
            if (this.mContext.mBridgeDevice != null && (connectionType == 2 && this.mContext.mBridgeDevice.equals(elinchromDevice.mComponentBridgeBle) || connectionType == 1 && this.mContext.mBridgeDevice.equals(elinchromDevice.mComponentBridgeUsb)) || this.mContext.mNextBridgeDevice != null && (connectionType == 2 && this.mContext.mNextBridgeDevice.equals(elinchromDevice.mComponentBridgeBle) || connectionType == 1 && this.mContext.mNextBridgeDevice.equals(elinchromDevice.mComponentBridgeUsb))) {
                this.mContext.mLogger.log("Selected bridge is bad device.");
                this.mContext.mLayoutPresenterChannel.onDetect();
            } else {
                this.mContext.mLogger.log("WARNING: bad device is not Selected bridge.");
            }
        }
    }

    public void handleInsertNewUnit(int connectionType, long flashUnitSdk, long flashUnitId) {
        if (flashUnitId != 0L && flashUnitSdk != 0L) {
            if (!this.mContext.mIsFreeing && !this.mContext.mIsFreeingAll) {
                ElinchromDevice elinchromDevice;
                if (this.mContext.mElinchromDevices.containsKey(flashUnitId)) {
                    elinchromDevice = this.mContext.mElinchromDevices.get(flashUnitId);
                } else {
                    this.mContext.mLogger.log("DEBUG: Inserting new device.");
                    elinchromDevice = new ElinchromDevice(this.mContext, flashUnitId, flashUnitSdk);
                    elinchromDevice.mComponentUpdatable = new ComponentUpdatable(this.mContext, elinchromDevice);
                    elinchromDevice.mComponentBridgeUsb = new BridgeDeviceUsb(this.mContext, elinchromDevice);
                    elinchromDevice.mComponentBridgeBle = new BridgeDeviceBle(this.mContext, elinchromDevice);
                    elinchromDevice.mComponentLighting = this.mContext.mUtil.factoryFlashUnit(elinchromDevice);
                    if (elinchromDevice.mComponentLighting != null) {
                        elinchromDevice.mComponentLighting.init();
                    }
                    this.mContext.mElinchromDevices.put(flashUnitId, elinchromDevice);
                }
                this.insertUnit(elinchromDevice);
            } else if (this.mContext.mIsFreeing) {
                this.mContext.mLogger.log("DEBUG: Device rejected because of freeing state.");
            } else if (this.mContext.mIsFreeingAll) {
                this.mContext.mLogger.log("DEBUG: Device rejected because of freeing all state.");
            }
        }
    }

    public void insertHasFirmware(int connectionType, long flashUnitSdk, long flashUnitId) {
        this.handleInsertNewUnit(connectionType, flashUnitSdk, flashUnitId);
    }

    public void insertCannotOpenTransmitterPro() {
        this.mContext.mOnScreenLayoutPresenter.onCannotOpenTransmitterPro();
    }

    public void insertHasRadio(int connectionType, long flashUnitSdk, long flashUnitId) {
        if (this.mContext.mLayoutPresenterChannel.mState == 6 && this.mContext.mBridgeDevice != null && this.mContext.mBridgeDevice.mElinchromDevice.mDeviceId == flashUnitId) {
            this.mContext.mLayoutPresenterChannel.mState = 7;
            this.mContext.mLayoutPresenterChannel.mState = 7;
        }
        this.handleInsertNewUnit(connectionType, flashUnitSdk, flashUnitId);
        if (this.mContext.mBridgeDevice != null && this.mContext.mBridgeDevice.mElinchromDevice.mDeviceId == flashUnitId) {
            this.mContext.mLayoutPresenterChannel.displayBridgeFirmwareStatus(this.mContext.mBridgeDevice);
        }
    }

    public void insertUnit(ElinchromDevice elinchromDevice) {
        boolean updateBridgeList = false;
        this.mContext.mOpThreadCore.enqueuePeriodicTask(elinchromDevice);
        Integer orderManual = this.mContext.mManuallySortedFlashUnitMap.get(elinchromDevice.getSkyportId());
        if (!this.mContext.mSortedLightingDevices.contains(elinchromDevice) && elinchromDevice.valueGetByte(60) == 1 && (elinchromDevice.valueGetByte(59) == 1 && elinchromDevice.valueGetLong(55) != 1L || elinchromDevice.valueGetByte(58) == 1 && elinchromDevice.valueGetLong(54) != 1L && elinchromDevice.valueGetByte(66) != 0 && elinchromDevice.valueGetByte(66) == this.mContext.mModuleManagerSdk.valueGetByte(38))) {
            if (orderManual == null) {
                orderManual = this.mContext.mManuallySortedFlashUnitMap.size();
                this.mContext.mManuallySortedFlashUnitMap.put(elinchromDevice.getSkyportId(), orderManual);
                this.mContext.mFileManager.updateManuallySortedUnits();
            }
            this.mContext.mLightingDevices.add(elinchromDevice);
            this.mContext.mSortedLightingDevices.add(elinchromDevice, orderManual);
            this.mContext.mLayoutPresenterUnits.addUnit(elinchromDevice.mComponentLighting);
        } else if (this.mContext.mSortedLightingDevices.contains(elinchromDevice)) {
            this.mContext.mLayoutPresenterUnits.displayUnit(elinchromDevice.mComponentLighting);
        }
        if (!this.mContext.mSortedBridges.contains(elinchromDevice.mComponentBridgeUsb) && elinchromDevice.valueGetByte(60) == 1 && elinchromDevice.valueGetByte(56) == 1 && elinchromDevice.valueGetLong(52) != 1L) {
            this.mContext.mBridges.add(elinchromDevice.mComponentBridgeUsb);
            this.mContext.mSortedBridges.add(elinchromDevice.mComponentBridgeUsb, orderManual == null ? 0 : orderManual);
            updateBridgeList = true;
        }
        if (!this.mContext.mSortedBridges.contains(elinchromDevice.mComponentBridgeBle) && elinchromDevice.valueGetByte(60) == 1 && elinchromDevice.valueGetByte(57) == 1 && elinchromDevice.valueGetLong(53) != 1L) {
            this.mContext.mBridges.add(elinchromDevice.mComponentBridgeBle);
            this.mContext.mSortedBridges.add(elinchromDevice.mComponentBridgeBle, orderManual == null ? 0 : orderManual);
            updateBridgeList = true;
        }
        if (updateBridgeList) {
            this.mContext.mLayoutPresenterChannel.displayBridgeList();
        }
        if (!this.mContext.mSortedUpdates.contains(elinchromDevice) && elinchromDevice.isFirmwareInfoAvailable() && (elinchromDevice.valueGetLong(49) != 1L || elinchromDevice.valueGetLong(50) != 1L || elinchromDevice.valueGetLong(51) != 1L)) {
            this.mContext.mUpdates.add(elinchromDevice);
            this.mContext.mSortedUpdates.add(elinchromDevice, orderManual == null ? 0 : orderManual);
            this.mContext.mLayoutPresenterUpdate.addUnit(elinchromDevice);
            this.mContext.mLayoutPresenterSideMenu.displayHasUpdates();
        } else if (this.mContext.mSortedUpdates.contains(elinchromDevice)) {
            this.mContext.mLayoutPresenterUpdateList.displayUpdate(elinchromDevice);
            this.mContext.mLayoutPresenterSideMenu.displayHasUpdates();
        }
    }

    public void handleSharingUi(TaskInit task) {
        try {
            String jsonString = task.mStrings[0];
            if (!jsonString.isEmpty()) {
                DataServiceResponse dataServiceResponse = this.mContext.mGson.fromJson(jsonString, DataServiceResponse.class);
                if (this.mContext.mStoredPreferences.installId.isEmpty()) {
                    if (!dataServiceResponse.install_id.isEmpty()) {
                        this.mContext.mStoredPreferences.installId = dataServiceResponse.install_id;
                        this.mContext.mStoredPreferences.needRefreshSharing = 0;
                        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                        this.mContext.mLayoutPresenterSettings.displayInstallId(this.mContext.mStoredPreferences.installId);
                    }
                } else if (dataServiceResponse.agree == this.mContext.mStoredPreferences.shareData) {
                    this.mContext.mStoredPreferences.needRefreshSharing = 0;
                    this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                }
            }
            this.mContext.mUtil.initSharingSoftware();
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void initConnectAfterStop() {
        this.mContext.mLogger.log("DEBUG: Stop freeing devices.");
        this.mContext.mIsFreeing = false;
    }

    public void initDetectAfterFree() {
        this.mContext.mLogger.log("DEBUG: Stop freeing all devices.");
        this.mContext.mIsFreeingAll = false;
    }

    public void initRootScreen() {
        this.mContext.mSplashDialog.stop();
        this.mContext.mPrimaryStage.show();
        this.mContext.mLayoutPresenterSideMenu.present((Pane)this.mContext.mLayoutNodeSideNavigation);
        this.mContext.mLayoutPresenterSideMenu.displayScenes();
        this.mContext.mLayoutClickChannelListener.onTouch();
    }

    public void initTaskState1() {
        this.initRootScreen();
        this.mContext.mLayoutPresenterMessages.displayDownloadSoftwareMessage(this.mContext.mLayoutPresenterChannel);
    }

    public void initTaskState2() {
        this.initRootScreen();
        this.mContext.mLayoutPresenterChannel.showProgress();
        if (!this.mContext.mLayoutPresenterMessages.displayAgreementMessageIfNeeded(this.mContext.mLayoutPresenterChannel)) {
            this.mContext.mUtil.initSharing();
            this.mContext.mAppMain.onReadyUi();
        }
    }

    public void initTaskState4(TaskInit task) {
        this.mContext.mLayoutPresenterChannel.showProgress();
        if (!this.mContext.mLayoutPresenterMessages.displayAgreementMessageIfNeeded(this.mContext.mLayoutPresenterChannel)) {
            this.mContext.mUtil.initSharing();
            this.mContext.mAppMain.onReadyUi();
        }
    }

    public void initTaskState5(TaskInit task) {
        for (JsonHelpFirmwareUpdate jsonHelpFirmwareUpdate : this.mContext.mFileDocumentFirmwareNews.mJsonFirmwareNews.help_firmware_update) {
            URL imageUrl = this.mContext.mFileDocumentSkyportUnits.getProductImage(jsonHelpFirmwareUpdate.product_names[0]);
            int connectionType = this.mContext.mFileDocumentSkyportUnits.getFirmwareUpdteConnectionType(jsonHelpFirmwareUpdate.product_names[0]);
            JsonNewsFirmware jsonNewsFirmware = this.mContext.mFileDocumentFirmwareNews.getFirmwareNews(jsonHelpFirmwareUpdate.product_names[0]);
            JsonHelpContents jsonHelpContents = this.mContext.mFileDocumentFirmwareNews.getFirmwareHelpContents(jsonHelpFirmwareUpdate.help_content_id);
            this.mContext.mLayoutPresenterHelpUpdateList.addItem(jsonHelpFirmwareUpdate, jsonNewsFirmware, jsonHelpContents, connectionType, imageUrl);
        }
        this.mContext.mLayoutPresenterHelpLinks.displayLinks(this.mContext.mFileDocumentFirmwareNews.mJsonFirmwareNews.help_links);
        this.mContext.mAppMain.onReadyCore();
        this.mContext.mLayoutPresenterUnits.updateMetrics();
    }

    public void onUnitChanged(ElinchromDevice elinchromDevice, int state, int iotIndex) {
        if (elinchromDevice != null) {
            FlashDevice flashUnit = elinchromDevice.mComponentLighting;
            flashUnit.initFlashSession();
            if (iotIndex == 12 || iotIndex == 14) {
                flashUnit.readNative(iotIndex);
            } else {
                if (iotIndex == 4 || iotIndex == 5) {
                    this.mContext.mLayoutPresenterUnits.sortUnits();
                    this.mContext.mLayoutPresenterUnits.displayUnits();
                }
                this.mContext.mLayoutPresenterUnits.displayUnit(flashUnit);
                this.mContext.mLayoutPresenterUpdateList.displayUpdate(elinchromDevice);
            }
            if ((state == 1 && (iotIndex == 13 || iotIndex == 8) || this.mContext.mModuleManagerSdk.valueGetByte(46) == 0 && state == 2) && this.mContext.mStoredPreferences.shareData == 1 && !this.mContext.mStoredPreferences.installId.isEmpty() && flashUnit != null) {
                String request = this.mContext.mUtil.factorySharingUnitRequest(this.mContext.mStoredPreferences.installId, flashUnit);
                this.mContext.mOpThreadCore.enqueueMediumPriorityTask(new TaskInit(this.mContext, 31, new String[]{request}));
            }
        }
    }

    public void refreshUI(TaskStatus task) {
        this.mContext.mLayoutPresenterChannel.refresh((int)task.mArg);
    }

    public void refreshUnit(ElinchromDevice elinchromDevice) {
        this.refreshUnit(elinchromDevice, false);
    }

    public void refreshUnit(ElinchromDevice elinchromDevice, boolean force) {
        if (elinchromDevice != null && !this.mContext.mIsUpdating) {
            int delayRefreshBatteryLevel;
            if (elinchromDevice.isSelectedBridgeByBle()) {
                delayRefreshBatteryLevel = 5;
                if (elinchromDevice.valueGetByte(72) == 0) {
                    delayRefreshBatteryLevel = 1;
                }
                if (Instant.now().isAfter(elinchromDevice.mSignalCheckTimeBle.plus(Duration.ofSeconds(delayRefreshBatteryLevel)))) {
                    elinchromDevice.mSignalCheckTimeBle = Instant.now();
                    this.mContext.mModuleManagerSdk.enqueueRxTxTask(8, 1, 0L, 0L, elinchromDevice.mDeviceId);
                }
            }
            if (elinchromDevice.isRefreshByUsbEnabled()) {
                delayRefreshBatteryLevel = 5;
                if (elinchromDevice.valueGetByte(68) == 0) {
                    delayRefreshBatteryLevel = 1;
                }
                if (Instant.now().isAfter(elinchromDevice.mSignalCheckTimeUsb.plus(Duration.ofSeconds(delayRefreshBatteryLevel)))) {
                    elinchromDevice.mSignalCheckTimeUsb = Instant.now();
                    this.mContext.mModuleManagerSdk.enqueueRxTxTask(8, 2, 0L, 0L, elinchromDevice.mDeviceId);
                }
            }
            if (elinchromDevice.isRefreshUpdateSignalBySkyportEnabled() && Instant.now().isAfter(elinchromDevice.mSignalCheckTimeSkyport.plus(Duration.ofSeconds(5L)))) {
                elinchromDevice.mSignalCheckTimeSkyport = Instant.now();
                this.mContext.mModuleManagerSdk.enqueueRxTxTask(8, 3, 0L, 0L, elinchromDevice.mDeviceId);
            }
            if (this.mContext.mBridges.contains(elinchromDevice.mComponentBridgeUsb)) {
                this.mContext.mLayoutPresenterChannel.displaySignalStrength(elinchromDevice.mComponentBridgeUsb, elinchromDevice.valueGetByte(46));
                if (elinchromDevice.isSelectedBridgeByUsb()) {
                    this.mContext.mLayoutPresenterSideMenu.displaySignalStrength(elinchromDevice.valueGetByte(46));
                    this.mContext.mLayoutPresenterChannel.displayBatteryLevel(elinchromDevice.mComponentBridgeUsb);
                }
            }
            if (this.mContext.mBridges.contains(elinchromDevice.mComponentBridgeBle) && elinchromDevice.isSelectedBridgeByBle()) {
                this.mContext.mLayoutPresenterChannel.displaySignalStrength(elinchromDevice.mComponentBridgeBle, elinchromDevice.valueGetByte(47));
                this.mContext.mLayoutPresenterSideMenu.displaySignalStrength(elinchromDevice.valueGetByte(47));
                this.mContext.mLayoutPresenterChannel.displayBatteryLevel(elinchromDevice.mComponentBridgeBle);
            }
            if (this.mContext.mLightingDevices.contains(elinchromDevice)) {
                if (elinchromDevice.valueGetByte(63) == 2) {
                    elinchromDevice.mComponentLighting.getLayoutViewUnit().displaySignalStrength(elinchromDevice.valueGetByte(47));
                    this.mContext.mLayoutPresenterSceneDetail.displaySignalStrength(elinchromDevice, elinchromDevice.valueGetByte(47));
                } else if (elinchromDevice.valueGetByte(63) == 3) {
                    elinchromDevice.mComponentLighting.getLayoutViewUnit().displaySignalStrength(elinchromDevice.valueGetByte(48));
                    this.mContext.mLayoutPresenterSceneDetail.displaySignalStrength(elinchromDevice, elinchromDevice.valueGetByte(48));
                }
                if (elinchromDevice.valueGetByte(45) == 1) {
                    elinchromDevice.mComponentLighting.getLayoutViewUnit().displayBatteryLevel((int)(elinchromDevice.valueGetLong(45) >> 8));
                }
            }
        }
        if (elinchromDevice != null && this.mContext.mUpdates.contains(elinchromDevice)) {
            if (elinchromDevice.valueGetByte(61) == 2) {
                elinchromDevice.mComponentUpdatable.getLayoutViewUpdate().displaySignalStrength(elinchromDevice.valueGetByte(47));
            } else if (elinchromDevice.valueGetByte(61) == 1) {
                elinchromDevice.mComponentUpdatable.getLayoutViewUpdate().displaySignalStrength(elinchromDevice.valueGetByte(46));
            } else if (elinchromDevice.valueGetByte(61) == 3) {
                elinchromDevice.mComponentUpdatable.getLayoutViewUpdate().displaySignalStrength(elinchromDevice.valueGetByte(48));
            }
        }
    }

    public void scanInitRf(ElinchromDevice elinchromDevice) {
    }

    public void refresh(ElinchromDevice elinchromDevice) {
        this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 10, 0L, 0L, 0L);
        this.mContext.mAppMain.launchManualRefresh();
    }

    public void statusExtractFirmware(ElinchromDevice elinchromDevice, int event, int value) {
        this.mContext.mLayoutPresenterUpdate.onExtractFirmwareStatus(elinchromDevice, event, value);
    }

    public void statusFirmwareExtracted(ElinchromDevice elinchromDevice, int board1Size, int board2Size) {
        this.mContext.mLayoutPresenterUpdate.onFirmwareExtracted(elinchromDevice, board1Size, board2Size);
    }

    public void statusUpdateFirmware(ElinchromDevice elinchromDevice, int event, int value) {
        this.mContext.mLayoutPresenterUpdate.onUpdateFirmwareStatus(elinchromDevice, event, value);
    }

    public void statusUpdateInit(ElinchromDevice elinchromDevice, int progress) {
        this.mContext.mLayoutPresenterUpdate.animateProgress(elinchromDevice, progress);
    }
}

