/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.QueuePeriodicTask;
import com.elinchrom.software.QueuePriority;
import com.elinchrom.software.Task;
import com.elinchrom.software.TaskStatus;

public class OpThreadCore
extends Thread {
    public Context mContext;
    protected QueuePriority mQueueTrigger = new QueuePriority();
    protected QueuePriority mQueueHigh = new QueuePriority();
    protected QueuePriority mQueueMedium = new QueuePriority();
    protected QueuePeriodicTask mQueuePeriodic = null;
    protected boolean mIsAlive = true;
    protected Task mTaskRefresh = null;

    public OpThreadCore(Context context) {
        this.mContext = context;
        this.mTaskRefresh = new TaskStatus(this.mContext, 6, 0L, 0L);
        this.mQueuePeriodic = new QueuePeriodicTask(this.mContext);
    }

    public void cancel() {
        this.mIsAlive = false;
    }

    public void enqueueHighPriorityTask(Task task) {
        this.mQueueHigh.add(task);
    }

    public void enqueueMediumPriorityTask(Task task) {
        this.mQueueMedium.add(task);
    }

    public void enqueuePeriodicTask(ElinchromDevice elinchromDevice) {
        this.mQueuePeriodic.addPeriodicTask(elinchromDevice);
    }

    public void init() {
    }

    public void removePeriodicTask(ElinchromDevice elinchromDevice) {
        this.mQueuePeriodic.removePeriodicTask(elinchromDevice);
    }

    public void reset() {
        this.mQueuePeriodic.reset();
    }

    @Override
    public void run() {
        while (this.mIsAlive) {
            try {
                Task currentTask = this.mQueueTrigger.pop();
                if (currentTask == null && (currentTask = this.mQueueHigh.pop()) == null && (currentTask = this.mQueueMedium.pop()) == null) {
                    currentTask = this.mQueuePeriodic.next();
                }
                if (currentTask != null) {
                    currentTask.accept(this.mContext.mOpDispatcherCore);
                }
                Thread.sleep(this.mContext.mOpDelayCore);
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }
}

