/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfImage;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.FileDocumentElConf;
import java.util.ArrayList;

public class Scene {
    protected Context mContext;
    protected String mName = null;
    public ElConfScene mElConfScene;

    public Scene(Context context) {
        this.mContext = context;
        this.mElConfScene = null;
        this.mName = null;
    }

    public Scene(Context context, String sceneName) {
        this.mContext = context;
        this.mElConfScene = this.findElConfScene(sceneName);
        this.mName = sceneName;
    }

    public Scene(Context context, ElConfScene elConfScene) {
        this.mContext = context;
        this.mElConfScene = elConfScene;
    }

    protected void copyTo(Scene otherScene) {
        otherScene.mElConfScene.description = this.mElConfScene.description;
        otherScene.mElConfScene.images = this.mElConfScene.images;
        otherScene.mElConfScene.units = this.mElConfScene.units;
    }

    public void create() {
        if (this.mElConfScene == null && this.mName != null) {
            this.mElConfScene = new ElConfScene();
            this.mElConfScene.name = this.mName;
            this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes = this.mContext.mUtil.arrayAppend(this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes, this.mElConfScene);
        }
    }

    public void delete() {
        if (this.exists()) {
            this.deleteImages();
            this.remove();
        }
    }

    public void deleteImage(int elConfImageId) {
        if (this.exists()) {
            try {
                new FileDocumentElConf(this.mContext).fromElConfId(elConfImageId).discard();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
            this.mElConfScene.images = this.findOtherImages(elConfImageId);
            this.mContext.mStoredPreferences.elConfIds = this.findOtherElConfIds(elConfImageId);
        }
    }

    public void deleteImages() {
        if (this.exists()) {
            for (ElConfImage elConfImage : this.mElConfScene.images) {
                this.deleteImage(elConfImage.id);
            }
        }
    }

    public boolean exists() {
        return this.mElConfScene != null;
    }

    protected ElConfScene findElConfScene(String sceneName) {
        ElConfScene foundScene = null;
        for (ElConfScene existingScene : this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes) {
            if (!existingScene.name.equals(sceneName)) continue;
            foundScene = existingScene;
            break;
        }
        return foundScene;
    }

    public Scene findNeighborScene() {
        ElConfScene neighborScene = null;
        if (this.exists()) {
            boolean isSceneFound = false;
            for (ElConfScene existingScene : this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes) {
                if (existingScene.name.equals(this.mElConfScene.name)) {
                    isSceneFound = true;
                } else {
                    neighborScene = existingScene;
                }
                if (isSceneFound && neighborScene != null) break;
            }
        }
        return new Scene(this.mContext, neighborScene);
    }

    protected int[] findOtherElConfIds(int elConfId) {
        int[] result;
        if (this.mContext.mUtil.arrayContains(this.mContext.mStoredPreferences.elConfIds, elConfId)) {
            result = new int[this.mContext.mStoredPreferences.elConfIds.length - 1];
            int index = 0;
            for (int existingId : this.mContext.mStoredPreferences.elConfIds) {
                if (existingId == elConfId) continue;
                result[index++] = existingId;
            }
        } else {
            result = this.mContext.mStoredPreferences.elConfIds;
        }
        return result;
    }

    protected ElConfImage[] findOtherImages(int elConfImageId) {
        ElConfImage[] result = new ElConfImage[this.mElConfScene.images.length - 1];
        boolean found = false;
        int index = 0;
        for (ElConfImage existingImage : this.mElConfScene.images) {
            if (existingImage.id == elConfImageId) {
                found = true;
                continue;
            }
            if (index >= result.length) continue;
            result[index++] = existingImage;
        }
        return found ? result : this.mElConfScene.images;
    }

    protected ElConfScene[] findOtherElConfScenes() {
        ArrayList<ElConfScene> elConfScenes = new ArrayList<ElConfScene>();
        for (ElConfScene existingScene : this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes) {
            if (existingScene.name.equals(this.mElConfScene.name)) continue;
            elConfScenes.add(existingScene);
        }
        return elConfScenes.toArray(new ElConfScene[0]);
    }

    public String getName() {
        return this.exists() ? this.mElConfScene.name : "";
    }

    public boolean is(Scene otherScene) {
        return this.exists() && otherScene.exists() && this.mElConfScene.name.equals(otherScene.mElConfScene.name);
    }

    public Scene moveTo(String destinationName) {
        Scene destinationScene = new Scene(this.mContext, destinationName);
        if (this.exists()) {
            if (!this.getName().equals(destinationName) && destinationScene.exists()) {
                this.copyTo(destinationScene);
                this.remove();
            } else {
                this.mElConfScene.name = destinationName;
                destinationScene = this;
            }
        }
        return destinationScene;
    }

    protected void remove() {
        this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes = this.findOtherElConfScenes();
    }

    public void store() {
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
    }
}

