/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.FirmwareVersion;
import com.elinchrom.software.JsonNewsFirmwareConnectionType;
import java.util.Arrays;

public class Unit_Prototype_Json {
    public int Product_id;
    public int Family_id;
    public String Model_full_name;
    public byte Min_flash_power;
    public byte Max_flash_power;
    public byte Min_lamp_power;
    public byte Max_lamp_power;
    public byte[] Supported_ratios = new byte[0];
    public Versioned_skyport_commands[] Versioned_bootloader = new Versioned_skyport_commands[0];
    public Versioned_skyport_commands[] Versioned_firmware = new Versioned_skyport_commands[0];
    public String Address_Key = "";
    public byte Num_outlets;
    public byte Generation;
    public byte[] Head_types = new byte[0];
    public byte Unit_category;
    public byte Max_battery_level;
    public String Bluetooth_name;
    public String Image_URL;
    public int USB_PID;

    public Unit_Prototype_Json() {
    }

    public Unit_Prototype_Json(int Product_id) {
        this.Product_id = Product_id;
    }

    public Unit_Prototype_Json(String Model_full_name, byte Product_id) {
        this.Model_full_name = Model_full_name;
        this.Product_id = Product_id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Versioned_skyport_commands vsc : this.Versioned_firmware) {
            if (vsc == null) {
                // empty if block
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.format("prod: %d | model: %s | gen: %d | cmds: %s", this.Product_id, this.Model_full_name, this.Generation, Arrays.toString(vsc.Commands)));
        }
        return sb.toString();
    }

    public String[] getVersionedCommands(FirmwareVersion version) {
        String[] retCmd = new String[]{};
        FirmwareVersion retVer = new FirmwareVersion("0.0");
        for (Versioned_skyport_commands vsc : this.Versioned_firmware) {
            FirmwareVersion from;
            if (vsc == null) {
                // empty if block
            }
            if (version.isBefore(from = new FirmwareVersion("" + vsc.From_version)) || from.isBefore(retVer)) continue;
            retVer = from;
            retCmd = vsc.Commands;
        }
        return retCmd;
    }

    public byte[] getSupportedCommands(FirmwareVersion version) {
        String[] cmds = this.getVersionedCommands(version);
        byte[] retVal = new byte[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            try {
                retVal[i] = Byte.parseByte(cmds[i], 16);
                continue;
            }
            catch (NumberFormatException nfe) {
                retVal[i] = 0;
            }
        }
        return retVal;
    }

    public int getProduct_id() {
        return this.Product_id;
    }

    public void setProduct_id(int product_id) {
        this.Product_id = product_id;
    }

    public String getModel_full_name() {
        return this.Model_full_name;
    }

    public void setModel_full_name(String model_full_name) {
        this.Model_full_name = model_full_name;
    }

    public byte getMin_flash_power() {
        return this.Min_flash_power;
    }

    public void setMin_flash_power(byte min_flash_power) {
        this.Min_flash_power = min_flash_power;
    }

    public byte getMax_flash_power() {
        return this.Max_flash_power;
    }

    public void setMax_flash_power(byte max_flash_power) {
        this.Max_flash_power = max_flash_power;
    }

    public byte getMin_lamp_power() {
        return this.Min_lamp_power;
    }

    public void setMin_lamp_power(byte min_lamp_power) {
        this.Min_lamp_power = min_lamp_power;
    }

    public byte getMax_lamp_power() {
        return this.Max_lamp_power;
    }

    public void setMax_lamp_power(byte max_lamp_power) {
        this.Max_lamp_power = max_lamp_power;
    }

    public byte getMax_battery_level() {
        return this.Max_battery_level;
    }

    public void setMax_battery_level(byte max_battery_level) {
        this.Max_battery_level = max_battery_level;
    }

    public byte[] getSupported_ratios() {
        return this.Supported_ratios;
    }

    public void setSupported_ratios(byte[] supported_ratios) {
        this.Supported_ratios = supported_ratios;
    }

    public byte getNum_outlets() {
        return this.Num_outlets;
    }

    public void setNum_outlets(byte num_outlets) {
        this.Num_outlets = num_outlets;
    }

    public byte getGeneration() {
        return this.Generation;
    }

    public void setGeneration(byte generation) {
        this.Generation = generation;
    }

    public byte[] getHead_types() {
        return this.Head_types;
    }

    public void setHead_types(byte[] head_types) {
        this.Head_types = head_types;
    }

    public byte getUnit_category() {
        return this.Unit_category;
    }

    public void setUnit_category(byte unit_category) {
        this.Unit_category = unit_category;
    }

    public String getBluetooth_name() {
        return this.Bluetooth_name;
    }

    public String getImage_URL() {
        return this.Image_URL;
    }

    public void setImage_URL(String image_URL) {
        this.Image_URL = image_URL;
    }

    public int getUSB_PID() {
        return this.USB_PID;
    }

    public void setUSB_PID(int USB_PID) {
        this.USB_PID = USB_PID;
    }

    public class Versioned_skyport_commands {
        public float From_version;
        public JsonNewsFirmwareConnectionType[] Update_by = new JsonNewsFirmwareConnectionType[0];
        public JsonNewsFirmwareConnectionType[] Bridge_by = new JsonNewsFirmwareConnectionType[0];
        public JsonNewsFirmwareConnectionType[] Control_by = new JsonNewsFirmwareConnectionType[0];
        public String[] Commands = new String[0];
    }
}

