/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.girod.javafx.svgimage.AwtImageConverter;
import org.girod.javafx.svgimage.GlobalConfig;
import org.girod.javafx.svgimage.LoaderParameters;
import org.girod.javafx.svgimage.SVGContent;
import org.girod.javafx.svgimage.SVGLoader;
import org.girod.javafx.svgimage.xml.SVGLibraryException;

public class SVGImage
extends Group {
    private static SnapshotParameters SNAPSHOT_PARAMS = null;
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private List<Animation> animations = new ArrayList<Animation>();
    private final SVGContent content;

    public SVGImage() {
        this.content = null;
    }

    public SVGImage(SVGContent content) {
        this.content = content;
    }

    public SVGContent getSVGContent() {
        return this.content;
    }

    public static void setDefaultSnapshotParameters(SnapshotParameters params) {
        SNAPSHOT_PARAMS = params;
    }

    public static SnapshotParameters getDefaultSnapshotParameters() {
        return SNAPSHOT_PARAMS;
    }

    void putNode(String id, Node node) {
        this.nodes.put(id, node);
    }

    public boolean hasNode(String id) {
        return this.nodes.containsKey(id);
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations;
    }

    public void playAnimations() {
        if (Platform.isFxApplicationThread()) {
            this.playAnimationsImpl();
        } else {
            new JFXPanel();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SVGImage.this.playAnimationsImpl();
                }
            });
        }
    }

    private void playAnimationsImpl() {
        if (!this.animations.isEmpty()) {
            for (Animation tr : this.animations) {
                tr.play();
            }
        }
    }

    public void stopAnimations() {
        if (Platform.isFxApplicationThread()) {
            this.stopAnimationsImpl();
        } else {
            new JFXPanel();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SVGImage.this.stopAnimationsImpl();
                }
            });
        }
    }

    private void stopAnimationsImpl() {
        if (!this.animations.isEmpty()) {
            for (Animation tr : this.animations) {
                tr.stop();
            }
        }
    }

    public double getWidth() {
        return this.getLayoutBounds().getWidth();
    }

    public double getScaledWidth() {
        return this.getBoundsInParent().getWidth();
    }

    public double getHeight() {
        return this.getLayoutBounds().getHeight();
    }

    public double getScaledHeight() {
        return this.getBoundsInParent().getHeight();
    }

    public Image toImageScaled(double scale) {
        return this.toImageScaled(scale, scale);
    }

    public Image toImageScaled(short quality, double scaleX, double scaleY) {
        if (quality == 1 && scaleX == scaleY) {
            SVGImage image = this.scale(scaleX);
            return image.toImage();
        }
        double initialWidth = this.getLayoutBounds().getWidth();
        double initialHeight = this.getLayoutBounds().getHeight();
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        double finalWidth = initialWidth * scaleX;
        double finalHeight = initialHeight * scaleY;
        SnapshotParameters params = SNAPSHOT_PARAMS;
        Rectangle2D viewport = new Rectangle2D(0.0, 0.0, finalWidth, finalHeight);
        if (params == null) {
            params = new SnapshotParameters();
            params.setViewport(viewport);
        } else {
            params = new SnapshotParameters();
            params.setCamera(SNAPSHOT_PARAMS.getCamera());
            params.setDepthBuffer(SNAPSHOT_PARAMS.isDepthBuffer());
            params.setTransform(SNAPSHOT_PARAMS.getTransform());
            params.setFill(SNAPSHOT_PARAMS.getFill());
            params.setViewport(viewport);
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImageScaled(double scaleX, double scaleY) {
        return this.toImageScaled((short)0, scaleX, scaleY);
    }

    public Image toImage(short quality, double width) {
        if (quality == 1) {
            SVGImage image = this.scaleTo(width);
            return image.toImage();
        }
        double initialWidth = this.getLayoutBounds().getWidth();
        double initialHeight = this.getLayoutBounds().getHeight();
        double scaleX = width / initialWidth;
        double scaleY = initialHeight * scaleX;
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        double finalWidth = width;
        double finalHeight = initialHeight * scaleY;
        SnapshotParameters params = SNAPSHOT_PARAMS;
        Rectangle2D viewport = new Rectangle2D(0.0, 0.0, finalWidth, finalHeight);
        if (params == null) {
            params = new SnapshotParameters();
            params.setViewport(viewport);
        } else {
            params = new SnapshotParameters();
            params.setCamera(SNAPSHOT_PARAMS.getCamera());
            params.setDepthBuffer(SNAPSHOT_PARAMS.isDepthBuffer());
            params.setTransform(SNAPSHOT_PARAMS.getTransform());
            params.setFill(SNAPSHOT_PARAMS.getFill());
            params.setViewport(viewport);
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImage(double width) {
        return this.toImage((short)0, width);
    }

    public Image toImage() {
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImage(SnapshotParameters params) {
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    private WritableImage snapshotImplInJFX(SnapshotParameters params) {
        WritableImage image = this.snapshot(params, null);
        return image;
    }

    public SVGImage scale(double scale) {
        SVGImage image;
        if (this.content == null) {
            this.setScaleX(scale);
            this.setScaleY(scale);
            return this;
        }
        if (this.content.params != null) {
            LoaderParameters params = this.content.params.clone();
            params.width = -1.0;
            params.scale = scale;
            image = this.content.isFromURL() ? SVGLoader.load(this.content.url, params) : SVGLoader.load(this.content.content, params);
        } else {
            image = this.content.isFromURL() ? SVGLoader.loadScaled(this.content.url, scale) : SVGLoader.loadScaled(this.content.content, scale);
        }
        return image;
    }

    public SVGImage scaleTo(double width) {
        double initialWidth = this.getLayoutBounds().getWidth();
        double scale = width / initialWidth;
        return this.scale(scale);
    }

    public boolean snapshot(SnapshotParameters params, String format, File file) throws SVGLibraryException {
        GlobalConfig config = GlobalConfig.getInstance();
        if (config.isSwingAvailable()) {
            try {
                WritableImage image = this.snapshotImpl(params);
                return AwtImageConverter.snapshot(image, params, format, file);
            }
            catch (SVGLibraryException ex) {
                config.handleLibraryException(ex);
                return false;
            }
        }
        config.handleLibraryError("Swing not available");
        return false;
    }

    public boolean snapshot(String format, File file) throws SVGLibraryException {
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
            params.setFill((Paint)Color.WHITE);
        }
        return this.snapshot(params, format, file);
    }

    private WritableImage snapshotImpl(final SnapshotParameters params) {
        if (Platform.isFxApplicationThread()) {
            return this.snapshotImplInJFX(params);
        }
        new JFXPanel();
        FutureTask<WritableImage> future = new FutureTask<WritableImage>(new Callable<WritableImage>(){

            @Override
            public WritableImage call() throws Exception {
                WritableImage img = SVGImage.this.snapshotImplInJFX(params);
                return img;
            }
        });
        Platform.runLater(future);
        try {
            return future.get();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

