/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.SVGShapeBuilder;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.TransformUtils;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class ClippingFactory
implements SVGTags {
    private final Map<String, XMLNode> clipSpecs = new HashMap<String, XMLNode>();

    public void addClipSpec(String id, XMLNode node) {
        this.clipSpecs.put(id, node);
    }

    public boolean hasClip(String id) {
        return this.clipSpecs.containsKey(id);
    }

    public Shape createClip(String id, Node node, Viewport viewport) {
        XMLNode xmlNode = this.clipSpecs.get(id);
        if (this.clipSpecs.containsKey(id)) {
            String units;
            Bounds objectBoundingBox = null;
            Shape theShape = null;
            if (xmlNode.hasAttribute("clipPathUnits") && (units = xmlNode.getAttributeValue("clipPathUnits")).equals("objectBoundingBox")) {
                objectBoundingBox = node.getBoundsInLocal();
            }
            for (XMLNode childNode : xmlNode.getChildren()) {
                String name;
                Shape shape = null;
                switch (name = childNode.getName()) {
                    case "circle": {
                        shape = SVGShapeBuilder.buildCircle(childNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "path": {
                        shape = SVGShapeBuilder.buildPath(childNode, objectBoundingBox, null, viewport);
                        FillRule rule = ParserUtils.getClipRule(childNode);
                        if (rule == null) break;
                        ((SVGPath)shape).setFillRule(rule);
                        break;
                    }
                    case "polyline": {
                        shape = SVGShapeBuilder.buildPolyline(xmlNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "polygon": {
                        shape = SVGShapeBuilder.buildPolygon(xmlNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "ellipse": {
                        shape = SVGShapeBuilder.buildEllipse(childNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "rect": {
                        shape = SVGShapeBuilder.buildRect(childNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "line": {
                        shape = SVGShapeBuilder.buildLine(childNode, objectBoundingBox, null, viewport);
                        break;
                    }
                    case "text": {
                        shape = SVGShapeBuilder.buildText(childNode, objectBoundingBox, null, viewport);
                    }
                }
                theShape = theShape == null ? shape : Shape.union(theShape, shape);
                if (!xmlNode.hasAttribute("transform")) continue;
                TransformUtils.setTransforms((Node)theShape, xmlNode, viewport);
            }
            return theShape;
        }
        return null;
    }
}

