/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.girod.javafx.svgimage.GlobalConfig;
import org.girod.javafx.svgimage.xml.FilterSpec;
import org.girod.javafx.svgimage.xml.LengthParser;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.Viewbox;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class ParserUtils
implements SVGTags {
    private static final Pattern ZERO = Pattern.compile("[\\-\u2212+]?0+");
    private static final Pattern FONT_SIZE_PAT = Pattern.compile("(\\d+\\.?\\d*)([a-z]+)?");
    private static final Pattern URL_PAT = Pattern.compile("url\\('?([^']+)'?\\)");
    private static final Pattern IMG_URL = Pattern.compile("data:image/(\\w+);base64,([^ ]+)\\s*");

    private ParserUtils() {
    }

    public static Color getColor(String value) {
        if (value.equals("none")) {
            return null;
        }
        try {
            return Color.web((String)value);
        }
        catch (IllegalArgumentException ex) {
            GlobalConfig.getInstance().handleParsingError("Color " + value + " is illegal");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getImage(URL url, String href, double width, double height) {
        URL imageUrl;
        Matcher m = IMG_URL.matcher(href);
        if (m.matches()) {
            String content = m.group(2);
            byte[] imgarray = Base64.getDecoder().decode(content);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(imgarray);){
                Image image2;
                Image image = image2 = new Image((InputStream)stream, width, height, true, true);
                return image;
            }
            catch (IOException e) {
                GlobalConfig.getInstance().handleParsingError("Image base64 " + href + " is invalid");
                return null;
            }
        }
        try {
            imageUrl = new URL(href);
            return new Image(imageUrl.toString(), width, height, true, true);
        }
        catch (MalformedURLException ex) {
            try {
                imageUrl = new URL(url, href);
                return new Image(imageUrl.toString(), width, height, true, true);
            }
            catch (MalformedURLException ex1) {
                GlobalConfig.getInstance().handleParsingError("URL " + href + " is not well formed");
                return null;
            }
        }
    }

    public static String getURL(String value) {
        Matcher m = URL_PAT.matcher(value);
        if (m.matches()) {
            value = m.group(1);
        }
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        return value;
    }

    public static Paint expressPaint(Map<String, Paint> gradients, String value) {
        Color paint = null;
        if (!value.equals("none")) {
            if (value.startsWith("url(")) {
                String id = ParserUtils.getURL(value);
                paint = gradients.get(id);
            } else {
                paint = ParserUtils.getColor(value);
            }
        }
        return paint;
    }

    public static FillRule getClipRule(XMLNode node) {
        if (node.hasAttribute("clip-rule")) {
            String value = node.getAttributeValue("clip-rule");
            if (value.equals("nonzero")) {
                return FillRule.NON_ZERO;
            }
            if (value.equals("evenodd")) {
                return FillRule.EVEN_ODD;
            }
            return null;
        }
        return null;
    }

    public static FillRule getFillRule(XMLNode node) {
        if (node.hasAttribute("fill-rule")) {
            String value = node.getAttributeValue("fill-rule");
            if (value.equals("nonzero")) {
                return FillRule.NON_ZERO;
            }
            if (value.equals("evenodd")) {
                return FillRule.EVEN_ODD;
            }
            return null;
        }
        return null;
    }

    public static List<Double> parseDashArray(String value, Viewport viewport) {
        if (value == null || value.equals("none")) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        StringTokenizer tokenizer = new StringTokenizer(value, " ,");
        while (tokenizer.hasMoreTokens()) {
            String dash = tokenizer.nextToken();
            list.add(ParserUtils.parseLengthValue(dash, true, null, viewport));
        }
        return list;
    }

    public static Color getColor(String value, double opacity) {
        try {
            return Color.web((String)value, (double)opacity);
        }
        catch (IllegalArgumentException ex) {
            GlobalConfig.getInstance().handleParsingError("Color " + value + " is illegal");
            return null;
        }
    }

    public static boolean parseVisibility(String value) {
        return !value.equals("hidden");
    }

    public static double parseOpacity(String value) {
        boolean isPercent = false;
        if (value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
            isPercent = true;
        }
        try {
            double opacity = Double.parseDouble(value);
            if (isPercent) {
                opacity /= 100.0;
            }
            return opacity;
        }
        catch (NumberFormatException e) {
            GlobalConfig.getInstance().handleParsingError("Opacity " + value + " is not a number");
            return -1.0;
        }
    }

    public static void setFillOpacity(Node node, double fillOpacity) {
        Shape shape;
        Paint paint;
        if (node instanceof Shape && fillOpacity < 1.0 && (paint = (shape = (Shape)node).getFill()) != null && paint instanceof Color) {
            Color fill = (Color)paint;
            fill = fill.deriveColor(0.0, 1.0, 1.0, fillOpacity);
            shape.setFill((Paint)fill);
        }
    }

    public static String parseFirstArgument(String value) {
        StringTokenizer tok = new StringTokenizer(value, " ");
        return tok.nextToken().trim();
    }

    public static int parseIntProtected(String valueS) {
        Matcher m = ZERO.matcher(valueS);
        if (m.matches()) {
            return 0;
        }
        try {
            int valueI = Integer.parseInt(valueS);
            return valueI;
        }
        catch (NumberFormatException e) {
            GlobalConfig.getInstance().handleParsingError("Value " + valueS + " is not a number");
            return 0;
        }
    }

    public static double parseDoubleProtected(String valueS) {
        Matcher m = ZERO.matcher(valueS = valueS.replace('\u2212', '-'));
        if (m.matches()) {
            return 0.0;
        }
        try {
            double valueD = Double.parseDouble(valueS);
            return valueD;
        }
        catch (NumberFormatException e) {
            GlobalConfig.getInstance().handleParsingError("Value " + valueS + " is not a number");
            return 0.0;
        }
    }

    public static double parseFontSize(String valueS) {
        Matcher m = FONT_SIZE_PAT.matcher(valueS);
        if (m.matches()) {
            int groupCount = m.groupCount();
            if (groupCount == 1) {
                double size = Double.parseDouble(valueS);
                return size;
            }
            String value1 = m.group(1);
            double size = Double.parseDouble(value1);
            String unit = m.group(2);
            if (unit != null && unit.equals("px")) {
                return size *= 1.25;
            }
            return size;
        }
        return 12.0;
    }

    public static double parsePositionValue(String valueS, boolean isWidth, Bounds bounds, Viewport viewport) {
        Matcher m = ZERO.matcher(valueS = valueS.replace('\u2212', '-'));
        if (m.matches()) {
            return 0.0;
        }
        return LengthParser.parsePosition(valueS, isWidth, bounds, viewport);
    }

    public static double parseLengthValue(String valueS, boolean isWidth, Bounds bounds, Viewport viewport) {
        Matcher m = ZERO.matcher(valueS = valueS.replace('\u2212', '-'));
        if (m.matches()) {
            return 0.0;
        }
        return LengthParser.parseLength(valueS, isWidth, bounds, viewport);
    }

    public static void parseLengthValue(List<Double> args, String value, boolean isWidth, Bounds bounds, Viewport viewport) {
        value = value.replace('\u2212', '-');
        double d = LengthParser.parseLength(value, isWidth, bounds, viewport);
        args.add(d);
    }

    public static double parseLineWidth(String value, Viewport viewport) {
        value = value.replace('\u2212', '-');
        double d = LengthParser.parseLineWidth(value, viewport);
        return d;
    }

    public static Effect expressFilter(Map<String, FilterSpec> filterSpecs, Node node, String value) {
        HashMap<String, Effect> namedEffects = new HashMap<String, Effect>();
        ArrayList<FilterSpec.AppliedEffect> appliedEffects = new ArrayList<FilterSpec.AppliedEffect>();
        Effect lastEffect = null;
        boolean useSourceAlpha = false;
        if (!value.equals("none")) {
            String id;
            if (value.startsWith("url(") && filterSpecs.containsKey(id = ParserUtils.getURL(value))) {
                FilterSpec spec = filterSpecs.get(id);
                List<FilterSpec.FilterEffect> effects = spec.getEffects();
                for (int i = 0; i < effects.size(); ++i) {
                    FilterSpec.FEComposite feComposite;
                    boolean toApply;
                    FilterSpec.FilterEffect filterEffect = effects.get(i);
                    if (filterEffect instanceof FilterSpec.FEComposite && !(toApply = (feComposite = (FilterSpec.FEComposite)filterEffect).shouldApply(appliedEffects, i))) continue;
                    if (filterEffect.getInputType() == 3) {
                        useSourceAlpha = true;
                    }
                    String resultId = filterEffect.getResultId();
                    lastEffect = filterEffect.getEffect(node);
                    appliedEffects.add(new FilterSpec.AppliedEffect(filterEffect, lastEffect));
                    if (resultId == null || lastEffect == null) continue;
                    namedEffects.put(resultId, lastEffect);
                }
            }
            ColorAdjust sourceAlpha = null;
            if (useSourceAlpha) {
                sourceAlpha = new ColorAdjust();
                sourceAlpha.setBrightness(-1.0);
            }
            Effect previousEffect = null;
            for (FilterSpec.AppliedEffect appliedEffect : appliedEffects) {
                FilterSpec.FilterEffect spec = appliedEffect.getEffectSpec();
                Effect effect = appliedEffect.getEffect();
                spec.resolveEffect(effect, (Effect)sourceAlpha, previousEffect, namedEffects);
                previousEffect = effect;
            }
        }
        return lastEffect;
    }

    public static void setBaselineShift(Text text, String value) {
        if (value.equals("sub")) {
            text.setTranslateY(text.getFont().getSize() * 0.3);
        } else if (value.equals("super")) {
            text.setTranslateY(text.getFont().getSize() * -0.3);
        } else {
            boolean isPercent = false;
            if (value.endsWith("%")) {
                isPercent = true;
                value = value.substring(0, value.length());
            }
            try {
                double shift = -Double.parseDouble(value);
                if (isPercent) {
                    shift *= 100.0;
                }
                text.setTranslateY(text.getFont().getSize() * shift);
            }
            catch (NumberFormatException e) {
                GlobalConfig.getInstance().handleParsingError("Value " + value + " is not a number");
            }
        }
    }

    public static boolean hasXPosition(XMLNode node) {
        return node.hasAttribute("x") || node.hasAttribute("dx");
    }

    public static Map<String, String> getStyles(XMLNode node) {
        HashMap<String, String> styles = new HashMap<String, String>();
        if (node.hasAttribute("style")) {
            String styleValue = node.getAttributeValue("style");
            StringTokenizer tok = new StringTokenizer(styleValue, ";");
            while (tok.hasMoreTokens()) {
                int index;
                String tk = tok.nextToken().trim();
                if (tk.isEmpty() || (index = tk.indexOf(58)) == -1) continue;
                String key = tk.substring(0, index);
                if (index >= tk.length() - 1) continue;
                String value = tk.substring(index + 1);
                styles.put(key, value);
            }
        }
        return styles;
    }

    public static String mergeStyles(Map<String, String> styles, XMLNode node) {
        styles = new HashMap<String, String>(styles);
        if (node.hasAttribute("style")) {
            String styleValue = node.getAttributeValue("style");
            StringTokenizer tok = new StringTokenizer(styleValue, ";");
            while (tok.hasMoreTokens()) {
                int index;
                String tk = tok.nextToken().trim();
                if (tk.isEmpty() || (index = tk.indexOf(58)) == -1) continue;
                String key = tk.substring(0, index);
                if (index >= tk.length() - 1) continue;
                String value = tk.substring(index + 1);
                styles.put(key, value);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            buf.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        return buf.toString();
    }

    public static void propagateStyleAttributes(XMLNode parentNode, XMLNode childNode) {
        if (childNode.getName().equals("tspan")) {
            return;
        }
        for (Map.Entry<String, String> entry : parentNode.attributes.entrySet()) {
            switch (entry.getKey()) {
                case "style": 
                case "stroke": 
                case "fill": 
                case "stroke-width": 
                case "class": {
                    if (childNode.hasAttribute(entry.getKey())) break;
                    childNode.addAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public static void setVisibility(Node node, XMLNode xmlNode) {
        if (xmlNode.hasAttribute("visibility")) {
            String visibilityS = xmlNode.getAttributeValue("visibility");
            boolean visible = ParserUtils.parseVisibility(visibilityS);
            node.setVisible(visible);
        }
    }

    public static void setOpacity(Node node, XMLNode xmlNode) {
        String fillOpacityS;
        double fillOpacity;
        String opacityS;
        double opacity;
        if (xmlNode.hasAttribute("opacity") && (opacity = ParserUtils.parseOpacity(opacityS = xmlNode.getAttributeValue("opacity"))) >= 0.0) {
            node.setOpacity(opacity);
        }
        if (xmlNode.hasAttribute("fill-opacity") && node instanceof Shape && (fillOpacity = ParserUtils.parseOpacity(fillOpacityS = xmlNode.getAttributeValue("fill-opacity"))) >= 0.0) {
            ParserUtils.setFillOpacity(node, fillOpacity);
        }
    }

    public static Viewport parseViewport(XMLNode xmlNode) {
        String box;
        StringTokenizer tok;
        double viewboxX = 0.0;
        double viewboxY = 0.0;
        double width = 0.0;
        double height = 0.0;
        double viewboxWidth = 0.0;
        double viewboxHeight = 0.0;
        boolean hasWidthAndHeight = false;
        if (xmlNode.hasAttribute("viewBox") && (tok = new StringTokenizer(box = xmlNode.getAttributeValue("viewBox"), " ,")).countTokens() >= 4) {
            viewboxX = ParserUtils.parseDoubleProtected(tok.nextToken());
            viewboxY = ParserUtils.parseDoubleProtected(tok.nextToken());
            viewboxWidth = ParserUtils.parseDoubleProtected(tok.nextToken());
            viewboxHeight = ParserUtils.parseDoubleProtected(tok.nextToken());
        }
        if (xmlNode.hasAttribute("width") && xmlNode.hasAttribute("height")) {
            width = xmlNode.getDoubleValue("width", 0.0);
            height = xmlNode.getDoubleValue("height", 0.0);
            if (ParserUtils.isPercent(xmlNode, "width")) {
                width = viewboxWidth * width / 100.0;
            }
            if (ParserUtils.isPercent(xmlNode, "height")) {
                height = viewboxHeight * height / 100.0;
            }
            hasWidthAndHeight = true;
        }
        Viewport theViewport = hasWidthAndHeight ? new Viewport(width, height) : new Viewport();
        if (xmlNode.hasAttribute("preserveAspectRatio")) {
            boolean preserve = ParserUtils.getPreserveAspectRatio(xmlNode.getAttributeValue("preserveAspectRatio"));
            theViewport.setPreserveAspectRatio(preserve);
        }
        theViewport.setViewbox(viewboxX, viewboxY, viewboxWidth, viewboxHeight);
        return theViewport;
    }

    public static boolean getPreserveAspectRatio(String value) {
        if (!value.contains(" ")) {
            return !value.equals("none");
        }
        StringTokenizer tok = new StringTokenizer(value, " ");
        return !tok.nextToken().equals("none");
    }

    public static Viewbox parseViewbox(XMLNode xmlNode, Viewport viewport) {
        if (xmlNode.hasAttribute("width") && xmlNode.hasAttribute("height")) {
            double width = xmlNode.getLengthValue("width", viewport, 0.0);
            double height = xmlNode.getLengthValue("height", viewport, 0.0);
            if (xmlNode.hasAttribute("viewBox")) {
                String box = xmlNode.getAttributeValue("viewBox");
                StringTokenizer tok = new StringTokenizer(box, " ,");
                if (tok.countTokens() >= 4) {
                    double viewboxX = ParserUtils.parseDoubleProtected(tok.nextToken());
                    double viewboxY = ParserUtils.parseDoubleProtected(tok.nextToken());
                    double viewboxWidth = ParserUtils.parseDoubleProtected(tok.nextToken());
                    double viewboxHeight = ParserUtils.parseDoubleProtected(tok.nextToken());
                    Viewbox theViewbox = new Viewbox(width, height);
                    theViewbox.setViewbox(viewboxX, viewboxY, viewboxWidth, viewboxHeight);
                    return theViewbox;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean isPercent(XMLNode xmlNode, String attrname) {
        if (xmlNode.hasAttribute(attrname)) {
            String value = xmlNode.getAttributeValue(attrname);
            return value.endsWith("%");
        }
        return true;
    }
}

