/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class TransformUtils
implements SVGTags {
    private static final Pattern TRANSFORM_PAT = Pattern.compile("\\w+\\((.*)\\)");

    private TransformUtils() {
    }

    public static List<Double> getTransformArgumentsForAnimation(String content, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        StringTokenizer tok = new StringTokenizer(content, ", ");
        while (tok.hasMoreTokens()) {
            String argumentS = tok.nextToken();
            ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
        }
        return args;
    }

    private static List<Double> getTranslateTransformArguments(String transformTxt, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        Matcher m = TRANSFORM_PAT.matcher(transformTxt);
        if (m.matches()) {
            String content = m.group(1);
            StringTokenizer tok = new StringTokenizer(content, ", ");
            while (tok.hasMoreTokens()) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
            }
        } else {
            return null;
        }
        return args;
    }

    private static List<Double> getScaleTransformArguments(String transformTxt, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        Matcher m = TRANSFORM_PAT.matcher(transformTxt);
        if (m.matches()) {
            String content = m.group(1);
            StringTokenizer tok = new StringTokenizer(content, ", ");
            while (tok.hasMoreTokens()) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
            }
        } else {
            return null;
        }
        return args;
    }

    private static List<Double> getRotateTransformArguments(String transformTxt, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        Matcher m = TRANSFORM_PAT.matcher(transformTxt);
        if (m.matches()) {
            String content = m.group(1);
            StringTokenizer tok = new StringTokenizer(content, ", ");
            int countTokens = tok.countTokens();
            if (countTokens == 1) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
            } else if (countTokens == 3) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
            }
        } else {
            return null;
        }
        return args;
    }

    private static List<Double> getSkewTransformArguments(String transformTxt, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        Matcher m = TRANSFORM_PAT.matcher(transformTxt);
        if (m.matches()) {
            String content = m.group(1);
            StringTokenizer tok = new StringTokenizer(content, ", ");
            while (tok.hasMoreTokens()) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
            }
        } else {
            return null;
        }
        return args;
    }

    private static List<Double> getMatrixTransformArguments(String transformTxt, Viewport viewport) {
        ArrayList<Double> args = new ArrayList<Double>();
        Matcher m = TRANSFORM_PAT.matcher(transformTxt);
        if (m.matches()) {
            String content = m.group(1);
            StringTokenizer tok = new StringTokenizer(content, ", ");
            int countTokens = tok.countTokens();
            if (countTokens == 6) {
                String argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, null);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
                argumentS = tok.nextToken();
                ParserUtils.parseLengthValue(args, argumentS, true, null, viewport);
            }
        } else {
            return null;
        }
        return args;
    }

    public static void setTransforms(Node node, XMLNode xmlNode, Viewport viewport) {
        String transforms;
        List<Transform> transformList;
        if (xmlNode.hasAttribute("transform") && !(transformList = TransformUtils.extractTransforms(transforms = xmlNode.getAttributeValue("transform"), viewport)).isEmpty()) {
            ObservableList nodeTransforms = node.getTransforms();
            for (Transform theTransForm : transformList) {
                nodeTransforms.add((Object)theTransForm);
            }
        }
    }

    public static List<Transform> extractTransforms(String transforms, Viewport viewport) {
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        StringTokenizer tokenizer = new StringTokenizer(transforms, ")");
        while (tokenizer.hasMoreTokens()) {
            Translate transform;
            List<Double> args;
            String transformTxt = tokenizer.nextToken() + ")";
            if ((transformTxt = transformTxt.trim()).startsWith("translate(")) {
                args = TransformUtils.getTranslateTransformArguments(transformTxt, viewport);
                if (args.size() != 2) continue;
                transform = Transform.translate((double)args.get(0), (double)args.get(1));
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("translateX(")) {
                args = TransformUtils.getTranslateTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.translate((double)args.get(0), (double)0.0);
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("translateY(")) {
                args = TransformUtils.getTranslateTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.translate((double)0.0, (double)args.get(0));
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("scale(")) {
                args = TransformUtils.getScaleTransformArguments(transformTxt, viewport);
                if (args.size() == 2) {
                    transform = Transform.scale((double)args.get(0), (double)args.get(1));
                    transformList.add((Transform)transform);
                    continue;
                }
                if (args.size() != 1) continue;
                transform = Transform.scale((double)args.get(0), (double)args.get(0));
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("scaleX(")) {
                args = TransformUtils.getScaleTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.translate((double)args.get(0), (double)1.0);
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("scaleY(")) {
                args = TransformUtils.getScaleTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.translate((double)1.0, (double)args.get(0));
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("rotate(")) {
                args = TransformUtils.getRotateTransformArguments(transformTxt, viewport);
                if (args.size() == 3) {
                    transform = Transform.rotate((double)args.get(0), (double)args.get(1), (double)args.get(2));
                    transformList.add((Transform)transform);
                    continue;
                }
                if (args.size() != 1) continue;
                transform = Transform.rotate((double)args.get(0), (double)0.0, (double)0.0);
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("skewX(")) {
                args = TransformUtils.getSkewTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.shear((double)Math.tan(Math.toRadians(args.get(0))), (double)0.0);
                transformList.add((Transform)transform);
                continue;
            }
            if (transformTxt.startsWith("skewY(")) {
                args = TransformUtils.getSkewTransformArguments(transformTxt, viewport);
                if (args.size() != 1) continue;
                transform = Transform.shear((double)0.0, (double)Math.tan(Math.toRadians(args.get(0))));
                transformList.add((Transform)transform);
                continue;
            }
            if (!transformTxt.startsWith("matrix(") || (args = TransformUtils.getMatrixTransformArguments(transformTxt, viewport)).size() != 6) continue;
            transform = Transform.affine((double)args.get(0), (double)args.get(1), (double)args.get(2), (double)args.get(3), (double)args.get(4), (double)args.get(5));
            transformList.add((Transform)transform);
        }
        return transformList;
    }
}

