/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.TimeUnit;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class UsbHidTrezorV1Example
implements HidServicesListener {
    static final int PACKET_LENGTH = 64;
    private HidServices hidServices;

    public static void main(String[] args) throws HidException {
        UsbHidTrezorV1Example example = new UsbHidTrezorV1Example();
        example.executeExample();
    }

    public void executeExample() throws HidException {
        char[] cArray = "\udc18\u19c1\ue5fd\u2f92\u4229\uc716\ua351\u9380\u28d9\u37c5\u3d05\u57d1\ud41c\u16e9\u573e\u924f\u1bc5".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x7D1D);
        System.out.println(c.v(cArray, 19894 << 16 | 0x47E7, 1, 3));
        this.hidServices = HidManager.getHidServices();
        this.hidServices.addHidServicesListener(this);
        char[] cArray2 = "\u1a09\ue010\u1c50\uc626\u9d23\ucc8d\u7bd9\u8d35\ud547\ue16e\u6396\ueb61\u4e46\u81c6\u5439\ub081\u21cb\u366c\u9d33\uc9ee\uf8b2\u56a1\u9d2d\u8c06\ud560\u4ad1\u74cc\u5a14\u77a6\ucf51\uf3ce".toCharArray();
        cArray2[16] = (char)(cArray2[16] ^ 0x705);
        System.out.println(c.v(cArray2, 9952 << 16 | 0x76B, 0, 3));
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            System.out.println(hidDevice);
        }
        HidDevice trezor = this.hidServices.getHidDevice(21324, 1, null);
        if (trezor != null) {
            this.sendInitialise(trezor);
        } else {
            char[] cArray3 = "\ud608\ueba3\u85da\ub04d\u9fec\ubd61\ubfdd\u633d\u09ef\u3a23\u972a\u2ece\u7b73\u70c7\uc2a0\u03b3\uc889\ub82c\u739e\u17f7\u0bd0\u476f\uf599\uceb6\u2655\u14c9\u322a\u7c2a".toCharArray();
            cArray3[22] = (char)(cArray3[22] ^ 0x241);
            System.out.println(c.v(cArray3, 15153 << 16 | 0x52A3, 5, 0));
        }
        UsbHidTrezorV1Example.sleepUninterruptibly(5L, TimeUnit.SECONDS);
        if (trezor != null && trezor.isOpen()) {
            trezor.close();
        }
        System.exit(0);
    }

    @Override
    public void hidDeviceAttached(HidServicesEvent event) {
        HidDevice trezor;
        char[] cArray = "\u0f40\ud90e\u1e0b\ucb4c\uf39c\u29de\u54e5\ub26f\u013b\u10d9\uffdb\u9539\u662c\u470d\u0d96\ubee5\u690d".toCharArray();
        cArray[6] = (char)(cArray[6] ^ 0x470);
        System.out.println(c.v(cArray, 30481 << 16 | 0x5E2F, 3, 5) + event);
        if (event.getHidDevice().getVendorId() == 21324 && event.getHidDevice().getProductId() == 1 && (trezor = this.hidServices.getHidDevice(21324, 1, null)) != null) {
            this.sendInitialise(trezor);
        }
    }

    @Override
    public void hidDeviceDetached(HidServicesEvent event) {
        char[] cArray = "\u33e7\ud7ea\u6483\u672e\ueab0\u151c\u4c49\u677e\u3c27\uf6bf\ua3ad\uf557\u1bdc\u168d\u1d9a\u251f\u9d7a".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x55BC);
        System.err.println(c.v(cArray, 15225 << 16 | 0x5CBC, 4, 3) + event);
    }

    @Override
    public void hidFailure(HidServicesEvent event) {
        char[] cArray = "\u4dd2\uf22f\u1c74\u67e0\uca30\u1407\ue615\u1bdf\ue8e3\uffdd\u63ca\ucda2\ud002".toCharArray();
        cArray[5] = (char)(cArray[5] ^ 0x1D8);
        System.err.println(c.v(cArray, 19138 << 16 | 0x54C8, 0, 0) + event);
    }

    private void sendInitialise(HidDevice trezor) {
        byte[] message = new byte[64];
        message[0] = 63;
        message[1] = 35;
        message[2] = 35;
        int val = trezor.write(message, 64, (byte)0);
        if (val != -1) {
            char[] cArray = "\ud6c0\u8565\uc938".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x428B);
            char[] cArray2 = "\u379d".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x93C);
            System.out.println(c.v(cArray, 17052 << 16 | 0x3686, 0, 5) + val + c.v(cArray2, 11992 << 16 | 0x46B7, 4, 1));
        } else {
            System.err.println(trezor.getLastErrorMessage());
        }
        boolean moreData = true;
        block4: while (moreData) {
            byte[] data = new byte[64];
            val = trezor.read(data, 500);
            switch (val) {
                case -1: {
                    System.err.println(trezor.getLastErrorMessage());
                    continue block4;
                }
                case 0: {
                    moreData = false;
                    continue block4;
                }
            }
            char[] cArray = "\ud172\uc422\u9a57".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x532);
            System.out.print(c.v(cArray, 10406 << 16 | 0x5465, 0, 0));
            for (byte b : data) {
                char[] cArray3 = "\u51fb\u67b5\u7c8d\u2620\u7a10".toCharArray();
                cArray3[2] = (char)(cArray3[2] ^ 0x78A);
                System.out.printf(c.v(cArray3, 115 << 16 | 0x2FED, 1, 4), b);
            }
            char[] cArray4 = "\u613e".toCharArray();
            cArray4[0] = (char)(cArray4[0] ^ 0x676F);
            System.out.println(c.v(cArray4, 7175 << 16 | 0x4E4A, 1, 3));
        }
    }

    public static void sleepUninterruptibly(long sleepFor, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(sleepFor);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

