/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom;

import ch.elinchrom.OS;
import ch.elinchrom.ScriptBuilder;
import ch.elinchrom.UpdaterContext;
import ch.elinchrom.gui.InstallOSxDriver;
import ch.elinchrom.util.FileSearch;
import ch.elinchrom.util.NativeUtils;
import com.apple.eawt.Application;
import elinchrom.Crypting_Functions;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OSMacOS
extends OS {
    public static final float OS_VERSION_MACOS_CATALINA = 10.15f;
    public static final int OS_VERSION_MACOS_CATALINA_MAJOR = 10;
    public static final int OS_VERSION_MACOS_CATALINA_MINOR = 15;

    public OSMacOS(UpdaterContext updaterContext) {
        super(updaterContext);
    }

    @Override
    public String getAppDirectory() {
        String appDirectory = null;
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            File jarDirectory = new File(jarFile.getParent());
            appDirectory = jarDirectory.getParentFile().getParentFile().getParent();
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return appDirectory;
    }

    @Override
    public boolean isSkyportUSBCompatible() {
        boolean isSkyportUSBCompatible = true;
        try {
            float version;
            String versionString = System.getProperty("os.version");
            String[] versionArray = versionString.split("\\.");
            int versionMajor = 0;
            int versionMinor = 0;
            if (versionArray.length >= 1) {
                versionMajor = Integer.parseInt(versionArray[0]);
            }
            if (versionArray.length >= 2) {
                versionMinor = Integer.parseInt(versionArray[1]);
            }
            isSkyportUSBCompatible = (version = (float)versionMajor + (float)versionMinor / 100.0f) < 10.15f;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return isSkyportUSBCompatible;
    }

    @Override
    public boolean checkDriverInstalled() {
        FileSearch fileSearch = new FileSearch();
        fileSearch.searchDirectory(new File("/System/Library/Extensions"), "FTDI");
        int count = fileSearch.getResult().size();
        return count != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installDriver() {
        try {
            JOptionPane.showMessageDialog(null, "Skyport driver is not installed. We will install it now. \n ATTENTION! The operation may take some time! \n Do not close until finished!");
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    OSMacOS.this.mUpdaterContext.installerFrame = new InstallOSxDriver();
                    OSMacOS.this.mUpdaterContext.installerFrame.setVisible(true);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
        }
        catch (Exception invocationTargetException) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
        }
        try {
            File encryptedDriverInstallerPackage = NativeUtils.loadLibraryFromJar("/lib/EL-Skyport_USB_Driver_OSx", true);
            FileInputStream inputStream = new FileInputStream(encryptedDriverInstallerPackage);
            byte[] inputBytes = new byte[(int)encryptedDriverInstallerPackage.length()];
            inputStream.read(inputBytes);
            byte[] driverInstallerPackageBytes = Crypting_Functions.decryptAsBinary(inputBytes);
            File driverInstallerPackage = File.createTempFile("EL-Skyport_USB_Driver_OSx", ".pkg");
            try (FileOutputStream os = new FileOutputStream(driverInstallerPackage);){
                ((OutputStream)os).write(driverInstallerPackageBytes);
            }
            String installCmd = "do shell script \" installer -pkg " + driverInstallerPackage.getPath() + " -target / \" with administrator privileges";
            ArrayList<String> args = null;
            args = new ArrayList<String>();
            args.add("osascript");
            args.add("-e");
            args.add(installCmd);
            new ScriptBuilder(args, this.mUpdaterContext.tempDirectory, this.mUpdaterContext.logger);
        }
        catch (IOException ex) {
            this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (OSMacOS.this.mUpdaterContext.installerFrame != null) {
                        OSMacOS.this.mUpdaterContext.installerFrame.dispatchEvent(new WindowEvent(OSMacOS.this.mUpdaterContext.installerFrame, 201));
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.mUpdaterContext.operatingSystem.checkDriverInstalled()) {
                JOptionPane.showMessageDialog(null, "The skyport driver has been correctly installed. The EL_Updater will now restart");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setOSLookAndFeel() {
        Application macApp = Application.getApplication();
        macApp.setDockIconImage(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/EL-Updater-Logo512.png")).getImage());
        System.setProperty("java.io.tmpdir", "/tmp");
    }
}

