/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.firmware_updater;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.UpdaterContext;
import ch.elinchrom.gui.MessageWithLink;
import ch.elinchrom.info.Firmware_Data;
import ch.elinchrom.info.Firmware_on_website;
import ch.elinchrom.info.HID_Bootloader_Commands;
import ch.elinchrom.logging.LogWrapper;
import ch.elinchrom.usb_skyport_manager.Skyport_Units_Update_Manager;
import ch.elinchrom.util.Elinchrom_Utils;
import com.sun.jna.Platform;
import elinchrom.Functions;
import elinchrom.Identifiers;
import elinchrom.Skyport_Module;
import elinchrom.Unit_Prototype_Json;
import firmware_updater.Jni_macosx_functions;
import firmware_updater.Jni_windows_functions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.hid4java.HidException;

public class Firmware_Updater
extends JFrame {
    private boolean sav_mode_active = false;
    private boolean is_elsp_unit = false;
    private boolean is_skyport_unit = false;
    private List<Firmware_Data> firmware_to_file = new ArrayList<Firmware_Data>();
    private List<Firmware_Data> firmware_to_verify = new ArrayList<Firmware_Data>();
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    protected UpdaterContext mUpdaterContext;
    private JLabel fw_rev_label;
    private JTextField fw_text_field;
    private JButton help_button;
    private JLabel img_label;
    private JLabel logo_label;
    private JLabel model_label;
    private JTextField model_text_field;
    private JPanel panel_available_fw;
    private JProgressBar progress_bar;
    private JScrollPane scroll_pane_info_area;
    private JTextArea system_info_area;
    private JPanel system_info_panel;
    private JPanel unit_info_panel;

    public Firmware_Updater(boolean is_skyport_uni, UpdaterContext updaterContext) throws HidException {
        this.mUpdaterContext = updaterContext;
        this.initComponents();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                if (ke.isControlDown() && ke.isShiftDown() && ke.getKeyCode() == 117) {
                    Firmware_Updater.this.SAV_mode();
                    return true;
                }
                return false;
            }
        });
        ImageIcon favicon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/EL-Updater-Logo512.png"));
        this.setIconImage(favicon.getImage());
        this.setTitle("Elinchrom Updater " + EL_Updater_Main.EL_Updater_Version);
        this.setLocationRelativeTo(null);
        this.logo_label.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/elinchrom_logo_transparent_no_flag.png")));
        this.is_skyport_unit = this.is_skyport_unit;
        if (EL_Updater_Main.plugged_hid_unit != null && EL_Updater_Main.plugged_hid_unit.getFirmware_type() == 0) {
            String img_file_name = EL_Updater_Main.plugged_hid_unit.getImage_URL().replace("%20", " ");
            ImageIcon img = new ImageIcon(Identifiers.ELINCHROM_LOCAL_FOLDER + img_file_name);
            ImageIcon scaled_img = new ImageIcon(img.getImage().getScaledInstance(256, 256, 4));
            this.set_gui_unit_info(EL_Updater_Main.plugged_hid_unit.getModel_full_name(), EL_Updater_Main.plugged_hid_unit.getApplication_Rev(), scaled_img);
            if (this.mUpdaterContext.mUpdaterCore.check_new_firmware_available(null, null, EL_Updater_Main.plugged_hid_unit) == 1) {
                JOptionPane.showMessageDialog(null, "There is a new firmware available for your unit. \n Release notes: \n " + EL_Updater_Main.new_firmware.getRelease_notes());
                this.draw_fw_buttons(EL_Updater_Main.new_firmware, false);
            } else {
                JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("fw_update_msg") + EL_Updater_Main.plugged_hid_unit.getModel_full_name() + " " + EL_Updater_Main.labels.getString("update_ok_msg"), EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
            }
        } else if (EL_Updater_Main.plugged_elsp_hs != null) {
            String img_file_name = EL_Updater_Main.plugged_elsp_hs.getImage_URL().replace("%20", " ");
            ImageIcon img = new ImageIcon(Identifiers.ELINCHROM_LOCAL_FOLDER + img_file_name);
            ImageIcon scaled_img = new ImageIcon(img.getImage().getScaledInstance(256, 256, 4));
            this.set_gui_unit_info(EL_Updater_Main.plugged_elsp_hs.getModel_full_name(), EL_Updater_Main.plugged_elsp_hs.getApplication_Rev(), scaled_img);
            int check_update = this.mUpdaterContext.mUpdaterCore.check_new_firmware_available(EL_Updater_Main.plugged_elsp_hs, null, null);
            block0 : switch (check_update) {
                case 2: {
                    Object[] update_choices = new String[]{"I read the instructions, proceed with update", "Exit"};
                    int reply = JOptionPane.showOptionDialog(null, new MessageWithLink("Our system detected that your unit needs a \n VERY IMPORTANT firmware update. BEFORE updating, please read the instructions on <a href=\"http://www.elinchrom.ch/data/download/elskyportinvisibledata/firmware_usb/update_instructions.pdf\">Elinchrom Website</a>"), "Warning", 0, 2, null, update_choices, "");
                    switch (reply) {
                        case 0: {
                            this.draw_fw_buttons(EL_Updater_Main.new_firmware, true);
                            break block0;
                        }
                        case 1: {
                            JOptionPane.showMessageDialog(null, "The system will now exit. If you want to update your unit you will have to restart EL_Updater");
                            System.exit(0);
                        }
                        case -1: {
                            JOptionPane.showMessageDialog(null, "The system will now exit. If you want to update your unit you will have to restart EL_Updater");
                            System.exit(0);
                        }
                    }
                    break;
                }
                case 0: {
                    JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("fw_update_msg") + EL_Updater_Main.plugged_elsp_hs.getModel_full_name() + " " + EL_Updater_Main.labels.getString("update_ok_msg"), EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
                    break;
                }
                case 1: {
                    JOptionPane.showMessageDialog(null, "There is a new firmware available for your unit. \n Release notes: \n " + EL_Updater_Main.new_firmware.getRelease_notes());
                    this.draw_fw_buttons(EL_Updater_Main.new_firmware, false);
                }
            }
        } else if (EL_Updater_Main.skyport_unit_to_update != null) {
            String model = EL_Updater_Main.get_unit_name((byte)EL_Updater_Main.skyport_unit_to_update.getProduct_id());
            EL_Updater_Main.skyport_unit_to_update.setModel_full_name(model);
            Unit_Prototype_Json temp = (Unit_Prototype_Json)Skyport_Module.elinchrom_units_prototypes.get(EL_Updater_Main.skyport_unit_to_update.getProduct_id());
            EL_Updater_Main.skyport_unit_to_update.setImage_URL(temp.getImage_URL());
            String img_file_name = EL_Updater_Main.skyport_unit_to_update.getImage_URL().replace("%20", " ");
            ImageIcon img = new ImageIcon(Identifiers.ELINCHROM_LOCAL_FOLDER + img_file_name);
            ImageIcon scaled_img = new ImageIcon(img.getImage().getScaledInstance(256, 256, 4));
            this.set_gui_unit_info(model, EL_Updater_Main.skyport_unit_to_update.getVersion().toString(), scaled_img);
            if (this.mUpdaterContext.mUpdaterCore.check_new_firmware_available(null, EL_Updater_Main.skyport_unit_to_update, null) == 1) {
                JOptionPane.showMessageDialog(null, "There is a new firmware available for your unit. \n Release notes: \n " + EL_Updater_Main.new_firmware.getRelease_notes());
                String versionToWrite = this.mUpdaterContext.mUpdateTaskQueue.isEmpty() ? EL_Updater_Main.new_firmware.getRevision() : this.mUpdaterContext.mUpdateTaskQueue.getFirst().mFirmwareInfo.getRevision();
                this.draw_fw_buttons(EL_Updater_Main.new_firmware, false, versionToWrite);
            } else {
                JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("fw_update_msg") + EL_Updater_Main.skyport_unit_to_update.getModel_full_name() + " " + EL_Updater_Main.labels.getString("update_ok_msg"), EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
            }
        } else {
            JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("unknown_unit"), EL_Updater_Main.labels.getString("window_title_error"), 0);
            System.exit(5468746);
        }
    }

    private void SAV_mode() {
        this.panel_available_fw.setLayout(new FlowLayout());
        if (!this.sav_mode_active) {
            String selectFirmwareLabel = "Choose Firmware";
            boolean isSkyport = false;
            if ((EL_Updater_Main.skyport_serial_manager != null || EL_Updater_Main.skyport_bluetooth != null) && EL_Updater_Main.skyport_unit_to_update != null) {
                isSkyport = true;
            }
            final boolean doSykportAction = isSkyport;
            JButton select_fw_button = new JButton(selectFirmwareLabel);
            JButton read_fw_from_unit = new JButton("Save Firmware");
            select_fw_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (doSykportAction) {
                        final JFileChooser choose_fw_file = new JFileChooser();
                        int status = choose_fw_file.showOpenDialog(Firmware_Updater.this);
                        if (status == 0) {
                            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                                @Override
                                protected Void doInBackground() {
                                    try {
                                        Skyport_Units_Update_Manager skyport_update_manager = new Skyport_Units_Update_Manager(Firmware_Updater.this.mUpdaterContext, Firmware_Updater.this.get_gui(), Firmware_Updater.this.progress_bar);
                                        skyport_update_manager.doUpdate(true, choose_fw_file.getSelectedFile().getPath());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return null;
                                }

                                @Override
                                public void done() {
                                    Firmware_Updater.this.progress_bar.setValue(0);
                                }
                            };
                            worker.execute();
                        }
                    } else {
                        final JFileChooser choose_fw_file = new JFileChooser();
                        int status = choose_fw_file.showOpenDialog(Firmware_Updater.this);
                        if (status == 0) {
                            if (EL_Updater_Main.plugged_hid_unit != null) {
                                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                                    @Override
                                    public Void doInBackground() {
                                        Firmware_Updater.this.update_elinchrom_hid_firmware(choose_fw_file.getSelectedFile().getPath(), true);
                                        return null;
                                    }

                                    @Override
                                    public void done() {
                                    }
                                };
                                worker.execute();
                            } else if (EL_Updater_Main.plugged_elsp_hs != null) {
                                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                                    @Override
                                    protected Void doInBackground() {
                                        Firmware_Updater.this.update_elsp_firmware(choose_fw_file.getSelectedFile().getPath(), true);
                                        return null;
                                    }

                                    @Override
                                    public void done() {
                                        Firmware_Updater.this.progress_bar.setValue(0);
                                    }
                                };
                                worker.execute();
                            }
                        }
                    }
                }
            });
            read_fw_from_unit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() {
                            if (EL_Updater_Main.skyport_unit_to_update != null) {
                                Skyport_Units_Update_Manager skyport_update_manager = new Skyport_Units_Update_Manager(Firmware_Updater.this.mUpdaterContext, Firmware_Updater.this.get_gui(), Firmware_Updater.this.progress_bar);
                                skyport_update_manager.ELC_read_firmware();
                            } else {
                                Firmware_Updater.this.read_firmware_from_unit();
                            }
                            return null;
                        }

                        @Override
                        public void done() {
                            Firmware_Updater.this.progress_bar.setValue(0);
                        }
                    };
                    worker.execute();
                }
            });
            this.panel_available_fw.add(select_fw_button);
            this.panel_available_fw.add(read_fw_from_unit);
            this.repaint();
            this.pack();
            this.sav_mode_active = true;
        }
    }

    private void elsp_bootloader_update(String file_name) {
        int overall_counter = 0;
        int sector_fds = 1536;
        byte[] to_send = new byte[512];
        int file_size = 0;
        this.progress_bar.setMaximum(126);
        int progress_bar_value = 0;
        HttpURLConnection conn = null;
        this.setCursor(this.waitCursor);
        try {
            Component[] in_panel = this.panel_available_fw.getComponents();
            this.disable_all_components(in_panel);
            URL url = new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + file_name);
            conn = (HttpURLConnection)url.openConnection();
            InputStream input = url.openStream();
            DataInputStream dis_elx = new DataInputStream(input);
            file_size = conn.getContentLength();
            byte[] elx_data = new byte[file_size];
            dis_elx.readFully(elx_data);
            dis_elx.close();
            this.system_info_area.append("Starting update.\n");
            this.system_info_area.append("DO NOT UNPLUG THE USB!\n");
            for (int i = 0; i < 126; ++i) {
                int counter = 0;
                int end_index = 512 * i + 512;
                for (int j = 512 * i; j < end_index; ++j) {
                    to_send[counter] = elx_data[overall_counter];
                    ++counter;
                    ++overall_counter;
                }
                int write_ok = Elinchrom_Utils.isWindows() ? Jni_windows_functions.update_firmware(to_send, sector_fds, EL_Updater_Main.elsp_drive_id) : Jni_macosx_functions.update_firmware(to_send, sector_fds, "NA");
                if (write_ok <= 0 && i < 125) {
                    JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("update_error_msg"), "Error", 0);
                    System.exit(0);
                }
                ++sector_fds;
                this.progress_bar.setValue(++progress_bar_value);
            }
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    private void initComponents() {
        this.progress_bar = new JProgressBar();
        this.unit_info_panel = new JPanel();
        this.model_label = new JLabel();
        this.fw_rev_label = new JLabel();
        this.model_text_field = new JTextField();
        this.fw_text_field = new JTextField();
        this.img_label = new JLabel();
        this.panel_available_fw = new JPanel();
        this.system_info_panel = new JPanel();
        this.scroll_pane_info_area = new JScrollPane();
        this.system_info_area = new JTextArea();
        this.logo_label = new JLabel();
        this.help_button = new JButton();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.progress_bar.setForeground(new Color(51, 255, 51));
        this.progress_bar.setToolTipText("");
        this.progress_bar.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.unit_info_panel.setBorder(BorderFactory.createTitledBorder("Connected Unit"));
        this.model_label.setText("Model");
        this.fw_rev_label.setText("Fw rev");
        this.model_text_field.setEditable(false);
        this.fw_text_field.setEditable(false);
        GroupLayout unit_info_panelLayout = new GroupLayout(this.unit_info_panel);
        this.unit_info_panel.setLayout(unit_info_panelLayout);
        unit_info_panelLayout.setHorizontalGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unit_info_panelLayout.createSequentialGroup().addContainerGap().addGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.model_label, -1, -1, Short.MAX_VALUE).addComponent(this.fw_rev_label, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.model_text_field, -1, 150, Short.MAX_VALUE).addComponent(this.fw_text_field)).addContainerGap(-1, Short.MAX_VALUE)));
        unit_info_panelLayout.setVerticalGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unit_info_panelLayout.createSequentialGroup().addContainerGap().addGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.model_label).addComponent(this.model_text_field, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(unit_info_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fw_text_field, -2, -1, -2).addComponent(this.fw_rev_label)).addContainerGap(-1, Short.MAX_VALUE)));
        this.img_label.setPreferredSize(new Dimension(256, 256));
        this.panel_available_fw.setBorder(BorderFactory.createTitledBorder("Available firmware revisions (click to update)"));
        GroupLayout panel_available_fwLayout = new GroupLayout(this.panel_available_fw);
        this.panel_available_fw.setLayout(panel_available_fwLayout);
        panel_available_fwLayout.setHorizontalGroup(panel_available_fwLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 293, Short.MAX_VALUE));
        panel_available_fwLayout.setVerticalGroup(panel_available_fwLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 34, Short.MAX_VALUE));
        this.system_info_panel.setBorder(BorderFactory.createTitledBorder("System information"));
        this.system_info_area.setEditable(false);
        this.system_info_area.setColumns(20);
        this.system_info_area.setRows(5);
        this.scroll_pane_info_area.setViewportView(this.system_info_area);
        GroupLayout system_info_panelLayout = new GroupLayout(this.system_info_panel);
        this.system_info_panel.setLayout(system_info_panelLayout);
        system_info_panelLayout.setHorizontalGroup(system_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll_pane_info_area, GroupLayout.Alignment.TRAILING));
        system_info_panelLayout.setVerticalGroup(system_info_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll_pane_info_area, -1, 107, Short.MAX_VALUE));
        this.help_button.setText("?");
        this.help_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Firmware_Updater.this.help_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panel_available_fw, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.unit_info_panel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.system_info_panel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progress_bar, -1, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(64, 64, 64).addComponent(this.img_label, -2, 256, -2)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logo_label, -2, 355, -2))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.help_button)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.unit_info_panel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panel_available_fw, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.system_info_panel, -2, -1, -2).addGap(27, 27, 27).addComponent(this.progress_bar, -2, 25, -2)).addGroup(layout.createSequentialGroup().addComponent(this.help_button).addGap(2, 2, 2).addComponent(this.img_label, -2, 256, -2).addGap(33, 33, 33).addComponent(this.logo_label, -2, 66, -2))).addContainerGap(18, Short.MAX_VALUE)));
        this.pack();
    }

    private void help_buttonActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URL(Identifiers.USAGE_GUIDE_URL).toURI());
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (URISyntaxException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    private void update_elsp_firmware(String file_name, boolean local_update) {
        int overall_counter = 0;
        int sector_fds = 1536;
        int sector_fif = 2048;
        byte[] to_send = new byte[512];
        int file_size = 0;
        HttpURLConnection conn = null;
        if (EL_Updater_Main.plugged_elsp_hs.getProduct_id() == 201) {
            this.progress_bar.setMaximum(126);
        } else {
            this.progress_bar.setMaximum(254);
        }
        int progress_bar_value = 0;
        this.setCursor(this.waitCursor);
        try {
            int write_ok;
            int j;
            int end_index;
            int counter;
            DataInputStream dis_elx;
            Component[] in_panel = this.panel_available_fw.getComponents();
            this.disable_all_components(in_panel);
            if (local_update) {
                File f2 = new File(file_name);
                FileInputStream in = new FileInputStream(new File(file_name));
                dis_elx = new DataInputStream(in);
                file_size = (int)f2.length();
            } else {
                URL url = new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + file_name);
                conn = (HttpURLConnection)url.openConnection();
                InputStream input = url.openStream();
                dis_elx = new DataInputStream(input);
                file_size = conn.getContentLength();
            }
            if (file_size != 130048 && file_size != 64512) {
                JOptionPane.showMessageDialog(null, "Attention! The firmware file is corrupted. Aborting update", "Error", 0);
                return;
            }
            byte[] elx_data = new byte[file_size];
            dis_elx.readFully(elx_data);
            dis_elx.close();
            this.system_info_area.append("Update in progress...\n");
            if (EL_Updater_Main.plugged_elsp_hs.getProduct_id() != 201) {
                for (int i = 0; i < 128; ++i) {
                    counter = 0;
                    end_index = 512 * i + 512;
                    for (j = 512 * i; j < end_index; ++j) {
                        to_send[counter] = elx_data[overall_counter];
                        ++counter;
                        ++overall_counter;
                    }
                    write_ok = Elinchrom_Utils.isWindows() ? Jni_windows_functions.update_firmware(to_send, sector_fif, EL_Updater_Main.elsp_drive_id) : Jni_macosx_functions.update_firmware(to_send, sector_fif, "NA");
                    if (write_ok <= 0) {
                        JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("update_error_msg"), "Error", 0);
                        System.exit(0);
                    }
                    ++sector_fif;
                    this.progress_bar.setValue(++progress_bar_value);
                }
                this.system_info_area.append("Ongoing update...\n");
            }
            for (int i = 0; i < 126; ++i) {
                counter = 0;
                end_index = 512 * i + 512;
                if (i == 120) {
                    this.system_info_area.append("Closing update\n");
                    this.system_info_area.append("Do not unplug USB...\n");
                }
                for (j = 512 * i; j < end_index; ++j) {
                    to_send[counter] = elx_data[overall_counter];
                    ++counter;
                    ++overall_counter;
                }
                write_ok = Elinchrom_Utils.isWindows() ? Jni_windows_functions.update_firmware(to_send, sector_fds, EL_Updater_Main.elsp_drive_id) : Jni_macosx_functions.update_firmware(to_send, sector_fds, "NA");
                if (write_ok <= 0 && i < 125) {
                    JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("update_error_msg"), "Error", 0);
                    System.exit(0);
                }
                ++sector_fds;
                this.progress_bar.setValue(++progress_bar_value);
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
                System.err.println("Error " + ex.toString());
            }
            this.system_info_area.append("Update completed! \n");
            this.progress_bar.setValue(0);
            this.enable_all_components(in_panel);
            JOptionPane.showMessageDialog(null, "The firmware of your " + this.model_text_field.getText() + " is up to date.", EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
            System.exit(0);
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    private boolean verify_firmware() {
        int i;
        boolean is_fw_ok = true;
        byte[] rx_packet = new byte[Skyport_Module.BUFFER_SIZE];
        byte[] address_to_send = new byte[4];
        byte[] packet_to_send = new byte[Skyport_Module.BUFFER_SIZE];
        long end_address = Long.parseLong(EL_Updater_Main.plugged_hid_unit.getApp_End_Address(), 16);
        long start_address = Long.parseLong(EL_Updater_Main.plugged_hid_unit.getApp_Start_Address(), 16);
        for (i = 0; i < Skyport_Module.BUFFER_SIZE; ++i) {
            packet_to_send[i] = 0;
        }
        this.progress_bar.setMaximum(this.firmware_to_file.size());
        for (i = 0; i < this.firmware_to_file.size(); ++i) {
            long decrypted_address;
            byte rowSize;
            Firmware_Data current = this.firmware_to_file.get(i);
            address_to_send = current.getAddress();
            this.progress_bar.setValue(i);
            if (Platform.isWindows()) {
                packet_to_send[0] = 0;
                packet_to_send[1] = HID_Bootloader_Commands.READ_DATA;
                packet_to_send[2] = address_to_send[3];
                packet_to_send[3] = address_to_send[2];
                packet_to_send[4] = address_to_send[1];
                packet_to_send[5] = address_to_send[0];
                if (i != this.firmware_to_file.size() - 1) {
                    packet_to_send[6] = rowSize = EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet();
                } else {
                    decrypted_address = Functions.get_crypted_address(Hex.encodeHexString(current.getAddress()), EL_Updater_Main.plugged_hid_unit.getProduct_id());
                    packet_to_send[6] = rowSize = (byte)((end_address - decrypted_address + 1L) * (long)EL_Updater_Main.plugged_hid_unit.getBytes_Per_Addr());
                }
            } else {
                packet_to_send[0] = HID_Bootloader_Commands.READ_DATA;
                packet_to_send[1] = address_to_send[3];
                packet_to_send[2] = address_to_send[2];
                packet_to_send[3] = address_to_send[1];
                packet_to_send[4] = address_to_send[0];
                if (i != this.firmware_to_file.size() - 1) {
                    packet_to_send[5] = rowSize = EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet();
                } else {
                    decrypted_address = Functions.get_crypted_address(Hex.encodeHexString(current.getAddress()), EL_Updater_Main.plugged_hid_unit.getProduct_id());
                    packet_to_send[5] = rowSize = (byte)((end_address - decrypted_address + 1L) * (long)EL_Updater_Main.plugged_hid_unit.getBytes_Per_Addr());
                }
            }
            int val = EL_Updater_Main.plugged_hid_unit.getHidDevice().write(packet_to_send, Skyport_Module.BUFFER_SIZE, (byte)0);
            int countBytes = EL_Updater_Main.plugged_hid_unit.getHidDevice().read(rx_packet, 150);
            if (countBytes < rowSize + 6) {
                System.err.println(EL_Updater_Main.plugged_hid_unit.getHidDevice().getLastErrorMessage());
            }
            this.manage_verify_page(rx_packet, rowSize);
            start_address += (long)(EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet() / EL_Updater_Main.plugged_hid_unit.getBytes_Per_Addr());
        }
        for (i = 0; i < this.firmware_to_verify.size(); ++i) {
            String unit_fw = Hex.encodeHexString(this.firmware_to_verify.get(i).getData());
            String file_fw = Hex.encodeHexString(this.firmware_to_file.get(i).getData());
            if (i == this.firmware_to_verify.size() - 1) {
                unit_fw = unit_fw.substring(0, this.firmware_to_verify.get(i).getData_size());
                file_fw = file_fw.substring(0, this.firmware_to_file.get(i).getData_size());
            }
            if (unit_fw.equals(file_fw)) continue;
            is_fw_ok = false;
        }
        this.firmware_to_verify.clear();
        this.firmware_to_file.clear();
        return is_fw_ok;
    }

    private void disable_all_components(Component[] comps) {
        for (Component comp : comps) {
            comp.setEnabled(false);
        }
    }

    private void enable_all_components(Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(true);
        }
        this.panel_available_fw.enable(true);
        this.panel_available_fw.setEnabled(true);
    }

    private byte[] read_firmware_page(byte[] address_to_read, byte size_to_read) {
        byte[] message = new byte[Skyport_Module.BUFFER_SIZE];
        for (int i = 0; i < Skyport_Module.BUFFER_SIZE; ++i) {
            message[i] = 0;
        }
        if (Platform.isWindows()) {
            message[0] = 0;
            message[1] = HID_Bootloader_Commands.READ_DATA;
            message[2] = address_to_read[3];
            message[3] = address_to_read[2];
            message[4] = address_to_read[1];
            message[5] = address_to_read[0];
            message[6] = size_to_read;
        } else {
            message[0] = HID_Bootloader_Commands.READ_DATA;
            message[1] = address_to_read[3];
            message[2] = address_to_read[2];
            message[3] = address_to_read[1];
            message[4] = address_to_read[0];
            message[5] = size_to_read;
        }
        int val = EL_Updater_Main.plugged_hid_unit.getHidDevice().write(message, Skyport_Module.BUFFER_SIZE, (byte)0);
        if (val == -1) {
            System.err.println(EL_Updater_Main.plugged_hid_unit.getHidDevice().getLastErrorMessage());
        }
        byte[] data = new byte[Skyport_Module.BUFFER_SIZE - 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0;
        }
        val = EL_Updater_Main.plugged_hid_unit.getHidDevice().read(data, 150);
        if (val < size_to_read + 6) {
            System.err.println(EL_Updater_Main.plugged_hid_unit.getHidDevice().getLastErrorMessage());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_firmware_from_unit() {
        OutputStreamWriter fw = null;
        byte[] current_address = new byte[4];
        byte[] aux_address = new byte[4];
        int progress_bar_value = 0;
        boolean all_ff = true;
        boolean last_row = false;
        byte[] data_read = new byte[Skyport_Module.BUFFER_SIZE];
        long numeric_end_address = Long.parseLong(EL_Updater_Main.plugged_hid_unit.getApp_End_Address(), 16);
        try {
            long numeric_current_address;
            JFileChooser temp = new JFileChooser();
            String header = "Elinchrom Firmware\n(c)Elinchrom Ltd 2014-2021\nID=" + EL_Updater_Main.plugged_hid_unit.getProduct_id() + "\nRev=" + EL_Updater_Main.plugged_hid_unit.getApplication_Rev() + "\n";
            String directory_name = temp.getFileSystemView().getDefaultDirectory().toString();
            File firmware = new File(directory_name + "/fw_" + this.model_text_field.getText().replace(" ", "") + "_rev_" + EL_Updater_Main.plugged_hid_unit.getApplication_Rev() + ".elx");
            fw = new FileWriter(firmware.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(header);
            int progress_bar_max = (int)((numeric_end_address - numeric_current_address) / 56L);
            this.progress_bar.setMaximum(progress_bar_max);
            for (numeric_current_address = Long.parseLong(EL_Updater_Main.plugged_hid_unit.getApp_Start_Address(), 16); numeric_current_address <= numeric_end_address; numeric_current_address += 56L) {
                if (numeric_end_address - numeric_current_address + 1L < (long)EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet()) {
                    last_row = true;
                }
                long crypted_numeric_current_address = Functions.get_crypted_address(Long.toHexString(numeric_current_address), EL_Updater_Main.plugged_hid_unit.getProduct_id());
                current_address = Elinchrom_Utils.hexStringToByteArray(Long.toHexString(crypted_numeric_current_address));
                if (!last_row) {
                    data_read = this.read_firmware_page(current_address, EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet());
                } else {
                    int bytes_to_read = (int)(numeric_end_address - numeric_current_address + 1L);
                    data_read = this.read_firmware_page(current_address, (byte)bytes_to_read);
                    for (int i = bytes_to_read + 6; i < data_read.length; ++i) {
                        data_read[i] = -1;
                    }
                }
                byte cmd_id = data_read[0];
                byte[] address = Arrays.copyOfRange(data_read, 1, 5);
                byte data_length = data_read[5];
                byte[] payload = Arrays.copyOfRange(data_read, 6, data_read.length);
                for (int i = 0; i < payload.length; ++i) {
                    byte result = Functions.encrypt_payload_byte(payload[i], EL_Updater_Main.plugged_hid_unit.getProduct_id(), i);
                    if (result == -1) continue;
                    all_ff = false;
                    aux_address[0] = address[3];
                    aux_address[1] = address[2];
                    aux_address[2] = address[1];
                    aux_address[3] = address[0];
                    break;
                }
                if (!all_ff) {
                    bw.write(":" + Elinchrom_Utils.bytesToHexString(aux_address).toUpperCase() + Elinchrom_Utils.bytesToHexString(payload).toUpperCase() + ".\n");
                }
                all_ff = true;
                this.progress_bar.setValue(++progress_bar_value);
            }
            bw.close();
            JOptionPane.showMessageDialog(null, "The firmware was saved in : " + firmware.getPath());
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
            }
        }
    }

    private void update_elinchrom_hid_firmware(String file_name, boolean local_file) {
        block18: {
            final Component[] in_panel = this.panel_available_fw.getComponents();
            this.setCursor(this.waitCursor);
            try {
                int reply2;
                int test_fw_result;
                List<String> firmwareIdList;
                String fw_revision;
                String fw_id;
                String copyright;
                String file_header;
                BufferedReader br;
                this.disable_all_components(in_panel);
                if (local_file) {
                    FileInputStream in = new FileInputStream(new File(file_name));
                    br = new BufferedReader(new InputStreamReader(in));
                    file_header = br.readLine();
                    copyright = br.readLine();
                    fw_id = br.readLine();
                    fw_revision = br.readLine();
                    firmwareIdList = Arrays.asList(fw_id.replace("ID=", "").split(","));
                    fw_revision = fw_revision.replace("Rev=", "");
                    test_fw_result = Elinchrom_Utils.check_firmware_file(file_header, firmwareIdList, fw_revision);
                } else {
                    URL url = new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + file_name);
                    br = new BufferedReader(new InputStreamReader(url.openStream()));
                    file_header = br.readLine();
                    copyright = br.readLine();
                    fw_id = br.readLine();
                    fw_revision = br.readLine();
                    firmwareIdList = Arrays.asList(fw_id.replace("ID=", "").split(","));
                    fw_revision = fw_revision.replace("Rev=", "");
                    test_fw_result = Elinchrom_Utils.check_firmware_file(file_header, firmwareIdList, fw_revision);
                }
                if (test_fw_result == 1) {
                    JOptionPane.showMessageDialog(null, "The firmware file you selected is corrupted.");
                } else if (test_fw_result == 2) {
                    JOptionPane.showMessageDialog(null, "The firmware file you selected is not compatible with your unit");
                } else if (test_fw_result == 3 && (reply2 = JOptionPane.showConfirmDialog(null, "The selected firmware is older than the one currently installed on your unit. Do you want to install it on your unit?", "Warning", 0)) == 0) {
                    test_fw_result = 4;
                }
                if (test_fw_result == 4) {
                    String line;
                    EventQueue.invokeLater(() -> this.system_info_area.append("Preparing update... \n"));
                    this.firmware_to_file.clear();
                    while ((line = br.readLine()) != null) {
                        this.parse_firmware_string(line);
                    }
                    br.close();
                    EL_Updater_Main.plugged_hid_unit.erase_unit();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException reply2) {
                        // empty catch block
                    }
                    if (EL_Updater_Main.plugged_hid_unit.getProduct_id() != 56 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 60 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 70 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 199) {
                        try {
                            Thread.sleep(14000L);
                        }
                        catch (InterruptedException reply2) {
                            // empty catch block
                        }
                    }
                    EventQueue.invokeLater(() -> this.system_info_area.append("Update in progress... \n"));
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        public Void doInBackground() {
                            Firmware_Updater.this.write_firmware_to_unit();
                            return null;
                        }

                        @Override
                        public void done() {
                            Firmware_Updater.this.progress_bar.setValue(0);
                            SwingWorker<Void, Void> checker = new SwingWorker<Void, Void>(){

                                @Override
                                public Void doInBackground() {
                                    EventQueue.invokeLater(() -> Firmware_Updater.this.system_info_area.append("Ongoing update... \n"));
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (EL_Updater_Main.plugged_hid_unit.getProduct_id() != 56 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 60 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 70 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 199) {
                                        try {
                                            Thread.sleep(14000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    EventQueue.invokeLater(() -> Firmware_Updater.this.system_info_area.append("Verifying update... \n"));
                                    if (Firmware_Updater.this.verify_firmware()) {
                                        EventQueue.invokeLater(() -> Firmware_Updater.this.system_info_area.append("Update completed! \n"));
                                        byte[] packet_to_send = new byte[Skyport_Module.BUFFER_SIZE];
                                        if (Platform.isWindows()) {
                                            packet_to_send[0] = 0;
                                            packet_to_send[1] = HID_Bootloader_Commands.UPDATE_DONE;
                                        } else {
                                            packet_to_send[0] = HID_Bootloader_Commands.UPDATE_DONE;
                                        }
                                        int val = EL_Updater_Main.plugged_hid_unit.getHidDevice().write(packet_to_send, Skyport_Module.BUFFER_SIZE, (byte)0);
                                        JOptionPane.showMessageDialog(null, "The firmware of your elinchrom unit is up to date.", EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
                                    } else {
                                        EL_Updater_Main.plugged_hid_unit.erase_unit();
                                        JOptionPane.showMessageDialog(null, "Verify fail, please retry updating the firmware. The update has been stopped", "Error", 0);
                                        System.exit(0);
                                    }
                                    return null;
                                }

                                @Override
                                public void done() {
                                    Firmware_Updater.this.progress_bar.setValue(0);
                                    Elinchrom_Utils.read_hid_unit_data(EL_Updater_Main.plugged_hid_unit);
                                    Firmware_Updater.this.enable_all_components(in_panel);
                                    Firmware_Updater.this.setCursor(Firmware_Updater.this.defaultCursor);
                                    Firmware_Updater.this.set_gui_unit_version(EL_Updater_Main.plugged_hid_unit.getApplication_Rev());
                                }
                            };
                            checker.execute();
                        }
                    };
                    worker.execute();
                    break block18;
                }
                this.enable_all_components(in_panel);
                this.setCursor(this.defaultCursor);
            }
            catch (MalformedURLException ex) {
                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
            }
            catch (IOException ex) {
                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
            }
            catch (HidException hidException) {
                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)hidException);
            }
        }
    }

    private void parse_firmware_string(String current_fw_line) {
        try {
            char[] to_convert = new char[EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet()];
            if (!current_fw_line.substring(0, 1).equals(":") || !current_fw_line.substring(current_fw_line.length() - 1, current_fw_line.length()).equals(".")) {
                JOptionPane.showMessageDialog(null, EL_Updater_Main.labels.getString("fw_corrupted_msg"));
            }
            current_fw_line = current_fw_line.substring(1, current_fw_line.length() - 1);
            to_convert = current_fw_line.toCharArray();
            this.save_firmware_page(Hex.decodeHex(to_convert));
        }
        catch (DecoderException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    private void manage_verify_page(byte[] message, byte rowSize) {
        Firmware_Data memory_page = new Firmware_Data();
        memory_page.setCommand((byte)0);
        byte[] address = Arrays.copyOfRange(message, 1, 5);
        ArrayUtils.reverse(address);
        memory_page.setAddress(address);
        memory_page.setData_size(rowSize);
        memory_page.setData(Arrays.copyOfRange(message, 6, EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet() + 6));
        this.firmware_to_verify.add(memory_page);
    }

    private void save_firmware_page(byte[] message) {
        Firmware_Data memory_page = new Firmware_Data();
        memory_page.setAddress(Arrays.copyOfRange(message, 0, 4));
        memory_page.setData(Arrays.copyOfRange(message, 4, message.length));
        this.firmware_to_file.add(memory_page);
    }

    private void write_firmware_to_unit() {
        int i;
        byte[] data_to_send = new byte[EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet()];
        byte[] address_to_send = new byte[4];
        byte[] packet_to_send = new byte[Skyport_Module.BUFFER_SIZE];
        long end_address = Long.parseLong(EL_Updater_Main.plugged_hid_unit.getApp_End_Address(), 16);
        this.progress_bar.setMaximum(this.firmware_to_file.size());
        for (i = 0; i < Skyport_Module.BUFFER_SIZE; ++i) {
            packet_to_send[i] = 0;
        }
        for (i = 0; i < this.firmware_to_file.size(); ++i) {
            int j;
            byte last_row_num_bytes;
            int j2;
            Firmware_Data current = this.firmware_to_file.get(i);
            address_to_send = current.getAddress();
            data_to_send = current.getData();
            if (Platform.isWindows()) {
                packet_to_send[0] = 0;
                packet_to_send[1] = HID_Bootloader_Commands.PROGRAM_DEVICE;
                packet_to_send[2] = address_to_send[3];
                packet_to_send[3] = address_to_send[2];
                packet_to_send[4] = address_to_send[1];
                packet_to_send[5] = address_to_send[0];
                if (i != this.firmware_to_file.size() - 1) {
                    current.setData_size(EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet());
                    packet_to_send[6] = EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet();
                    for (j2 = 0; j2 < EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet(); ++j2) {
                        packet_to_send[j2 + 7] = data_to_send[j2];
                    }
                } else {
                    long decrypted_address = Functions.get_crypted_address(Hex.encodeHexString(current.getAddress()), EL_Updater_Main.plugged_hid_unit.getProduct_id());
                    last_row_num_bytes = (byte)((end_address - decrypted_address + 1L) * (long)EL_Updater_Main.plugged_hid_unit.getBytes_Per_Addr());
                    current.setData_size(last_row_num_bytes);
                    packet_to_send[6] = last_row_num_bytes;
                    for (j = 0; j < EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet(); ++j) {
                        packet_to_send[j + 7] = data_to_send[j];
                    }
                }
            } else {
                packet_to_send[0] = HID_Bootloader_Commands.PROGRAM_DEVICE;
                packet_to_send[1] = address_to_send[3];
                packet_to_send[2] = address_to_send[2];
                packet_to_send[3] = address_to_send[1];
                packet_to_send[4] = address_to_send[0];
                if (i != this.firmware_to_file.size() - 1) {
                    current.setData_size(EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet());
                    packet_to_send[5] = EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet();
                    for (j2 = 0; j2 < EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet(); ++j2) {
                        packet_to_send[j2 + 6] = data_to_send[j2];
                    }
                } else {
                    long decrypted_address = Functions.get_crypted_address(Hex.encodeHexString(current.getAddress()), EL_Updater_Main.plugged_hid_unit.getProduct_id());
                    last_row_num_bytes = (byte)((end_address - decrypted_address + 1L) * (long)EL_Updater_Main.plugged_hid_unit.getBytes_Per_Addr());
                    current.setData_size(last_row_num_bytes);
                    packet_to_send[5] = last_row_num_bytes;
                    for (j = 0; j < EL_Updater_Main.plugged_hid_unit.getSize_Data_Packet(); ++j) {
                        packet_to_send[j + 6] = data_to_send[j];
                    }
                }
            }
            if (EL_Updater_Main.plugged_hid_unit.getProduct_id() != 56 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 60 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 70 && EL_Updater_Main.plugged_hid_unit.getProduct_id() != 199) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException decrypted_address) {
                    // empty catch block
                }
            }
            int val = EL_Updater_Main.plugged_hid_unit.getHidDevice().write(packet_to_send, Skyport_Module.BUFFER_SIZE, (byte)0);
            for (int j3 = 0; j3 < Skyport_Module.BUFFER_SIZE; ++j3) {
                packet_to_send[j3] = 0;
            }
            this.progress_bar.setValue(i);
        }
    }

    public JFrame get_gui() {
        return this;
    }

    private void draw_fw_buttons(Firmware_on_website fw_info, boolean update_bootloader) {
        this.draw_fw_buttons(fw_info, update_bootloader, fw_info.getRevision());
    }

    private void draw_fw_buttons(Firmware_on_website fw_info, final boolean update_bootloader, String versionToWrite) {
        this.panel_available_fw.setLayout(new FlowLayout());
        final Component[] in_panel = this.panel_available_fw.getComponents();
        JButton to_add = new JButton();
        if (update_bootloader) {
            this.fw_text_field.setText("");
            to_add.setText("UPDATE " + fw_info.getBootloaderRev());
            to_add.setActionCommand(fw_info.getBootloaderFileName());
            this.panel_available_fw.add(to_add);
        } else if (!update_bootloader) {
            JButton release_notes_button = new JButton("Notes");
            release_notes_button.setActionCommand(fw_info.getNotesURL());
            release_notes_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (Firmware_Updater.this.is_skyport_unit) {
                            Desktop.getDesktop().browse(new URL(Identifiers.ELINCHROM_SKYPORT_DEVICES_INFO_URL + evt.getActionCommand()).toURI());
                        } else {
                            Desktop.getDesktop().browse(new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + evt.getActionCommand()).toURI());
                        }
                    }
                    catch (IOException ex) {
                        LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
                    }
                    catch (URISyntaxException ex) {
                        LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
                    }
                }
            });
            this.panel_available_fw.add(release_notes_button);
            to_add.setText("UPDATE " + versionToWrite);
            to_add.setActionCommand(fw_info.getFile_name());
            this.panel_available_fw.add(to_add);
        }
        to_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent evt) {
                final ActionEvent event = evt;
                if (EL_Updater_Main.plugged_hid_unit != null && EL_Updater_Main.plugged_hid_unit.getFirmware_type() == 0) {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        public Void doInBackground() {
                            Firmware_Updater.this.update_elinchrom_hid_firmware(evt.getActionCommand().toLowerCase(), false);
                            return null;
                        }

                        @Override
                        public void done() {
                        }
                    };
                    worker.execute();
                } else if (EL_Updater_Main.skyport_unit_to_update != null && !update_bootloader) {
                    Firmware_Updater.this.disable_all_components(Firmware_Updater.this.panel_available_fw.getComponents());
                    Skyport_Units_Update_Manager skyport_update_manager = new Skyport_Units_Update_Manager(Firmware_Updater.this.mUpdaterContext, Firmware_Updater.this.get_gui(), Firmware_Updater.this.progress_bar);
                    skyport_update_manager.execute();
                } else {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        public Void doInBackground() {
                            Firmware_Updater.this.disable_all_components(in_panel);
                            if (!update_bootloader && !Firmware_Updater.this.is_skyport_unit) {
                                Firmware_Updater.this.update_elsp_firmware(event.getActionCommand().toLowerCase(), false);
                            } else if (update_bootloader) {
                                Firmware_Updater.this.elsp_bootloader_update(event.getActionCommand().toLowerCase());
                            }
                            return null;
                        }

                        @Override
                        public void done() {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ex) {
                                LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
                            }
                            if (!update_bootloader) {
                                Firmware_Updater.this.system_info_area.append("Update completed! \n");
                                Firmware_Updater.this.progress_bar.setValue(0);
                                Firmware_Updater.this.enable_all_components(in_panel);
                                JOptionPane.showMessageDialog(null, "The firmware of your " + Firmware_Updater.this.model_text_field.getText() + " is up to date.", EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
                                System.exit(0);
                            } else {
                                Firmware_Updater.this.progress_bar.setValue(0);
                                Firmware_Updater.this.enable_all_components(in_panel);
                                JOptionPane.showMessageDialog(null, "Step 1 completed. Unplug the USB, switch ON the unit, then replug the USB and restart the EL_Updater", "Step 1 completed", 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/warning.png")));
                                System.exit(0);
                            }
                        }
                    };
                    worker.execute();
                }
            }
        });
    }

    private void set_gui_unit_info(String model_text, String fw_revision, ImageIcon image) {
        this.model_text_field.setText(model_text);
        this.fw_text_field.setText(fw_revision);
        this.img_label.setIcon(image);
    }

    private void set_gui_unit_version(String fw_revision) {
        this.fw_text_field.setText(fw_revision);
    }
}

