/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.gui;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.logging.LogWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private int duration;
    private LogWrapper logger = LogWrapper.getLogger(this.getClass().getName());

    public SplashScreen(int d) {
        this.duration = d;
    }

    public void showSplash() {
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.white);
        int width = 450;
        int height = 115;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x2 = (screen.width - width) / 2;
        int y2 = (screen.height - height) / 2;
        this.setBounds(x2, y2, width, height);
        JLabel label = new JLabel("", 0);
        label.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/elinchrom_logo_transparent_no_flag.png")));
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, new File("img/Muli-Bold.ttf")));
        }
        catch (FontFormatException | IOException ge) {
            // empty catch block
        }
        JLabel copyrt = new JLabel("Copyright 2021, Elinchrom SA, Version " + EL_Updater_Main.EL_Updater_Version, 0);
        copyrt.setFont(new Font("Muli", 1, 12));
        content.add((Component)label, "Center");
        content.add((Component)copyrt, "South");
        Color oraRed = new Color(156, 255, 255, 255);
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.setVisible(true);
    }

    private String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return "Unknown Computer";
    }

    private void updateImage() {
        try {
            File file = new File("src/main/resources/img/splashscreen.png");
            if (!file.exists()) {
                return;
            }
            this.logger.activity("Update " + file.getAbsolutePath());
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g2 = image.createGraphics();
            this.paint(g2);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
            }
            catch (IOException e) {
                this.logger.error("An error occurred while writting splashscreen file", e);
            }
        }
        catch (Exception e) {
            this.logger.error("An error occurred while updating splashscreen file", e);
        }
    }

    public void showSplashAndExit() {
        this.showSplash();
    }
}

