/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.usb_skyport_manager;

import ch.elinchrom.ConcurrentQueue;
import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.gui.Skyport_USB_Scan;
import ch.elinchrom.logging.LogWrapper;
import ch.elinchrom.usb_skyport_manager.ELInterface;
import ch.elinchrom.usb_skyport_manager.EL_commands;
import ch.elinchrom.usb_skyport_manager.Skyport_Units_Update_Manager;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.swing.JProgressBar;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class Serial_Port_Manager
implements SerialPortEventListener,
ELInterface {
    public static final int BASIC_PORT_SPEED = 9600;
    private final int TIME_OUT = 2000;
    private SerialPort serialPort;
    private OutputStream outStream;
    private InputStream inStream;
    private boolean update_in_progress = false;
    private String pending_rx_packet = "";
    private String last_rx_string = "";
    private Skyport_Units_Update_Manager manager = null;
    protected int mPacketSize = 54;
    protected ConcurrentQueue mConcurrentQueue = new ConcurrentQueue();

    public SerialPort open_port(String port_id, int baudRate) {
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(port_id);
            this.serialPort = portId.open("ELSkyportLibrary", 2000);
            this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
            this.serialPort.setFlowControlMode(0);
            this.inStream = this.serialPort.getInputStream();
            this.outStream = this.serialPort.getOutputStream();
            this.serialPort.addEventListener(this);
            this.serialPort.notifyOnDataAvailable(true);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return this.serialPort;
    }

    public void set_update_in_progress(boolean update) {
        this.update_in_progress = update;
    }

    public void set_last_rx_string(String last_rx) {
        this.last_rx_string = last_rx;
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void close() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
    }

    @Override
    public void serialEvent(SerialPortEvent oEvent) {
        this.onEventReceived(oEvent);
    }

    public void build_and_send_command(String command) {
        try {
            String command_clean = command.replace("$", "");
            if (command.contains("61")) {
                // empty if block
            }
            this.getOutputStream().write(Hex.decodeHex(command_clean.toCharArray()));
            this.getOutputStream().flush();
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Serial_Port_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (DecoderException ex) {
            LogWrapper.getLogger(Serial_Port_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    public void wait_timer(int milliseconds) {
        long currentTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() < currentTime + (long)milliseconds) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void set_old_unit_address(String serial_number, String new_address) {
        String command = EL_commands.EL_Conf_Unit_single + serial_number + EL_commands.EL_a_command + new_address;
        for (int i = 0; i < 2; ++i) {
            this.build_and_send_command(command);
            this.wait_timer(700);
        }
    }

    public void set_old_channel(Serial_Port_Manager ELSkyport, String chan) {
        String oldFreq = EL_commands.EL_Conf_USB + EL_commands.EL_S_command + chan + EL_commands.EL_normal_mode;
        this.build_and_send_command(oldFreq);
        this.wait_timer(200);
    }

    public void set_new_channel(String channel) {
        String newFreq = EL_commands.EL_Conf_USB + EL_commands.EL_S_command + channel + EL_commands.EL_normal_mode + EL_commands.EL_data_mode_new;
        this.build_and_send_command(newFreq);
        this.wait_timer(200);
    }

    public void set_skyport_update_manager(Skyport_Units_Update_Manager manager) {
        this.manager = manager;
    }

    public void discover_all_units(JProgressBar progress_bar) {
        int i;
        long start_old_scan = System.currentTimeMillis();
        for (i = 0; i < 2; ++i) {
            String reset_flag = EL_commands.EL_Conf_All_Units + EL_commands.EL_x_Command + EL_commands.EL_Reset_UnitFound_Flag;
            this.build_and_send_command(reset_flag);
        }
        this.wait_timer(10);
        for (i = 0; i < 3; ++i) {
            String find_all = EL_commands.EL_Conf_All_Units + EL_commands.EL_G_command + EL_commands.EL_get_register_info;
            this.wait_timer(250);
            this.build_and_send_command(find_all);
        }
        String single_PNP = EL_commands.EL_Conf_All_Units + EL_commands.EL_G_command + EL_commands.EL_get_once_PNP_info;
        for (int i2 = 0; i2 < 3; ++i2) {
            progress_bar.setValue(progress_bar.getValue() + 1);
            this.build_and_send_command(single_PNP);
            this.wait_timer(500);
        }
        long end_old_scan = System.currentTimeMillis();
    }

    public void read_firmware_page(String skyportId, String address_to_read) {
        String toSend = EL_commands.EL_Conf_Unit_single + skyportId + "2E7200" + address_to_read;
        this.build_and_send_command(toSend);
    }

    public boolean verify_last_write(String last_sent) {
        boolean isValidated = false;
        if (!this.mConcurrentQueue.isEmpty()) {
            String queuedString = this.mConcurrentQueue.pop();
            isValidated = queuedString.substring(2, 14).equals(last_sent) && queuedString.substring(14, 16).equals("00");
        }
        return isValidated;
    }

    public boolean wait_and_verify_last_write(int milliseconds, String last_sent) {
        long currentTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() < currentTime + (long)milliseconds && this.mConcurrentQueue.isEmpty()) {
                Thread.sleep(8L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.verify_last_write(last_sent);
    }

    public boolean verify_last_transmission(String tx_address, String tx_data) {
        boolean isValidated = false;
        String rx_address = "";
        String rx_data = "";
        if (!this.mConcurrentQueue.isEmpty()) {
            String queuedString = this.mConcurrentQueue.pop();
            if (tx_address.length() > 5) {
                rx_address = queuedString.substring(14, 20);
                rx_data = queuedString.substring(20, 52);
            } else {
                rx_address = queuedString.substring(10, 14);
                rx_data = queuedString.substring(14, 46);
            }
        }
        isValidated = rx_address.equals(tx_address) && rx_data.equals(tx_data);
        return isValidated;
    }

    public boolean wait_and_verify_transmission(int milliseconds, String tx_address, String tx_data) {
        long currentTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() < currentTime + (long)milliseconds && this.mConcurrentQueue.isEmpty()) {
                Thread.sleep(8L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.verify_last_transmission(tx_address, tx_data);
    }

    @Override
    public void onEventReceived(SerialPortEvent oEvent) {
        if (oEvent.getEventType() == 1) {
            Object rx_string = "";
            try {
                if (!this.update_in_progress) {
                    this.wait_timer(50);
                }
                int availableBytes = this.getInputStream().available();
                while (availableBytes > 0) {
                    int rx = this.getInputStream().read();
                    rx_string = rx >= 16 ? (String)rx_string + Integer.toHexString(rx) : (String)rx_string + "0" + Integer.toHexString(rx);
                    availableBytes = this.getInputStream().available();
                }
                if (this.update_in_progress) {
                    if (!EL_Updater_Main.elc_erased) {
                        EL_Updater_Main.elc_erased = true;
                    }
                    this.pending_rx_packet = this.pending_rx_packet + (String)rx_string;
                    if (this.pending_rx_packet.length() == this.mPacketSize) {
                        this.mConcurrentQueue.add(this.pending_rx_packet);
                        this.pending_rx_packet = "";
                    }
                } else {
                    switch (((String)rx_string).substring(0, 2)) {
                        case "f8": {
                            break;
                        }
                        case "f9": {
                            if (((String)rx_string).substring(8, 10).equals("3a")) {
                                Skyport_USB_Scan.update_mode = true;
                                break;
                            }
                            if (((String)rx_string).substring(8, 12).equals("2e72")) {
                                Skyport_USB_Scan.update_mode = true;
                                break;
                            }
                            Skyport_USB_Scan.process_string((String)rx_string);
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Exception: " + e.toString());
            }
        }
    }
}

