/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.usb_skyport_manager;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.UpdateTask;
import ch.elinchrom.UpdaterContext;
import ch.elinchrom.info.Firmware_Data;
import ch.elinchrom.logging.LogWrapper;
import ch.elinchrom.usb_skyport_manager.EL_commands;
import ch.elinchrom.usb_skyport_manager.Serial_Port_Manager;
import elinchrom.Elinchrom_Flash_Unit;
import elinchrom.Elinchrom_Skyport_Exception;
import elinchrom.Functions;
import elinchrom.Identifiers;
import elinchrom.Skyport_Module;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class Skyport_Units_Update_Manager
extends SwingWorker {
    private static final String BIOS_LOWER_BOUND = "1A00";
    private static final String BIOS_UPPER_BOUND = "1FFF";
    private static final String BIOS_ADDRESS_OFFSET = "0800";
    private static final int MAX_PAGE_RETRANSMISSIONS = 50;
    private static final String EMPTY_FW_LINE = "5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A";
    private static final int MAX_WAIT_REPLY_TIME = 110;
    private static final int MAX_ELC_WAIT_REPLY_TIME = 110;
    private static String last_sent_addr = "";
    private static String last_sent_data = "";
    private Elinchrom_Flash_Unit unit_to_update;
    private byte microcontroller_to_update;
    private JProgressBar progress_bar;
    private JFrame gui;
    private Serial_Port_Manager serial_manager;
    private List<Firmware_Data> fw_to_write = new ArrayList<Firmware_Data>();
    private List<Firmware_Data> bios_to_write = new ArrayList<Firmware_Data>();
    private Skyport_Module skyport_bluetooth;
    protected UpdaterContext mUpdaterContext;
    protected int mProgressCounter;

    public Skyport_Units_Update_Manager(UpdaterContext updaterContext, JFrame gui, JProgressBar progress_bar) {
        this.mUpdaterContext = updaterContext;
        this.gui = gui;
        this.progress_bar = progress_bar;
        this.unit_to_update = EL_Updater_Main.skyport_unit_to_update;
        if (EL_Updater_Main.skyport_serial_manager != null) {
            this.serial_manager = EL_Updater_Main.skyport_serial_manager;
            this.serial_manager.set_update_in_progress(true);
            this.serial_manager.set_skyport_update_manager(this);
        } else {
            this.skyport_bluetooth = EL_Updater_Main.skyport_bluetooth;
        }
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return sb.toString();
    }

    public void import_unit_firmware_from_website(boolean isLocalPath, String file_name) {
        try {
            String current_line;
            BufferedReader br = null;
            if (isLocalPath) {
                FileInputStream in = new FileInputStream(new File(file_name));
                br = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.ISO_8859_1));
            } else {
                URL url = new URL(Identifiers.ELINCHROM_SKYPORT_DEVICES_INFO_URL + file_name);
                br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));
            }
            for (int i = 0; i < 5; ++i) {
                current_line = br.readLine();
            }
            while ((current_line = br.readLine()) != null) {
                if (current_line.length() <= 10 || this.parse_and_store_firmware_string(current_line)) continue;
                System.out.println("There was an error");
            }
            this.progress_bar.setMaximum(this.bios_to_write.size() + this.fw_to_write.size());
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    public void ELC_import_unit_firmware_from_website(boolean isLocalPath, String file_name, List<Firmware_Data> firmwareBinary) {
        try {
            String current_line;
            BufferedReader br = null;
            if (isLocalPath) {
                FileInputStream in = new FileInputStream(new File(file_name));
                br = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.ISO_8859_1));
            } else {
                URL url = new URL(Identifiers.ELINCHROM_SKYPORT_DEVICES_INFO_URL + file_name);
                br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));
            }
            for (int i = 0; i < 5; ++i) {
                current_line = br.readLine();
                if (current_line.contains("MCUID")) {
                    String MC_ID = current_line.split("_")[1];
                    int n = Integer.parseInt(MC_ID.substring(5));
                }
                current_line = "";
            }
            while ((current_line = br.readLine()) != null) {
                if (current_line.length() <= 10) continue;
                String line_block0 = current_line;
                String line_block1 = br.readLine();
                String line_block2 = br.readLine();
                String line_block3 = br.readLine();
                String data_to_test0 = line_block0.substring(11);
                String data_to_test1 = line_block1.substring(11);
                String data_to_test2 = line_block2.substring(11);
                String data_to_test3 = line_block3.substring(11);
                if (data_to_test0.equals(EMPTY_FW_LINE) && data_to_test1.equals(EMPTY_FW_LINE) && data_to_test2.equals(EMPTY_FW_LINE) && data_to_test3.equals(EMPTY_FW_LINE)) continue;
                if (!this.ELC_parse_and_store_firmware_string(line_block0, firmwareBinary)) {
                    System.out.println("There was an error");
                }
                if (!this.ELC_parse_and_store_firmware_string(line_block1, firmwareBinary)) {
                    System.out.println("There was an error");
                }
                if (!this.ELC_parse_and_store_firmware_string(line_block2, firmwareBinary)) {
                    System.out.println("There was an error");
                }
                if (this.ELC_parse_and_store_firmware_string(line_block3, firmwareBinary)) continue;
                System.out.println("There was an error");
            }
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    private boolean ELC_parse_and_store_firmware_string(String firmware_line, List<Firmware_Data> firmwareBinary) {
        String check_line = "";
        String addr_length = "";
        String address_low = "";
        Object complete_address = "";
        String address_high = "";
        String address_upper = "";
        String security_char = "";
        String data = "";
        Object decoded_data = "";
        Firmware_Data fw_page = new Firmware_Data();
        char[] check_char = new char[1];
        check_line = firmware_line.substring(0, 1);
        check_char = check_line.toCharArray();
        int complete_address_int = 0;
        char ascii_check = check_char[0];
        if (ascii_check != '\u009f') {
            return false;
        }
        try {
            addr_length = firmware_line.substring(1, 3);
            address_upper = this.decode(firmware_line.substring(3, 5));
            address_high = this.decode(firmware_line.substring(5, 7));
            address_low = this.decode(firmware_line.substring(7, 9));
            security_char = this.decode(firmware_line.substring(9, 11));
            complete_address = address_upper + address_high + address_low;
            complete_address_int = Integer.parseInt((String)complete_address, 16);
            complete_address = Integer.toHexString(complete_address_int);
            if (((String)complete_address).length() < 6) {
                if (complete_address_int < 16) {
                    complete_address = "00000" + (String)complete_address;
                } else if (complete_address_int < 255) {
                    complete_address = "0000" + (String)complete_address;
                } else if (complete_address_int < 4096) {
                    complete_address = "000" + (String)complete_address;
                } else if (complete_address_int < 65536) {
                    complete_address = "00" + (String)complete_address;
                } else if (complete_address_int < 0x100000) {
                    complete_address = "0" + (String)complete_address;
                }
            }
            data = firmware_line.substring(11);
            for (int i = 0; i < data.length(); i += 2) {
                decoded_data = (String)decoded_data + this.decode(data.substring(i, i + 2));
            }
            fw_page.setAddress(Hex.decodeHex(((String)complete_address).toCharArray()));
            fw_page.setData(Hex.decodeHex(((String)decoded_data).toCharArray()));
            firmwareBinary.add(fw_page);
        }
        catch (DecoderException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        return true;
    }

    private boolean parse_and_store_firmware_string(String firmware_line) {
        String check_line = "";
        String addr_length = "";
        String address_low = "";
        Object complete_address = "";
        String address_high = "";
        String security_char = "";
        String data = "";
        Object decoded_data = "";
        Firmware_Data fw_page = new Firmware_Data();
        char[] check_char = new char[1];
        check_line = firmware_line.substring(0, 1);
        check_char = check_line.toCharArray();
        int complete_address_int = 0;
        int bios_lower_bound = Integer.parseInt(BIOS_LOWER_BOUND, 16);
        char ascii_check = check_char[0];
        if (ascii_check != '\u009f') {
            return false;
        }
        try {
            addr_length = firmware_line.substring(1, 3);
            address_high = this.decode(firmware_line.substring(3, 5));
            address_low = this.decode(firmware_line.substring(5, 7));
            complete_address = address_high + address_low;
            complete_address_int = Integer.parseInt((String)complete_address, 16);
            complete_address = Integer.toHexString(complete_address_int /= 2);
            if (((String)complete_address).length() < 4) {
                if (complete_address_int < 16) {
                    complete_address = "000" + (String)complete_address;
                } else if (complete_address_int < 255) {
                    complete_address = "00" + (String)complete_address;
                } else if (complete_address_int < 4096) {
                    complete_address = "0" + (String)complete_address;
                }
            }
            security_char = this.decode(firmware_line.substring(7, 9));
            data = firmware_line.substring(9);
            for (int i = 0; i < data.length(); i += 2) {
                decoded_data = (String)decoded_data + this.decode(data.substring(i, i + 2));
            }
            fw_page.setAddress(Hex.decodeHex(((String)complete_address).toCharArray()));
            fw_page.setData(Hex.decodeHex(((String)decoded_data).toCharArray()));
            if (bios_lower_bound <= complete_address_int) {
                this.bios_to_write.add(fw_page);
            } else {
                this.fw_to_write.add(fw_page);
            }
        }
        catch (DecoderException ex) {
            LogWrapper.getLogger(Skyport_Units_Update_Manager.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        return true;
    }

    private String decode(String encoded) {
        long temp_decoded = Long.parseLong(encoded, 16) ^ Long.parseLong(EL_commands.EL_xor_key.replace("$", ""), 16);
        Object result = temp_decoded == 0L || temp_decoded < 16L ? "0" + Long.toHexString(temp_decoded) : Long.toHexString(temp_decoded);
        return result;
    }

    private String encode(String clear) {
        long temp_encoded = Long.parseLong(clear, 16) ^ Long.parseLong(EL_commands.EL_xor_key.replace("$", ""), 16);
        Object result = temp_encoded == 0L || temp_encoded < 16L ? "0" + Long.toHexString(temp_encoded) : Long.toHexString(temp_encoded);
        return result;
    }

    public void ELC_update_firmware_procedure(String microcontroller, List<Firmware_Data> firmware) throws InterruptedException {
        block26: {
            try {
                byte[] write_memory_result;
                this.gui.setCursor(new Cursor(3));
                Object encoded_data = "";
                int counter = 0;
                int fill_buffer = 0;
                Object to_send = "";
                String command_write_buffer = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_w_command + microcontroller;
                while (counter < firmware.size()) {
                    int page_retransmissions = 0;
                    boolean send_next_page = false;
                    Object command_fill_buffer = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_fill_buffer_Command + microcontroller;
                    if (fill_buffer < 4) {
                        byte[] answer_from_unit;
                        ++fill_buffer;
                        Firmware_Data aux_fw = firmware.get(counter);
                        ++counter;
                        String aux_address = Hex.encodeHexString(aux_fw.getAddress());
                        String aux_data = Hex.encodeHexString(aux_fw.getData());
                        String low_addr = this.encode(aux_address.substring(4));
                        String high_addr = this.encode(aux_address.substring(2, 4));
                        String upper_addr = this.encode(aux_address.substring(0, 2));
                        to_send = (String)to_send + low_addr + high_addr + upper_addr;
                        command_fill_buffer = (String)command_fill_buffer + low_addr + high_addr + upper_addr;
                        for (int i = 0; i < aux_data.length(); i += 2) {
                            encoded_data = (String)encoded_data + this.encode(aux_data.substring(i, i + 2));
                        }
                        to_send = (String)to_send + (String)encoded_data;
                        command_fill_buffer = (String)command_fill_buffer + (String)encoded_data;
                        last_sent_addr = low_addr + high_addr + upper_addr;
                        last_sent_data = encoded_data;
                        byte[] data_to_send = Functions.hexStringToByteArray((String)to_send);
                        to_send = "";
                        encoded_data = "";
                        command_fill_buffer = ((String)command_fill_buffer).replace("$", "");
                        this.mUpdaterContext.mUpdaterUtil.sleep(0L);
                        if (this.serial_manager != null) {
                            this.serial_manager.build_and_send_command((String)command_fill_buffer);
                            send_next_page = this.serial_manager.wait_and_verify_transmission(110, last_sent_addr, last_sent_data);
                        } else {
                            try {
                                answer_from_unit = this.skyport_bluetooth.send_firmware_page_block(this.unit_to_update, data_to_send, this.microcontroller_to_update);
                                send_next_page = this.verify_last_transmission(answer_from_unit);
                            }
                            catch (Elinchrom_Skyport_Exception i) {
                                // empty catch block
                            }
                        }
                        EventQueue.invokeLater(() -> this.progress_bar.setValue(++this.mProgressCounter));
                        while (!send_next_page) {
                            if (++page_retransmissions > 50) {
                                JOptionPane.showMessageDialog(null, "ERROR UPDATING THE FIRMWARE, data error");
                                System.exit(0);
                            }
                            this.mUpdaterContext.mUpdaterUtil.sleep(0L);
                            if (this.serial_manager != null) {
                                this.serial_manager.build_and_send_command((String)command_fill_buffer);
                                send_next_page = this.serial_manager.wait_and_verify_transmission(110, last_sent_addr, last_sent_data);
                                continue;
                            }
                            try {
                                answer_from_unit = this.skyport_bluetooth.send_firmware_page_block(this.unit_to_update, data_to_send, this.microcontroller_to_update);
                                send_next_page = this.verify_last_transmission(answer_from_unit);
                            }
                            catch (Elinchrom_Skyport_Exception i) {}
                        }
                        continue;
                    }
                    fill_buffer = 0;
                    this.mUpdaterContext.mUpdaterUtil.sleep(0L);
                    if (this.serial_manager != null) {
                        this.serial_manager.build_and_send_command(command_write_buffer);
                        send_next_page = this.serial_manager.wait_and_verify_last_write(110, command_write_buffer.substring(2).replace("$", ""));
                    } else {
                        try {
                            write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                            send_next_page = write_memory_result[8] == this.microcontroller_to_update;
                        }
                        catch (Elinchrom_Skyport_Exception i) {
                            // empty catch block
                        }
                    }
                    while (!send_next_page) {
                        if (++page_retransmissions >= 50) {
                            JOptionPane.showMessageDialog(null, "ERROR UPDATING THE FIRMWARE, write error");
                            System.exit(0);
                        }
                        this.mUpdaterContext.mUpdaterUtil.sleep(0L);
                        if (this.serial_manager != null) {
                            this.serial_manager.build_and_send_command(command_write_buffer);
                            send_next_page = this.serial_manager.wait_and_verify_last_write(110, command_write_buffer.substring(2).replace("$", ""));
                            continue;
                        }
                        try {
                            write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                            send_next_page = write_memory_result[8] == this.microcontroller_to_update;
                        }
                        catch (Elinchrom_Skyport_Exception i) {}
                    }
                }
                if (this.serial_manager != null) {
                    this.serial_manager.wait_timer(200);
                    this.serial_manager.build_and_send_command(command_write_buffer);
                    this.serial_manager.wait_timer(110);
                    this.serial_manager.build_and_send_command(command_write_buffer);
                    this.serial_manager.wait_timer(110);
                    this.serial_manager.build_and_send_command(command_write_buffer);
                    this.serial_manager.wait_timer(110);
                    this.serial_manager.build_and_send_command(command_write_buffer);
                    this.serial_manager.wait_timer(110);
                    this.serial_manager.wait_timer(200);
                    String restartCommand = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_Restart_Unit + microcontroller;
                    this.serial_manager.build_and_send_command(restartCommand);
                    break block26;
                }
                Thread.sleep(200L);
                try {
                    write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                    Thread.sleep(110L);
                    write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                    Thread.sleep(110L);
                    write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                    Thread.sleep(110L);
                    write_memory_result = this.skyport_bluetooth.ELC_send_write_memory_block_command(this.unit_to_update, this.microcontroller_to_update);
                    Thread.sleep(110L);
                }
                catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                    // empty catch block
                }
                Thread.sleep(200L);
                this.skyport_bluetooth.restart_unit(this.unit_to_update, this.microcontroller_to_update);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR UPDATING THE FIRMWARE, unknown error");
                System.exit(0);
            }
        }
    }

    private boolean verify_last_transmission_2nd_generation(byte[] reply_from_unit) {
        boolean isValidated = false;
        String data_as_string = Skyport_Units_Update_Manager.bytesToHexString(reply_from_unit);
        if (data_as_string.length() >= 50) {
            String address = data_as_string.substring(14, 18);
            String data = data_as_string.substring(18, 50);
            isValidated = last_sent_addr.equals(address) && last_sent_data.equals(data);
        }
        return isValidated;
    }

    private boolean verify_last_transmission(byte[] reply_from_unit) {
        boolean isValidated = false;
        String data_as_string = Skyport_Units_Update_Manager.bytesToHexString(reply_from_unit);
        if (data_as_string.length() >= 56) {
            String address = data_as_string.substring(18, 24);
            String data = data_as_string.substring(24, 56);
            isValidated = last_sent_addr.equals(address) && last_sent_data.equals(data);
        }
        return isValidated;
    }

    public void update_firmware_procedure(boolean is_bios_update) throws InterruptedException {
        try {
            this.gui.setCursor(new Cursor(3));
            String aux_address = "";
            String aux_data = "";
            Object command_to_send = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_w_command;
            Object update_bios_command = "";
            Object update_completed = "";
            Object sp_bluetooth_data = "";
            byte[] sp_bluetooth_data_to_send = new byte[]{};
            byte[] answer_from_unit = new byte[]{};
            Object encoded_data = "";
            boolean send_next_page = true;
            List<Object> firmware = new ArrayList();
            int aux_address_as_int = 0;
            int address_to_write = 0;
            int page_retransmissions = 0;
            int bios_address_offset = Integer.parseInt(BIOS_ADDRESS_OFFSET, 16);
            firmware = is_bios_update ? this.bios_to_write : this.fw_to_write;
            for (Firmware_Data firmware_Data : firmware) {
                aux_address = Hex.encodeHexString(firmware_Data.getAddress());
                aux_data = Hex.encodeHexString(firmware_Data.getData());
                aux_address_as_int = Integer.parseInt(aux_address, 16);
                if (is_bios_update) {
                    address_to_write = aux_address_as_int - bios_address_offset;
                    aux_address = Integer.toHexString(address_to_write);
                }
                String low_addr = this.encode(aux_address.substring(2));
                String high_addr = this.encode(aux_address.substring(0, 2));
                command_to_send = (String)command_to_send + low_addr + high_addr;
                sp_bluetooth_data = (String)sp_bluetooth_data + low_addr + high_addr;
                for (int i = 0; i < aux_data.length(); i += 2) {
                    encoded_data = (String)encoded_data + this.encode(aux_data.substring(i, i + 2));
                }
                command_to_send = (String)command_to_send + (String)encoded_data;
                sp_bluetooth_data = (String)sp_bluetooth_data + (String)encoded_data;
                last_sent_addr = low_addr + high_addr;
                last_sent_data = encoded_data;
                encoded_data = "";
                command_to_send = ((String)command_to_send).replace("$", "");
                sp_bluetooth_data_to_send = Functions.hexStringToByteArray((String)sp_bluetooth_data);
                sp_bluetooth_data = "";
                if (this.serial_manager != null) {
                    this.serial_manager.build_and_send_command((String)command_to_send);
                    send_next_page = this.serial_manager.wait_and_verify_transmission(110, last_sent_addr, last_sent_data);
                } else {
                    try {
                        answer_from_unit = this.skyport_bluetooth.write_program_memory_2nd_generation(this.unit_to_update, sp_bluetooth_data_to_send);
                        send_next_page = this.verify_last_transmission_2nd_generation(answer_from_unit);
                    }
                    catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                        // empty catch block
                    }
                }
                this.progress_bar.setValue(this.progress_bar.getValue() + 1);
                while (!send_next_page) {
                    if (++page_retransmissions >= 50) {
                        JOptionPane.showMessageDialog(null, "ERROR UPDATING THE FIRMWARE");
                        System.exit(0);
                    }
                    if (this.serial_manager != null) {
                        this.serial_manager.build_and_send_command((String)command_to_send);
                        send_next_page = this.serial_manager.wait_and_verify_transmission(110, last_sent_addr, last_sent_data);
                        continue;
                    }
                    try {
                        answer_from_unit = this.skyport_bluetooth.write_program_memory_2nd_generation(this.unit_to_update, sp_bluetooth_data_to_send);
                        send_next_page = this.verify_last_transmission_2nd_generation(answer_from_unit);
                    }
                    catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {}
                }
                page_retransmissions = 0;
                send_next_page = false;
                command_to_send = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_w_command;
            }
            if (this.serial_manager != null) {
                this.serial_manager.wait_timer(200);
            } else {
                Thread.sleep(200L);
            }
            if (is_bios_update) {
                if (this.serial_manager != null) {
                    update_bios_command = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_update_bios + EL_commands.EL_start_update_bios + "00";
                    this.serial_manager.build_and_send_command((String)update_bios_command);
                } else {
                    try {
                        answer_from_unit = this.skyport_bluetooth.start_bios_update_routine_2nd_generation(this.unit_to_update, (byte)1);
                    }
                    catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {}
                }
            } else if (this.serial_manager != null) {
                update_completed = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_update_bios + EL_commands.EL_update_completed + "00";
                this.serial_manager.build_and_send_command((String)update_completed);
            } else {
                try {
                    answer_from_unit = this.skyport_bluetooth.start_bios_update_routine_2nd_generation(this.unit_to_update, (byte)2);
                }
                catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {}
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR UPDATING THE FIRMWARE, unknown error");
            System.exit(0);
        }
    }

    protected Void doInBackground() throws Exception {
        return this.doUpdate(false, null);
    }

    public Void doUpdate(boolean isLocalPath, String localPath) throws Exception {
        switch (this.unit_to_update.getGeneration()) {
            case 0: {
                this.import_unit_firmware_from_website(isLocalPath, isLocalPath ? localPath : EL_Updater_Main.new_firmware.getFile_name());
                this.update_firmware_procedure(true);
                if (this.serial_manager != null) {
                    this.serial_manager.wait_timer(3000);
                } else {
                    Thread.sleep(3000L);
                }
                this.update_firmware_procedure(false);
            }
            case 1: {
                int progressMax = 0;
                if (isLocalPath) {
                    this.mUpdaterContext.mUpdateTaskQueue.clear();
                    if (localPath.contains("slave")) {
                        EL_Updater_Main.skyport_unit_to_update.setELC_update_slave(true);
                        this.mUpdaterContext.mUpdateTaskQueue.add(new UpdateTask(1, "01", localPath));
                    }
                    if (localPath.contains("master")) {
                        EL_Updater_Main.skyport_unit_to_update.setELC_update_master(true);
                        this.mUpdaterContext.mUpdateTaskQueue.add(new UpdateTask(0, "00", localPath));
                    }
                }
                for (UpdateTask taskToDo : this.mUpdaterContext.mUpdateTaskQueue) {
                    this.ELC_import_unit_firmware_from_website(isLocalPath, taskToDo.mFilePath, taskToDo.mFirmwareBinary);
                    progressMax += taskToDo.mFirmwareBinary.size();
                }
                for (UpdateTask taskToDo : this.mUpdaterContext.mUpdateTaskQueue) {
                    EL_Updater_Main.elc_erased = false;
                    this.microcontroller_to_update = taskToDo.mMicrocontrollerType;
                    for (int count = 0; !EL_Updater_Main.elc_erased && count < 50; ++count) {
                        this.ELC_erase_unit(taskToDo.mMicrocontroller);
                        Thread.sleep(500L);
                    }
                }
                int sleep = 15000;
                this.mProgressCounter = 0;
                this.progress_bar.setMaximum(progressMax);
                while (!this.mUpdaterContext.mUpdateTaskQueue.isEmpty()) {
                    UpdateTask task = this.mUpdaterContext.mUpdateTaskQueue.removeFirst();
                    this.microcontroller_to_update = task.mMicrocontrollerType;
                    this.ELC_update_firmware_procedure(task.mMicrocontroller, task.mFirmwareBinary);
                    Thread.sleep(sleep);
                    sleep = 1000;
                }
                break;
            }
        }
        this.gui.setCursor(new Cursor(0));
        return null;
    }

    public void ELC_read_firmware() {
        byte[] address = new byte[3];
        long numeric_current_address = Long.parseLong("6000", 16);
        long numeric_end_address = Long.parseLong("1FFFF", 16);
        int progress_bar_max = (int)((numeric_end_address - numeric_current_address) / 16L);
        this.progress_bar.setMaximum(progress_bar_max);
        JFileChooser location = new JFileChooser();
        String header = ";Elinchrom Firmware_MCUID0\n;(c) Elinchrom Ltd 2014-2021\n;elfirmware_elc_series_master_r" + this.unit_to_update.getMaster_fw_rev() + ".elx\n;ID=50,51\n;Revision= " + this.unit_to_update.getMaster_fw_rev() + "\n";
        File firmware = new File("elfirmware_elc_series_master_r" + this.unit_to_update.getMaster_fw_rev() + ".elx");
        location.setSelectedFile(firmware);
        if (location.showSaveDialog(null) == 0) {
            try {
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(location.getSelectedFile()), StandardCharsets.ISO_8859_1);
                wr.write(header);
                if (this.serial_manager != null) {
                    // empty if block
                }
                while (numeric_current_address <= numeric_end_address) {
                    long crypted_numeric_current_address = numeric_current_address ^ Long.parseLong("A5A5A5", 16);
                    String current_address_string = Long.toHexString(crypted_numeric_current_address);
                    byte[] current_address = Functions.hexStringToByteArray(current_address_string);
                    if (this.serial_manager != null) {
                        this.serial_manager.read_firmware_page(this.unit_to_update.getSkyport_id(), current_address_string);
                        continue;
                    }
                    try {
                        byte[] data_read = this.skyport_bluetooth.read_firmware_page(this.unit_to_update, current_address[2], current_address[1], current_address[0]);
                        byte[] reverse_address = Arrays.copyOfRange(data_read, 9, 12);
                        address[0] = reverse_address[2];
                        address[1] = reverse_address[1];
                        address[2] = reverse_address[0];
                        byte[] payload = Arrays.copyOfRange(data_read, 12, 28);
                        ((Writer)wr).write(159);
                        wr.write("B4" + Skyport_Units_Update_Manager.bytesToHexString(address).toUpperCase() + "A5" + Skyport_Units_Update_Manager.bytesToHexString(payload).toUpperCase() + "\n");
                        numeric_current_address += 16L;
                    }
                    catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.progress_bar.setValue(this.progress_bar.getValue() + 1);
                }
                ((Writer)wr).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private byte[] read_firmware_page(byte[] address_to_read) {
        byte[] unit_address = Functions.hexStringToByteArray(this.unit_to_update.getSkyport_id());
        byte[] to_send = new byte[]{-86, -6, unit_address[0], unit_address[1], unit_address[2], 46, 114, 0, address_to_read[2], address_to_read[1], address_to_read[0]};
        byte[] read_page = new byte[]{};
        try {
            read_page = this.skyport_bluetooth.send_custom_command(this.unit_to_update, to_send);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
        }
        catch (Exception e) {
            throw e;
        }
        return read_page;
    }

    public void ELC_restart_unit() {
        if (this.serial_manager != null) {
            this.serial_manager.wait_timer(200);
            String restartCommand = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_Restart_Unit + "00";
            this.serial_manager.build_and_send_command(restartCommand);
            this.serial_manager.wait_timer(200);
            restartCommand = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_Restart_Unit + "01";
            this.serial_manager.build_and_send_command(restartCommand);
        } else if (this.skyport_bluetooth != null) {
            try {
                Thread.sleep(200L);
                this.skyport_bluetooth.restart_unit(this.unit_to_update, (byte)0);
                Thread.sleep(200L);
                this.skyport_bluetooth.restart_unit(this.unit_to_update, (byte)1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void ELC_erase_unit(String microcontroller) {
        if (this.serial_manager != null) {
            String command_erase = EL_commands.EL_Conf_Unit_single + this.unit_to_update.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_a_command + microcontroller;
            this.serial_manager.build_and_send_command(command_erase);
        } else if (this.skyport_bluetooth != null) {
            byte[] erase_result = new byte[Skyport_Module.BUFFER_SIZE];
            try {
                switch (microcontroller) {
                    case "00": {
                        erase_result = this.skyport_bluetooth.send_erase_firmware(EL_Updater_Main.skyport_unit_to_update, (byte)0);
                        if (erase_result[7] != 97 || erase_result[8] != 0) break;
                        EL_Updater_Main.elc_erased = true;
                        break;
                    }
                    case "01": {
                        erase_result = this.skyport_bluetooth.send_erase_firmware(EL_Updater_Main.skyport_unit_to_update, (byte)1);
                        if (erase_result[7] != 97 || erase_result[8] != 1) break;
                        EL_Updater_Main.elc_erased = true;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void done() {
        super.done();
        this.progress_bar.setValue(0);
        JOptionPane.showMessageDialog(null, "The firmware of your elinchrom unit is up to date.", EL_Updater_Main.labels.getString("window_title_update_ok"), 1, new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/ok.png")));
        System.exit(0);
    }
}

