/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray$JsonParser;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;

final class DefaultDateTypeAdapter
implements JsonSerializer<java.util.Date>,
JsonDeserializer<java.util.Date> {
    private final DateFormat enUsFormat;
    private final DateFormat localFormat;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(String datePattern) {
        this(new SimpleDateFormat(datePattern, Locale.US), new SimpleDateFormat(datePattern));
    }

    DefaultDateTypeAdapter(int style) {
        this(DateFormat.getDateInstance(style, Locale.US), DateFormat.getDateInstance(style));
    }

    public DefaultDateTypeAdapter(int dateStyle, int timeStyle) {
        this(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US), DateFormat.getDateTimeInstance(dateStyle, timeStyle));
    }

    DefaultDateTypeAdapter(DateFormat enUsFormat, DateFormat localFormat) {
        this.enUsFormat = enUsFormat;
        this.localFormat = localFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement serialize(java.util.Date src, Type typeOfSrc, JsonSerializationContext context) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            String dateFormatAsString = this.enUsFormat.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }
    }

    @Override
    public java.util.Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            char[] cArray = "\ub6a2\u3b20\uc1b8\ud99a\uf46e\u2f40\u5f32\u3c5e\u22d0\ue947\u2e98\ucd80\u26b2\ufeb1\u04c7\u7404\u5ada\ub354\uf1e3\ua598\u6c00\u7115\ucd40\u221b\u423e\uba1a\u9aae\u743d\u3c1c\u4e15\u6420\u5df8\u11a9".toCharArray();
            cArray[14] = (char)(cArray[14] ^ 0x46CC);
            throw new JsonParseException(JsonArray$JsonParser.C(cArray, 17913 << 16 | 0x1971, (short)3, (byte)2));
        }
        java.util.Date date = this.deserializeToDate(json);
        if (typeOfT == java.util.Date.class) {
            return date;
        }
        if (typeOfT == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (typeOfT == Date.class) {
            return new Date(date.getTime());
        }
        char[] cArray = "\u9174\u479a\u4b50\u28b7\u85a1\u8832\ucbad\u8450\u6b7e\u2074\uddac\ua879\u6d12\u0385\u86be\uabf5\u0969\ue86b\u8e39\ub474\ue5f6\ua349\uedb9".toCharArray();
        cArray[13] = (char)(cArray[13] ^ 0x2CDE);
        throw new IllegalArgumentException(this.getClass() + JsonArray$JsonParser.C(cArray, 23273 << 16 | 0x50DB, (short)4, (byte)5) + typeOfT);
    }

    private java.util.Date deserializeToDate(JsonElement json) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                return this.localFormat.parse(json.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.enUsFormat.parse(json.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        return ISO8601Utils.parse(json.getAsString(), new ParsePosition(0));
                    }
                    catch (ParseException e) {
                        throw new JsonSyntaxException(json.getAsString(), e);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DefaultDateTypeAdapter.class.getSimpleName());
        sb.append('(').append(this.localFormat.getClass().getSimpleName()).append(')');
        return sb.toString();
    }
}

