/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject$JsonArray;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    public JsonElement parse(String json) throws JsonSyntaxException {
        return this.parse(new StringReader(json));
    }

    public JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(json);
            JsonElement element = this.parse(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                char[] cArray = "\u6093\u471f\u0df6\ua821\ud383\ub880\ud630\u0480\u647e\uc7c7\u2c45\u9b9a\u4231\u4643\uf3e6\u6262\u336a\ub444\u069e\u46c9\uff1d\ua972\u840b\uc816\u0ded\u44b0\uc61b\u489c\u7d8c\u7195\u5a30\u491f\u06b2\ucd4f\u162f\u45c6".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x70E2);
                throw new JsonSyntaxException(JsonObject$JsonArray.y(cArray, 73 << 16 | 0x6C89, false, false));
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        boolean lenient = json.isLenient();
        json.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(json);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            char[] cArray = "\u1ff3\uf63f\u4326\ua3c2\u331f\uc12e\u83aa\ub7b5\u2978\u937a\u6d20\u5c72\u89fa\u157b\u9b7c\uface\u21cd\ufc4c\u551c\u28b0\u043e\u228e\u6bfc\u877c\ue40a\uf3c0\ubd68\u8d1c".toCharArray();
            cArray[10] = (char)(cArray[10] ^ 0x5EBF);
            char[] cArray2 = "\u3876\ueaed\u26fc\u9316\ue1f3\u8adf\u4a7f\u8d57".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x3F13);
            throw new JsonParseException(JsonObject$JsonArray.y(cArray, 27012 << 16 | 0x21F6, true, true) + json + JsonObject$JsonArray.y(cArray2, 7561 << 16 | 0x1003, false, true), e);
        }
        catch (OutOfMemoryError e) {
            char[] cArray = "\u8d5e\u490f\u2b69\u696e\u2a85\ufddd\u8f0c\u9fe0\ud121\u7146\u3d3f\u7238\uf49d\ub5f2\u531a\u885b\u3697\ud6f3\ue156\u3dff\uc98e\u998b\u1d9c\u53f0\u6487\uef23\uf12e\uca96".toCharArray();
            cArray[15] = (char)(cArray[15] ^ 0x4F81);
            char[] cArray3 = "\uc8c8\u0a38\ufea7\ubbf9\u0b8a\u0ee2\u3da8\ufd0c".toCharArray();
            cArray3[7] = (char)(cArray3[7] ^ 0x3D5A);
            throw new JsonParseException(JsonObject$JsonArray.y(cArray, 15685 << 16 | 0x119B, true, false) + json + JsonObject$JsonArray.y(cArray3, 2282 << 16 | 0x35FB, false, true), e);
        }
        finally {
            json.setLenient(lenient);
        }
    }
}

