/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonIOException;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives$Excluder;
import com.google.gson.internal.Primitives$Primitives;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> instanceCreators) {
        this.instanceCreators = instanceCreators;
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        final Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        final InstanceCreator<?> typeCreator = this.instanceCreators.get(type);
        if (typeCreator != null) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return typeCreator.createInstance(type);
                }
            };
        }
        final InstanceCreator<?> rawTypeCreator = this.instanceCreators.get(rawType);
        if (rawTypeCreator != null) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return rawTypeCreator.createInstance(type);
                }
            };
        }
        ObjectConstructor<T> defaultConstructor = this.newDefaultConstructor(rawType);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ObjectConstructor<T> defaultImplementation = this.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return this.newUnsafeAllocator(type, rawType);
    }

    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> rawType) {
        try {
            final Constructor<T> constructor = rawType.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    try {
                        Object[] args = null;
                        return constructor.newInstance(args);
                    }
                    catch (InstantiationException e) {
                        char[] cArray = "\u6192\u7353\ufabc\u44dc\u83d9\ufc48\u12d1\u4477\ud3eb\u9d6f\u8c24\u4dc0\u30b0\u29be\u1cde\u27a4\u7eed".toCharArray();
                        cArray[12] = (char)(cArray[12] ^ 0x7DB0);
                        char[] cArray2 = "\uf887\u702c\u3f40\u751f\u46e0\ue5e3\ue257\uc202\u0447\u5535\ue35a\u7d24\u996e".toCharArray();
                        cArray2[0] = (char)(cArray2[0] ^ 0xBBD);
                        throw new RuntimeException(Primitives$Excluder.w(cArray, 1708 << 16 | 0x28B1, (short)5, (short)4) + constructor + Primitives$Excluder.w(cArray2, 19346 << 16 | 0x24DB, (short)2, (short)3), e);
                    }
                    catch (InvocationTargetException e) {
                        char[] cArray = "\u5d00\u3564\uc359\ua176\uff55\u4dd9\ue9f2\u9d2e\u5dcc\ub6e8\u7a1b\ube96\u7943\ua697\u2a42\ub551\u79e2".toCharArray();
                        cArray[9] = (char)(cArray[9] ^ 0x6023);
                        char[] cArray3 = "\u5a2c\ud156\u8bdc\ufa20\u7a95\ua1d5\u074f\ud945\ucaca\uf1c7\uc9a8\u63c6\ud2a2".toCharArray();
                        cArray3[9] = (char)(cArray3[9] ^ 0x7204);
                        throw new RuntimeException(Primitives$Excluder.w(cArray, 14320 << 16 | 0x5223, (short)1, (short)3) + constructor + Primitives$Excluder.w(cArray3, 2741 << 16 | 0x18CE, (short)3, (short)4), e.getTargetException());
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(final Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        if (type instanceof ParameterizedType) {
                            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (elementType instanceof Class) {
                                return EnumSet.noneOf((Class)elementType);
                            }
                            char[] cArray = "\u26e4\ue716\ua65f/\u2b1e\u966b\uff15\u4af3\ue333\u4dd4\uc2fe\uf309\u41cd\u8aa8\u3a26\u06cd\u81b1\u78cb\uae61\u0f8b\u5a24\u9e4f".toCharArray();
                            cArray[19] = (char)(cArray[19] ^ 0x14AD);
                            throw new JsonIOException(Primitives$Primitives.C(cArray, 16789 << 16 | 0x2F01, (short)5, (byte)5) + type.toString());
                        }
                        char[] cArray = "\u3a31\u8de9\ud1c6\u810a\u0fc5\u201e\uc826\ue61d\u8902\u339e\u49ca\u0ec8\u83f6\ucba7\uf36f\uc32c\ubc4a\u1f07\u1b0d\u2d6d\u7c5b\u8912".toCharArray();
                        cArray[10] = (char)(cArray[10] ^ 0x5913);
                        throw new JsonIOException(Primitives$Primitives.C(cArray, 18957 << 16 | 0x5EC5, (short)3, (byte)4) + type.toString());
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ArrayDeque();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentSkipListMap();
                    }
                };
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentHashMap();
                    }
                };
            }
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(final Type type, final Class<? super T> rawType) {
        return new ObjectConstructor<T>(){
            private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

            @Override
            public T construct() {
                try {
                    Object newInstance = this.unsafeAllocator.newInstance(rawType);
                    return newInstance;
                }
                catch (Exception e) {
                    char[] cArray = "\u9d56\uc5e1\ue5a1\ud1eb\u00f8\u1e9f\uc00e\u0dc4\uca9b\u8f8b\u1059\u99b8\uc738\ubdf5\u9774\u8e35\u7886\uc46d\u7a6c\ufa87\ubb2b\uf1b0\u00bc\u8055\ub25d\u9491\u2d96\uac78\u2a2a\ua868\u7205\u703d\ucb3a\ucfda\uc8be\u5924\u9e51\u731b\uf07a\u18f2\u4635".toCharArray();
                    cArray[31] = (char)(cArray[31] ^ 0x196A);
                    char[] cArray2 = "\u3a91\ua66f".toCharArray();
                    cArray2[0] = (char)(cArray2[0] ^ 0x109F);
                    char[] cArray3 = "\ud914\uad67\uacf7\u825e\uaea8\ue551\ue16e\u3ac7\ub3c5\u7a6d\u075a\u0e57\uf067\uca79\u0d74\u291b\ub3a0\ue274\u4c0a\u5be7\u53b8\uc6be\u7d04\uf3dc\ua0da\ueecd\u0fa6\ubea7\ud5ff\u50b6\u9114\u914c\u0ebe\u55ea\u9d3c\u7fe0\u8057\u4a9c\uba4e\u9cb6\u209f\u4e53\u3182\u6fc0\ufef0\uce64\u14c5\uea59\u1959\ue3ef\u242e\u3406\u685f\u7a7a\u7e4a\u6805\u3bbe\u5510\u711a\u9f11\u3638\ud799\ufb4c\ub6f5\u8ac4\ue3cf\u7078\u4dd7\ud170\uecd2\u4f48\uca63\u9d24".toCharArray();
                    cArray3[66] = (char)(cArray3[66] ^ 0x10E8);
                    throw new RuntimeException(Primitives$Excluder.w(cArray, 4693 << 16 | 0x3D79, (short)0, (short)4) + type + Primitives$Excluder.w(cArray2, 29183 << 16 | 0x45B, (short)3, (short)0) + Primitives$Excluder.w(cArray3, 5689 << 16 | 0x4EC1, (short)2, (short)2), e);
                }
            }
        };
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

