/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter;
import com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation = rawType.getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type, JsonAdapter annotation) {
        TypeAdapter<Object> typeAdapter;
        Object instance = constructorConstructor.get(TypeToken.get(annotation.value())).construct();
        if (instance instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter)instance;
        } else if (instance instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance).create(gson, type);
        } else if (instance instanceof JsonSerializer || instance instanceof JsonDeserializer) {
            JsonSerializer serializer = instance instanceof JsonSerializer ? (JsonSerializer)instance : null;
            JsonDeserializer deserializer = instance instanceof JsonDeserializer ? (JsonDeserializer)instance : null;
            typeAdapter = new TreeTypeAdapter(serializer, deserializer, gson, type, null);
        } else {
            char[] cArray = "\u1886\u0cff\u31d1\uf921\u41b2\u17b5\u671c\u05f7\u150c\u1ec6\ud34ar\u7909\ub159\u80e5\ud9f3\uf96e\u1b0d\uec64\u3e36\u3ece\u81ae\u16b4\u898b\ufc16\u73dc\uaba4\u78b7\ua6b1\ub2ea\ud5e4\u7482\ufc2e\u82be\u6772\u58c3\u5aa7\u4196\ud0da\u18bb\u6dae\ufa62\u262a\u3df7\u3801\ue0cc\ua494\ud18a\ud631\ue3b5\u7d25\u2af8\u6b85\u1aaa\ua6eb\uf80e\u8b5e\ua9e8\u1517\u5399\u6d35\ua214\u854e\ueb64\u6c79\ua7b3\u18c0\uc374\ufd45\u6112\u0291\u711e\uc0d0\u7669\ubd15\ue65e\ua2e2\u492e\u743e\u81e0\ub8a2\u7a95\ue9f5\uff7b\u271e\uf9d4\uef82\u29bb\u73e1\u8bad\ue476\u73b2\u3af5\u8cd5\u1158\u7a27\u2586\uc699\ua123\u6ef1\u32b8\u5790\u3943\u16ea\u9aea".toCharArray();
            cArray[88] = (char)(cArray[88] ^ 0x2BF9);
            throw new IllegalArgumentException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 10933 << 16 | 0x1D09, (short)0, 1));
        }
        if (typeAdapter != null) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

