/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TreeTypeAdapter$TreeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new Reader(){

        @Override
        public int read(char[] buffer, int offset, int count) throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final Object SENTINEL_CLOSED = new Object();
    private Object[] stack = new Object[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    public JsonTreeReader(JsonElement element) {
        super(UNREADABLE_READER);
        this.push(element);
    }

    @Override
    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
        JsonArray array = (JsonArray)this.peekStack();
        this.push(array.iterator());
        this.pathIndices[this.stackSize - 1] = 0;
    }

    @Override
    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
        JsonObject object = (JsonObject)this.peekStack();
        this.push(object.entrySet().iterator());
    }

    @Override
    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        JsonToken token = this.peek();
        return token != JsonToken.END_OBJECT && token != JsonToken.END_ARRAY;
    }

    @Override
    public JsonToken peek() throws IOException {
        if (this.stackSize == 0) {
            return JsonToken.END_DOCUMENT;
        }
        Object o = this.peekStack();
        if (o instanceof Iterator) {
            boolean isObject = this.stack[this.stackSize - 2] instanceof JsonObject;
            Iterator iterator = (Iterator)o;
            if (iterator.hasNext()) {
                if (isObject) {
                    return JsonToken.NAME;
                }
                this.push(iterator.next());
                return this.peek();
            }
            return isObject ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
        }
        if (o instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (o instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)o;
            if (primitive.isString()) {
                return JsonToken.STRING;
            }
            if (primitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (primitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (o instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (o == SENTINEL_CLOSED) {
            char[] cArray = "\ufd7c\ud046\uc057\u2530\uf756\u51e4\ub108\u3989\udfa0\ua559\u0b4b\udb4a\ucb32\u672a\ud2ec\u79fe\u6a7f\u55fb\u99d6\ua555".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x41EF);
            throw new IllegalStateException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 3675 << 16 | 0x103E, (short)3, 2));
        }
        throw new AssertionError();
    }

    private Object peekStack() {
        return this.stack[this.stackSize - 1];
    }

    private Object popStack() {
        Object result = this.stack[--this.stackSize];
        this.stack[this.stackSize] = null;
        return result;
    }

    private void expect(JsonToken expected) throws IOException {
        if (this.peek() != expected) {
            char[] cArray = "\u3b28\u8097\u8c29\u5ee7\u24d5\u48a0\uf8e6\ua618\u2265".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x1D89);
            char[] cArray2 = "\u96d9\uc2d1\u085e\u5a6a\ufa13\u6256\ufa31\u08f0\ud22b".toCharArray();
            cArray2[7] = (char)(cArray2[7] ^ 0x21F4);
            throw new IllegalStateException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 24180 << 16 | 0x1F26, (short)0, 4) + (Object)((Object)expected) + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 13935 << 16 | 0x511B, (short)1, 0) + (Object)((Object)this.peek()) + this.locationString());
        }
    }

    @Override
    public String nextName() throws IOException {
        String result;
        this.expect(JsonToken.NAME);
        Iterator i = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)i.next();
        this.pathNames[this.stackSize - 1] = result = (String)entry.getKey();
        this.push(entry.getValue());
        return result;
    }

    @Override
    public String nextString() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.STRING && token != JsonToken.NUMBER) {
            char[] cArray = "\u7d61\u5f5d\u5344\ufa3f\u66eb\u6a92\ue0ef\uffa2\u5f22".toCharArray();
            cArray[8] = (char)(cArray[8] ^ 0x1982);
            char[] cArray2 = "\u2166\u43de\uc098\u4c85\u2e7b\u673f\u3cf7\u261c\ucb0a".toCharArray();
            cArray2[8] = (char)(cArray2[8] ^ 0x16C2);
            throw new IllegalStateException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 1331 << 16 | 0x994, (short)0, 5) + (Object)((Object)JsonToken.STRING) + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 9116 << 16 | 0xF89, (short)4, 0) + (Object)((Object)token) + this.locationString());
        }
        String result = ((JsonPrimitive)this.popStack()).getAsString();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        this.expect(JsonToken.BOOLEAN);
        boolean result = ((JsonPrimitive)this.popStack()).getAsBoolean();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public void nextNull() throws IOException {
        this.expect(JsonToken.NULL);
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public double nextDouble() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            char[] cArray = "\ue4d3\ue011\u5fb0\udf13\u77b4\u9f59\u120b\ud376\u44a5".toCharArray();
            cArray[8] = (char)(cArray[8] ^ 0x1A3D);
            char[] cArray2 = "\u341c\u6432\u0c98\u61b7\u8c01\ub7a8\ue9b1\uec1f\uab2e".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x4F82);
            throw new IllegalStateException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 27865 << 16 | 0x602D, 5, (byte)4) + (Object)((Object)JsonToken.NUMBER) + TreeTypeAdapter$TreeTypeAdapter.N(cArray2, 3033 << 16 | 0x2CCA, 0, (byte)5) + (Object)((Object)token) + this.locationString());
        }
        double result = ((JsonPrimitive)this.peekStack()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(result) || Double.isInfinite(result))) {
            char[] cArray = "\u6a43\u3a21\u81bc\u543a\ucc2d\u2ade\u4964\u0328\ue5fb\u3a0e\ue0e7\u9fba\u19d6\uaba6\u5088\uf499\udfd6\u47f4\u22e6\u7403\ub50a\ub8bf\uf2d6\uf47d\u020c\u3c57\u7546\ufa3e\ud8cd\u5fa1\u1a8e\u065c\uf90a".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x75F7);
            throw new NumberFormatException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 31606 << 16 | 0x7788, 4, (byte)1) + result);
        }
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public long nextLong() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            char[] cArray = "\u3407\u46ff\udec8\u2060\ufeeb\u780a\ud743\u96b5\u391e".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x7761);
            char[] cArray2 = "\u4902\u4d7e\u12c8\ua486\u15d6\u471a\u33cf\u7481\ue1b2".toCharArray();
            cArray2[5] = (char)(cArray2[5] ^ 0xEE3);
            throw new IllegalStateException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 13730 << 16 | 0x32F8, 1, (byte)2) + (Object)((Object)JsonToken.NUMBER) + TreeTypeAdapter$TreeTypeAdapter.N(cArray2, 24496 << 16 | 0x72C4, 3, (byte)2) + (Object)((Object)token) + this.locationString());
        }
        long result = ((JsonPrimitive)this.peekStack()).getAsLong();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public int nextInt() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            char[] cArray = "\ue81b\u5b60\u0814\ud51e\u3a31\ue06f\uda29\u8ee7\u54c1".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x3A84);
            char[] cArray2 = "\uc08a\ua8d7\ub564\u8d52\ua69a\u0513\ub79a\uf674\ue526".toCharArray();
            cArray2[8] = (char)(cArray2[8] ^ 0x441C);
            throw new IllegalStateException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 2708 << 16 | 0x544E, (short)1, 5) + (Object)((Object)JsonToken.NUMBER) + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 2207 << 16 | 0x580E, (short)5, 1) + (Object)((Object)token) + this.locationString());
        }
        int result = ((JsonPrimitive)this.peekStack()).getAsInt();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.stack = new Object[]{SENTINEL_CLOSED};
        this.stackSize = 1;
    }

    @Override
    public void skipValue() throws IOException {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
            char[] cArray = "\u0143\uf93f\ub27e\uc087".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x11BD);
            this.pathNames[this.stackSize - 2] = ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 9156 << 16 | 0x1174, (short)0, (byte)5);
        } else {
            this.popStack();
            char[] cArray = "\udb2b\uf94d\u94ac\u7025".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x36FD);
            this.pathNames[this.stackSize - 1] = ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 25560 << 16 | 0x4909, (short)5, (byte)4);
        }
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void promoteNameToValue() throws IOException {
        this.expect(JsonToken.NAME);
        Iterator i = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)i.next();
        this.push(entry.getValue());
        this.push(new JsonPrimitive((String)entry.getKey()));
    }

    private void push(Object newTop) {
        if (this.stackSize == this.stack.length) {
            Object[] newStack = new Object[this.stackSize * 2];
            int[] newPathIndices = new int[this.stackSize * 2];
            String[] newPathNames = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, newPathIndices, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, newPathNames, 0, this.stackSize);
            this.stack = newStack;
            this.pathIndices = newPathIndices;
            this.pathNames = newPathNames;
        }
        this.stack[this.stackSize++] = newTop;
    }

    @Override
    public String getPath() {
        StringBuilder result = new StringBuilder().append('$');
        for (int i = 0; i < this.stackSize; ++i) {
            if (this.stack[i] instanceof JsonArray) {
                if (!(this.stack[++i] instanceof Iterator)) continue;
                result.append('[').append(this.pathIndices[i]).append(']');
                continue;
            }
            if (!(this.stack[i] instanceof JsonObject) || !(this.stack[++i] instanceof Iterator)) continue;
            result.append('.');
            if (this.pathNames[i] == null) continue;
            result.append(this.pathNames[i]);
        }
        return result.toString();
    }

    private String locationString() {
        char[] cArray = "\ub775\ube81\u0e29\u3a38\u113e\ue595\u8ebd\u2c7d\uaf40".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x735F);
        return TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 7770 << 16 | 0x635C, (short)2, 0) + this.getPath();
    }
}

