/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TreeTypeAdapter$TreeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        @Override
        public void write(JsonWriter out, Class value) throws IOException {
            if (value != null) {
                char[] cArray = "\ucca6\uaae6\u614e\u525c\u012d\ue027\u2a04\ud15c\u7a35\uca07\ub7af\u8378\u785a\u13c6\uab23\u93aa\u40ed\u47ab\ub20b\ubf7e\u2407\u5476\u9144\u41d0\u5400\uff90\ue3ec\u285f\ua0e7\uc0df\u7b1b\u4a05\u6728\u1335\udc92\ue3d0\u2786\ue9fa\u5021\u934d".toCharArray();
                cArray[16] = (char)(cArray[16] ^ 0x1AF2);
                char[] cArray2 = "\u6c1e\u05a1\u59ed\uf870\ufa6d\u7b5e\u55c4\u2c49\u4ce2\u3a8e\ube16\u3a88\u02b7\u3cce\uf1a0\u42e3\uf2dd\u8d89\u9239\u2787\uf719\ub58f\u9329\ue560\ufb8f\u7675\u4f8b\u84e8\u8953\ubb6f\u01f3\u48c2\u39fc\u73a2\u9c17\u958b".toCharArray();
                cArray2[32] = (char)(cArray2[32] ^ 0x7EA3);
                throw new UnsupportedOperationException(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 385 << 16 | 0x2BEB, (short)4, (byte)2) + value.getName() + ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray2, 19440 << 16 | 0x5238, (short)2, (byte)5));
            }
            out.nullValue();
        }

        @Override
        public Class read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            char[] cArray = "\u540f\u9406\u57d4\u7641\ua0fc\u65ff\u882e\ua995\uc002\u0573\u3f4d\u57f7\uea6d\u5bd6\ub153\uba50\ubed6\u095b\u1b09\ua842\u26df\u0217\ub298\u7dfa\u0304\u4e52\u29a7\u20c0\u73d1\u3fe5\ufef5\u068b\ue8cf\u7fae\u1f2a\u0014\ucf6d\u89bc\ud701\ucfc5\u9e19\u6461\u4c20\u611e\u4591\ua886\uee94\ue24f\u779d\u48bf\u1165\ud457\ufae1\u13f4\u9a45\uce90\u2255\u1cad\ucbf3\udfcb\u6e09\u9671\u882d\u94e2\u4b44\u7fb0\u41a8\u94f2\u0dc8\uf3d7\u085d\ucc46\u2277\u9fc8\uc4a0\ud38d\u4d04\u1e0f".toCharArray();
            cArray[53] = (char)(cArray[53] ^ 0x5F70);
            throw new UnsupportedOperationException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 16616 << 16 | 0x676E, (short)4, 0));
        }
    };
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        @Override
        public BitSet read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            BitSet bitset = new BitSet();
            in.beginArray();
            int i = 0;
            JsonToken tokenType = in.peek();
            while (tokenType != JsonToken.END_ARRAY) {
                boolean set;
                switch (tokenType) {
                    case NUMBER: {
                        set = in.nextInt() != 0;
                        break;
                    }
                    case BOOLEAN: {
                        set = in.nextBoolean();
                        break;
                    }
                    case STRING: {
                        String stringValue = in.nextString();
                        try {
                            set = Integer.parseInt(stringValue) != 0;
                            break;
                        }
                        catch (NumberFormatException e) {
                            char[] cArray = "\u6664\u9bce\u37d0\u2f06\u0f30\ude39\ue813\u05b7\u5399\ub0cf\ua0b7\ufd16\uff73\u8c2e\uea59\u809c\u5d91\ua2be\u582b\u3371\ufbd3\uf4c9\uf218\u34de\u4fb5\ue707\u95bf\u60c5\ub8ae\ucaa9\uf1cb\u92a3\u596c\u9f5c\ud458\u2140\u9824\u9881\uc99a\u37d1\uc4df\ue3ba\uc62f\u8855\u919a\u8002\u8087\uf790\ue14a\u70c0\ucfb5\u0248\u1814".toCharArray();
                            cArray[48] = (char)(cArray[48] ^ 0x3014);
                            throw new JsonSyntaxException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 14913 << 16 | 0x18ED, (short)0, 3) + stringValue);
                        }
                    }
                    default: {
                        char[] cArray = "\ua96f\u5468\u40ed\u8404\u9831\u07d6\uace8\u8582\ud88f\u61f0\uba7e\uac3b\u09e8\u3db1\u8615\uc76f\u8864\ue904\u0438\u44ff\ue792\ufed0\ub3f4\u26a7\ua30b\u1665\u8ecb".toCharArray();
                        cArray[1] = (char)(cArray[1] ^ 0x7880);
                        throw new JsonSyntaxException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 18089 << 16 | 0x768B, (short)1, 5) + (Object)((Object)tokenType));
                    }
                }
                if (set) {
                    bitset.set(i);
                }
                ++i;
                tokenType = in.peek();
            }
            in.endArray();
            return bitset;
        }

        @Override
        public void write(JsonWriter out, BitSet src) throws IOException {
            if (src == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (int i = 0; i < src.length(); ++i) {
                int value = src.get(i) ? 1 : 0;
                out.value(value);
            }
            out.endArray();
        }
    };
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        @Override
        public Boolean read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in.peek() == JsonToken.STRING) {
                return Boolean.parseBoolean(in.nextString());
            }
            return in.nextBoolean();
        }

        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        @Override
        public Boolean read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Boolean.valueOf(in.nextString());
        }

        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            String string;
            if (value == null) {
                char[] cArray = "\udce1\u14c3\u73e2\u7af2".toCharArray();
                cArray[2] = (char)(cArray[2] ^ 0x5FC0);
                string = TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 32255 << 16 | 0x4E0E, (short)0, 4);
            } else {
                string = value.toString();
            }
            out.value(string);
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                int intValue = in.nextInt();
                return (byte)intValue;
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return (short)in.nextInt();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextInt();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<AtomicInteger> ATOMIC_INTEGER = new TypeAdapter<AtomicInteger>(){

        @Override
        public AtomicInteger read(JsonReader in) throws IOException {
            try {
                return new AtomicInteger(in.nextInt());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, AtomicInteger value) throws IOException {
            out.value(value.get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, ATOMIC_INTEGER);
    public static final TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN = new TypeAdapter<AtomicBoolean>(){

        @Override
        public AtomicBoolean read(JsonReader in) throws IOException {
            return new AtomicBoolean(in.nextBoolean());
        }

        @Override
        public void write(JsonWriter out, AtomicBoolean value) throws IOException {
            out.value(value.get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, ATOMIC_BOOLEAN);
    public static final TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY = new TypeAdapter<AtomicIntegerArray>(){

        @Override
        public AtomicIntegerArray read(JsonReader in) throws IOException {
            ArrayList<Integer> list = new ArrayList<Integer>();
            in.beginArray();
            while (in.hasNext()) {
                try {
                    int integer = in.nextInt();
                    list.add(integer);
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException(e);
                }
            }
            in.endArray();
            int length = list.size();
            AtomicIntegerArray array = new AtomicIntegerArray(length);
            for (int i = 0; i < length; ++i) {
                array.set(i, (Integer)list.get(i));
            }
            return array;
        }

        @Override
        public void write(JsonWriter out, AtomicIntegerArray value) throws IOException {
            out.beginArray();
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                out.value(value.get(i));
            }
            out.endArray();
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, ATOMIC_INTEGER_ARRAY);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextLong();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)in.nextDouble());
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextDouble();
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> NUMBER = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            JsonToken jsonToken = in.peek();
            switch (jsonToken) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
                case NUMBER: {
                    return new LazilyParsedNumber(in.nextString());
                }
            }
            char[] cArray = "\ue110\u59dd\u69a0\u4c95\u522b\u2353\u7550\u274c\u565c\u05f0\u9a31\uace9\u551e\uf204\udea8\u3277\u8b7a\u1c5a\ub2e5\u86cc\ud86f\ubfb8\u9431".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0x466C);
            throw new JsonSyntaxException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 2852 << 16 | 0x5430, 5, (byte)1) + (Object)((Object)jsonToken));
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        @Override
        public Character read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String str = in.nextString();
            if (str.length() != 1) {
                char[] cArray = "\u5ba7\u8b11\ud244t\ua07a\u945b\u6ca3\u685b\ud9c9\ucb31\u3053\u3dfc\u83c0\u9f89\u7268\uc822\u5ec0\ub8a2\u865f\ua0cf\uf2a3\u832a\u45e9\u7af1\u348f\ue6f2".toCharArray();
                cArray[4] = (char)(cArray[4] ^ 0x36D2);
                throw new JsonSyntaxException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 12012 << 16 | 0x5898, 2, (byte)1) + str);
            }
            return Character.valueOf(str.charAt(0));
        }

        @Override
        public void write(JsonWriter out, Character value) throws IOException {
            out.value(value == null ? null : String.valueOf(value));
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public String read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return in.nextString();
        }

        @Override
        public void write(JsonWriter out, String value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return new BigDecimal(in.nextString());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, BigDecimal value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        @Override
        public BigInteger read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return new BigInteger(in.nextString());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException(e);
            }
        }

        @Override
        public void write(JsonWriter out, BigInteger value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        @Override
        public StringBuilder read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuilder(in.nextString());
        }

        @Override
        public void write(JsonWriter out, StringBuilder value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        @Override
        public StringBuffer read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuffer(in.nextString());
        }

        @Override
        public void write(JsonWriter out, StringBuffer value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        @Override
        public URL read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String nextString = in.nextString();
            char[] cArray = "\u0a1b\ufa14\u41f1\u6758".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x78DC);
            return TreeTypeAdapter$TreeTypeAdapter.N(cArray, 8312 << 16 | 0x4DD7, 4, (byte)3).equals(nextString) ? null : new URL(nextString);
        }

        @Override
        public void write(JsonWriter out, URL value) throws IOException {
            out.value(value == null ? null : value.toExternalForm());
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        @Override
        public URI read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                String nextString = in.nextString();
                char[] cArray = "\ubb1c\u43e4\uc14f\uf1b2".toCharArray();
                cArray[0] = (char)(cArray[0] ^ 0x44F5);
                return ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 19610 << 16 | 0x3ECD, (short)4, (byte)2).equals(nextString) ? null : new URI(nextString);
            }
            catch (URISyntaxException e) {
                throw new JsonIOException(e);
            }
        }

        @Override
        public void write(JsonWriter out, URI value) throws IOException {
            out.value(value == null ? null : value.toASCIIString());
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        @Override
        public InetAddress read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return InetAddress.getByName(in.nextString());
        }

        @Override
        public void write(JsonWriter out, InetAddress value) throws IOException {
            out.value(value == null ? null : value.getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        @Override
        public UUID read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return java.util.UUID.fromString(in.nextString());
        }

        @Override
        public void write(JsonWriter out, UUID value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapter<Currency> CURRENCY = new TypeAdapter<Currency>(){

        @Override
        public Currency read(JsonReader in) throws IOException {
            return Currency.getInstance(in.nextString());
        }

        @Override
        public void write(JsonWriter out, Currency value) throws IOException {
            out.value(value.getCurrencyCode());
        }
    }.nullSafe();
    public static final TypeAdapterFactory CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, CURRENCY);
    public static final TypeAdapterFactory TIMESTAMP_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Timestamp.class) {
                return null;
            }
            final TypeAdapter<Date> dateTypeAdapter = gson.getAdapter(Date.class);
            return new TypeAdapter<Timestamp>(){

                @Override
                public Timestamp read(JsonReader in) throws IOException {
                    Date date = (Date)dateTypeAdapter.read(in);
                    return date != null ? new Timestamp(date.getTime()) : null;
                }

                @Override
                public void write(JsonWriter out, Timestamp value) throws IOException {
                    dateTypeAdapter.write(out, value);
                }
            };
        }
    };
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){
        private static final String YEAR;
        private static final String MONTH;
        private static final String DAY_OF_MONTH;
        private static final String HOUR_OF_DAY;
        private static final String MINUTE;
        private static final String SECOND;

        @Override
        public Calendar read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int year = 0;
            int month = 0;
            int dayOfMonth = 0;
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            while (in.peek() != JsonToken.END_OBJECT) {
                String name = in.nextName();
                int value = in.nextInt();
                char[] cArray = "\u7be6\u938a\u45da\uf446".toCharArray();
                cArray[2] = (char)(cArray[2] ^ 0xEFA);
                if (TreeTypeAdapter$TreeTypeAdapter.N(cArray, 1717 << 16 | 0x521B, 2, (byte)4).equals(name)) {
                    year = value;
                    continue;
                }
                char[] cArray2 = "\ubc6c\u87df\u84da\u2bd3\ud6e8".toCharArray();
                cArray2[0] = (char)(cArray2[0] ^ 0x358D);
                if (TreeTypeAdapter$TreeTypeAdapter.N(cArray2, 29003 << 16 | 0x75CD, 1, (byte)0).equals(name)) {
                    month = value;
                    continue;
                }
                char[] cArray3 = "\u25c3\u4776\u000f\u79b1\u8df1\u2b1e\ue1cc\u8a85\ua0e3\u7a0a".toCharArray();
                cArray3[2] = (char)(cArray3[2] ^ 0x5760);
                if (TreeTypeAdapter$TreeTypeAdapter.N(cArray3, 32398 << 16 | 0x46E8, 0, (byte)3).equals(name)) {
                    dayOfMonth = value;
                    continue;
                }
                char[] cArray4 = "\u56d4\u777a\u0d8e\ufff0\uc66b\u36c1\ua8f4\ud982\u396c".toCharArray();
                cArray4[4] = (char)(cArray4[4] ^ 0x4A29);
                if (TreeTypeAdapter$TreeTypeAdapter.N(cArray4, 23889 << 16 | 0x2982, 0, (byte)5).equals(name)) {
                    hourOfDay = value;
                    continue;
                }
                char[] cArray5 = "\ua228\u2e5f\ubef3\ue7ec\ue64e\u06ad".toCharArray();
                cArray5[4] = (char)(cArray5[4] ^ 0x67D5);
                if (TreeTypeAdapter$TreeTypeAdapter.N(cArray5, 484 << 16 | 0x2946, 2, (byte)0).equals(name)) {
                    minute = value;
                    continue;
                }
                char[] cArray6 = "\ua6af\u8ce0\ub06c\ua0f9\u5fdc\udfb2".toCharArray();
                cArray6[1] = (char)(cArray6[1] ^ 0x2787);
                if (!TreeTypeAdapter$TreeTypeAdapter.N(cArray6, 26758 << 16 | 0x1D32, 4, (byte)4).equals(name)) continue;
                second = value;
            }
            in.endObject();
            return new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        }

        @Override
        public void write(JsonWriter out, Calendar value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            char[] cArray = "\u4657\u6831\u3ac0\ufc51".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x4D31);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 3197 << 16 | 0x3087, (short)0, (byte)2));
            out.value(value.get(1));
            char[] cArray2 = "\ue3f6\u9089\u374e\u5139\u045c".toCharArray();
            cArray2[4] = (char)(cArray2[4] ^ 0x4250);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray2, 12260 << 16 | 0x1B00, (short)5, (byte)1));
            out.value(value.get(2));
            char[] cArray3 = "\u290d\u870d\ud562\u0d3b\u272f\u0705\u7278\ua700\uf94f\u8def".toCharArray();
            cArray3[9] = (char)(cArray3[9] ^ 0x432F);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray3, 22135 << 16 | 0x63D8, (short)3, (byte)5));
            out.value(value.get(5));
            char[] cArray4 = "\u2892\ua682\u6e29\u5453\ub9e9\ufaa0\udaa5\ua143\u3a07".toCharArray();
            cArray4[2] = (char)(cArray4[2] ^ 0x1391);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray4, 31123 << 16 | 0x51F7, (short)3, (byte)1));
            out.value(value.get(11));
            char[] cArray5 = "\u8131\u4f3d\u9df2\uec33\ufc13\ue0e2".toCharArray();
            cArray5[0] = (char)(cArray5[0] ^ 0x10E8);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray5, 737 << 16 | 0x3337, (short)4, (byte)1));
            out.value(value.get(12));
            char[] cArray6 = "\u7405\u4164\u82a8\ubdc3\u141e\u344f".toCharArray();
            cArray6[0] = (char)(cArray6[0] ^ 0x4DA0);
            out.name(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray6, 26072 << 16 | 0x7373, (short)5, (byte)1));
            out.value(value.get(13));
            out.endObject();
        }

        static {
            char[] cArray = "\u4f65\ucfcf\u3f40\ucb74\u3344".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x5D4A);
            MONTH = TreeTypeAdapter$TreeTypeAdapter.N(cArray, 4379 << 16 | 0x1A9F, 0, (byte)2);
            char[] cArray2 = "\u48f3\ue64f\u9465\ud1b6".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x4CF2);
            YEAR = TreeTypeAdapter$TreeTypeAdapter.N(cArray2, 24461 << 16 | 0x14E1, 2, (byte)0);
            char[] cArray3 = "\uee11\u6c99\ua34e\u267d\ub7c4\ud2e9\u1ca1\uc755\u9f6c\u25c7".toCharArray();
            cArray3[8] = (char)(cArray3[8] ^ 0x3603);
            DAY_OF_MONTH = TreeTypeAdapter$TreeTypeAdapter.N(cArray3, 31607 << 16 | 0x4176, 3, (byte)2);
            char[] cArray4 = "\uf466\u7b26\ubbe8\udfd1\uffde\ufd60\ucf94\u8895\u67a4".toCharArray();
            cArray4[4] = (char)(cArray4[4] ^ 0x1FB9);
            HOUR_OF_DAY = TreeTypeAdapter$TreeTypeAdapter.N(cArray4, 214 << 16 | 0x2709, 1, (byte)1);
            char[] cArray5 = "\uc876\ub91a\ueda2\uee1d\ud899\uefa5".toCharArray();
            cArray5[0] = (char)(cArray5[0] ^ 0x4F42);
            MINUTE = TreeTypeAdapter$TreeTypeAdapter.N(cArray5, 5769 << 16 | 0x4513, 4, (byte)2);
            char[] cArray6 = "\u2339\u40a3\u19e5\u27b7\u3dfb\ud2d6".toCharArray();
            cArray6[3] = (char)(cArray6[3] ^ 0x7A17);
            SECOND = TreeTypeAdapter$TreeTypeAdapter.N(cArray6, 719 << 16 | 0x5989, 0, (byte)1);
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        @Override
        public Locale read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String locale = in.nextString();
            char[] cArray = "\u105a".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x1923);
            StringTokenizer tokenizer = new StringTokenizer(locale, TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 446 << 16 | 0x61CC, (short)2, 0));
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        @Override
        public void write(JsonWriter out, Locale value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        @Override
        public JsonElement read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case STRING: {
                    return new JsonPrimitive(in.nextString());
                }
                case NUMBER: {
                    String number = in.nextString();
                    return new JsonPrimitive(new LazilyParsedNumber(number));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(in.nextBoolean());
                }
                case NULL: {
                    in.nextNull();
                    return JsonNull.INSTANCE;
                }
                case BEGIN_ARRAY: {
                    JsonArray array = new JsonArray();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.add(this.read(in));
                    }
                    in.endArray();
                    return array;
                }
                case BEGIN_OBJECT: {
                    JsonObject object = new JsonObject();
                    in.beginObject();
                    while (in.hasNext()) {
                        object.add(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return object;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void write(JsonWriter out, JsonElement value) throws IOException {
            if (value == null || value.isJsonNull()) {
                out.nullValue();
            } else if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    out.value(primitive.getAsNumber());
                } else if (primitive.isBoolean()) {
                    out.value(primitive.getAsBoolean());
                } else {
                    out.value(primitive.getAsString());
                }
            } else if (value.isJsonArray()) {
                out.beginArray();
                for (JsonElement e : value.getAsJsonArray()) {
                    this.write(out, e);
                }
                out.endArray();
            } else if (value.isJsonObject()) {
                out.beginObject();
                for (Map.Entry<String, JsonElement> e : value.getAsJsonObject().entrySet()) {
                    out.name(e.getKey());
                    this.write(out, e.getValue());
                }
                out.endObject();
            } else {
                char[] cArray = "\ud334\u9a76\u2387\u3ae6\ud7dc\u4998\u8261\u4d55\u14d5\ud087\u3412\u09a2\uac38\u4932\ud1ed".toCharArray();
                cArray[7] = (char)(cArray[7] ^ 0x43F2);
                throw new IllegalArgumentException(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 11133 << 16 | 0x4AE9, (short)4, (byte)5) + value.getClass());
            }
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class<T> rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            return new EnumTypeAdapter<T>(rawType);
        }
    };

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.equals(type) ? typeAdapter : null;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.getRawType() == type ? typeAdapter : null;
            }

            public String toString() {
                char[] cArray = "\u9ad3\u9b00\u5f08\u7ce4\u5e0d\u0773\u91ce\u18fa\u70f4\ubb82\u7d57\uaae4\uc150".toCharArray();
                cArray[3] = (char)(cArray[3] ^ 0x2ECF);
                char[] cArray2 = "\u3f2f\u92b9\ua2cb\ua7fd\u4d78\u6e9c\u502a\ue2fa\u80a2".toCharArray();
                cArray2[6] = (char)(cArray2[6] ^ 0x2B11);
                char[] cArray3 = "\u93db".toCharArray();
                cArray3[0] = (char)(cArray3[0] ^ 0x1095);
                return TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 26195 << 16 | 0x691E, (short)4, 0) + type.getName() + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 1537 << 16 | 0x53F, (short)2, 2) + typeAdapter + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray3, 13674 << 16 | 0x479D, (short)2, 3);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> unboxed, final Class<TT> boxed, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == unboxed || rawType == boxed ? typeAdapter : null;
            }

            public String toString() {
                char[] cArray = "\udf6e\u6cd5\uff32\u29e4\u0c42\ud480\uca9e\u4da4\udd8d\u0406\ub325\u7118\u0f4a".toCharArray();
                cArray[0] = (char)(cArray[0] ^ 0x23FF);
                char[] cArray2 = "\u4844".toCharArray();
                cArray2[0] = (char)(cArray2[0] ^ 0x217);
                char[] cArray3 = "\u70ba\ufc98\ud9b4\u5bca\u6c13\uc2a7\ub9a3\uf1ad\u2e98".toCharArray();
                cArray3[2] = (char)(cArray3[2] ^ 0x73B5);
                char[] cArray4 = "\ufde9".toCharArray();
                cArray4[0] = (char)(cArray4[0] ^ 0x194);
                return ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 31964 << 16 | 0x6698, (short)1, (byte)3) + boxed.getName() + ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray2, 26152 << 16 | 0x7E03, (short)1, (byte)0) + unboxed.getName() + ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray3, 1240 << 16 | 0x49B6, (short)4, (byte)0) + typeAdapter + ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray4, 20390 << 16 | 0x63E3, (short)5, (byte)4);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> base, final Class<? extends TT> sub, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == base || rawType == sub ? typeAdapter : null;
            }

            public String toString() {
                char[] cArray = "\u7ee6\uf39c\u971b\u8b2e\u04a6\ua287\ue2d0\ucb2e\u3ce0\ue4e3\ua9f4\u018d\ue776".toCharArray();
                cArray[11] = (char)(cArray[11] ^ 0x7BAB);
                char[] cArray2 = "\ueb40".toCharArray();
                cArray2[0] = (char)(cArray2[0] ^ 0x5664);
                char[] cArray3 = "\u9064\u349a\ueb13\u5b25\u2543\ua4b6\uccd6\uc39b\u27ea".toCharArray();
                cArray3[5] = (char)(cArray3[5] ^ 0x29A0);
                char[] cArray4 = "\u7c80".toCharArray();
                cArray4[0] = (char)(cArray4[0] ^ 0x2D5E);
                return TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 30727 << 16 | 0x330F, (short)1, 2) + base.getName() + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 26412 << 16 | 0x560D, (short)3, 0) + sub.getName() + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray3, 28099 << 16 | 0x1578, (short)0, 2) + typeAdapter + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray4, 29928 << 16 | 0x2A49, (short)0, 1);
            }
        };
    }

    public static <T1> TypeAdapterFactory newTypeHierarchyFactory(final Class<T1> clazz, final TypeAdapter<T1> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T2> TypeAdapter<T2> create(Gson gson, TypeToken<T2> typeToken) {
                final Class<T2> requestedType = typeToken.getRawType();
                if (!clazz.isAssignableFrom(requestedType)) {
                    return null;
                }
                return new TypeAdapter<T1>(){

                    @Override
                    public void write(JsonWriter out, T1 value) throws IOException {
                        typeAdapter.write(out, value);
                    }

                    @Override
                    public T1 read(JsonReader in) throws IOException {
                        Object result = typeAdapter.read(in);
                        if (result != null && !requestedType.isInstance(result)) {
                            char[] cArray = "\u9329\u6a38\u2a31\u27cf\u04aa\u2c3e\ude5b\ud0aa\ub450\u5e53\u04d8".toCharArray();
                            cArray[6] = (char)(cArray[6] ^ 0x65A9);
                            char[] cArray2 = "\ub1f3\ue806\uf8ea\u8a82\u4a1b\uc0cb\uc747\u3a22\u39e9".toCharArray();
                            cArray2[6] = (char)(cArray2[6] ^ 0x6E3D);
                            throw new JsonSyntaxException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 31279 << 16 | 0xACF, (short)3, 2) + requestedType.getName() + TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray2, 13820 << 16 | 0x6A76, (short)5, 3) + result.getClass().getName());
                        }
                        return result;
                    }
                };
            }

            public String toString() {
                char[] cArray = "\ue1ba\u6c69\u421b\u2d6d\ub0c1\u1075\u3206\uf07c\u7bf1\ue5f4\ua482\ue365\ucde0\u7435\u6b4d\u9ccd\u6c96\u4da2\uf07a\u0243\u219c\u304b".toCharArray();
                cArray[12] = (char)(cArray[12] ^ 0x7214);
                char[] cArray2 = "\u7d42\u4bf0\u3123\ub499\u64e3\u1320\u1c90\ufce4\u5914".toCharArray();
                cArray2[2] = (char)(cArray2[2] ^ 0x7914);
                char[] cArray3 = "\u3b35".toCharArray();
                cArray3[0] = (char)(cArray3[0] ^ 0x533B);
                return TreeTypeAdapter$TreeTypeAdapter.N(cArray, 3053 << 16 | 0x1BD0, 3, (byte)0) + clazz.getName() + TreeTypeAdapter$TreeTypeAdapter.N(cArray2, 1581 << 16 | 0x4BE3, 2, (byte)2) + typeAdapter + TreeTypeAdapter$TreeTypeAdapter.N(cArray3, 16385 << 16 | 0x64C2, 3, (byte)0);
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public EnumTypeAdapter(Class<T> classOfT) {
            try {
                for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                    String name = constant.name();
                    SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                        for (String alternate : annotation.alternate()) {
                            this.nameToConstant.put(alternate, constant);
                        }
                    }
                    this.nameToConstant.put(name, constant);
                    this.constantToName.put(constant, name);
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get(in.nextString()));
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : this.constantToName.get(value));
        }
    }
}

