/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter$JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    public JsonReader(Reader in) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (in == null) {
            char[] cArray = "\u1b2b\u4802\u2b72\u7ed1\ub29b\u98b7\u268a\u7001\u0a0f\u389c".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0xD5C);
            throw new NullPointerException(JsonWriter$JsonWriter.H(cArray, 16395 << 16 | 0x333B, 4, 2));
        }
        this.in = in;
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 3) {
            char[] cArray = "\u412e\u45fa\u8ea8\u7068\ua9d9\u6e3f\uce76\ufa3e\u9365\ua66f\ufb4d\u448d\u0406\ua30d\u8e5a\u1536\u32f3\u51c6\u2ccc\u104e\u66d7\u9115\uf48a\ua3b6\u8e0b\u462a\u81a7\uec6a\ud0f3".toCharArray();
            cArray[6] = (char)(cArray[6] ^ 0x543E);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 13975 << 16 | 0x7FFB, 4, 3) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.push(1);
        this.pathIndices[this.stackSize - 1] = 0;
        this.peeked = 0;
    }

    public void endArray() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 4) {
            --this.stackSize;
        } else {
            char[] cArray = "\u8980\uec77\u0830\u58e0\ub05f\uadde\u6d02\u85a4\u3afc\uda11\ue2a8\ue4dc\ub91e\uc053\ub14d\u8ba2\uf890\u049a\u5679\u44d4\u5305\u7ce2\u67cc\u6a49\ueb81\ubf27\u6b53".toCharArray();
            cArray[6] = (char)(cArray[6] ^ 0x37);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 21950 << 16 | 0x1D22, 3, 0) + (Object)((Object)this.peek()) + this.locationString());
        }
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.peeked = 0;
    }

    public void beginObject() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 1) {
            char[] cArray = "\uba46\u6692\u4528\ue44a\uac9a\u7750\u48f5\ua830\uaaab\u9bfe\u7f73\u70e3\uc241\u860e\u0a8e\u0cec\ub4d1\ua466\u3540\u7487\u8529\u72d2\u4164\u4d55\u429c\u4b55\ub02e\u9567\ua24d\u400f".toCharArray();
            cArray[22] = (char)(cArray[22] ^ 0x986);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 32147 << 16 | 0x4988, 2, 0) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.push(3);
        this.peeked = 0;
    }

    public void endObject() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 2) {
            --this.stackSize;
        } else {
            char[] cArray = "\u9882\u0ab7\u654b\u1812\u5ed9\ue13d\ua643\udf5d\u6e07\u5857\u9ee8\u1027\uc305\ucdcd\u0e35\u411d\u0bf3\ud1cb\u8118\u203a\u39b0\u74ac\u985b\u3b3e\u25ee\u231d\u6122\uf53e".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x22B2);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 25489 << 16 | 0x39FF, 0, 1) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.peeked = 0;
    }

    public boolean hasNext() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p != 2 && p != 4;
    }

    public JsonToken peek() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        switch (p) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    int doPeek() throws IOException {
        int c2;
        int peekStack;
        block45: {
            block47: {
                block46: {
                    block44: {
                        peekStack = this.stack[this.stackSize - 1];
                        if (peekStack != 1) break block44;
                        this.stack[this.stackSize - 1] = 2;
                        break block45;
                    }
                    if (peekStack != 2) break block46;
                    c2 = this.nextNonWhitespace(true);
                    switch (c2) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            char[] cArray = "\ueb70\ubd01\ub1e1\ubc77\uf74d\ua03e\ud00b\u09ca\u5be0\u86bc\u1eb0\ueba8\ud039\uee1a\u15f9\uc280\ueaa1\ube54".toCharArray();
                            cArray[4] = (char)(cArray[4] ^ 0x6A13);
                            throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 18934 << 16 | 0x93E, 5, 4));
                        }
                    }
                    break block45;
                }
                if (peekStack == 3 || peekStack == 5) {
                    int c3;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack == 5) {
                        c3 = this.nextNonWhitespace(true);
                        switch (c3) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                char[] cArray = "\udb1f\ue9f9\u86e4\uc97f\u80f8\u939f\ude87\ub58b\uba9e\u205b\u607b\u5e53\ufd97\ua0a3\u9aef\u6717\u5d3d\u934f\u8c03".toCharArray();
                                cArray[9] = (char)(cArray[9] ^ 0x4145);
                                throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 9735 << 16 | 0x18D9, 1, 0));
                            }
                        }
                    }
                    c3 = this.nextNonWhitespace(true);
                    switch (c3) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (peekStack != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            char[] cArray = "\u321e\u5e92\u170e\u82a8\u2a29\uba17\u18e6\u6208\u757a\ub1b6\ub21d\u88f9\u7da3".toCharArray();
                            cArray[4] = (char)(cArray[4] ^ 0x4651);
                            throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 14598 << 16 | 0x6EAA, 5, 4));
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)c3)) {
                        this.peeked = 14;
                        return 14;
                    }
                    char[] cArray = "\u6d73\u4eb9\u5658\u9177\u8f96\ud28c\u74fc\udb2b\ufef1\ud171\uf0cc\u8531\ua703".toCharArray();
                    cArray[3] = (char)(cArray[3] ^ 0x4159);
                    throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 4170 << 16 | 0x7E28, 5, 4));
                }
                if (peekStack != 4) break block47;
                this.stack[this.stackSize - 1] = 5;
                c2 = this.nextNonWhitespace(true);
                switch (c2) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                            break;
                        }
                        break block45;
                    }
                    default: {
                        char[] cArray = "\uf606\ubaed\ub139\ucd0b\u8ab8\u1a72\ucc71\u35df\ufaf6\udf55\ua8c5\u2d9c".toCharArray();
                        cArray[1] = (char)(cArray[1] ^ 0x469E);
                        throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 323 << 16 | 0x349F, 3, 2));
                    }
                }
                break block45;
            }
            if (peekStack == 6) {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (peekStack == 7) {
                c2 = this.nextNonWhitespace(false);
                if (c2 == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.pos;
            } else if (peekStack == 8) {
                char[] cArray = "\u39fc\u766f\u6dec\uf3da\u8ee4\u3e01\u4bde\ueece\u1002\u0fed\u88c3\uec1c\u79bb\u429d\u4e18\u1fd8\u68b6\u5af6\udc6c\u1170".toCharArray();
                cArray[9] = (char)(cArray[9] ^ 0xB0A);
                throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 26458 << 16 | 0x41AE, 1, 0));
            }
        }
        c2 = this.nextNonWhitespace(true);
        switch (c2) {
            case 93: {
                if (peekStack == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (peekStack == 1 || peekStack == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return 7;
                }
                char[] cArray = "\u97b6\u755b\u6199\ub32b\u7485\u1e82\u93a2\u1ada\uc1f8\ua3bf\ub1fb\u5d8a\u4d8a\u1389\u97a2\u052f".toCharArray();
                cArray[10] = (char)(cArray[10] ^ 0x6A18);
                throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 32375 << 16 | 0x1FEF, 4, 5));
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.pos;
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            char[] cArray = "\u6812\udf0c\uf218\u6e71\u533e\uf1fa\u0875\u7582\uf8d3\uefde\u3c37\uf97d\u696a\uadfc".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x6155);
            throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 20725 << 16 | 0x43E, 2, 4));
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() throws IOException {
        int peeking;
        String keywordUpper;
        String keyword;
        char c2 = this.buffer[this.pos];
        if (c2 == 't' || c2 == 'T') {
            char[] cArray = "\ua167\u41be\uad99\u0f0f".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x2C7A);
            keyword = JsonWriter$JsonWriter.H(cArray, 24102 << 16 | 0x2E8B, 2, 0);
            char[] cArray2 = "\u517b\u6493\ucbc1\u7873".toCharArray();
            cArray2[2] = (char)(cArray2[2] ^ 0x1B0D);
            keywordUpper = JsonWriter$JsonWriter.H(cArray2, 19043 << 16 | 0x7AEA, 1, 5);
            peeking = 5;
        } else if (c2 == 'f' || c2 == 'F') {
            char[] cArray = "\u8466\uf540\u9e4b\u2f57\uad78".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x15B3);
            keyword = JsonWriter$JsonWriter.H(cArray, 6410 << 16 | 0x612A, 4, 3);
            char[] cArray3 = "\u86a5\u5026\u0b75\u5f9a\u8fa6".toCharArray();
            cArray3[4] = (char)(cArray3[4] ^ 0x1BF8);
            keywordUpper = JsonWriter$JsonWriter.H(cArray3, 19708 << 16 | 0x4766, 3, 4);
            peeking = 6;
        } else if (c2 == 'n' || c2 == 'N') {
            char[] cArray = "\u2bb4\u9d49\u9949\ub598".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x3343);
            keyword = JsonWriter$JsonWriter.H(cArray, 32169 << 16 | 0xDD1, 4, 0);
            char[] cArray4 = "\u6995\u5389\uc20c\ucad6".toCharArray();
            cArray4[0] = (char)(cArray4[0] ^ 0x5A22);
            keywordUpper = JsonWriter$JsonWriter.H(cArray4, 9057 << 16 | 0x451, 1, 0);
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            c2 = this.buffer[this.pos + i];
            if (c2 == keyword.charAt(i) || c2 == keywordUpper.charAt(i)) continue;
            return 0;
        }
        if ((this.pos + length < this.limit || this.fillBuffer(length + 1)) && this.isLiteral(this.buffer[this.pos + length])) {
            return 0;
        }
        this.pos += length;
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        char[] buffer = this.buffer;
        int p = this.pos;
        int l = this.limit;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block6: while (true) {
            if (p + i == l) {
                if (i == buffer.length) {
                    return 0;
                }
                if (!this.fillBuffer(i + 1)) break;
                p = this.pos;
                l = this.limit;
            }
            char c2 = buffer[p + i];
            switch (c2) {
                case '-': {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c2 < '0' || c2 > '9') {
                        if (!this.isLiteral(c2)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value = -(c2 - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value == 0L) {
                            return 0;
                        }
                        long newValue = value * 10L - (long)(c2 - 48);
                        fitsInLong &= value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                        value = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.pos += i;
            this.peeked = 15;
            return 15;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(char c2) throws IOException {
        switch (c2) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() throws IOException {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 14) {
            result = this.nextUnquotedValue();
        } else if (p == 12) {
            result = this.nextQuotedValue('\'');
        } else if (p == 13) {
            result = this.nextQuotedValue('\"');
        } else {
            char[] cArray = "\u71b2\u0268\udfb9\ud04d\ua16f\uf2d8\u4a28\u2cb5\u5964\u6a90\u6d85\u13f8\ua87d\ue61b\u7192\u386c\ub4bf\ud586\ub3ae\u9cb9\ud725\u22ed\u967c\u64cf".toCharArray();
            cArray[21] = (char)(cArray[21] ^ 0xBEE);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 24340 << 16 | 0x2A95, 4, 3) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    public String nextString() throws IOException {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 10) {
            result = this.nextUnquotedValue();
        } else if (p == 8) {
            result = this.nextQuotedValue('\'');
        } else if (p == 9) {
            result = this.nextQuotedValue('\"');
        } else if (p == 11) {
            result = this.peekedString;
            this.peekedString = null;
        } else if (p == 15) {
            result = Long.toString(this.peekedLong);
        } else if (p == 16) {
            result = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            char[] cArray = "\u77be\uc1c0\u04c0\u8747\ua47a\u69c9\ued26\u06c0\u8f6f\u65f8\u3792\u190e\u8086\uc48b\uf790\ud371\ubf9c\u0f5c\u9767\u1aa6\ufabf\ua191\ue1f7\ubedb\uce00\u4336".toCharArray();
            cArray[8] = (char)(cArray[8] ^ 0x3CB9);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 15400 << 16 | 0x28F5, 1, 5) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    public boolean nextBoolean() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 5) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return true;
        }
        if (p == 6) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return false;
        }
        char[] cArray = "\u8c07\ue981\u7833\ue923\udf07\ud71e\u1e27\u95cb\u2433\ue43d\uf575\u7d6e\u2c62\u608e\u8d3e\u275f\u80c5\u0247\u268e\u2bd9\u1623\ubc99\u3928\u7a2b\ue5d9\uc18b\u9d95".toCharArray();
        cArray[17] = (char)(cArray[17] ^ 0x52BA);
        throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 29316 << 16 | 0x2665, 3, 1) + (Object)((Object)this.peek()) + this.locationString());
    }

    public void nextNull() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 7) {
            char[] cArray = "\u6f17\ubfc6\u7199\u2804\uad60\u2d2b\u5be2\u8e4e\u15ec\uf1fe\u7aff\u0bf9\uf175\u0f87\u7dba\ue68c\u87b7\ub1b5\u51d7\ua316\uc6b7\u9817".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x2A96);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 971 << 16 | 0x402B, 0, 3) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
    }

    public double nextDouble() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            char[] cArray = "\u8cbb\u6e1c\u6965\uab88\u3b5a\u3e62\u0920\ub939\ue0ec\ufbf5\uda5e\u52ce\u7320\u31ca\u84f6\ue44e\uf7b3\u5827\u53eb\u4528\u062a\ua8f5\ufc44\uf6fa\u3ea7\u29fd".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0xE79);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 17605 << 16 | 0x5489, 4, 3) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double result = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(result) || Double.isInfinite(result))) {
            char[] cArray = "\u40d9\u8106\ufbb7\ueb51\u6860\uac7a\u8196\u8af2\u1cbc\ueab1\ud4ba\u5a57\u6259\u3d0b\u9a69\u1563\u6d74\uc00a\u2d11\u9918\u2757\u896b\u11b1\u05b4\u27da\u6a32\ub757\uf22b\u84e9\u9d1e\u9fe0\uf2c0\u0ed4".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x5EEF);
            throw new MalformedJsonException(JsonWriter$JsonWriter.H(cArray, 2772 << 16 | 0x1E2F, 0, 2) + result + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    public long nextLong() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p == 8 || p == 9 || p == 10) {
            this.peekedString = p == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
            try {
                long result = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else {
            char[] cArray = "\u925d\u0708\u1e61\u5c79\u56f5\u3c5d\ua0dc\uffda\u7abd\ucbef\uf969\u102d\u1330\u2ae3\u051d\u3d6b\ub44c\u67f6\u7635\u34e9\u9fcc\u1f98\u011a\udcae".toCharArray();
            cArray[16] = (char)(cArray[16] ^ 0x36E5);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 24034 << 16 | 0xF4C, 1, 0) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        long result = (long)asDouble;
        if ((double)result != asDouble) {
            char[] cArray = "\ud022\u578c\u25b3\u243b\u54ab\u0370\u7b7a\u2b23\u71ae\u3595\u8fad\u2119\u0eec\u9ebf\ued45\u90aa\u211c\uae69\u71b3\ua839\u3b30\u24e0\uddec\u64e9".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0xC55);
            throw new NumberFormatException(JsonWriter$JsonWriter.H(cArray, 1210 << 16 | 0x10A5, 1, 5) + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    private String nextQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        StringBuilder builder = new StringBuilder();
        do {
            int p = this.pos;
            int l = this.limit;
            int start = p;
            while (p < l) {
                char c2;
                if ((c2 = buffer[p++]) == quote) {
                    this.pos = p;
                    builder.append(buffer, start, p - start - 1);
                    return builder.toString();
                }
                if (c2 == '\\') {
                    this.pos = p;
                    builder.append(buffer, start, p - start - 1);
                    builder.append(this.readEscapeCharacter());
                    p = this.pos;
                    l = this.limit;
                    start = p;
                    continue;
                }
                if (c2 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = p;
            }
            builder.append(buffer, start, p - start);
            this.pos = p;
        } while (this.fillBuffer(1));
        char[] cArray = "\u4956\u24e7\u1bdf\u4dbc\ude53\u0220\ub6d6\ude00\u590e\u6564\u8202\uea55\u02ce\u9e52\ue704\u693d\u64bb\ub9d9\u7dcb".toCharArray();
        cArray[2] = (char)(cArray[2] ^ 0x7FDD);
        throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 18273 << 16 | 0x6FD2, 1, 2));
    }

    private String nextUnquotedValue() throws IOException {
        String result;
        StringBuilder builder = null;
        int i = 0;
        block4: while (true) {
            if (this.pos + i < this.limit) {
                switch (this.buffer[this.pos + i]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
                continue;
            }
            if (i < this.buffer.length) {
                if (!this.fillBuffer(i + 1)) break;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer, this.pos, i);
            this.pos += i;
            i = 0;
            if (!this.fillBuffer(1)) break;
        }
        if (builder == null) {
            result = new String(this.buffer, this.pos, i);
        } else {
            builder.append(this.buffer, this.pos, i);
            result = builder.toString();
        }
        this.pos += i;
        return result;
    }

    private void skipQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        do {
            int p = this.pos;
            int l = this.limit;
            while (p < l) {
                char c2;
                if ((c2 = buffer[p++]) == quote) {
                    this.pos = p;
                    return;
                }
                if (c2 == '\\') {
                    this.pos = p;
                    this.readEscapeCharacter();
                    p = this.pos;
                    l = this.limit;
                    continue;
                }
                if (c2 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = p;
            }
            this.pos = p;
        } while (this.fillBuffer(1));
        char[] cArray = "\u24fd\u2abd\uf8cc\u1e68\u3f8f\ufd4e\ufa8d\u2148\uca69\ud851\uaf13\u7097\u0d7c\uae3e\u6694\ue36b\u05c7\ud890\u1db9".toCharArray();
        cArray[6] = (char)(cArray[6] ^ 0x29E);
        throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 16667 << 16 | 0x442C, 1, 3));
    }

    private void skipUnquotedValue() throws IOException {
        do {
            int i = 0;
            while (this.pos + i < this.limit) {
                switch (this.buffer[this.pos + i]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.pos += i;
                        return;
                    }
                }
                ++i;
            }
            this.pos += i;
        } while (this.fillBuffer(1));
    }

    public int nextInt() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                char[] cArray = "\uf195\u2a9b\u848f\u0a7a\ub3b5\u5048\u7f67\u9ae6\u3d14\u3f34\u4b3e\u2c54\ubb46\u22c2\ue8e5\u6a91\ueaab\u249f\u814e\u5401\ua56b\u671f\ud877\uc698".toCharArray();
                cArray[13] = (char)(cArray[13] ^ 0x688F);
                throw new NumberFormatException(JsonWriter$JsonWriter.H(cArray, 26530 << 16 | 0x778E, 0, 4) + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return result;
        }
        if (p == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p == 8 || p == 9 || p == 10) {
            this.peekedString = p == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
            try {
                int result = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            char[] cArray = "\ubda0\u8275\uf719\ue221\u2ee0\u7642\u3c50\u8383\u577b\u0ce3\u3f36\uaf01\ufe90\u685c\u0c4f\uba29\uefcf\ucfa6\uef63\u960a\ub20f\ubcae\u6913\ub100".toCharArray();
            cArray[15] = (char)(cArray[15] ^ 0x55F8);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 29930 << 16 | 0x4B17, 0, 0) + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        int result = (int)asDouble;
        if ((double)result != asDouble) {
            char[] cArray = "\ud002\u40c3\ua6cc\ubdb4\udee9\u0ca3\u65ac\u604d\u4bd5\ua74f\u3772\u2c3f\ua108\ucaab\u5275\u0f12\u6477\u7d83\u5317\ue075\uf37e\uc1be\ue9f7\u6745".toCharArray();
            cArray[19] = (char)(cArray[19] ^ 0x5A10);
            throw new NumberFormatException(JsonWriter$JsonWriter.H(cArray, 12643 << 16 | 0x7BEB, 5, 0) + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() throws IOException {
        int count = 0;
        do {
            int p;
            if ((p = this.peeked) == 0) {
                p = this.doPeek();
            }
            if (p == 3) {
                this.push(1);
                ++count;
            } else if (p == 1) {
                this.push(3);
                ++count;
            } else if (p == 4) {
                --this.stackSize;
                --count;
            } else if (p == 2) {
                --this.stackSize;
                --count;
            } else if (p == 14 || p == 10) {
                this.skipUnquotedValue();
            } else if (p == 8 || p == 12) {
                this.skipQuotedValue('\'');
            } else if (p == 9 || p == 13) {
                this.skipQuotedValue('\"');
            } else if (p == 16) {
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (count != 0);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        char[] cArray = "\u8bc9\u7255\u6697\u6e3d".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x4C79);
        this.pathNames[this.stackSize - 1] = JsonWriter$JsonWriter.H(cArray, 14836 << 16 | 0x29AC, 4, 5);
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            int[] newPathIndices = new int[this.stackSize * 2];
            String[] newPathNames = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, newPathIndices, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, newPathNames, 0, this.stackSize);
            this.stack = newStack;
            this.pathIndices = newPathIndices;
            this.pathNames = newPathNames;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private boolean fillBuffer(int minimum) throws IOException {
        int total;
        char[] buffer = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(buffer, this.pos, buffer, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((total = this.in.read(buffer, this.limit, buffer.length - this.limit)) != -1) {
            this.limit += total;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && buffer[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++minimum;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private int nextNonWhitespace(boolean throwOnEof) throws IOException {
        block12: {
            char c2;
            char[] buffer = this.buffer;
            int p = this.pos;
            int l = this.limit;
            block4: while (true) {
                if (p == l) {
                    this.pos = p;
                    if (!this.fillBuffer(1)) break block12;
                    p = this.pos;
                    l = this.limit;
                }
                if ((c2 = buffer[p++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = p;
                    continue;
                }
                if (c2 == ' ' || c2 == '\r' || c2 == '\t') continue;
                if (c2 == '/') {
                    this.pos = p;
                    if (p == l) {
                        --this.pos;
                        boolean charsLoaded = this.fillBuffer(2);
                        ++this.pos;
                        if (!charsLoaded) {
                            return c2;
                        }
                    }
                    this.checkLenient();
                    char peek = buffer[this.pos];
                    switch (peek) {
                        case '*': {
                            ++this.pos;
                            char[] cArray = "\udc19\ub6af".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x276A);
                            if (!this.skipTo(JsonWriter$JsonWriter.H(cArray, 24640 << 16 | 0xF34, 3, 4))) {
                                char[] cArray2 = "\uf081\u8ff9\ueb01\u3773\u2770\u7451\ub7b3\u986c\ud308\u8d57\uac1f\u8f86\ubc35\ue8c1\uf4ed\udc34\u600d\udf77\u9c57\u9f05".toCharArray();
                                cArray2[9] = (char)(cArray2[9] ^ 0x1470);
                                throw this.syntaxError(JsonWriter$JsonWriter.H(cArray2, 17613 << 16 | 0x1B4D, 3, 2));
                            }
                            p = this.pos + 2;
                            l = this.limit;
                            continue block4;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            p = this.pos;
                            l = this.limit;
                            continue block4;
                        }
                    }
                    return c2;
                }
                if (c2 != '#') break;
                this.pos = p;
                this.checkLenient();
                this.skipToEndOfLine();
                p = this.pos;
                l = this.limit;
            }
            this.pos = p;
            return c2;
        }
        if (throwOnEof) {
            char[] cArray = "\u63b1\u833c\u522d\ue7b6\u3b1c\u4faf\uac12\u239b\u2386\u9458\ua1f0\u39c7".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x7BDB);
            throw new EOFException(JsonWriter$JsonWriter.H(cArray, 30461 << 16 | 0x7105, 1, 3) + this.locationString());
        }
        return -1;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            char[] cArray = "\uf25a\u404c\u7dbc\uc46c\u77f0\u59b4\u18b2\u8098\ue93c\ue6ea\u8e4c\u5fa7\uce8f\udd45\u3087\ufcb5\uf1e1\u7103\ucfe8\u60a0\u24a3\u626b\u255b\uf99d\u7bd1\u75d8\uf65e\u1129\u1e0a\u1e6e\uf49e\u1eb1\u4e13\u1ac5\u0989\u625c\u2e65\udd15\u9cf2\u6272\uc285\uece9\u9cfd\u22c7\uc68f\u3441\uce7c\uf513\u439d\ucd9c\ud31a\u9eba\u63d4\u0fd5\u91df\r".toCharArray();
            cArray[55] = (char)(cArray[55] ^ 0x5ED1);
            throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 22928 << 16 | 0x201, 3, 4));
        }
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c2;
            if ((c2 = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                break;
            }
            if (c2 != '\r') continue;
            break;
        }
    }

    private boolean skipTo(String toFind) throws IOException {
        while (this.pos + toFind.length() <= this.limit || this.fillBuffer(toFind.length())) {
            block5: {
                if (this.buffer[this.pos] == '\n') {
                    ++this.lineNumber;
                    this.lineStart = this.pos + 1;
                } else {
                    for (int c2 = 0; c2 < toFind.length(); ++c2) {
                        if (this.buffer[this.pos + c2] == toFind.charAt(c2)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.pos;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    private String locationString() {
        int line = this.lineNumber + 1;
        int column = this.pos - this.lineStart + 1;
        char[] cArray = "\u2220\ued60\uf0b7\uc059\u7466\u68f7\u5c9d\ubf92\ud65e".toCharArray();
        cArray[2] = (char)(cArray[2] ^ 0x38F6);
        char[] cArray2 = "\u179f\ud471\u142b\u2e1e\u692e\u30f9\u6a53\u52ab".toCharArray();
        cArray2[5] = (char)(cArray2[5] ^ 0x7D8F);
        char[] cArray3 = "\uf07e\u58ff\uf297\u4f67\uc59f\u3f58".toCharArray();
        cArray3[5] = (char)(cArray3[5] ^ 0x404);
        return JsonWriter$JsonWriter.H(cArray, 32751 << 16 | 0x4AA3, 2, 1) + line + JsonWriter$JsonWriter.H(cArray2, 23482 << 16 | 0x6377, 3, 5) + column + JsonWriter$JsonWriter.H(cArray3, 20724 << 16 | 0x3B14, 3, 4) + this.getPath();
    }

    public String getPath() {
        StringBuilder result = new StringBuilder().append('$');
        int size = this.stackSize;
        block4: for (int i = 0; i < size; ++i) {
            switch (this.stack[i]) {
                case 1: 
                case 2: {
                    result.append('[').append(this.pathIndices[i]).append(']');
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    result.append('.');
                    if (this.pathNames[i] == null) continue block4;
                    result.append(this.pathNames[i]);
                    continue block4;
                }
            }
        }
        return result.toString();
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            char[] cArray = "\uf7fd\ub598\u2d32\u96c9\u4bc8\u95d4\u2ec0\ue1b8\u5bd9\ub339\u5b76\u9576\u0d5c\u29bd\u08f8\u0784\uc7df\u56c0\u4b6e\ubad1\u3c62\u2278\u2333\ud8ff\ue505\u82cc\ue097\uecc5".toCharArray();
            cArray[6] = (char)(cArray[6] ^ 0x5094);
            throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 29664 << 16 | 0x2787, 1, 3));
        }
        char escaped = this.buffer[this.pos++];
        switch (escaped) {
            case 'u': {
                int i;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    char[] cArray = "\ua145\u28b8\u0d83\u23be\ucf57\u6a60\u3097\uae3f\ueb2a\ucfb8\u66f2\u7eb4\u8785\u4bd8\u7916\u608a\u2170\u01b0\ufbdc\u92f4\uc6d5\u8549\u42f6\u46ee\u465e\uba06\u137a\u3e51".toCharArray();
                    cArray[1] = (char)(cArray[1] ^ 0x4B6E);
                    throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 26312 << 16 | 0x4EF0, 1, 1));
                }
                char result = '\u0000';
                int end = i + 4;
                for (i = this.pos; i < end; ++i) {
                    char c2 = this.buffer[i];
                    result = (char)(result << 4);
                    if (c2 >= '0' && c2 <= '9') {
                        result = (char)(result + (c2 - 48));
                        continue;
                    }
                    if (c2 >= 'a' && c2 <= 'f') {
                        result = (char)(result + (c2 - 97 + 10));
                        continue;
                    }
                    if (c2 >= 'A' && c2 <= 'F') {
                        result = (char)(result + (c2 - 65 + 10));
                        continue;
                    }
                    char[] cArray = "\uab13\u0d6f".toCharArray();
                    cArray[0] = (char)(cArray[0] ^ 0x367E);
                    throw new NumberFormatException(JsonWriter$JsonWriter.H(cArray, 22540 << 16 | 0x4C17, 0, 5) + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return result;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                return escaped;
            }
        }
        char[] cArray = "\uf7ef\ubfe2\ud888\ua531\u5506\u9553\ua31d\u0b4a\u9771\u1728\u9e1c\u07fa\uc299\uca54\uab79\u9099\u1f94\u29bd\ua668\ub120\ua3ed\ue968\u11fa".toCharArray();
        cArray[7] = (char)(cArray[7] ^ 0x403B);
        throw this.syntaxError(JsonWriter$JsonWriter.H(cArray, 16743 << 16 | 0x7EC5, 4, 3));
    }

    private IOException syntaxError(String message) throws IOException {
        throw new MalformedJsonException(message + this.locationString());
    }

    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        for (int i = 0; i < NON_EXECUTE_PREFIX.length; ++i) {
            if (this.buffer[this.pos + i] == NON_EXECUTE_PREFIX[i]) continue;
            return;
        }
        this.pos += NON_EXECUTE_PREFIX.length;
    }

    static {
        char[] cArray = "\u6ed2\u9040\u2f4b\ufbd8\u8fcd".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x4863);
        NON_EXECUTE_PREFIX = JsonWriter$JsonWriter.H(cArray, 13176 << 16 | 0x69EC, 3, 4).toCharArray();
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader reader) throws IOException {
                if (reader instanceof JsonTreeReader) {
                    ((JsonTreeReader)reader).promoteNameToValue();
                    return;
                }
                int p = reader.peeked;
                if (p == 0) {
                    p = reader.doPeek();
                }
                if (p == 13) {
                    reader.peeked = 9;
                } else if (p == 12) {
                    reader.peeked = 8;
                } else if (p == 14) {
                    reader.peeked = 10;
                } else {
                    char[] cArray = "\u8b6e\ucaa2\u5c78\u760f\u9e7f\u0d59\u9fd2\u7a15\u894f\u4083\u102a\ua206\uac6c\uedd6\ub442\u0dad\u1b76\ua543\u66f4\u0bc7\ub65e\ud193\u546a\uc271".toCharArray();
                    cArray[21] = (char)(cArray[21] ^ 0x6AAF);
                    throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 21547 << 16 | 0x3735, 1, 1) + (Object)((Object)reader.peek()) + reader.locationString());
                }
            }
        };
    }
}

