/*
 * Decompiled with CFR 0.152.
 */
package elinchrom;

import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import elinchrom.FirmwareVersion;
import elinchrom.Unit_Prototype_Json;
import java.util.Arrays;

public class Elinchrom_Flash_Unit
extends Unit_Prototype_Json {
    public static final int UNIT_CLASS_COMPACT = 1;
    public static final int UNIT_CLASS_BATTERY_SINGLE_FIXED_RATIO = 2;
    public static final int UNIT_CLASS_BATTERY_MULTIPLE_FIXED_RATIO_ASYMM_LAMP = 3;
    public static final int UNIT_CLASS_VIDEO_LIGHT = 4;
    public static final int UNIT_CLASS_BATTERY_FULLY_ASYMMETRIC = 5;
    public static final int UNIT_CLASS_SKYPORT_DEVICES = 6;
    public static final int HEAD_TYPE_NOT_COMPATIBLE = 0;
    public static final int HEAD_TYPE_ELB1200_PRO = 1;
    public static final int HEAD_TYPE_ELB1200_ACTION = 2;
    public static final int HEAD_TYPE_ELB1200_HS = 3;
    public static final int HEAD_TYPE_ELB1200_VIDEO = 4;
    public static final int NO_INTERNET_CONNECTION = 0;
    public static final int NEW_FIRMWARE_ON_WEBSITE = 1;
    public static final int UNIT_UPDATED_TO_LAST_FIRMWARE = 2;
    private String skyport_id;
    private byte[] skyport_id_byte_array;
    private byte group;
    private byte[] friendly_name;
    private byte flash_power;
    private byte head_a_power;
    private byte head_b_power;
    private byte head_on;
    private byte head_a_type;
    private byte head_b_type;
    private byte head_c_type;
    private byte head_d_type;
    private byte head_plugged;
    private byte modlamp_a_power;
    private byte modlamp_b_power;
    private FirmwareVersion version;
    private byte[] supported_commands;
    private byte lamp_power_fstop;
    private byte lamp_mode;
    private byte lamp_timer;
    private byte lamp_power_percentage;
    private byte flash_mode;
    private byte sequence_address;
    private byte num_sequence_units;
    private short sequence_timeout;
    private boolean second_gen_seq_on;
    private byte second_gen_seq_count;
    private byte second_gen_seq_time;
    private short delay_time;
    private byte strobo_frequency;
    private short strobo_duration;
    private byte auto_off_minutes;
    private byte auto_off_hours;
    private byte num_outlets;
    private byte unit_category;
    private boolean update_mode;
    private boolean elc_update_master;
    private boolean elc_update_slave;
    private byte photocell_mode;
    private byte num_preflashes;
    private byte charge_mode;
    private byte audio_mode;
    private byte auto_off;
    private byte radio_channel;
    private byte radio_mode;
    private boolean unit_standby;
    private boolean unit_found;
    private boolean vfc;
    private int new_firmware_available;
    private byte[] flash_counter;
    private byte heads_ratio;

    public byte getModlamp_a_power() {
        return this.modlamp_a_power;
    }

    public void setModlamp_a_power(byte modlamp_a_power) {
        this.modlamp_a_power = modlamp_a_power;
    }

    public byte getModlamp_b_power() {
        return this.modlamp_b_power;
    }

    public void setModlamp_b_power(byte modlamp_b_power) {
        this.modlamp_b_power = modlamp_b_power;
    }

    public byte getHead_a_type() {
        return this.head_a_type;
    }

    public void setHead_a_type(byte head_a_type) {
        this.head_a_type = head_a_type;
    }

    public byte getHead_b_type() {
        return this.head_b_type;
    }

    public void setHead_b_type(byte head_b_type) {
        this.head_b_type = head_b_type;
    }

    public byte getHead_c_type() {
        return this.head_c_type;
    }

    public void setHead_c_type(byte head_c_type) {
        this.head_c_type = head_c_type;
    }

    public byte getHead_d_type() {
        return this.head_d_type;
    }

    public void setHead_d_type(byte head_d_type) {
        this.head_d_type = head_d_type;
    }

    public boolean isUnit_standby() {
        return this.unit_standby;
    }

    public void setUnit_standby(boolean unit_standby) {
        this.unit_standby = unit_standby;
    }

    protected boolean isUnit_found() {
        return this.unit_found;
    }

    public byte getHeads_ratio() {
        return this.heads_ratio;
    }

    public void setHeads_ratio(byte heads_ratio) {
        this.heads_ratio = heads_ratio;
    }

    protected void setUnit_found(boolean unit_found) {
        this.unit_found = unit_found;
    }

    public boolean isSecond_gen_seq_on() {
        return this.second_gen_seq_on;
    }

    public void setSecond_gen_seq_on(boolean second_gen_seq_on) {
        this.second_gen_seq_on = second_gen_seq_on;
    }

    public byte getSecond_gen_seq_count() {
        return this.second_gen_seq_count;
    }

    public void setSecond_gen_seq_count(byte second_gen_seq_count) {
        this.second_gen_seq_count = second_gen_seq_count;
    }

    public byte getSecond_gen_seq_time() {
        return this.second_gen_seq_time;
    }

    public void setSecond_gen_seq_time(byte second_gen_seq_time) {
        this.second_gen_seq_time = second_gen_seq_time;
    }

    public byte[] getFlash_counter() {
        return this.flash_counter;
    }

    public void setFlash_counter(byte[] flash_counter) {
        this.flash_counter = flash_counter;
    }

    public void setRadio_mode(byte radio_mode) {
        this.radio_mode = radio_mode;
    }

    public byte getRadio_mode() {
        return this.radio_mode;
    }

    public byte getRadio_channel() {
        return this.radio_channel;
    }

    public void setRadio_channel(byte radio_channel) {
        this.radio_channel = radio_channel;
    }

    public byte getLamp_timer() {
        return this.lamp_timer;
    }

    public void setLamp_timer(byte lamp_timer) {
        this.lamp_timer = lamp_timer;
    }

    public byte getAuto_off() {
        return this.auto_off;
    }

    public void setAuto_off(byte auto_off) {
        this.auto_off = auto_off;
    }

    public byte getHead_on() {
        return this.head_on;
    }

    public void setHead_on(byte head_on) {
        this.head_on = head_on;
    }

    public byte getHead_plugged() {
        return this.head_plugged;
    }

    public void setHead_plugged(byte head_plugged) {
        this.head_plugged = head_plugged;
    }

    public Elinchrom_Flash_Unit(String model_full_name, byte product_id, String skyport_id, byte[] skyport_id_byte_array, int generation, byte group, byte[] friendly_name, byte flash_power, byte head_a_power, byte head_b_power, byte head_on, byte head_plugged, byte master_fw_rev, byte slave_fw_rev, byte lamp_power_fstop, byte lamp_mode, byte lamp_timer, byte lamp_power_percentage, byte flash_mode, byte sequence_address, byte num_sequence_units, byte sequence_timeout, boolean second_gen_seq_on, byte second_gen_seq_count, byte second_gen_seq_time, byte delay_time, byte strobo_frequency, byte strobo_duration, byte auto_off_minutes, byte auto_off_hours, byte num_outlets, byte max_power, byte min_power, byte photocell_mode, byte num_preflashes, byte charge_mode, byte audio_mode, byte auto_off, byte radio_channel, byte radio_mode, boolean unit_standby, boolean unit_found, byte new_firmware_available, byte[] flash_counter, boolean vfc, byte modlamp_a_power, byte modlamp_b_power, byte head_a_type, byte head_b_type, byte head_c_type, byte head_d_type, byte unit_category, byte max_lamp_power, byte min_lamp_power) {
        super(model_full_name, product_id);
        this.skyport_id = skyport_id;
        this.skyport_id_byte_array = skyport_id_byte_array;
        this.group = group;
        this.friendly_name = friendly_name;
        this.flash_power = flash_power;
        this.head_a_power = head_a_power;
        this.head_b_power = head_b_power;
        this.head_on = head_on;
        this.head_plugged = head_plugged;
        this.version = new FirmwareVersion(master_fw_rev, slave_fw_rev);
        this.lamp_power_fstop = lamp_power_fstop;
        this.lamp_mode = lamp_mode;
        this.lamp_timer = lamp_timer;
        this.lamp_power_percentage = lamp_power_percentage;
        this.flash_mode = flash_mode;
        this.sequence_address = sequence_address;
        this.num_sequence_units = num_sequence_units;
        this.sequence_timeout = sequence_timeout;
        this.second_gen_seq_on = second_gen_seq_on;
        this.second_gen_seq_count = second_gen_seq_count;
        this.second_gen_seq_time = second_gen_seq_time;
        this.delay_time = delay_time;
        this.strobo_frequency = strobo_frequency;
        this.strobo_duration = strobo_duration;
        this.auto_off_minutes = auto_off_minutes;
        this.auto_off_hours = auto_off_hours;
        this.num_outlets = num_outlets;
        this.photocell_mode = photocell_mode;
        this.num_preflashes = num_preflashes;
        this.charge_mode = charge_mode;
        this.audio_mode = audio_mode;
        this.auto_off = auto_off;
        this.radio_channel = radio_channel;
        this.radio_mode = radio_mode;
        this.unit_standby = unit_standby;
        this.unit_found = unit_found;
        this.new_firmware_available = new_firmware_available;
        this.flash_counter = flash_counter;
        this.vfc = vfc;
        this.modlamp_a_power = modlamp_a_power;
        this.modlamp_b_power = modlamp_b_power;
        this.head_a_type = head_a_type;
        this.head_b_type = head_b_type;
        this.head_c_type = head_c_type;
        this.head_d_type = head_d_type;
        this.unit_category = unit_category;
    }

    @Override
    public byte getUnit_category() {
        return this.unit_category;
    }

    @Override
    public void setUnit_category(byte unit_category) {
        this.unit_category = unit_category;
    }

    public Elinchrom_Flash_Unit(byte product_id, String skyport_id, byte generation) {
        super(product_id);
        this.skyport_id = skyport_id;
        this.setGeneration(generation);
        this.skyport_id_byte_array = HexBin.decode(skyport_id);
        this.version = new FirmwareVersion(0);
    }

    public Elinchrom_Flash_Unit(String skyport_id, byte product_id, byte master_fw_rev) {
        super(product_id);
        this.skyport_id = skyport_id;
        this.version = new FirmwareVersion(master_fw_rev);
        this.update_mode = false;
    }

    public boolean getVfc() {
        return this.vfc;
    }

    public void setVfc(boolean vfc) {
        this.vfc = vfc;
    }

    @Override
    public String toString() {
        return this.getModel_full_name();
    }

    public byte[] getSkyport_id_byte_array() {
        return this.skyport_id_byte_array;
    }

    public short getStrobo_duration() {
        return this.strobo_duration;
    }

    public void setStrobo_duration(short strobo_duration) {
        this.strobo_duration = strobo_duration;
    }

    public byte getStrobo_frequency() {
        return this.strobo_frequency;
    }

    public void setStrobo_frequency(byte strobo_frequency) {
        this.strobo_frequency = strobo_frequency;
    }

    public short getDelay_time() {
        return this.delay_time;
    }

    public void setDelay_time(short delay_time) {
        this.delay_time = delay_time;
    }

    public boolean getUpdateMode() {
        return this.update_mode;
    }

    public void setUpdateMode(boolean mode) {
        this.update_mode = mode;
    }

    public boolean getELC_update_master() {
        return this.elc_update_master;
    }

    public void setELC_update_master(boolean update_master) {
        this.elc_update_master = update_master;
    }

    public boolean getELC_update_slave() {
        return this.elc_update_slave;
    }

    public void setELC_update_slave(boolean update_slave) {
        this.elc_update_slave = update_slave;
    }

    public byte getGroup() {
        return this.group;
    }

    public void setGroup(byte group) {
        this.group = group;
    }

    public byte[] getFriendly_name() {
        return this.friendly_name;
    }

    public void setFriendly_name(byte[] friendly_name) {
        this.friendly_name = friendly_name;
    }

    public byte getFlash_power() {
        return this.flash_power;
    }

    public void setFlash_power(byte flash_power) {
        this.flash_power = flash_power;
    }

    public byte getHead_a_power() {
        return this.head_a_power;
    }

    public void setHead_a_power(byte head_a_power) {
        this.head_a_power = this.getProduct_id() == 60 || this.getProduct_id() == 70 ? head_a_power : (head_a_power == 0 ? head_a_power : (this.head_b_power != 0 ? (byte)(this.getFlash_power() - 6) : this.getFlash_power()));
    }

    public byte getHead_b_power() {
        return this.head_b_power;
    }

    public void setHead_b_power(byte head_b_power) {
        this.head_b_power = this.getProduct_id() == 60 || this.getProduct_id() == 70 ? head_b_power : (head_b_power == 0 ? head_b_power : (this.head_a_power != 0 ? (byte)(this.getFlash_power() - 16) : (this.flash_power > 16 ? (byte)(this.flash_power - 16) : this.flash_power)));
    }

    public byte getLamp_power_fstop() {
        return this.lamp_power_fstop;
    }

    public void setLamp_power_fstop(byte lamp_power_fstop) {
        this.lamp_power_fstop = lamp_power_fstop;
    }

    public byte getLamp_power_percentage() {
        return this.lamp_power_percentage;
    }

    public void setLamp_power_percentage(byte lamp_power_percentage) {
        this.lamp_power_percentage = lamp_power_percentage;
    }

    public int isNew_firmware_available() {
        return this.new_firmware_available;
    }

    public void setNew_firmware_available(int new_firmware_available) {
        this.new_firmware_available = new_firmware_available;
    }

    public byte getLamp_mode() {
        return this.lamp_mode;
    }

    public void setLamp_mode(byte lamp_mode) {
        this.lamp_mode = lamp_mode;
    }

    public byte getFlash_mode() {
        return this.flash_mode;
    }

    public void setFlash_mode(byte flash_mode) {
        this.flash_mode = flash_mode;
    }

    public byte getSequence_address() {
        return this.sequence_address;
    }

    public void setSequence_address(byte sequence_address) {
        this.sequence_address = sequence_address;
    }

    public short getSequence_timeout() {
        return this.sequence_timeout;
    }

    public void setSequence_timeout(short sequence_timeout) {
        this.sequence_timeout = sequence_timeout;
    }

    public byte getNum_sequence_units() {
        return this.num_sequence_units;
    }

    public void setNum_sequence_units(byte num_sequence_units) {
        this.num_sequence_units = num_sequence_units;
    }

    public byte getPhotocell_mode() {
        return this.photocell_mode;
    }

    public void setPhotocell_mode(byte photocell_mode) {
        this.photocell_mode = photocell_mode;
    }

    public byte getNum_preflashes() {
        return this.num_preflashes;
    }

    public void setNum_preflashes(byte num_preflashes) {
        this.num_preflashes = num_preflashes;
    }

    public byte getCharge_mode() {
        return this.charge_mode;
    }

    public String getSkyport_id() {
        return this.skyport_id;
    }

    public void setSkyport_id(String skyport_id) {
        this.skyport_id = skyport_id;
    }

    public void setCharge_mode(byte charge_mode) {
        this.charge_mode = charge_mode;
    }

    public byte getAudio_mode() {
        return this.audio_mode;
    }

    public void setAudio_mode(byte audio_mode) {
        this.audio_mode = audio_mode;
    }

    public byte getAuto_off_minutes() {
        return this.auto_off_minutes;
    }

    public void setAuto_off_minutes(byte auto_off_minutes) {
        this.auto_off_minutes = auto_off_minutes;
    }

    public byte getAuto_off_hours() {
        return this.auto_off_hours;
    }

    public void setAuto_off_hours(byte auto_off_hours) {
        this.auto_off_hours = auto_off_hours;
    }

    public FirmwareVersion getVersion() {
        return this.version;
    }

    public void setVersion(FirmwareVersion v) {
        this.version = v;
    }

    public byte getMaster_fw_rev() {
        return this.version.getMaster();
    }

    public void setMaster_fw_rev(byte master_fw_rev) {
        this.version = new FirmwareVersion(master_fw_rev, this.version.getSlave());
    }

    public byte getSlave_fw_rev() {
        return this.version.getSlave();
    }

    public void setSlave_fw_rev(byte slave_fw_rev) {
        this.version = new FirmwareVersion(this.version.getMaster(), slave_fw_rev);
    }

    public void setUnitSupportedCommands(byte[] cmds) {
        this.supported_commands = cmds;
        Arrays.sort(this.supported_commands);
    }

    public boolean isCommandSupported(byte cmd) {
        return Arrays.binarySearch(this.supported_commands, cmd) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Elinchrom_Flash_Unit other = (Elinchrom_Flash_Unit)obj;
        return this.getSkyport_id().equals(other.getSkyport_id());
    }

    public void calculate_flash_power_fstop() {
        if (this.getProduct_id() == 60) {
            if (this.head_on == 0) {
                this.head_a_power = 0;
                this.head_b_power = 0;
            } else if (this.head_on == 1) {
                this.head_a_power = this.flash_power;
                this.head_b_power = 0;
            } else if (this.head_on == 2) {
                this.head_a_power = 0;
                switch (this.heads_ratio) {
                    case 8: {
                        this.head_b_power = (byte)(this.flash_power - 10);
                        break;
                    }
                    case 22: {
                        this.head_b_power = (byte)(this.flash_power - 16);
                        break;
                    }
                }
            } else if (this.head_on == 3) {
                switch (this.heads_ratio) {
                    case 8: {
                        this.head_a_power = (byte)(this.flash_power - 10);
                        this.head_b_power = (byte)(this.flash_power - 10);
                        break;
                    }
                    case 22: {
                        this.head_a_power = (byte)(this.flash_power - 6);
                        this.head_b_power = (byte)(this.flash_power - 16);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (this.getProduct_id() == 20 || this.getProduct_id() == 21 || this.getProduct_id() == 22 || this.getProduct_id() == 56) {
            if (this.head_plugged == 0) {
                this.head_a_power = 0;
                this.head_b_power = 0;
            } else if (this.head_plugged == 1) {
                this.head_a_power = this.flash_power;
                this.head_b_power = 0;
            } else if (this.head_plugged == 2) {
                this.head_a_power = 0;
                this.head_b_power = this.flash_power;
            } else if (this.head_plugged == 3) {
                switch (this.heads_ratio) {
                    case 8: {
                        this.head_a_power = (byte)(this.flash_power - 10);
                        this.head_b_power = (byte)(this.flash_power - 10);
                        break;
                    }
                    case 22: {
                        this.head_a_power = (byte)(this.flash_power - 6);
                        this.head_b_power = (byte)(this.flash_power - 16);
                        break;
                    }
                }
            }
        }
    }
}

