/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager$HidManager;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;

class HidDeviceManager {
    private int scanInterval = 500;
    private final Map<String, HidDevice> attachedDevices = Collections.synchronizedMap(new HashMap());
    private final HidServicesListenerList listenerList;
    private Thread scanThread = null;
    private boolean scanning = false;

    HidDeviceManager(HidServicesListenerList listenerList, int scanInterval) throws HidException {
        this.listenerList = listenerList;
        this.scanInterval = scanInterval;
        try {
            HidApi.init();
        }
        catch (Throwable t) {
            char[] cArray = "\u741d\u174b\u57e5\ubecf\u05c5\udfc8\u61e2\u249e\u3519\udad3\u5425\u9a69\ud5f1\u5447\u472b\ud7fd\ub73a\u746f\ud126\ufd0c\u3c8e\u4d83\u0ad1\ue5e4\u9786a\ue500".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0x7F13);
            throw new HidException(HidManager$HidManager.U(cArray, 27224 << 16 | 0x8A2, true, (short)5) + t.getMessage());
        }
    }

    public void start() {
        if (this.isScanning()) {
            return;
        }
        this.scan();
        final int scanInterval = this.scanInterval;
        if (scanInterval == 0) {
            return;
        }
        this.scanThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HidDeviceManager.this.scanning = true;
                while (true) {
                    try {
                        Thread.sleep(scanInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    HidDeviceManager.this.scan();
                }
                HidDeviceManager.this.scanning = false;
            }
        });
        this.scanThread.setDaemon(true);
        char[] cArray = "\u32e3\u8ccf\ue6da\u4210\uae98\ub983\ue517\u1af7\ueb89\ue09a\u8d93\ub2ee\ucf94\u3f15\u9492\u6712\ua99e\u86ef\u5bd9\ua86c\ue87e\uf492\u3f72".toCharArray();
        cArray[6] = (char)(cArray[6] ^ 0x1A39);
        this.scanThread.setName(HidManager$HidManager.U(cArray, 2924 << 16 | 0x4DF6, false, (short)1));
        this.scanThread.start();
    }

    public synchronized void stop() {
        if (this.scanThread != null) {
            this.scanThread.interrupt();
        }
    }

    public synchronized void scan() {
        ArrayList<String> removeList = new ArrayList<String>();
        List<HidDevice> attachedHidDeviceList = this.getAttachedHidDevices();
        for (HidDevice hidDevice : attachedHidDeviceList) {
            if (this.attachedDevices.containsKey(hidDevice.getId())) continue;
            this.attachedDevices.put(hidDevice.getId(), hidDevice);
            this.listenerList.fireHidDeviceAttached(hidDevice);
        }
        for (Map.Entry entry : this.attachedDevices.entrySet()) {
            String deviceId = (String)entry.getKey();
            HidDevice hidDevice = (HidDevice)entry.getValue();
            if (attachedHidDeviceList.contains(hidDevice)) continue;
            removeList.add(deviceId);
            this.listenerList.fireHidDeviceDetached(this.attachedDevices.get(deviceId));
        }
        if (!removeList.isEmpty()) {
            this.attachedDevices.keySet().removeAll(removeList);
        }
    }

    public void setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
    }

    public boolean isScanning() {
        return this.scanning;
    }

    public List<HidDevice> getAttachedHidDevices() {
        HidDeviceInfoStructure root;
        ArrayList<HidDevice> hidDeviceList = new ArrayList<HidDevice>();
        try {
            root = HidApi.enumerateDevices(0, 0);
        }
        catch (Throwable e) {
            this.stop();
            char[] cArray = "\u68ab\u35f7\ua008\u475b\ub3ab\uc753\uf11b\u2682\u0cea\u5db1\u6e17\ue639\u63f6\u0f39\uaf4a\u0de6\u558a\u2224\uab0b\u5da4\uef6c\u317c\u5592\u0286".toCharArray();
            cArray[12] = (char)(cArray[12] ^ 0x4910);
            throw new HidException(HidManager$HidManager.U(cArray, 19238 << 16 | 0x267C, false, (short)2) + e.getMessage());
        }
        if (root != null) {
            HidDeviceInfoStructure hidDeviceInfoStructure = root;
            do {
                hidDeviceList.add(new HidDevice(hidDeviceInfoStructure));
            } while ((hidDeviceInfoStructure = hidDeviceInfoStructure.next()) != null);
            HidApi.freeEnumeration(root);
        }
        return hidDeviceList;
    }
}

