/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom;

import ch.elinchrom.UpdaterContext;
import ch.elinchrom.UpdaterCore;
import ch.elinchrom.UpdaterUtil;
import ch.elinchrom.info.ELSP_HS_Device;
import ch.elinchrom.info.Elinchrom_HID_Device;
import ch.elinchrom.info.Firmware_on_website;
import ch.elinchrom.logging.LogWrapper;
import ch.elinchrom.logging.TraceLevel;
import ch.elinchrom.usb_skyport_manager.Elinchrom_Skyport_USB_Finder;
import ch.elinchrom.usb_skyport_manager.Elinchrom_Skyport_USB_Module;
import ch.elinchrom.usb_skyport_manager.Serial_Port_Manager;
import ch.elinchrom.util.Elinchrom_Utils;
import elinchrom.Elinchrom_Flash_Unit;
import elinchrom.Functions;
import elinchrom.Skyport_Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.apache.commons.collections4.map.MultiValueMap;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidServices;

public class EL_Updater_Main {
    public static final int UNIT_ALREADY_UPDATED = 0;
    public static final int NEW_FIRMWARE_AVAILABLE = 1;
    public static final int BOOTLOADER_TO_UPDATE = 2;
    public static final short elinchrom_vid = 10924;
    public static final String EL_Updater_Version = EL_Updater_Main.class.getPackage().getSpecificationVersion();
    private static final LogWrapper logger = LogWrapper.getLogger(EL_Updater_Main.class.getName());
    public static String driver_exe_pathname = "";
    public static String driver_exe_file_path = "";
    public static String driver_exe_file_name = "";
    public static ResourceBundle labels = ResourceBundle.getBundle("localized_strings/LabelsBundle", Locale.ENGLISH);
    public static MultiValueMap website_firmwares = new MultiValueMap();
    public static List<Firmware_on_website> newest_firmwares = new ArrayList<Firmware_on_website>();
    public static ArrayList<Elinchrom_Flash_Unit> Units_Found = new ArrayList();
    public static boolean elc_erased = false;
    public static Firmware_on_website new_firmware;
    public static Elinchrom_Flash_Unit skyport_unit_to_update;
    public static Elinchrom_HID_Device plugged_hid_unit;
    public static ELSP_HS_Device plugged_elsp_hs;
    public static Serial_Port_Manager skyport_serial_manager;
    public static Skyport_Module skyport_bluetooth;
    public static String elsp_drive_id;
    private static int num_connected_elinchrom_devices;
    private static List<Elinchrom_Skyport_USB_Module> Skyport_USB_Modules;
    private static Elinchrom_Skyport_USB_Finder skyport_usb_finder;
    private static HidServices hidServices;
    private static HidDevice skyport_hid_connector;

    public static void main(String[] args) throws HidException {
        UpdaterContext updaterContext = new UpdaterContext();
        updaterContext.mUpdaterCore = new UpdaterCore(updaterContext);
        try {
            updaterContext.mUpdaterCore.preInit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.log(TraceLevel.ACTIVITY, "Starting EL_Updater");
        updaterContext.logger = logger;
        updaterContext.labels = labels;
        updaterContext.mUpdateTaskQueue = new LinkedList();
        updaterContext.mUpdaterUtil = new UpdaterUtil(updaterContext);
        int errorStatus = 0;
        try {
            updaterContext.mUpdaterCore.init();
            if (Elinchrom_Utils.check_internet_connection()) {
                updaterContext.mUpdaterCore.lookForDevices();
            } else {
                JOptionPane.showMessageDialog(null, updaterContext.labels.getString("no_internet_msg"));
                System.exit(0);
            }
        }
        catch (Exception ex) {
            updaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
            errorStatus = 1;
        }
        updaterContext.mUpdaterCore.restoreTempDir();
        if (errorStatus != 0) {
            System.exit(errorStatus);
        }
    }

    public static String get_unit_name(int elinchrom_product_id) throws HidException {
        String result;
        try {
            result = Functions.getUnitNameFromProductID(elinchrom_product_id);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, (Throwable)exception);
            throw new HidException("Could not get the unit name");
        }
        return result;
    }

    static {
        elsp_drive_id = "";
        num_connected_elinchrom_devices = 0;
    }
}

