/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.OSMacOS;
import ch.elinchrom.OSWindows;
import ch.elinchrom.UpdateTask;
import ch.elinchrom.UpdaterContext;
import ch.elinchrom.firmware_updater.Firmware_Updater;
import ch.elinchrom.gui.Skyport_USB_Scan;
import ch.elinchrom.gui.SplashScreen;
import ch.elinchrom.info.ELSP_HS_Device;
import ch.elinchrom.info.Elinchrom_HID_Device;
import ch.elinchrom.info.Firmware_on_website;
import ch.elinchrom.usb_skyport_manager.Elinchrom_Skyport_USB_Finder;
import ch.elinchrom.usb_skyport_manager.Serial_Port_Manager;
import ch.elinchrom.util.Elinchrom_Utils;
import ch.elinchrom.util.NativeUtils;
import elinchrom.Elinchrom_Flash_Unit;
import elinchrom.Identifiers;
import elinchrom.Skyport_Module;
import elinchrom.Unit_Prototype_Json;
import java.awt.EventQueue;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.hid4java.HidException;

public class UpdaterCore {
    protected UpdaterContext mUpdaterContext;
    protected int mNumConnectedElinchromDevices = 0;
    protected int mExceptionState = 0;
    protected Unit_Prototype_Json mLastDetectedHidPrototype = null;
    protected int mRetryCount = 0;
    protected boolean mHasMessage = true;
    protected Properties mProps = null;
    protected String mJnaTempDir = null;
    protected String mUsb4javaTempDir = null;

    public UpdaterCore(UpdaterContext updaterContext) {
        this.mUpdaterContext = updaterContext;
    }

    public void preInit() throws IOException {
        this.createTempDir();
        this.setTempDir();
    }

    public void init() {
        this.updateOperatingSystemStatus();
        this.setLookAndFeel();
        this.setAppDirectory();
        this.importConfig();
        this.installDrivers();
    }

    public void setAppDirectory() {
        this.mUpdaterContext.mAppDirectory = this.mUpdaterContext.operatingSystem.getAppDirectory();
    }

    public void setTempDir() {
        if (Elinchrom_Utils.isWindows()) {
            try {
                this.mJnaTempDir = System.getProperty("jna.tmpdir");
                this.mUsb4javaTempDir = System.getProperty("java.io.tmpdir");
                String baseDirString = "c:\\";
                String systemDrive = System.getenv("SystemDrive");
                String appDataDir = System.getenv("AllUsersProfile");
                if (appDataDir != null) {
                    baseDirString = appDataDir;
                } else if (systemDrive != null) {
                    baseDirString = systemDrive;
                }
                File baseDir = new File(baseDirString);
                if (baseDir.exists() && baseDir.isDirectory()) {
                    File elUpdaterDir;
                    File elinchromDir = new File(baseDirString + "\\Elinchrom");
                    if (!elinchromDir.exists()) {
                        elinchromDir.mkdir();
                    }
                    if (!(elUpdaterDir = new File(baseDirString + "\\Elinchrom\\EL_Updater")).exists()) {
                        elUpdaterDir.mkdir();
                    }
                    System.setProperty("jna.tmpdir", elUpdaterDir.getCanonicalPath());
                    System.setProperty("java.io.tmpdir", elUpdaterDir.getCanonicalPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void restoreTempDir() {
        if (Elinchrom_Utils.isWindows() && this.mProps != null) {
            if (this.mUsb4javaTempDir != null) {
                System.setProperty("java.io.tmpdir", this.mUsb4javaTempDir);
            } else {
                System.clearProperty("java.io.tmpdir");
            }
            if (this.mJnaTempDir != null) {
                this.mProps.setProperty("jna.tmpdir", this.mJnaTempDir);
            } else {
                System.clearProperty("jna.tmpdir");
            }
        }
    }

    public void createTempDir() throws IOException {
        this.mUpdaterContext.tempDirectory = NativeUtils.createTempDir("EL_Updater_temp");
    }

    public void lookForDevices() {
        if (!this.mUpdaterContext.operatingSystem.isSkyportUSBCompatible() || this.mUpdaterContext.operatingSystem.checkDriverInstalled()) {
            Locale.setDefault(Locale.getDefault());
            Object[] choices = new String[]{this.mUpdaterContext.labels.getString("retry_btn_msg"), this.mUpdaterContext.labels.getString("exit_btn_msg")};
            Object[] choice_device = new String[]{"Skyport", "USB"};
            this.mUpdaterContext.skyportUsbFinder = new Elinchrom_Skyport_USB_Finder(Elinchrom_Utils.isWindows());
            int reply = -1;
            String updaterNewsUrl = this.tryGetLocalFile("el_updater_news.txt", Identifiers.UPDATER_NEWS_URL);
            Elinchrom_Utils.check_new_updater_available(updaterNewsUrl);
            this.mUpdaterContext.skyportUsbModules = Elinchrom_Utils.isWindows() ? this.mUpdaterContext.skyportUsbFinder.get_all_Elinchrom_USB_Modules_Windows() : this.mUpdaterContext.skyportUsbFinder.get_all_Elinchrom_USB_Modules_OSx();
            this.mNumConnectedElinchromDevices = Elinchrom_Utils.count_connected_elinchrom_units() + this.mUpdaterContext.skyportUsbModules.size();
            boolean hidRetry = true;
            while (hidRetry) {
                hidRetry = false;
                String message = null;
                while (this.mNumConnectedElinchromDevices == 0) {
                    message = null;
                    if (this.mExceptionState == 1 && this.mLastDetectedHidPrototype != null && this.mLastDetectedHidPrototype.getUSB_PID() == 3) {
                        this.mUpdaterContext.pollState = 1;
                        if (this.mRetryCount == 0) {
                            this.mRetryCount = 5;
                            message = this.mUpdaterContext.labels.getString("reconnect_ELB500TTL_msg");
                        }
                        this.mRetryCount = Math.max(this.mRetryCount - 1, 0);
                    } else {
                        message = this.mUpdaterContext.labels.getString(Elinchrom_Utils.isWindows10() ? "reconnect_ELB500TTL_msg" : "no_device_msg");
                    }
                    if (message != null) {
                        SwingWorker<Void, Void> pollDevice = null;
                        if (this.mUpdaterContext.pollState == 1) {
                            pollDevice = new SwingWorker<Void, Void>(){

                                @Override
                                public Void doInBackground() {
                                    boolean polling = true;
                                    while (UpdaterCore.this.mUpdaterContext.pollState == 1 && polling) {
                                        Elinchrom_Utils.open_hid_device_connection(EL_Updater_Main.plugged_hid_unit, UpdaterCore.this.mUpdaterContext.device);
                                        polling = EL_Updater_Main.plugged_hid_unit.getHidDevice() == null || EL_Updater_Main.plugged_hid_unit.getHidDevice().getManufacturer() == null;
                                        try {
                                            Thread.sleep(60L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    return null;
                                }
                            };
                            pollDevice.execute();
                        }
                        reply = JOptionPane.showOptionDialog(null, message, "Error", 0, 0, null, choices, "");
                        if (this.mUpdaterContext.pollState == 1) {
                            this.mUpdaterContext.pollState = 2;
                            try {
                                pollDevice.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException executionException) {
                                // empty catch block
                            }
                        }
                    }
                    if (reply == 0) {
                        this.mUpdaterContext.skyportUsbFinder = new Elinchrom_Skyport_USB_Finder(Elinchrom_Utils.isWindows());
                        this.mUpdaterContext.skyportUsbModules = Elinchrom_Utils.isWindows() ? this.mUpdaterContext.skyportUsbFinder.get_all_Elinchrom_USB_Modules_Windows() : this.mUpdaterContext.skyportUsbFinder.get_all_Elinchrom_USB_Modules_OSx();
                        this.mNumConnectedElinchromDevices = Elinchrom_Utils.count_connected_elinchrom_units() + this.mUpdaterContext.skyportUsbModules.size();
                        continue;
                    }
                    System.exit(0);
                }
                this.mExceptionState = 0;
                this.mLastDetectedHidPrototype = null;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UpdaterCore.this.mUpdaterContext.splashScreen = new SplashScreen(3000);
                            UpdaterCore.this.mUpdaterContext.splashScreen.showSplashAndExit();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (UpdaterCore.this.mUpdaterContext.splashScreen != null) {
                                UpdaterCore.this.mUpdaterContext.splashScreen.setVisible(false);
                                UpdaterCore.this.mUpdaterContext.splashScreen.dispatchEvent(new WindowEvent(UpdaterCore.this.mUpdaterContext.splashScreen, 201));
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
                }
                if (this.mUpdaterContext.skyportUsbModules.isEmpty() && this.mNumConnectedElinchromDevices == 1) {
                    try {
                        this.hid_or_elsp_update();
                    }
                    catch (HidException hidException) {
                        this.mUpdaterContext.logger.log(Level.WARNING, null, (Throwable)hidException);
                        this.mNumConnectedElinchromDevices = 0;
                        this.mExceptionState = 1;
                        hidRetry = true;
                    }
                    continue;
                }
                if (this.mNumConnectedElinchromDevices > 1 && !this.mUpdaterContext.skyportUsbModules.isEmpty()) {
                    int select_what_to_update = JOptionPane.showOptionDialog(null, this.mUpdaterContext.labels.getString("select_update"), "Error", 0, 2, null, choice_device, "");
                    if (select_what_to_update == 0) {
                        String firmwareSkyportUrl = this.tryGetLocalFile("firmware_skyport_news.txt", Identifiers.SKYPORT_FIRMWARE_NEWS_FILE_URL);
                        this.import_units_firmware(firmwareSkyportUrl);
                        EL_Updater_Main.skyport_serial_manager = new Serial_Port_Manager();
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    UpdaterCore.this.mUpdaterContext.scanWindow = new Skyport_USB_Scan(UpdaterCore.this.mUpdaterContext);
                                    UpdaterCore.this.mUpdaterContext.scanWindow.setVisible(true);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
                        }
                        this.mUpdaterContext.scanWindow.initSkyport(this.mUpdaterContext.skyportUsbModules.get(0));
                        continue;
                    }
                    if (select_what_to_update == 1) {
                        try {
                            this.hid_or_elsp_update();
                        }
                        catch (HidException hidException) {
                            this.mUpdaterContext.logger.log(Level.WARNING, null, (Throwable)hidException);
                            this.mNumConnectedElinchromDevices = 0;
                            this.mExceptionState = 1;
                            hidRetry = true;
                        }
                        continue;
                    }
                    if (select_what_to_update != -1) continue;
                    System.exit(0);
                    continue;
                }
                if (this.mNumConnectedElinchromDevices == 1 && !this.mUpdaterContext.skyportUsbModules.isEmpty()) {
                    String firmwareSkyportUrl = this.tryGetLocalFile("firmware_skyport_news.txt", Identifiers.SKYPORT_FIRMWARE_NEWS_FILE_URL);
                    this.import_units_firmware(firmwareSkyportUrl);
                    EL_Updater_Main.skyport_serial_manager = new Serial_Port_Manager();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                UpdaterCore.this.mUpdaterContext.scanWindow = new Skyport_USB_Scan(UpdaterCore.this.mUpdaterContext);
                                UpdaterCore.this.mUpdaterContext.scanWindow.setVisible(true);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
                    }
                    this.mUpdaterContext.scanWindow.initSkyport(this.mUpdaterContext.skyportUsbModules.get(0));
                    continue;
                }
                if (this.mNumConnectedElinchromDevices <= 1 || !this.mUpdaterContext.skyportUsbModules.isEmpty()) continue;
                while (this.mNumConnectedElinchromDevices > 1) {
                    reply = JOptionPane.showOptionDialog(null, "Only one USB module should be connected! Please unplug one unit!", "Error", 0, 0, null, choices, "");
                    if (reply == 0) {
                        this.mNumConnectedElinchromDevices = Elinchrom_Utils.count_connected_elinchrom_units() + this.mUpdaterContext.skyportUsbModules.size();
                        continue;
                    }
                    System.exit(0);
                }
                try {
                    this.hid_or_elsp_update();
                }
                catch (HidException hidException) {
                    this.mUpdaterContext.logger.log(Level.WARNING, null, (Throwable)hidException);
                    this.mNumConnectedElinchromDevices = 0;
                    this.mExceptionState = 1;
                    hidRetry = true;
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "Skyport driver is not installed; the updater cannot work without Skyport driver");
            System.exit(0);
        }
    }

    protected void import_units_firmware(String firmware_info_url) {
        String current_bootloader_file_name = "";
        try {
            String current_line;
            URL url = new URL(firmware_info_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((current_line = br.readLine()) != null) {
                if (!current_line.contains("[")) continue;
                String family_id = current_line.replace("[", "");
                family_id = family_id.replace("]", "");
                String fw_rev = br.readLine().split(":")[1];
                String bootloader_rev = br.readLine().split(":")[1];
                String fw_release_notes = br.readLine().split(":")[1];
                String fw_release_notes_url = br.readLine().split(":")[1];
                String fw_file_name = br.readLine().split(":")[1];
                current_bootloader_file_name = br.readLine().split(":")[1];
                Firmware_on_website available_fw = new Firmware_on_website(family_id, fw_rev, bootloader_rev, fw_release_notes, fw_release_notes_url, fw_file_name, current_bootloader_file_name);
                EL_Updater_Main.newest_firmwares.add(available_fw);
                String[] supported_devices = family_id.split(",");
                for (int i = 0; i < supported_devices.length; ++i) {
                    EL_Updater_Main.website_firmwares.put(Integer.valueOf(Integer.parseInt(supported_devices[i])), available_fw);
                }
            }
        }
        catch (MalformedURLException ex) {
            this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    protected void hid_or_elsp_update() throws HidException {
        String firmwareUsbUrl = this.tryGetLocalFile("firmware_news.txt", Identifiers.USB_FIRMWARE_NEWS_FILE_URL);
        this.import_units_firmware(firmwareUsbUrl);
        this.mUpdaterContext.device = Elinchrom_Utils.check_connected_device_type();
        if (EL_Updater_Main.plugged_hid_unit == null || EL_Updater_Main.plugged_hid_unit.getHidDevice() == null || EL_Updater_Main.plugged_hid_unit.getHidDevice().getManufacturer() == null) {
            EL_Updater_Main.plugged_hid_unit = new Elinchrom_HID_Device();
            Elinchrom_Utils.open_hid_device_connection(EL_Updater_Main.plugged_hid_unit, this.mUpdaterContext.device);
        }
        if (EL_Updater_Main.plugged_hid_unit.getIsHidDevice()) {
            Elinchrom_Utils.read_hid_unit_data(EL_Updater_Main.plugged_hid_unit);
        }
        for (Map.Entry mapEntry : Skyport_Module.elinchrom_units_prototypes.entrySet()) {
            Unit_Prototype_Json current = (Unit_Prototype_Json)mapEntry.getValue();
            if (EL_Updater_Main.plugged_hid_unit.getIsHidDevice()) {
                if (current.getProduct_id() != EL_Updater_Main.plugged_hid_unit.getProduct_id()) continue;
                this.mLastDetectedHidPrototype = current;
                if (!current.getModel_full_name().contains("Bluetooth")) break;
                EL_Updater_Main.skyport_bluetooth = new Skyport_Module(EL_Updater_Main.plugged_hid_unit.getHidDevice());
                break;
            }
            if (current.getUSB_PID() != this.mUpdaterContext.device) continue;
            EL_Updater_Main.plugged_elsp_hs = new ELSP_HS_Device(current);
            Elinchrom_Utils.update_ELSP_device_info();
            break;
        }
        if (!EL_Updater_Main.plugged_hid_unit.getIsHidDevice()) {
            EL_Updater_Main.plugged_hid_unit = null;
        }
        if (EL_Updater_Main.plugged_hid_unit != null || EL_Updater_Main.plugged_elsp_hs == null) {
            // empty if block
        }
        if (EL_Updater_Main.skyport_bluetooth != null) {
            if (EL_Updater_Main.plugged_hid_unit.getFirmware_type() != 0) {
                String firmwareSkyportUrl = this.tryGetLocalFile("firmware_skyport_news.txt", Identifiers.SKYPORT_FIRMWARE_NEWS_FILE_URL);
                this.import_units_firmware(firmwareSkyportUrl);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UpdaterCore.this.mUpdaterContext.scanWindow = new Skyport_USB_Scan(UpdaterCore.this.mUpdaterContext);
                            UpdaterCore.this.mUpdaterContext.scanWindow.setVisible(true);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.mUpdaterContext.logger.log(Level.WARNING, null, invocationTargetException.getCause());
                }
                this.mUpdaterContext.scanWindow.initSkyport(EL_Updater_Main.skyport_bluetooth);
            } else {
                String firmwareUsbUrl2 = this.tryGetLocalFile("firmware_news.txt", Identifiers.USB_FIRMWARE_NEWS_FILE_URL);
                this.import_units_firmware(firmwareUsbUrl2);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new Firmware_Updater(false, UpdaterCore.this.mUpdaterContext).setVisible(true);
                        }
                        catch (HidException ex) {
                            UpdaterCore.this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
                        }
                    }
                });
            }
        } else if (EL_Updater_Main.plugged_hid_unit != null) {
            if (EL_Updater_Main.plugged_hid_unit.getFirmware_type() == 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new Firmware_Updater(false, UpdaterCore.this.mUpdaterContext).setVisible(true);
                        }
                        catch (HidException ex) {
                            UpdaterCore.this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
                        }
                    }
                });
            } else {
                JOptionPane.showMessageDialog(null, "The unit is not in firmware update mode. Please check and try restarting the software", "Critical error", 0);
                System.exit(0);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        new Firmware_Updater(false, UpdaterCore.this.mUpdaterContext).setVisible(true);
                    }
                    catch (HidException ex) {
                        UpdaterCore.this.mUpdaterContext.logger.log(Level.SEVERE, null, (Throwable)ex);
                    }
                }
            });
        }
    }

    public void importConfig() {
        JFrame frame = new JFrame("Elinchrom Updater " + EL_Updater_Main.EL_Updater_Version);
        int min = 0;
        int max = 20;
        String[] message = new String[2];
        message[0] = "Preparing the software (first launch takes a few seconds).";
        final ProgressMonitor monitor = new ProgressMonitor(frame, message, "Work in progress", min, max);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int sleepTime = 500;
                Object msg = ".";
                for (int i = 0; i < monitor.getMaximum(); ++i) {
                    try {
                        monitor.setNote((String)msg);
                        msg = (String)msg + ".";
                        monitor.setProgress(i);
                        if (monitor.isCanceled()) {
                            monitor.setProgress(100);
                            break;
                        }
                        Thread.sleep(sleepTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                monitor.close();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        int result = Skyport_Module.import_config_files(this.mUpdaterContext.mAppDirectory == null ? null : this.mUpdaterContext.mAppDirectory + System.getProperty("file.separator") + "units_info_versioned.json");
        monitor.setMaximum(0);
        if (result == 0) {
            JOptionPane.showMessageDialog(null, "Error. When launching for the first time the software, the computer needs to be connected to the internet");
            System.exit(0);
        }
    }

    protected String tryGetLocalFile(String fileName, String defaultUrl) {
        String fileUrl = defaultUrl;
        try {
            File localFile = new File(this.mUpdaterContext.mAppDirectory + System.getProperty("file.separator") + fileName);
            if (localFile.canRead()) {
                fileUrl = localFile.toURI().toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileUrl;
    }

    public void installDrivers() {
        if (this.mUpdaterContext.operatingSystem.isSkyportUSBCompatible() && !this.mUpdaterContext.operatingSystem.checkDriverInstalled()) {
            this.mUpdaterContext.operatingSystem.installDriver();
        }
    }

    public void setLookAndFeel() {
        this.mUpdaterContext.operatingSystem.setLookAndFeel();
    }

    public void updateOperatingSystemStatus() {
        if (Elinchrom_Utils.isWindows()) {
            this.mUpdaterContext.operatingSystemType = 1;
            this.mUpdaterContext.operatingSystem = new OSWindows(this.mUpdaterContext);
        } else {
            this.mUpdaterContext.operatingSystemType = 0;
            this.mUpdaterContext.operatingSystem = new OSMacOS(this.mUpdaterContext);
        }
    }

    public int check_new_firmware_available(ELSP_HS_Device elsp_hs_device, Elinchrom_Flash_Unit skyport_unit, Elinchrom_HID_Device hid_device) {
        block17: {
            block16: {
                if (elsp_hs_device == null) break block16;
                for (int i = 0; i < EL_Updater_Main.newest_firmwares.size(); ++i) {
                    String unit_fw_rev = Elinchrom_Utils.removeDiacriticalMarks(elsp_hs_device.getApplication_Rev());
                    Firmware_on_website aux_fw = EL_Updater_Main.newest_firmwares.get(i);
                    if (aux_fw.getFamilyID().contains(Integer.toString(elsp_hs_device.getProduct_id())) && !aux_fw.getBootloaderRev().equals("NA") && Elinchrom_Utils.isLeftNewer(aux_fw.getBootloaderRev(), elsp_hs_device.getBootloader_Rev())) {
                        EL_Updater_Main.new_firmware = aux_fw;
                        return 2;
                    }
                    if (!aux_fw.getFamilyID().contains(Integer.toString(elsp_hs_device.getProduct_id())) || aux_fw.getRevision().equals("NA")) continue;
                    if (unit_fw_rev.contains("y") || unit_fw_rev.equals("PG_BOOT1")) {
                        elsp_hs_device.setApplication_Rev("No FW");
                        EL_Updater_Main.new_firmware = aux_fw;
                        return 1;
                    }
                    if (elsp_hs_device.getApplication_Rev().equals("No FW")) continue;
                    elsp_hs_device.setApplication_Rev(elsp_hs_device.getApplication_Rev().replace("Beta", ""));
                    elsp_hs_device.setApplication_Rev(elsp_hs_device.getApplication_Rev().replace("BETA", ""));
                    elsp_hs_device.setApplication_Rev(elsp_hs_device.getApplication_Rev().replace("b", ""));
                    if (elsp_hs_device.getApplication_Rev().charAt(0) == '0' && elsp_hs_device.getApplication_Rev().length() == 4) {
                        int available_fw_rev = Integer.parseInt(aux_fw.getRevision().replace(".", ""));
                        if (available_fw_rev * 10 <= Elinchrom_Utils.hexStringToByteArray(elsp_hs_device.getApplication_Rev().replace(".", "0"))[1]) continue;
                        EL_Updater_Main.new_firmware = aux_fw;
                        return 1;
                    }
                    if (Elinchrom_Utils.isLeftNewer(aux_fw.getRevision(), elsp_hs_device.getApplication_Rev())) {
                        EL_Updater_Main.new_firmware = aux_fw;
                        return 1;
                    }
                    return 0;
                }
                break block17;
            }
            if (skyport_unit != null) {
                byte unit_master_fw = skyport_unit.getMaster_fw_rev();
                ArrayList test = (ArrayList)EL_Updater_Main.website_firmwares.getCollection(skyport_unit.getProduct_id());
                if (!skyport_unit.getModel_full_name().toLowerCase().contains("elc")) {
                    Firmware_on_website aux_fw = (Firmware_on_website)test.get(0);
                    if (unit_master_fw == -1 || unit_master_fw < Byte.parseByte(aux_fw.getRevision())) {
                        EL_Updater_Main.new_firmware = aux_fw;
                        return 1;
                    }
                    return 0;
                }
                Firmware_on_website master_fw = null;
                Firmware_on_website slave_fw = null;
                for (int i = 0; i < 2; ++i) {
                    Firmware_on_website aux_fw = (Firmware_on_website)test.get(i);
                    if (aux_fw.getFile_name().contains("master")) {
                        master_fw = aux_fw;
                        continue;
                    }
                    slave_fw = aux_fw;
                }
                int ret = 0;
                this.mUpdaterContext.mUpdateTaskQueue.clear();
                if (slave_fw.getFile_name().contains("slave") && Integer.parseInt(slave_fw.getRevision()) > skyport_unit.getSlave_fw_rev() || skyport_unit.getSlave_fw_rev() == -1) {
                    EL_Updater_Main.skyport_unit_to_update.setELC_update_slave(true);
                    EL_Updater_Main.new_firmware = slave_fw;
                    ret = 1;
                    this.mUpdaterContext.mUpdateTaskQueue.add(new UpdateTask(1, "01", slave_fw));
                }
                if (master_fw.getFile_name().contains("master") && (skyport_unit.getMaster_fw_rev() < Integer.parseInt(master_fw.getRevision()) || skyport_unit.getMaster_fw_rev() == -1)) {
                    EL_Updater_Main.skyport_unit_to_update.setELC_update_master(true);
                    EL_Updater_Main.new_firmware = master_fw;
                    ret = 1;
                    this.mUpdaterContext.mUpdateTaskQueue.add(new UpdateTask(0, "00", master_fw));
                }
                return ret;
            }
            if (hid_device == null) break block17;
            for (int i = 0; i < EL_Updater_Main.newest_firmwares.size(); ++i) {
                Firmware_on_website aux_fw = EL_Updater_Main.newest_firmwares.get(i);
                if (!aux_fw.getFamilyID().contains(Integer.toString(hid_device.getProduct_id()))) continue;
                if (hid_device.getApplication_Rev().equals("No FW")) {
                    EL_Updater_Main.new_firmware = aux_fw;
                    return 1;
                }
                if (hid_device.getApplication_Rev().charAt(0) == '0' && hid_device.getApplication_Rev().length() == 4) {
                    int available_fw_rev = Integer.parseInt(aux_fw.getRevision().replace(".", ""));
                    if (available_fw_rev * 10 <= Elinchrom_Utils.hexStringToByteArray(hid_device.getApplication_Rev().replace(".", "0"))[1]) continue;
                    EL_Updater_Main.new_firmware = aux_fw;
                    return 1;
                }
                if (Elinchrom_Utils.isLeftNewer(aux_fw.getRevision(), hid_device.getApplication_Rev())) {
                    EL_Updater_Main.new_firmware = aux_fw;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }
}

