/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.gui;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.UpdaterContext;
import ch.elinchrom.firmware_updater.Firmware_Updater;
import ch.elinchrom.logging.LogWrapper;
import ch.elinchrom.usb_skyport_manager.EL_commands;
import ch.elinchrom.usb_skyport_manager.Elinchrom_Skyport_USB_Module;
import ch.elinchrom.util.Elinchrom_Utils;
import elinchrom.Elinchrom_Flash_Unit;
import elinchrom.Elinchrom_Skyport_Exception;
import elinchrom.Functions;
import elinchrom.Skyport_Module;
import elinchrom.Unit_Prototype_Json;
import gnu.io.SerialPort;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.hid4java.HidException;

public class Skyport_USB_Scan
extends JFrame {
    private static final int MAX_TIMES_CHECK_UPDATE_MODE = 15;
    private static final byte[] skyport_channels = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    public static boolean sending_unit_found = false;
    public static boolean update_mode;
    private static Elinchrom_Skyport_USB_Module skyport;
    private static Skyport_Module skyport_bluetooth;
    private static SerialPort skyport_port;
    private static boolean is_old_skyport;
    private static boolean update_in_progress;
    protected UpdaterContext mUpdaterContext;
    private JComboBox chan_combo_box;
    private JLabel jLabel2;
    private JPanel main_pane;
    private JButton scan_button;
    private JProgressBar scan_progress_bar;

    public Skyport_USB_Scan(UpdaterContext updaterContext) {
        this.mUpdaterContext = updaterContext;
        this.initComponents();
        ImageIcon favicon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("img/EL-Updater-Logo512.png"));
        this.setIconImage(favicon.getImage());
        this.setTitle("Elinchrom Updater " + EL_Updater_Main.EL_Updater_Version);
        this.setLocationRelativeTo(null);
    }

    public void initSkyport(Elinchrom_Skyport_USB_Module skyport) {
        Skyport_USB_Scan.skyport = skyport;
        if (Elinchrom_Utils.isWindows()) {
            Skyport_USB_Scan.open_serial_connection(skyport.getComPort());
        } else {
            Skyport_USB_Scan.open_serial_connection(skyport.getOSxPort());
        }
    }

    public void initSkyport(Skyport_Module skyport_bluetooth) {
        Skyport_USB_Scan.skyport_bluetooth = skyport_bluetooth;
    }

    private static void open_serial_connection(String port) {
        try {
            Object USBInfo = EL_commands.EL_Conf_USB + EL_commands.EL_G_command + EL_commands.EL_get_once_PNP_info;
            USBInfo = ((String)USBInfo).replace("$", "");
            skyport_port = EL_Updater_Main.skyport_serial_manager.open_port(port, 9600);
            InputStream input = EL_Updater_Main.skyport_serial_manager.getInputStream();
            byte[] bytes = Hex.decodeHex(((String)USBInfo).toCharArray());
            EL_Updater_Main.skyport_serial_manager.getOutputStream().write(bytes);
            EL_Updater_Main.skyport_serial_manager.getOutputStream().flush();
            EL_Updater_Main.skyport_serial_manager.wait_timer(50);
            if (input.available() > 0) {
                is_old_skyport = true;
            } else {
                EL_Updater_Main.skyport_serial_manager.close();
                skyport_port = null;
                skyport_port = EL_Updater_Main.skyport_serial_manager.open_port(port, 19200);
                bytes = Hex.decodeHex(((String)USBInfo).toCharArray());
                EL_Updater_Main.skyport_serial_manager.getOutputStream().write(bytes);
                EL_Updater_Main.skyport_serial_manager.getOutputStream().flush();
            }
        }
        catch (DecoderException ex) {
            LogWrapper.getLogger(Skyport_USB_Scan.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Skyport_USB_Scan.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        System.out.println("COM Port open, start scanning");
    }

    public static void process_string(String rx_value) {
        if (((String)rx_value).length() % 2 != 0) {
            rx_value = (String)rx_value + "0";
        }
        String[] result = new String[((String)rx_value).length() / 2 + 1];
        int counter = 0;
        while (!((String)rx_value).isEmpty()) {
            result[counter] = ((String)rx_value).substring(0, 2);
            rx_value = ((String)rx_value).substring(2, ((String)rx_value).length());
            ++counter;
        }
        if (EL_commands.find_unit_process) {
            Elinchrom_Flash_Unit temp = null;
            String serial_number = result[1] + result[2] + result[3];
            byte product_id = Byte.parseByte(Byte.valueOf(result[6], 16).toString());
            byte app_rev = (byte)Integer.parseInt(Integer.valueOf(result[8], 16).toString());
            byte powerBoard_rev = (byte)Integer.parseInt(Integer.valueOf(result[10], 16).toString());
            temp = new Elinchrom_Flash_Unit(serial_number, product_id, app_rev);
            temp.setSlave_fw_rev(powerBoard_rev);
            Unit_Prototype_Json unit_prototype = (Unit_Prototype_Json)Skyport_Module.elinchrom_units_prototypes.get(product_id);
            if (unit_prototype != null) {
                temp.setGeneration(unit_prototype.getGeneration());
            } else if (powerBoard_rev != 0) {
                temp.setGeneration((byte)1);
            }
            if (!EL_Updater_Main.Units_Found.contains(temp)) {
                EL_Updater_Main.Units_Found.add(temp);
                Skyport_USB_Scan.sendUnitFound(temp.getSkyport_id());
            }
        }
    }

    private static void sendUnitFound(String serial_number) {
        sending_unit_found = true;
        EL_Updater_Main.skyport_serial_manager.wait_timer(2000);
        String toSend = EL_commands.EL_Conf_Unit_single + serial_number + EL_commands.EL_x_Command + EL_commands.EL_Set_UnitFound_Flag;
        EL_Updater_Main.skyport_serial_manager.build_and_send_command(toSend);
        sending_unit_found = false;
    }

    private void bt_check_units_update_mode() {
        Elinchrom_Flash_Unit test = EL_Updater_Main.Units_Found.get(0);
        test.setUpdateMode(true);
    }

    private void check_units_update_mode() {
        int num_check_times;
        Object check_update_mode = "";
        Elinchrom_Flash_Unit current_unit = EL_Updater_Main.skyport_unit_to_update;
        byte[] unit_address = Functions.hexStringToByteArray(current_unit.getSkyport_id());
        byte[] to_send_bluetooth = new byte[]{-86, -6, unit_address[0], unit_address[1], unit_address[2], 58, -91, -91};
        update_mode = false;
        if (skyport_bluetooth == null) {
            String xor_addr_to_read_2;
            String xor_addr_to_read_1;
            if (current_unit.getGeneration() == 1) {
                EL_Updater_Main.skyport_serial_manager.set_new_channel("0" + (String)this.chan_combo_box.getSelectedItem());
                xor_addr_to_read_1 = this.calculate_xor(EL_commands.EL_xor_key, EL_commands.EL_memory_address_to_check_update_1);
                xor_addr_to_read_2 = this.calculate_xor(EL_commands.EL_xor_key, EL_commands.EL_memory_address_to_check_update_2);
                String xor_addr_to_read_3 = this.calculate_xor(EL_commands.EL_xor_key, EL_commands.EL_memory_address_to_check_update_3);
                String MCU_ID = "00";
                check_update_mode = EL_commands.EL_Conf_Unit_single + current_unit.getSkyport_id() + EL_commands.EL_write_memory + EL_commands.EL_r_command + MCU_ID + xor_addr_to_read_1 + xor_addr_to_read_2 + xor_addr_to_read_3;
            } else {
                EL_Updater_Main.skyport_serial_manager.set_old_channel(EL_Updater_Main.skyport_serial_manager, "0" + (String)this.chan_combo_box.getSelectedItem());
                xor_addr_to_read_1 = this.calculate_xor(EL_commands.EL_xor_key, EL_commands.EL_memory_address_to_check_update_1);
                xor_addr_to_read_2 = this.calculate_xor(EL_commands.EL_xor_key, EL_commands.EL_memory_address_to_check_update_2);
                check_update_mode = EL_commands.EL_Conf_Unit_single + current_unit.getSkyport_id() + EL_commands.EL_read_memory + xor_addr_to_read_1 + xor_addr_to_read_2;
            }
            while (num_check_times < 15 && !update_mode) {
                EL_Updater_Main.skyport_serial_manager.build_and_send_command((String)check_update_mode);
                EL_Updater_Main.skyport_serial_manager.wait_timer(200);
                ++num_check_times;
            }
            current_unit.setUpdateMode(update_mode);
        } else {
            for (num_check_times = 0; num_check_times < 15 && !update_mode; ++num_check_times) {
                try {
                    update_mode = skyport_bluetooth.check_unit_update_mode(current_unit);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            current_unit.setUpdateMode(update_mode);
        }
    }

    private String calculate_xor(String s1, String s2) {
        String aux1 = s1.replace("$", "");
        String aux2 = s2.replace("$", "");
        String result = Integer.toHexString(Integer.parseInt(aux1, 16) ^ Integer.parseInt(aux2, 16));
        return result;
    }

    private void scan_for_flash_units(final JProgressBar pbar) {
        EL_Updater_Main.Units_Found.clear();
        if (skyport_bluetooth != null) {
            List<Elinchrom_Flash_Unit> units = null;
            try {
                skyport_bluetooth.update_skyport_radio(skyport_channels[this.chan_combo_box.getSelectedIndex()], (byte)1, (byte)0);
            }
            catch (Elinchrom_Skyport_Exception elinchrom_Skyport_Exception) {
                // empty catch block
            }
            TimerTask test = new TimerTask(){

                @Override
                public void run() {
                    System.out.println("Run");
                    pbar.setValue(pbar.getValue() + 1);
                }
            };
            Timer time = new Timer();
            time.schedule(test, 0L, 1250L);
            units = skyport_bluetooth.scan_for_updateFW_units(3, 250);
            time.cancel();
            for (int i = 0; i < units.size(); ++i) {
                EL_Updater_Main.Units_Found.add(units.get(i));
            }
            EL_Updater_Main.skyport_unit_to_update = units.get(0);
        } else {
            long time_start = System.currentTimeMillis();
            EL_Updater_Main.Units_Found.clear();
            EL_commands.find_unit_process = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            EL_Updater_Main.skyport_serial_manager.set_new_channel("0" + this.chan_combo_box.getSelectedItem());
            EL_Updater_Main.skyport_serial_manager.discover_all_units(this.scan_progress_bar);
            EL_Updater_Main.skyport_serial_manager.wait_timer(500);
            EL_Updater_Main.skyport_serial_manager.set_old_channel(EL_Updater_Main.skyport_serial_manager, "0" + (String)this.chan_combo_box.getSelectedItem());
            EL_Updater_Main.skyport_serial_manager.discover_all_units(this.scan_progress_bar);
            EL_Updater_Main.skyport_serial_manager.wait_timer(500);
            long time_end = System.currentTimeMillis();
            for (Elinchrom_Flash_Unit elinchrom_Flash_Unit : EL_Updater_Main.Units_Found) {
            }
            EL_Updater_Main.skyport_serial_manager.wait_timer(20);
            EL_Updater_Main.skyport_unit_to_update = EL_Updater_Main.Units_Found.get(0);
            for (int i = 0; i < EL_Updater_Main.Units_Found.size(); ++i) {
                Elinchrom_Flash_Unit elinchrom_Flash_Unit;
                elinchrom_Flash_Unit = EL_Updater_Main.Units_Found.get(i);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initComponents() {
        this.main_pane = new JPanel();
        this.jLabel2 = new JLabel();
        this.chan_combo_box = new JComboBox();
        this.scan_button = new JButton();
        this.scan_progress_bar = new JProgressBar();
        this.setDefaultCloseOperation(3);
        this.main_pane.setBorder(BorderFactory.createTitledBorder("Scan for skyport units"));
        this.jLabel2.setText("Frequency Channel");
        this.chan_combo_box.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", " "}));
        this.chan_combo_box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Skyport_USB_Scan.this.chan_combo_boxActionPerformed(evt);
            }
        });
        this.scan_button.setText("Start Scan");
        this.scan_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Skyport_USB_Scan.this.scan_buttonActionPerformed(evt);
            }
        });
        GroupLayout main_paneLayout = new GroupLayout(this.main_pane);
        this.main_pane.setLayout(main_paneLayout);
        main_paneLayout.setHorizontalGroup(main_paneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(main_paneLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chan_combo_box, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scan_button, -2, 91, -2).addContainerGap(26, Short.MAX_VALUE)).addComponent(this.scan_progress_bar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        main_paneLayout.setVerticalGroup(main_paneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(main_paneLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(main_paneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.chan_combo_box, -2, -1, -2).addComponent(this.scan_button)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scan_progress_bar, -2, 26, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.main_pane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.main_pane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void chan_combo_boxActionPerformed(ActionEvent evt) {
    }

    private void scan_buttonActionPerformed(ActionEvent evt) {
        SwingWorker<Void, Void> scan_worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                Skyport_USB_Scan.this.scan_progress_bar.setMaximum(6);
                Skyport_USB_Scan.this.scan_for_flash_units(Skyport_USB_Scan.this.scan_progress_bar);
                return null;
            }

            @Override
            public void done() {
                Skyport_USB_Scan.this.scan_progress_bar.setValue(0);
                if (EL_Updater_Main.Units_Found.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "No unit found. Please try changing channel or check your units and try again", "Warning", 2);
                } else {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (EL_Updater_Main.Units_Found.size() != 1) {
                        JOptionPane.showMessageDialog(null, "You should have only one unit switched on. Please try again", "Warning", 2);
                    } else {
                        SwingWorker<Void, Void> check_update_worker = new SwingWorker<Void, Void>(){

                            @Override
                            public Void doInBackground() {
                                Skyport_USB_Scan.this.check_units_update_mode();
                                return null;
                            }

                            @Override
                            public void done() {
                                if (!EL_Updater_Main.Units_Found.get(0).getUpdateMode()) {
                                    JOptionPane.showMessageDialog(null, "The unit must be in firmware update mode. Please try again", "Warning", 2);
                                    EL_Updater_Main.Units_Found.clear();
                                } else {
                                    SwingWorker<Void, Void> update_manager = new SwingWorker<Void, Void>(){

                                        @Override
                                        public Void doInBackground() {
                                            update_in_progress = true;
                                            EL_Updater_Main.skyport_unit_to_update = EL_Updater_Main.Units_Found.get(0);
                                            EventQueue.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    try {
                                                        new Firmware_Updater(true, Skyport_USB_Scan.this.mUpdaterContext).setVisible(true);
                                                        Skyport_USB_Scan.this.setVisible(false);
                                                    }
                                                    catch (HidException ex) {
                                                        LogWrapper.getLogger(Skyport_USB_Scan.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
                                                    }
                                                }
                                            });
                                            return null;
                                        }

                                        @Override
                                        public void done() {
                                        }
                                    };
                                    update_manager.execute();
                                }
                            }
                        };
                        check_update_worker.run();
                    }
                }
            }
        };
        scan_worker.execute();
    }

    static {
        skyport = null;
        skyport_bluetooth = null;
        skyport_port = null;
        update_in_progress = false;
    }
}

