/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.logging;

import ch.elinchrom.logging.TraceLevel;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogWrapper {
    private static Dictionary<String, LogWrapper> wrappers = new Hashtable<String, LogWrapper>();
    private final Logger logger;
    private FileHandler logFileHandler;

    private LogWrapper(String name) {
        this.logger = Logger.getLogger(name);
    }

    public static LogWrapper getLogger(String name) {
        LogWrapper wrapper = wrappers.get(name);
        if (wrapper == null) {
            wrapper = new LogWrapper(name);
            wrappers.put(name, wrapper);
        }
        return wrapper;
    }

    public void log(TraceLevel traceLevel, String msg) {
        this.log(traceLevel, msg, null);
    }

    public void log(TraceLevel traceLevel, String msg, Throwable thrown) {
        this.log(switch (traceLevel) {
            case TraceLevel.ERROR -> Level.SEVERE;
            case TraceLevel.WARNING -> Level.WARNING;
            case TraceLevel.ACTIVITY, TraceLevel.PATH, TraceLevel.DATA -> Level.INFO;
            case TraceLevel.DETAILS -> Level.FINE;
            default -> Level.SEVERE;
        }, traceLevel, msg, thrown);
    }

    public void log(Level level, String msg, Throwable thrown) {
        TraceLevel traceLevel = level == Level.SEVERE ? TraceLevel.ERROR : (level == Level.WARNING ? TraceLevel.WARNING : TraceLevel.DETAILS);
        this.log(level, traceLevel, msg, thrown);
    }

    public void log(Level level, TraceLevel traceLevel, String msg, Throwable thrown) {
        switch (traceLevel) {
            case ERROR: {
                break;
            }
            case WARNING: {
                break;
            }
            case ACTIVITY: {
                break;
            }
            case PATH: {
                break;
            }
            case DATA: {
                break;
            }
        }
    }

    public void error(String msg, Throwable e) {
        this.log(TraceLevel.ERROR, msg, e);
    }

    public void activity(String msg) {
        this.log(TraceLevel.ACTIVITY, msg);
    }

    public void setLogFile(String logFileAbsolutePath) {
        try {
            this.logFileHandler = new FileHandler(logFileAbsolutePath);
            SimpleFormatter formatter = new SimpleFormatter();
            this.logFileHandler.setFormatter(formatter);
            this.logger.addHandler(this.logFileHandler);
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeLogFile() {
        try {
            this.logFileHandler.close();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

