/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.usb_skyport_manager;

import ch.elinchrom.usb_skyport_manager.Elinchrom_Skyport_USB_Module;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Elinchrom_Skyport_USB_Finder {
    private WinNT.HANDLE hDevInfo = null;
    private boolean is_windows;
    private DISetupApi setupApi = null;

    public Elinchrom_Skyport_USB_Finder(boolean is_windows) {
        this.is_windows = is_windows;
        if (is_windows) {
            this.setupApi = DISetupApi.DI_INSTANCE;
            this.hDevInfo = this.getWinNtHandleAlsoKnownAsDevInfo(2, 4);
            if (this.hDevInfo == WinBase.INVALID_HANDLE_VALUE) {
                throw new RuntimeException("Unable to get a valid WinNT.HANDLE");
            }
        }
    }

    public List<Elinchrom_Skyport_USB_Module> get_all_Elinchrom_USB_Modules_OSx() {
        ArrayList<Elinchrom_Skyport_USB_Module> Elinchrom_Modules_List = new ArrayList<Elinchrom_Skyport_USB_Module>();
        Object portId = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portId == null && portEnum.hasMoreElements()) {
            CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
            if (!currPortId.getName().contains("/dev/tty.usbserial-EL")) continue;
            Elinchrom_Skyport_USB_Module Skyport_Module2 = new Elinchrom_Skyport_USB_Module(currPortId.getName());
            Elinchrom_Modules_List.add(Skyport_Module2);
        }
        return Elinchrom_Modules_List;
    }

    public List<Elinchrom_Skyport_USB_Module> get_all_Elinchrom_USB_Modules_Windows() {
        ArrayList<Elinchrom_Skyport_USB_Module> Elinchrom_Modules_List = new ArrayList<Elinchrom_Skyport_USB_Module>();
        SetupApi.SP_DEVINFO_DATA.ByReference devNfoDataRef = new SetupApi.SP_DEVINFO_DATA.ByReference();
        ArrayList<SetupApi.SP_DEVINFO_DATA.ByReference> deviceDevInfoDataReferences = new ArrayList<SetupApi.SP_DEVINFO_DATA.ByReference>();
        int i = 0;
        while (this.setupApi.SetupDiEnumDeviceInfo(this.hDevInfo, i, devNfoDataRef)) {
            deviceDevInfoDataReferences.add(devNfoDataRef);
            devNfoDataRef = new SetupApi.SP_DEVINFO_DATA.ByReference();
            ++i;
        }
        for (SetupApi.SP_DEVINFO_DATA.ByReference devNfoDataRef1 : deviceDevInfoDataReferences) {
            String friendlyName = this.getRegistryPropertyForDevInfoAndDevinfoData(this.hDevInfo, devNfoDataRef1, 12);
            String hardwareId = this.getRegistryPropertyForDevInfoAndDevinfoData(this.hDevInfo, devNfoDataRef1, 1);
            String manufacturer = this.getRegistryPropertyForDevInfoAndDevinfoData(this.hDevInfo, devNfoDataRef1, 11);
            if (!friendlyName.contains("EL-Skyport")) continue;
            Elinchrom_Skyport_USB_Module Elinchrom_module = new Elinchrom_Skyport_USB_Module(friendlyName, hardwareId, manufacturer);
            Elinchrom_Modules_List.add(Elinchrom_module);
        }
        return Elinchrom_Modules_List;
    }

    private WinNT.HANDLE getWinNtHandleAlsoKnownAsDevInfo(int flag, int ... flags) {
        Guid.GUID classGuid = null;
        Pointer enumerator = null;
        Pointer hwndParent = null;
        int flagsOr = flag;
        for (int f2 : flags) {
            flagsOr |= f2;
        }
        WinNT.HANDLE hDevInfo = null;
        try {
            hDevInfo = this.setupApi.SetupDiGetClassDevs(classGuid, enumerator, hwndParent, flagsOr);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return hDevInfo;
    }

    private String getRegistryPropertyForDevInfoAndDevinfoData(WinNT.HANDLE hDevInfo, SetupApi.SP_DEVINFO_DATA.ByReference devNfoDataRef, int property) {
        String retValue = "";
        IntByReference propertyRegDataType = new IntByReference(0);
        IntByReference requiredSize = new IntByReference();
        boolean isOk = this.setupApi.SetupDiGetDeviceRegistryProperty(hDevInfo, devNfoDataRef, property, propertyRegDataType, null, 0, requiredSize);
        if (isOk) {
            System.out.println("Funky! First call to SetupApi.SetupDiGetDeviceRegistryProperty did not fail!");
        } else {
            int errorCode = this.getLastError();
            if (errorCode == 13) {
                return retValue;
            }
            if (errorCode != 122) {
                throw new RuntimeException(this.getLastErrorAsString());
            }
        }
        if (requiredSize.getValue() <= 0) {
            return retValue;
        }
        Memory ptr = new Memory(requiredSize.getValue() * 2);
        isOk = this.setupApi.SetupDiGetDeviceRegistryProperty(hDevInfo, devNfoDataRef, property, propertyRegDataType, ptr, requiredSize.getValue(), requiredSize);
        retValue = this.extractDataFromRegistryLookup(propertyRegDataType, requiredSize.getValue(), ptr);
        return retValue;
    }

    private String extractDataFromRegistryLookup(IntByReference propertyRegDataType, int requiredSize, Pointer ptr) {
        Object retValue = null;
        int propValue = propertyRegDataType.getValue();
        retValue = propValue == 0 || propValue == 1 || propValue == 2 ? ptr.getString(0L, true) : (propValue == 11 || propValue == 12 ? "" + ptr.getLong(0L) : ptr.getString(0L, true));
        return retValue;
    }

    private int getLastError() {
        return Kernel32.INSTANCE.GetLastError();
    }

    private String getLastErrorAsString() {
        return this.getErrorCodeAsString(this.getLastError());
    }

    private String getErrorCodeAsString(int errorCode) {
        Object ret = "";
        try {
            ret = Kernel32Util.formatMessageFromLastErrorCode(errorCode) + " (ErrorCode: " + errorCode + ")";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    static interface DISetupApi
    extends SetupApi {
        public static final DISetupApi DI_INSTANCE = Native.loadLibrary("setupapi", DISetupApi.class, W32APIOptions.DEFAULT_OPTIONS);
        public static final int SPDRP_HARDWAREID = 1;
        public static final int SPDRP_MFG = 11;
        public static final int SPDRP_FRIENDLYNAME = 12;

        public boolean SetupDiEnumDeviceInfo(WinNT.HANDLE var1, int var2, SetupApi.SP_DEVINFO_DATA.ByReference var3);
    }
}

